/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.CnvtInfo;
import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmBinder;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.sql.DmdbDateTime;
import dm.sql.DmdbTime;
import java.sql.SQLException;

public class DmdmTimeBinder
extends DmBinder {
    public DmdmTimeBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
    }

    void init() {
        this.recDType = 15;
        this.recPrec = 5;
        this.recScale = 0;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        DmdbTime x = ((DmdbTime[])this.pstmt.m_paramObjects[icol])[irow];
        CnvtInfo cnvtInfo = this.pstmt.connection.getCnvtInfo();
        String serverEncoding = cnvtInfo.getServerEncoding();
        byte[] ret = DmdmTimeBinder.toDbBytes(x, this.destDType, this.destPrec, this.srcScale, serverEncoding, cnvtInfo.getTimeZone(), cnvtInfo.getDbTz());
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public static byte[] toDbBytes(DmdbTime x, int destDType, int destPrec, int srcScale, String serverEncoding, short ltz, short dbtz) throws SQLException {
        byte[] ret = null;
        switch (destDType) {
            case 15: {
                DmdbTime t = new DmdbTime(String.valueOf(x), srcScale);
                ret = Convertion.TimeToByteArray(t);
                break;
            }
            case 16: {
                DmdbDateTime dt = new DmdbDateTime(x.toString(), srcScale, 2);
                ret = Convertion.TimeStampToByteArray(dt, destDType, srcScale, dbtz, ltz);
                break;
            }
            case 0: 
            case 1: {
                ret = Convertion.String_char_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                break;
            }
            case 2: 
            case 19: {
                ret = Convertion.String_varchar_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return ret;
    }
}

