/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.GlobalControlCfg;
import dm.jdbc.driver.DmdbCSI;
import dm.jdbc.driver.DmdbCallableStatement_bs;
import dm.jdbc.driver.DmdbColumn;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbInfo;
import dm.jdbc.driver.DmdbLog;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbResultSetCache_h;
import dm.jdbc.driver.DmdbResultSetCache_v;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.innerData.DmdbExecOpt;
import dm.jdbc.rsCache.DmdbCachedResultSetPool;
import dm.jdbc.util.StringUtil;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;

public class DmdbStatement_bs
implements Statement {
    public static final int STATEMENT = 0;
    public static final int PREPARED_STATEMENT = 1;
    public static final int CALLABLE_STATEMENT = 2;
    public static final int STATICPREPARED_STATEMENT = 3;
    protected int handle;
    protected DmdbConnection_bs connection;
    protected DmdbInfo dbInfo;
    DmdbResultSetCache rsCache = null;
    DmdbResultSet_bs currentRs = null;
    ArrayList resultsList = null;
    short resId = 0;
    protected String m_insertTableName = "";
    protected int resultSetConcurrency;
    protected int resultSetType;
    protected int resultSetHoldability;
    boolean process_escapes;
    protected int m_queryTimeout;
    int max_field_size;
    int maxRows;
    int row_prefetch;
    public boolean closed = true;
    int fetch_direction;
    SQLWarning m_warnings;
    ArrayList m_batchItems = null;
    String cursorName;
    public long cursorUpdateRow;
    boolean fromRowSetFlag = false;
    int type = 0;
    int m_putLobData = 1;
    protected String originalSql = null;
    protected long[] m_TbIds = null;
    protected long[] m_TbTss = null;
    private int executeId = -1;
    private boolean m_ExecOpt = false;
    protected boolean m_autoGenKeys = false;
    private long[] m_retIds = null;
    private boolean m_execfromStanbdy = false;
    int CLOSE_CURRENT_RESULT = 1;
    int KEEP_CURRENT_RESULT = 2;
    int CLOSE_ALL_RESULTS = 3;
    int SUCCESS_NO_INFO = -2;
    int EXECUTE_FAILED = -3;
    int RETURN_GENERATED_KEYS = 1;
    int NO_GENERATED_KEYS = 2;

    public DmdbResultSetCache getRsCache() {
        return this.rsCache;
    }

    public void setRsCache(DmdbResultSetCache cache) {
        this.rsCache = cache;
    }

    public void setFromStandby(boolean standby) {
        this.m_execfromStanbdy = standby;
    }

    public boolean getFromStandby() {
        return this.m_execfromStanbdy;
    }

    public final void setRetIds(long[] retIds) {
        int len = retIds.length;
        if (retIds == null || retIds.length == 0) {
            return;
        }
        this.m_retIds = new long[len];
        System.arraycopy(retIds, 0, this.m_retIds, 0, len);
    }

    public void setExecuteId(int id) {
        this.executeId = id;
    }

    public int getExecuteId() {
        return this.executeId;
    }

    public long getRowId() {
        if (this.dbInfo != null) {
            return this.dbInfo.getRowId();
        }
        return -1L;
    }

    public void setTbsId_Ts(long[] ids, long[] tss) {
        this.m_TbIds = (long[])ids.clone();
        this.m_TbTss = (long[])tss.clone();
    }

    public DmdbInfo getDmdbInfo() {
        if (this.dbInfo == null) {
            this.dbInfo = new DmdbInfo();
        }
        return this.dbInfo;
    }

    public DmdbInfo getDmdbInfoNRS() {
        if (this.dbInfo != null) {
            this.dbInfo.setHasResultSet(false);
            this.dbInfo.setSavepointFlag(false);
            return this.dbInfo;
        }
        this.m_retIds = null;
        return this.getDmdbInfo();
    }

    public boolean fromRowSetFlag() {
        return this.fromRowSetFlag;
    }

    void initializeState() throws SQLException {
        this.m_ExecOpt = this.connection.getConstParaOpt();
        this.resultSetConcurrency = 1007;
        this.resultSetType = 1003;
        this.resultSetHoldability = this.connection.getHoldability();
        this.process_escapes = this.connection.getEscapesProcessing();
        this.m_queryTimeout = 0;
        this.max_field_size = 0;
        this.maxRows = this.connection.getMaxRows();
        this.row_prefetch = this.connection.getDefaultRowPrefetch();
        this.fetch_direction = 1000;
        this.m_warnings = null;
        this.m_batchItems = null;
        this.resultsList = new ArrayList(3);
        this.handle = DmdbCSI.allocStmtHandle(this.connection);
        long ttt = this.handle;
        if (this.handle < 0) {
            ttt = 0xFFFFFFFFL & ttt;
        }
        this.cursorName = "DM7CUR" + ttt;
        this.type = 0;
        this.closed = false;
    }

    public void initializeReuseStmt(DmdbConnection_bs conn) throws SQLException {
        this.closed = false;
    }

    public DmdbStatement_bs(DmdbConnection_bs conn) throws SQLException {
        this.connection = conn;
        this.initializeState();
    }

    public DmdbStatement_bs(DmdbConnection_bs conn, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this(conn);
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "executeQuery(String)", sql);
        }
        this.executeInner(sql, 2);
        return this.currentRs;
    }

    public synchronized ResultSet executeQuery(String sql, int flag) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "executeQuery(String, int)", "sql is " + sql + ", flag = " + flag);
        }
        this.checkClosed();
        this.clearWarnings();
        this.checkNullOrEmpty(sql);
        this.originalSql = sql = this.connection.nativeSQL(sql, this.process_escapes);
        ++DmdbConnection_bs.execSqlNum;
        this.currentRs = this.enableRsCache() ? DmdbCachedResultSetPool.getResultSet(this.connection.getGUID(), this.connection.getSchema(), this.originalSql, this) : null;
        if (this.currentRs != null) {
            ++DmdbConnection_bs.rsCachedNum;
            this.dbInfo = this.currentRs.dbInfo;
            return this.currentRs;
        }
        this.dbInfo = this.directExec(this, sql, true, 1);
        DmdbResultSet_bs rs = this.getResultSet(true);
        this.close_free();
        return rs;
    }

    public synchronized int executeUpdate(String sql) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "executeUpdate(String)", sql);
        }
        this.executeInner(sql, 3);
        if (this.dbInfo.getHasResultSet()) {
            DBError.throwSQLException(6009);
        }
        if (this.dbInfo.getRowCount() > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.dbInfo.getRowCount();
    }

    protected void checkClosed() throws SQLException {
        if (this.closed) {
            DBError.throwSQLException(6035);
            return;
        }
        if (this.connection == null || this.connection.closed) {
            DBError.throwSQLException(6035);
        }
    }

    void resetState(boolean clear_dbInfo) throws SQLException {
        if (clear_dbInfo) {
            this.dbInfo = null;
        }
        this.rsCache = null;
        this.m_insertTableName = "";
        this.cursorUpdateRow = 0L;
        this.fromRowSetFlag = false;
        this.resultSetConcurrency = 1007;
        this.resultSetType = 1003;
        this.resultSetHoldability = this.connection.getHoldability();
        this.process_escapes = this.connection.getEscapesProcessing();
        this.m_queryTimeout = 0;
        this.max_field_size = 0;
        this.maxRows = this.connection.getMaxRows();
        this.row_prefetch = this.connection.getDefaultRowPrefetch();
        this.fetch_direction = 1000;
        long ttt = this.handle;
        if (this.handle < 0) {
            ttt = 0xFFFFFFFFL & ttt;
        }
        this.cursorName = "DM7CUR" + ttt;
        this.type = 0;
    }

    private void close_free() throws SQLException {
        if (this.type == 0) {
            if (this.currentRs != null && !this.currentRs.metaRsFlag) {
                this.currentRs.close();
                this.currentRs = null;
            }
            this.originalSql = null;
            if (this.connection != null && !this.connection.closed && this.connection.getStmtPoolSize() < this.connection.getStmtPoolMaxSize()) {
                this.resetState(true);
                this.clearWarnings();
                this.clearBatch();
                this.closed = true;
                this.connection.remove_statement(this.handle);
                this.connection.addToStmtPool(this);
                return;
            }
        }
        try {
            if (this.connection != null && !this.connection.closed) {
                DmdbCSI.freeHandle(this);
                this.connection.remove_statement(this.handle);
                this.connection.delStmt(this);
            }
        }
        finally {
            this.connection = null;
            this.clearWarnings();
            this.clearBatch();
            this.closed = true;
        }
    }

    public synchronized void close() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "close()", "");
        }
        if (this.closed) {
            return;
        }
        this.close_free();
    }

    public void closeSimple() {
        this.closed = true;
    }

    public synchronized void innerClose() throws SQLException {
        try {
            DmdbCSI.freeHandle(this);
            this.connection.remove_statement(this.handle);
        }
        finally {
            this.connection = null;
            this.clearWarnings();
            this.clearBatch();
            this.closed = true;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        return this.max_field_size;
    }

    public synchronized void setMaxFieldSize(int max) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setMaxFieldSize(int)", "max = " + max);
        }
        if (max < 0) {
            DBError.throwSQLException(6036);
        }
        this.max_field_size = max;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public int getMaxRowsInner() throws SQLException {
        if (GlobalControlCfg.getEnRsCache()) {
            return 0;
        }
        return this.maxRows;
    }

    public synchronized void setMaxRows(int max) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setMaxRows(int)", "max = " + max);
        }
        if (max < 0) {
            DBError.throwSQLException(6036);
        }
        this.maxRows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setEscapeProcessing(boolean)", "enable = " + enable);
        }
        this.process_escapes = enable;
    }

    public int getQueryTimeout() throws SQLException {
        return this.m_queryTimeout;
    }

    public synchronized void setQueryTimeout(int seconds) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setQueryTimeout(int)", "seconds = " + seconds);
        }
        if (seconds < 0) {
            DBError.throwSQLException(6036);
        }
        this.m_queryTimeout = seconds;
    }

    public synchronized void cancel() throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.m_warnings;
    }

    public void clearWarnings() throws SQLException {
        this.m_warnings = null;
        if (this.dbInfo != null) {
            this.dbInfo.setExplain(null);
        }
    }

    public void setCursorName(String name) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setCursorName(String)", "name = " + name);
        }
        DmdbCSI.setCursorName(this, name);
        this.cursorName = name;
    }

    public synchronized boolean execute(String sql) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "execute(String)", sql);
        }
        this.executeInner(sql, 1);
        boolean hasRs = this.dbInfo.getHasResultSet();
        return hasRs;
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getResultSet()", "");
        }
        this.checkClosed();
        if (!this.dbInfo.getHasResultSet()) {
            return null;
        }
        return this.currentRs;
    }

    public synchronized int getUpdateCount() throws SQLException {
        int updateCount = -1;
        if (!this.dbInfo.getHasResultSet()) {
            updateCount = (int)this.dbInfo.getRowCount();
            this.dbInfo.setRowCount(-1L);
        }
        return updateCount;
    }

    public boolean getMoreResults() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getMoreResults()", "");
        }
        return this.getMoreResults(this.CLOSE_CURRENT_RESULT);
    }

    public synchronized void setFetchDirection(int direction) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setFetchDirection(int)", "direction = " + direction);
        }
        if (direction == 1000 || direction == 1001) {
            this.fetch_direction = direction;
        } else if (direction == 1002) {
            this.fetch_direction = 1000;
            this.m_warnings = DBError.addSQLWarning(this.m_warnings, 37);
        } else {
            DBError.throwSQLException(6036);
        }
    }

    public int getFetchDirection() throws SQLException {
        return this.fetch_direction;
    }

    public synchronized void setFetchSize(int rows) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setFetchSize(int)", "rows = " + rows);
        }
        if (rows < 0 && rows != Integer.MIN_VALUE || this.maxRows != 0 && this.maxRows != -1 && rows > this.maxRows) {
            DBError.throwSQLException(6036);
        }
        this.row_prefetch = rows;
    }

    public int getFetchSize() throws SQLException {
        return this.row_prefetch;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    public void addBatch(String sql) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "addBatch(String)", sql);
        }
        if (this.m_batchItems == null) {
            this.m_batchItems = new ArrayList(10);
        }
        this.checkNullOrEmpty(sql);
        this.m_batchItems.add(sql);
    }

    public void clearBatch() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "clearBatch()", "");
        }
        if (this.m_batchItems != null) {
            this.m_batchItems.clear();
            this.m_batchItems = null;
        }
    }

    public int[] executeBatch() throws SQLException {
        int[] nArray;
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "executeBatch()", "");
        }
        this.resId = 0;
        this.clearWarnings();
        if (this.connection.isReadOnly()) {
            DBError.throwSQLException(6008);
        }
        try {
            int[] updateCounts = new int[]{};
            if (this.m_batchItems != null) {
                int nbrCommands = this.m_batchItems.size();
                updateCounts = new int[nbrCommands];
                int i = 0;
                while (i < nbrCommands) {
                    updateCounts[i] = this.EXECUTE_FAILED;
                    ++i;
                }
                Throwable sqlEx = null;
                int commandIndex = 0;
                try {
                    commandIndex = 0;
                    while (commandIndex < nbrCommands) {
                        updateCounts[commandIndex] = this.executeUpdate((String)this.m_batchItems.get(commandIndex));
                        ++commandIndex;
                    }
                }
                catch (SQLException ex) {
                    updateCounts[commandIndex] = this.EXECUTE_FAILED;
                    if (this.connection.getContinueBatchOnError()) {
                        sqlEx = ex;
                    }
                    int[] newUpdateCounts = new int[commandIndex];
                    System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                    throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
                }
                if (sqlEx != null) {
                    throw new BatchUpdateException(sqlEx.getMessage(), ((SQLException)sqlEx).getSQLState(), ((SQLException)sqlEx).getErrorCode(), updateCounts);
                }
            }
            nArray = updateCounts != null ? updateCounts : new int[]{};
        }
        catch (Throwable throwable) {
            this.clearBatch();
            throw throwable;
        }
        this.clearBatch();
        return nArray;
    }

    public DmdbConnection_bs getConnection_bs() {
        return this.connection;
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public synchronized boolean getMoreResults(int current) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getMoreResultS(int)", "" + current);
        }
        if (this.dbInfo.getHasResultSet()) {
            this.checkCloseRsCons(current);
            this.getMoreRsInner();
            this.handleOldRsByCloseRs(current);
        }
        return this.dbInfo.getHasResultSet();
    }

    private ResultSet makeGeneratedKeysRs() throws SQLException {
        DmdbInfo dbInfo = new DmdbInfo();
        dbInfo.setColCount(1);
        DmdbColumn[] colInfos = new DmdbColumn[]{new DmdbColumn(this.connection)};
        colInfos[0].getDesc().setDType(8);
        colInfos[0].getDesc().setPrec(8);
        colInfos[0].getDesc().setScale(0);
        colInfos[0].getDesc().setName("AUTO_GEN_KEY");
        colInfos[0].getDesc().setNullable(false);
        colInfos[0].getDesc().setSchName(this.getTbSchNameSolo());
        colInfos[0].getDesc().setTabName(this.getTbNameSolo());
        colInfos[0].getDesc().setTypeName("BIGINT");
        dbInfo.setColumnsInfo(colInfos);
        DmdbResultSetCache_h rsCache = null;
        rsCache = new DmdbResultSetCache_h(this, colInfos);
        int rowCnt = 0;
        if (this.m_retIds != null && this.m_retIds.length > 0) {
            rowCnt = this.m_retIds.length;
        }
        dbInfo.setRowCount(rowCnt);
        byte[] rowbuf = new byte[22 * rowCnt];
        int offset = 0;
        int i = 0;
        while (i < rowCnt) {
            Convertion.setShort(rowbuf, offset, (short)22);
            Convertion.setLong(rowbuf, offset += 2, this.m_retIds[i]);
            Convertion.setShort(rowbuf, offset += 8, (short)12);
            Convertion.setShort(rowbuf, offset += 2, (short)8);
            Convertion.setLong(rowbuf, offset += 2, this.m_retIds[i]);
            offset += 8;
            ++i;
        }
        ((DmdbResultSetCache)rsCache).fillBuffer(rowbuf, rowbuf.length, rowCnt);
        DmdbResultSet_bs rs = null;
        rs = new DmdbResultSet_bs(rsCache, dbInfo, this.m_execfromStanbdy);
        return rs;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getGeneratedKeys()", "");
        }
        ResultSet rs = this.makeGeneratedKeysRs();
        return rs;
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.setAutoGetKeysInner(autoGeneratedKeys);
        int updateCount = this.executeUpdate(sql);
        this.setAutoGenInfoAftExec();
        return updateCount;
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes != null && columnIndexes.length > 0) {
            this.setAutoGetKeysTrue(true);
        } else {
            this.setAutoGetKeysTrue(false);
        }
        int ret = this.executeUpdate(sql);
        this.setAutoGenInfoAftExec();
        return ret;
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (columnNames != null && columnNames.length > 0) {
            this.setAutoGetKeysTrue(true);
        } else {
            this.setAutoGetKeysTrue(false);
        }
        int ret = this.executeUpdate(sql);
        this.setAutoGenInfoAftExec();
        return ret;
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.setAutoGetKeysInner(autoGeneratedKeys);
        boolean hasRs = this.execute(sql);
        this.setAutoGenInfoAftExec();
        return hasRs;
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes != null && columnIndexes.length > 0) {
            this.setAutoGetKeysTrue(true);
        } else {
            this.setAutoGetKeysTrue(false);
        }
        boolean b = this.execute(sql);
        this.setAutoGenInfoAftExec();
        return b;
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (columnNames != null && columnNames.length > 0) {
            this.setAutoGetKeysTrue(true);
        } else {
            this.setAutoGetKeysTrue(false);
        }
        boolean b = this.execute(sql);
        this.setAutoGenInfoAftExec();
        return b;
    }

    public int getResultSetHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    void checkNullOrEmpty(String sql) throws SQLException {
        if (sql == null || sql.length() == 0) {
            DBError.throwSQLException(6003);
        }
    }

    public int getHandle() {
        return this.handle;
    }

    protected DmdbInfo directExec(DmdbStatement_bs stmt, String s, boolean direct, int checkFlag) throws SQLException {
        DmdbInfo info = DmdbCSI.prepareSQL(stmt, s, direct, checkFlag);
        int sqlcode = info.getSQLCode();
        if (sqlcode > 0) {
            this.m_warnings = DBError.addSQLWarning(this.m_warnings, sqlcode);
        }
        return info;
    }

    protected DmdbInfo directExec_Opt(DmdbExecOpt execOpt) throws SQLException {
        DmdbInfo info = DmdbCSI.directExec_Opt(this, execOpt);
        int sqlcode = info.getSQLCode();
        if (sqlcode > 0) {
            this.m_warnings = DBError.addSQLWarning(this.m_warnings, sqlcode);
        }
        return info;
    }

    protected DmdbResultSet_bs getResultSet(boolean fetchAll) throws SQLException {
        if (this.rsCache == null) {
            this.rsCache = this.dbInfo.isBdtaRs() ? new DmdbResultSetCache_v(this, this.dbInfo.getColumnsInfo(), -1) : new DmdbResultSetCache_h(this, this.dbInfo.getColumnsInfo());
        }
        DmdbResultSet_bs rs = new DmdbResultSet_bs(this.rsCache, this.dbInfo, fetchAll, this.m_execfromStanbdy);
        if (this.enableRsCache_dbInfo()) {
            DmdbCachedResultSetPool.addResultSet(rs, this.connection.getGUID(), this.connection.getSchema(), this.originalSql, this.m_TbIds, this.m_TbTss, this.dbInfo);
        }
        return rs;
    }

    protected DmdbResultSet_bs getResultSetPrivate(int closeRs) throws SQLException {
        this.closeCurrentResultSet(closeRs);
        return this.createNewResultSetByDbInfo();
    }

    private void handleOldRsByCloseRs(int closeRs) throws SQLException {
        if (closeRs == 2) {
            if (this.currentRs != null) {
                this.resultsList.add(this.currentRs);
            }
            this.createNewResultSetByDbInfo();
        } else if (closeRs == 1) {
            this.getResultSetPrivate(1);
        } else {
            this.getResultSetPrivate(1);
            int i = 0;
            while (i < this.resultsList.size()) {
                ((DmdbResultSet_bs)this.resultsList.get(i)).close();
                ++i;
            }
            this.resultsList.clear();
        }
    }

    private void checkCloseRsCons(int closeRs) throws SQLException {
        switch (closeRs) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                DBError.throwSQLException(Const.res.getString("error.unsupportedParam"));
            }
        }
    }

    private void closeCurrentResultSet(int closeRs) throws SQLException {
        if (closeRs == 1 && this.currentRs != null) {
            if (this instanceof DmdbCallableStatement_bs) {
                if (((DmdbCallableStatement_bs)this).resultsCount == 0) {
                    this.currentRs.close();
                }
            } else {
                this.currentRs.close();
            }
        }
    }

    private void getMoreRsInner() throws SQLException {
        this.dbInfo = DmdbCSI.getMoreResult(this, (short)0);
        if (this.dbInfo.getHasResultSet()) {
            this.resId = (short)(this.resId + 1);
        }
    }

    private DmdbResultSet_bs createNewResultSetByDbInfo() throws SQLException {
        if (!this.dbInfo.getHasResultSet()) {
            this.currentRs = null;
        } else {
            if (this.rsCache == null) {
                this.rsCache = this.dbInfo.isBdtaRs() ? new DmdbResultSetCache_v(this, this.dbInfo.getColumnsInfo(), -1) : new DmdbResultSetCache_h(this, this.dbInfo.getColumnsInfo());
            }
            this.currentRs = new DmdbResultSet_bs(this.rsCache, this.dbInfo, this.m_execfromStanbdy);
            this.currentRs.setRsId(this.resId);
            this.currentRs.startRow = 0L;
            if (this.enableRsCache_dbInfo()) {
                this.currentRs.fromRsCachePool = true;
                this.currentRs.maxRows = this.maxRows;
                DmdbCachedResultSetPool.addResultSet(this.currentRs, this.connection.getGUID(), this.connection.getSchema(), this.originalSql, this.m_TbIds, this.m_TbTss, this.dbInfo);
            }
        }
        return this.currentRs;
    }

    String getTableNameBySql(String sql) {
        if (!this.m_autoGenKeys) {
            return "";
        }
        int headlen = 0;
        headlen = -1 != sql.toLowerCase().indexOf("insert into") ? "insert into".length() : (-1 != sql.toLowerCase().indexOf("insert") ? "insert".length() : 0);
        if (headlen == 0) {
            return null;
        }
        int valuesIndex = sql.toLowerCase().indexOf("values");
        if (-1 == valuesIndex) {
            return null;
        }
        String sqltb = sql.substring(headlen, valuesIndex).trim();
        int leftB = sqltb.indexOf("(");
        if (-1 == leftB) {
            return sqltb;
        }
        return sqltb.substring(0, leftB).trim();
    }

    String getTbSchNameSolo() {
        if (this.m_insertTableName == null || this.m_insertTableName.length() == 0) {
            return null;
        }
        int colonIndex = this.m_insertTableName.indexOf(".");
        if (colonIndex == -1) {
            return this.connection.getSchema().toUpperCase();
        }
        return this.m_insertTableName.substring(0, colonIndex).toUpperCase();
    }

    String getTbNameSolo() {
        if (this.m_insertTableName == null || this.m_insertTableName.length() == 0) {
            return null;
        }
        int colonIndex = this.m_insertTableName.indexOf(".");
        if (colonIndex == -1) {
            return this.m_insertTableName.toUpperCase();
        }
        return this.m_insertTableName.substring(colonIndex + 1).toUpperCase();
    }

    protected DmdbColumn[] getColumnsInfo() throws SQLException {
        DmdbColumn[] colInfo = null;
        String sql = "select * from " + StringUtil.getEscObjName(this.m_insertTableName) + " where 1 = 2";
        DmdbStatement_bs stmt = (DmdbStatement_bs)this.connection.createStatement();
        stmt.executeQuery(sql);
        colInfo = stmt.dbInfo.getColumnsInfo();
        stmt.close();
        return colInfo;
    }

    public final boolean getIsPutLobData_In() {
        return this.m_putLobData == 1;
    }

    public final void setPutLobData(int flag) {
        this.m_putLobData = flag;
    }

    public boolean autoGeneratedKeys() {
        return this.m_autoGenKeys;
    }

    protected void setAutoGenInfoAftExec() {
        this.m_autoGenKeys = false;
    }

    protected void setAutoGetKeysInner(int autoGeneratedKeys) {
        this.m_autoGenKeys = autoGeneratedKeys == 1;
        this.m_retIds = null;
    }

    protected void setAutoGetKeysTrue(boolean auto) {
        this.m_autoGenKeys = auto;
    }

    protected void transReadOnlyCheck(String sql) throws SQLException {
        String tmpsql = sql.trim();
        String sqlhead = tmpsql.split(" ", 2)[0];
        if (sqlhead.equalsIgnoreCase("INSERT") || sqlhead.equalsIgnoreCase("UPDATE") || sqlhead.equalsIgnoreCase("DELETE") || sqlhead.equalsIgnoreCase("CREATE") || sqlhead.equalsIgnoreCase("TRUNCATE") || sqlhead.equalsIgnoreCase("DROP")) {
            this.connection.setTransReadonly(false);
        }
    }

    protected void executeInner(String sql, int execType) throws SQLException {
        this.resId = 0;
        this.checkClosed();
        this.clearWarnings();
        this.checkNullOrEmpty(sql);
        DmdbExecOpt execOpt = null;
        sql = this.m_ExecOpt ? ((execOpt = this.connection.nativeSQL_ExecOpt(sql, this.process_escapes)).hasErrorOrProcessed() || execOpt.isToPrepare() ? execOpt.getOrgSql() : execOpt.getSqlStr()) : this.connection.nativeSQL(sql, this.process_escapes);
        this.originalSql = sql;
        this.transReadOnlyCheck(sql);
        ++DmdbConnection_bs.execSqlNum;
        this.currentRs = this.enableRsCache() ? DmdbCachedResultSetPool.getResultSet(this.connection.getGUID(), this.connection.getSchema(), this.originalSql, this) : null;
        if (this.currentRs != null) {
            ++DmdbConnection_bs.rsCachedNum;
            this.dbInfo = this.currentRs.dbInfo;
            return;
        }
        int checkFlag = 0;
        switch (execType) {
            case 2: {
                checkFlag = 1;
                break;
            }
            case 3: {
                checkFlag = 2;
            }
        }
        if (this.m_ExecOpt && execOpt != null && !execOpt.hasErrorOrProcessed() && !execOpt.isToPrepare()) {
            try {
                this.dbInfo = this.directExec_Opt(execOpt);
            }
            catch (SQLException ex) {
                if (-2007 == ex.getErrorCode()) {
                    sql = execOpt.getOrgSql();
                    this.dbInfo = this.directExec(this, sql, true, checkFlag);
                }
                throw ex;
            }
        } else {
            this.dbInfo = this.directExec(this, sql, true, checkFlag);
        }
        if (this.dbInfo.getHasResultSet()) {
            this.resId = (short)(this.resId + 1);
        }
        this.getResultSetPrivate(1);
        this.m_insertTableName = this.getTableNameBySql(sql);
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public void setPoolable(boolean poolable) throws SQLException {
    }

    public boolean isPoolable() throws SQLException {
        return this.connection.getStmtPoolMaxSize() > 0;
    }

    public synchronized void preCompile(String sql) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "preCompile(sql)", "sql is " + sql);
        }
        this.checkNullOrEmpty(sql);
        this.originalSql = sql = this.connection.nativeSQL(sql, this.process_escapes);
        this.dbInfo = this.directExec(this, sql, false, 0);
    }

    public synchronized void executeDirect() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "executeDirect()", "");
        }
        this.dbInfo = DmdbCSI.executePrepared(this, 0);
    }

    protected boolean enableRsCache_dbInfo() {
        return GlobalControlCfg.getEnRsCache() && this.dbInfo.getRsCacheOffset() != 0;
    }

    protected boolean enableRsCache() {
        return GlobalControlCfg.getEnRsCache();
    }

    public String getExplain() {
        return this.dbInfo.getExplain();
    }
}

