/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.ParameterDesc;
import dm.jdbc.driver.DmARRAYBinder;
import dm.jdbc.driver.DmBigDecBinder;
import dm.jdbc.driver.DmBinder;
import dm.jdbc.driver.DmBlobBinder;
import dm.jdbc.driver.DmBooleanBinder;
import dm.jdbc.driver.DmByteArrBinder;
import dm.jdbc.driver.DmByteBinder;
import dm.jdbc.driver.DmClobBinder;
import dm.jdbc.driver.DmDateBinder;
import dm.jdbc.driver.DmDoubleBinder;
import dm.jdbc.driver.DmFloatBinder;
import dm.jdbc.driver.DmInputStreamBinder;
import dm.jdbc.driver.DmInputStreamParam;
import dm.jdbc.driver.DmIntBinder;
import dm.jdbc.driver.DmIntvDTBinder;
import dm.jdbc.driver.DmIntvYMBinder;
import dm.jdbc.driver.DmLongBinder;
import dm.jdbc.driver.DmNullBinder;
import dm.jdbc.driver.DmOutParamBinder;
import dm.jdbc.driver.DmReaderBinder;
import dm.jdbc.driver.DmReaderParam;
import dm.jdbc.driver.DmSTRUCTBinder;
import dm.jdbc.driver.DmShortBinder;
import dm.jdbc.driver.DmStringBinder;
import dm.jdbc.driver.DmTimeBinder;
import dm.jdbc.driver.DmTimestampBinder;
import dm.jdbc.driver.DmdbCSI;
import dm.jdbc.driver.DmdbCallableStatement_bs;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbInfo;
import dm.jdbc.driver.DmdbLog;
import dm.jdbc.driver.DmdbParameterMetaData_bs;
import dm.jdbc.driver.DmdbResultSetMetaData_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.driver.DmdmTimeBinder;
import dm.jdbc.innerData.DmdbConnAgent;
import dm.jdbc.innerData.DmdbParamVal;
import dm.jdbc.rsCache.DmdbCachedResultSetPool;
import dm.jdbc.rsCache.DmdbResultSetKey;
import dm.sql.ARRAY;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbSQLOutput;
import dm.sql.DmdbTime;
import dm.sql.STRUCT;
import dm.sql.StructDescriptor;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.ResourceBundle;

public class DmdbPreparedStatement_bs
extends DmdbStatement_bs
implements PreparedStatement {
    ParameterDesc[] m_paramsDesc = null;
    private int m_outParamCount = 0;
    String printMsg = null;
    boolean realClose = false;
    private final ResourceBundle res = Const.res;
    Object[] m_paramObjects = null;
    byte[][] m_nullIndicator = null;
    private int m_rowIndex = -1;
    protected DmBinder[] m_curRow = null;
    private int m_rowsAllocated;
    private byte[] m_bindIndicator = null;
    private boolean m_isBatchOpt = false;
    private boolean m_bp_with_err = false;

    public void setRealClose(boolean rClose) {
        this.realClose = rClose;
    }

    private void checkIndexInner(int index) throws SQLException {
        int paramCount = this.getParamCount();
        if (index < 1 || index > paramCount) {
            String str = "colid = " + index + ",  ";
            str = this.m_paramsDesc == null ? String.valueOf(str) + "m_paramsDesc is null" : String.valueOf(str) + "m_paramsDesc length is " + paramCount;
            if (Const.TRACE_LEVEL > 0) {
                DmdbLog.trace(this, "checkIndex()", str);
            }
            DBError.throwSQLException(6010);
        }
    }

    protected synchronized void paramBindPrepare(int paramIndex) throws SQLException {
        this.checkIndexInner(paramIndex);
        if (this.m_rowIndex < 0) {
            this.m_rowIndex = 0;
        }
        int i = paramIndex - 1;
        if (!this.m_isBatchOpt && (this.m_bindIndicator[i] & 1) == 1) {
            if (this.m_curRow[i] != null) {
                if (this.m_curRow[i] instanceof DmOutParamBinder) {
                    this.m_curRow[i].setInoutParamBinder(null);
                    if (this.m_paramsDesc[i].getIOType() == 2) {
                        this.m_curRow[i].setInoutParamBinder(new DmNullBinder(this));
                    }
                } else {
                    this.m_curRow[i] = new DmNullBinder(this);
                }
            }
            this.m_paramObjects[i] = null;
            this.m_nullIndicator[this.m_rowIndex][i] = 0;
        }
        int n = i;
        this.m_bindIndicator[n] = (byte)(this.m_bindIndicator[n] | 1);
    }

    protected synchronized void OutparamBindPrepare(int paramIndex) throws SQLException {
        this.checkIndexInner(paramIndex);
        if (this.m_rowIndex < 0) {
            this.m_rowIndex = 0;
        }
        int i = paramIndex - 1;
        if (!this.m_isBatchOpt && (this.m_bindIndicator[i] & 0x80) == 128 && this.m_curRow[i] != null && this.m_curRow[i] instanceof DmOutParamBinder) {
            DmBinder inbinder = ((DmOutParamBinder)this.m_curRow[i]).getInoutParamBinder();
            this.m_curRow[i] = new DmOutParamBinder(this);
            this.m_curRow[i].setInoutParamBinder(inbinder);
        }
        int n = i;
        this.m_bindIndicator[n] = (byte)(this.m_bindIndicator[n] | 0x80);
    }

    private void growBinds(int totalRows) {
        if (totalRows < this.m_rowsAllocated) {
            return;
        }
        int destRows = 0;
        destRows = this.m_rowsAllocated > 20000 ? this.m_rowsAllocated + 20000 : this.m_rowsAllocated * 2;
        Object lparam = null;
        int paramCount = this.getParamCount();
        int i = 0;
        while (i < paramCount) {
            if (this.m_paramObjects[i] instanceof boolean[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new boolean[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof byte[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new byte[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof short[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new short[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof int[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new int[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof long[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new long[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof float[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new float[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof double[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new double[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof BigDecimal[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new BigDecimal[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof Date[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new Date[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof Timestamp[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new Timestamp[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof Time[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new Time[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof DmdbTime[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new DmdbTime[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof DmdbIntervalDT[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new DmdbIntervalDT[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof DmdbIntervalYM[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new DmdbIntervalYM[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof String[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new String[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof byte[][]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new byte[destRows][];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof Blob[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new Blob[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof Clob[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new Clob[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof DmReaderParam[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new DmReaderParam[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof DmInputStreamParam[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new DmInputStreamParam[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof ARRAY[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new ARRAY[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else if (this.m_paramObjects[i] instanceof STRUCT[]) {
                lparam = this.m_paramObjects[i];
                this.m_paramObjects[i] = new STRUCT[destRows];
                System.arraycopy(lparam, 0, this.m_paramObjects[i], 0, totalRows);
            } else {
                Object cfr_ignored_0 = this.m_paramObjects[i];
            }
            ++i;
        }
        if (this.m_nullIndicator != null) {
            lparam = this.m_nullIndicator;
            this.m_nullIndicator = new byte[destRows][];
            System.arraycopy(lparam, 0, this.m_nullIndicator, 0, totalRows);
            i = totalRows;
            while (i < destRows) {
                this.m_nullIndicator[i] = new byte[paramCount];
                ++i;
            }
        }
        this.m_rowsAllocated = destRows;
    }

    private void checkParamBoundInner() throws SQLException {
        int paramCount = this.getParamCount();
        int index = 0;
        while (index < paramCount) {
            if (this.m_paramsDesc[index].getIOType() != 1 && this.m_paramsDesc[index].getIOType() != 2 && this.m_paramsDesc[index].getDType() != 120 && (this.m_bindIndicator == null || (this.m_bindIndicator[index] & 1) == 0)) {
                DBError.throwSQLException(6054);
                break;
            }
            ++index;
        }
    }

    private void addBatchInner() throws SQLException {
        this.checkParamBoundInner();
        ++this.m_rowIndex;
        this.m_bindIndicator = new byte[this.getParamCount()];
        this.growBinds(this.m_rowIndex);
        this.m_isBatchOpt = true;
    }

    private void setObjectInner(int paramIndex, Object value) throws SQLException {
        if (value == null) {
            this.setNull(paramIndex, 0);
            return;
        }
        if (value instanceof Boolean) {
            this.setBooleanInner(paramIndex, (Boolean)value);
        } else if (value instanceof Byte) {
            this.setByte(paramIndex, (Byte)value);
        } else if (value instanceof Short) {
            this.setShort(paramIndex, (Short)value);
        } else if (value instanceof Integer) {
            this.setIntInner(paramIndex, (Integer)value);
        } else if (value instanceof Long) {
            this.setLongInner(paramIndex, (Long)value);
        } else if (value instanceof Float) {
            this.setFloatInner(paramIndex, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.setDoubleInner(paramIndex, (Double)value);
        } else if (value instanceof BigDecimal) {
            this.setBigDecimalInner(paramIndex, (BigDecimal)value);
        } else if (value instanceof BigInteger) {
            this.setBigDecimalInner(paramIndex, new BigDecimal((BigInteger)value));
        } else if (value instanceof Date) {
            this.setDateInner(paramIndex, (Date)value);
        } else if (value instanceof Timestamp) {
            this.setTimestampInner(paramIndex, (Timestamp)value);
        } else if (value instanceof Time) {
            this.setTimeInner(paramIndex, (Time)value);
        } else if (value instanceof DmdbTime) {
            this.setTIMEInner(paramIndex, (DmdbTime)value);
        } else if (value instanceof DmdbIntervalDT) {
            this.setINTERVALDTInner(paramIndex, (DmdbIntervalDT)value);
        } else if (value instanceof DmdbIntervalYM) {
            this.setINTERVALYMInner(paramIndex, (DmdbIntervalYM)value);
        } else if (value instanceof java.util.Date) {
            java.util.Date udt = (java.util.Date)value;
            Date date = new Date(udt.getTime());
            this.setDateInner(paramIndex, date);
        } else if (value instanceof String) {
            this.setStringInner(paramIndex, (String)value);
        } else if (value instanceof byte[]) {
            this.setBytesInner(paramIndex, (byte[])value);
        } else if (value instanceof Blob) {
            this.setBlobInner(paramIndex, (Blob)value);
        } else if (value instanceof Clob) {
            this.setClobInner(paramIndex, (Clob)value);
        } else if (value instanceof Reader) {
            this.setReaderInner(paramIndex, (Reader)value, 0L, false);
        } else if (value instanceof InputStream) {
            this.setInputstreamInner(paramIndex, (InputStream)value, 0L, false);
        } else if (value instanceof ARRAY) {
            this.setArrayInner(paramIndex, (Array)value);
        } else if (value instanceof STRUCT) {
            this.setStructInner(paramIndex, (Struct)value);
        } else if (value instanceof Character) {
            char[] chars = new char[]{((Character)value).charValue()};
            this.setStringInner(paramIndex, new String(chars));
        } else if (value instanceof SQLData) {
            String typeName = ((SQLData)value).getSQLTypeName();
            if (this.connection.getTypeMap().containsKey(typeName) && value.getClass() == this.connection.getTypeMap().get(typeName)) {
                DmdbConnAgent connAgent = new DmdbConnAgent(this.connection);
                StructDescriptor desc = StructDescriptor.createDescriptor(typeName, connAgent);
                DmdbSQLOutput stream = new DmdbSQLOutput();
                ((SQLData)value).writeSQL(stream);
                STRUCT struct = new STRUCT(desc, connAgent, stream.getAttribs());
                this.setStructInner(paramIndex, struct);
            } else {
                DBError.throwSQLException(6007);
            }
        } else {
            DBError.throwUnsupportedSQLException();
        }
    }

    public final int getBatchSize() {
        return this.m_rowIndex;
    }

    public final byte[][] getNullIndicator() throws SQLException {
        return this.m_nullIndicator;
    }

    public final DmBinder[] getParamBoundDesc() throws SQLException {
        return this.m_curRow;
    }

    void checkOutParam(int paramIndex) throws SQLException {
        if (this.m_paramsDesc == null) {
            throw new SQLException(Const.res.getString("error.notOutParam"));
        }
        this.checkIndexInner(paramIndex);
        byte ioType = this.m_paramsDesc[paramIndex - 1].getIOType();
        if (ioType != 1 && ioType != 2) {
            throw new SQLException(Const.res.getString("error.notOutParam"));
        }
    }

    protected void regOutParam(int paramIndex, int SQLType2) throws SQLException {
        this.checkOutParam(paramIndex);
        this.OutparamBindPrepare(paramIndex);
        DmOutParamBinder outBinder = (DmOutParamBinder)this.m_curRow[paramIndex - 1];
        outBinder.setSqlType(SQLType2);
    }

    protected void regOutParam(int paramIndex, int SQLType2, int sqlScale) throws SQLException {
        this.checkOutParam(paramIndex);
        this.OutparamBindPrepare(paramIndex);
        DmOutParamBinder outBinder = (DmOutParamBinder)this.m_curRow[paramIndex - 1];
        outBinder.setSqlType(SQLType2);
        outBinder.setSqlScale(sqlScale);
    }

    protected void regOutParam(int paramIndex, int SQLType2, String typeName) throws SQLException {
        this.checkOutParam(paramIndex);
        this.OutparamBindPrepare(paramIndex);
        DmOutParamBinder outBinder = (DmOutParamBinder)this.m_curRow[paramIndex - 1];
        outBinder.setSqlType(SQLType2);
        outBinder.setTypeName(typeName);
    }

    public int getOutParamCount() {
        return this.m_outParamCount;
    }

    public void copyParamValueBound(DmdbResultSetKey rsKey) {
        int paramCount = this.getParamCount();
        if (paramCount <= 0 || paramCount - this.getOutParamCount() <= 0) {
            return;
        }
        rsKey.m_paramObjects = new Object[paramCount];
        int i = 0;
        while (i < paramCount) {
            if (this.m_paramObjects[i] instanceof boolean[]) {
                rsKey.m_paramObjects[i] = new Boolean(((boolean[])this.m_paramObjects[i])[0]);
            } else if (this.m_paramObjects[i] instanceof byte[]) {
                rsKey.m_paramObjects[i] = new Byte(((byte[])this.m_paramObjects[i])[0]);
            } else if (this.m_paramObjects[i] instanceof short[]) {
                rsKey.m_paramObjects[i] = new Short(((short[])this.m_paramObjects[i])[0]);
            } else if (this.m_paramObjects[i] instanceof int[]) {
                rsKey.m_paramObjects[i] = new Integer(((int[])this.m_paramObjects[i])[0]);
            } else if (this.m_paramObjects[i] instanceof long[]) {
                rsKey.m_paramObjects[i] = new Long(((long[])this.m_paramObjects[i])[0]);
            } else if (this.m_paramObjects[i] instanceof float[]) {
                rsKey.m_paramObjects[i] = new Float(((float[])this.m_paramObjects[i])[0]);
            } else if (this.m_paramObjects[i] instanceof double[]) {
                rsKey.m_paramObjects[i] = new Double(((double[])this.m_paramObjects[i])[0]);
            } else if (this.m_paramObjects[i] instanceof BigDecimal[]) {
                rsKey.m_paramObjects[i] = ((BigDecimal[])this.m_paramObjects[i])[0];
            } else if (this.m_paramObjects[i] instanceof Date[]) {
                rsKey.m_paramObjects[i] = ((Date[])this.m_paramObjects[i])[0].clone();
            } else if (this.m_paramObjects[i] instanceof Timestamp[]) {
                rsKey.m_paramObjects[i] = ((Timestamp[])this.m_paramObjects[i])[0].clone();
            } else if (this.m_paramObjects[i] instanceof Time[]) {
                rsKey.m_paramObjects[i] = ((Time[])this.m_paramObjects[i])[0].clone();
            } else if (this.m_paramObjects[i] instanceof DmdbTime[]) {
                rsKey.m_paramObjects[i] = ((DmdbTime[])this.m_paramObjects[i])[0].clone();
            } else if (this.m_paramObjects[i] instanceof DmdbIntervalDT[]) {
                rsKey.m_paramObjects[i] = ((DmdbIntervalDT[])this.m_paramObjects[i])[0].clone();
            } else if (this.m_paramObjects[i] instanceof DmdbIntervalYM[]) {
                rsKey.m_paramObjects[i] = ((DmdbIntervalYM[])this.m_paramObjects[i])[0].clone();
            } else if (this.m_paramObjects[i] instanceof String[]) {
                rsKey.m_paramObjects[i] = ((String[])this.m_paramObjects[i])[0];
            } else if (this.m_paramObjects[i] instanceof byte[][]) {
                int len = ((byte[][])this.m_paramObjects[i])[0].length;
                rsKey.m_paramObjects[i] = new byte[len];
                System.arraycopy(((byte[][])this.m_paramObjects[i])[0], 0, (byte[])rsKey.m_paramObjects[i], 0, len);
            }
            ++i;
        }
    }

    public int getParamCount() {
        if (this.m_paramsDesc == null) {
            return 0;
        }
        return this.m_paramsDesc.length;
    }

    void initializeParam(boolean closeFlag) throws SQLException {
        if (closeFlag) {
            this.m_outParamCount = 0;
            this.m_curRow = null;
            this.m_bindIndicator = null;
            this.m_rowIndex = -1;
            this.m_paramObjects = null;
            this.m_isBatchOpt = false;
            return;
        }
        if (this.m_paramsDesc == null) {
            this.m_outParamCount = 0;
            if (this.m_curRow == null) {
                this.m_curRow = new DmBinder[0];
            }
            this.m_bindIndicator = null;
            this.m_rowIndex = -1;
            this.m_paramObjects = null;
            this.m_isBatchOpt = false;
            return;
        }
        this.m_rowIndex = -1;
        this.m_rowsAllocated = 500;
        int paramCount = this.getParamCount();
        if (this.m_curRow != null) {
            int i = 0;
            while (i < paramCount) {
                if (this.m_curRow[i] != null) {
                    if (this.m_curRow[i] instanceof DmOutParamBinder) {
                        this.m_curRow[i].setInoutParamBinder(null);
                        if (this.m_paramsDesc[i].getIOType() == 2) {
                            this.m_curRow[i].setInoutParamBinder(new DmNullBinder(this));
                        }
                    } else {
                        this.m_curRow[i] = new DmNullBinder(this);
                    }
                }
                ++i;
            }
        } else {
            this.m_curRow = new DmBinder[paramCount];
            this.m_outParamCount = 0;
            int i = 0;
            while (i < paramCount) {
                if (this.m_paramsDesc[i].getIOType() == 0) {
                    this.m_curRow[i] = new DmNullBinder(this);
                } else {
                    this.m_curRow[i] = new DmOutParamBinder(this);
                    ++this.m_outParamCount;
                    if (this.m_paramsDesc[i].getIOType() == 2) {
                        this.m_curRow[i].setInoutParamBinder(new DmNullBinder(this));
                    }
                }
                ++i;
            }
        }
        this.m_paramObjects = new Object[paramCount];
        this.m_nullIndicator = new byte[this.m_rowsAllocated][paramCount];
        this.m_bindIndicator = new byte[paramCount];
    }

    void initialize(String sql) throws SQLException {
        this.checkNullOrEmpty(sql);
        this.originalSql = this.connection.nativeSQL(sql, this.process_escapes);
        this.transReadOnlyCheck(this.originalSql);
        this.dbInfo = null;
        if (this.dbInfo == null) {
            this.dbInfo = this.directExec(this, this.originalSql, false, 0);
        }
        this.m_paramsDesc = this.dbInfo.getParamsInfo();
        this.initializeParam(false);
        this.type = 1;
        this.m_insertTableName = this.getTableNameBySql(this.originalSql);
    }

    void initializeReusePreparedStmt(DmdbConnection_bs conn, String sql) throws SQLException {
        super.initializeReuseStmt(conn);
        this.type = 1;
    }

    public DmdbPreparedStatement_bs(DmdbConnection_bs conn, String sql) throws SQLException {
        super(conn);
        this.initialize(sql);
    }

    public DmdbPreparedStatement_bs(DmdbConnection_bs conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(conn, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.initialize(sql);
    }

    protected DmdbPreparedStatement_bs(DmdbConnection_bs conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys) throws SQLException {
        super(conn, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.setAutoGetKeysInner(autoGeneratedKeys);
        this.initialize(sql);
    }

    protected DmdbPreparedStatement_bs(DmdbConnection_bs conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int[] columnIndexes) throws SQLException {
        super(conn, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (columnIndexes != null && columnIndexes.length > 0) {
            this.setAutoGetKeysTrue(true);
        } else {
            this.setAutoGetKeysTrue(false);
        }
        this.initialize(sql);
    }

    protected DmdbPreparedStatement_bs(DmdbConnection_bs conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String[] columnNames) throws SQLException {
        super(conn, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (columnNames != null && columnNames.length > 0) {
            this.setAutoGetKeysTrue(true);
        } else {
            this.setAutoGetKeysTrue(false);
        }
        this.initialize(sql);
    }

    protected DmdbPreparedStatement_bs(DmdbConnection_bs conn, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(conn, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public synchronized ResultSet executeQuery() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "executeQuery()", "");
        }
        this.executeInner(0, 2);
        if (this instanceof DmdbCallableStatement_bs) {
            ((DmdbCallableStatement_bs)this).colsInfo = new ArrayList(((DmdbCallableStatement_bs)this).resultsCount);
            ((DmdbCallableStatement_bs)this).colsInfo.add(this.dbInfo.getColumnsInfo());
            this.rsCache = null;
        }
        return this.currentRs;
    }

    public synchronized ResultSet executeQuery2() throws SQLException {
        this.fromRowSetFlag = true;
        this.executeInner(0, 4);
        return this.currentRs;
    }

    public int executeUpdate() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "executeUpdate()", "");
        }
        return this.executeUpdate_ex(0);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setNull()", "colid = " + parameterIndex + ", sqlType is " + sqlType);
        }
        this.paramBindPrepare(parameterIndex);
        this.setNullInner(parameterIndex);
    }

    private void setNullInner(int parameterIndex) throws SQLException {
        int paramCount = this.getParamCount();
        if (this.m_nullIndicator == null) {
            this.m_nullIndicator = new byte[this.m_rowsAllocated][paramCount];
        }
        this.m_nullIndicator[this.m_rowIndex][parameterIndex - 1] = 1;
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setBoolean()", "colid = " + parameterIndex + ", boolean is " + x);
        }
        this.paramBindPrepare(parameterIndex);
        this.setBooleanInner(parameterIndex, x);
    }

    private void setBooleanInner(int parameterIndex, boolean x) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmBooleanBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmBooleanBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmBooleanBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (this.m_paramObjects[parameterIndex - 1] == null) {
            this.m_paramObjects[parameterIndex - 1] = new boolean[this.m_rowsAllocated];
        }
        ((boolean[])this.m_paramObjects[parameterIndex - 1])[this.m_rowIndex] = x;
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setByte()", "colid = " + parameterIndex + ", byte is " + x);
        }
        this.paramBindPrepare(parameterIndex);
        this.setByteInner(parameterIndex, x);
    }

    private void setByteInner(int parameterIndex, byte x) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmByteBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmByteBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmByteBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (this.m_paramObjects[parameterIndex - 1] == null) {
            this.m_paramObjects[parameterIndex - 1] = new byte[this.m_rowsAllocated];
        }
        ((byte[])this.m_paramObjects[parameterIndex - 1])[this.m_rowIndex] = x;
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setShort()", "colid = " + parameterIndex + ", short is " + x);
        }
        this.paramBindPrepare(parameterIndex);
        this.setShortInner(parameterIndex, x);
    }

    private void setShortInner(int parameterIndex, short x) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmShortBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmShortBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmShortBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (this.m_paramObjects[parameterIndex - 1] == null) {
            this.m_paramObjects[parameterIndex - 1] = new short[this.m_rowsAllocated];
        }
        ((short[])this.m_paramObjects[parameterIndex - 1])[this.m_rowIndex] = x;
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setInt()", "colid = " + parameterIndex + ", int is " + x);
        }
        this.paramBindPrepare(parameterIndex);
        this.setIntInner(parameterIndex, x);
    }

    private void setIntInner(int parameterIndex, int x) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmIntBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmIntBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmIntBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (this.m_paramObjects[parameterIndex - 1] == null) {
            this.m_paramObjects[parameterIndex - 1] = new int[this.m_rowsAllocated];
        }
        ((int[])this.m_paramObjects[parameterIndex - 1])[this.m_rowIndex] = x;
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setLong()", "colid = " + parameterIndex + ", long is " + x);
        }
        this.paramBindPrepare(parameterIndex);
        this.setLongInner(parameterIndex, x);
    }

    private void setLongInner(int parameterIndex, long x) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmLongBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmLongBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmLongBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (this.m_paramObjects[parameterIndex - 1] == null) {
            this.m_paramObjects[parameterIndex - 1] = new long[this.m_rowsAllocated];
        }
        ((long[])this.m_paramObjects[parameterIndex - 1])[this.m_rowIndex] = x;
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setFloat()", "colid = " + parameterIndex + ", float is " + x);
        }
        this.paramBindPrepare(parameterIndex);
        this.setFloatInner(parameterIndex, x);
    }

    private void setFloatInner(int parameterIndex, float x) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmFloatBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmFloatBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmFloatBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (this.m_paramObjects[parameterIndex - 1] == null) {
            this.m_paramObjects[parameterIndex - 1] = new float[this.m_rowsAllocated];
        }
        ((float[])this.m_paramObjects[parameterIndex - 1])[this.m_rowIndex] = x;
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setDouble()", "colid = " + parameterIndex + ", double is " + x);
        }
        this.paramBindPrepare(parameterIndex);
        this.setDoubleInner(parameterIndex, x);
    }

    private void setDoubleInner(int parameterIndex, double x) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmDoubleBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmDoubleBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmDoubleBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (this.m_paramObjects[parameterIndex - 1] == null) {
            this.m_paramObjects[parameterIndex - 1] = new double[this.m_rowsAllocated];
        }
        ((double[])this.m_paramObjects[parameterIndex - 1])[this.m_rowIndex] = x;
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "setBigDecimal()", "colid = " + parameterIndex + ", BigDecimal is null");
            } else {
                DmdbLog.trace(this, "setBigDecimal()", "colid = " + parameterIndex + ", BigDecimal is " + x.toString());
            }
        }
        this.paramBindPrepare(parameterIndex);
        this.setBigDecimalInner(parameterIndex, x);
    }

    private void setBigDecimalInner(int parameterIndex, BigDecimal x) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmBigDecBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmBigDecBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmBigDecBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (x == null) {
            this.setNullInner(parameterIndex);
            return;
        }
        if (this.m_paramObjects[parameterIndex - 1] == null) {
            this.m_paramObjects[parameterIndex - 1] = new BigDecimal[this.m_rowsAllocated];
        }
        ((BigDecimal[])this.m_paramObjects[parameterIndex - 1])[this.m_rowIndex] = x;
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "setString()", "colid = " + parameterIndex + ", string is null");
            } else {
                DmdbLog.trace(this, "setString()", "colid = " + parameterIndex + ", string is " + x);
            }
        }
        this.paramBindPrepare(parameterIndex);
        this.setStringInner(parameterIndex, x);
    }

    private void setStringInner(int parameterIndex, String x) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmStringBinder(this, x == null ? 0 : x.length()));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmStringBinder(this, x == null ? 0 : x.length());
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmStringBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (x == null || x.length() == 0 && DmdbType.emptyStringToNull(this.m_paramsDesc[parameterIndex - 1].getDType())) {
            this.setNullInner(parameterIndex);
            return;
        }
        if (this.m_paramObjects[parameterIndex - 1] == null) {
            this.m_paramObjects[parameterIndex - 1] = new String[this.m_rowsAllocated];
        }
        ((String[])this.m_paramObjects[parameterIndex - 1])[this.m_rowIndex] = x;
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "setBytes()", "colid = " + parameterIndex + ", bytes is null");
            } else {
                DmdbLog.trace(this, "setBytes()", "colid = " + parameterIndex + ", bytes is " + x.toString());
            }
        }
        this.paramBindPrepare(parameterIndex);
        this.setBytesInner(parameterIndex, x);
    }

    private void setBytesInner(int parameterIndex, byte[] x) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmByteArrBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmByteArrBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmByteArrBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (x == null) {
            this.setNullInner(parameterIndex);
            return;
        }
        if (this.m_paramObjects[parameterIndex - 1] == null) {
            this.m_paramObjects[parameterIndex - 1] = new byte[this.m_rowsAllocated][];
        }
        ((byte[][])this.m_paramObjects[parameterIndex - 1])[this.m_rowIndex] = x;
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "setDate()", "colid = " + parameterIndex + ", date is null");
            } else {
                DmdbLog.trace(this, "setDate()", "colid = " + parameterIndex + ", date is " + x.toString());
            }
        }
        this.paramBindPrepare(parameterIndex);
        this.setDateInner(parameterIndex, x);
    }

    private void setDateInner(int parameterIndex, Date x) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmDateBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmDateBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmDateBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (x == null) {
            this.setNullInner(parameterIndex);
            return;
        }
        if (this.m_paramObjects[parameterIndex - 1] == null) {
            this.m_paramObjects[parameterIndex - 1] = new Date[this.m_rowsAllocated];
        }
        ((Date[])this.m_paramObjects[parameterIndex - 1])[this.m_rowIndex] = x;
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "setTime()", "colid = " + parameterIndex + ", time is null");
            } else {
                DmdbLog.trace(this, "setTime()", "colid = " + parameterIndex + ", time is " + x);
            }
        }
        this.paramBindPrepare(parameterIndex);
        this.setTimeInner(parameterIndex, x);
    }

    private void setTimeInner(int parameterIndex, Time x) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmTimeBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmTimeBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmTimeBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (x == null) {
            this.setNullInner(parameterIndex);
            return;
        }
        if (this.m_paramObjects[parameterIndex - 1] == null) {
            this.m_paramObjects[parameterIndex - 1] = new Time[this.m_rowsAllocated];
        }
        ((Time[])this.m_paramObjects[parameterIndex - 1])[this.m_rowIndex] = x;
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "setTimestamp()", "colid = " + parameterIndex + ", timestamp is null");
            } else {
                DmdbLog.trace(this, "setTimestamp()", "colid = " + parameterIndex + ", timestamp is " + x);
            }
        }
        this.paramBindPrepare(parameterIndex);
        this.setTimestampInner(parameterIndex, x);
    }

    private void setTimestampInner(int parameterIndex, Timestamp x) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmTimestampBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmTimestampBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmTimestampBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (x == null) {
            this.setNullInner(parameterIndex);
            return;
        }
        if (this.m_paramObjects[parameterIndex - 1] == null) {
            this.m_paramObjects[parameterIndex - 1] = new Timestamp[this.m_rowsAllocated];
        }
        ((Timestamp[])this.m_paramObjects[parameterIndex - 1])[this.m_rowIndex] = x;
    }

    public synchronized void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "setAsciiStream()", "colid = " + parameterIndex + ", InputStream is null");
            } else {
                DmdbLog.trace(this, "setAsciiStream()", "colid = " + parameterIndex + ", InputStream is " + x.toString() + ", length = " + length);
            }
        }
        this.paramBindPrepare(parameterIndex);
        this.setInputstreamInner(parameterIndex, x, length, true);
    }

    private void setInputstreamInner(int parameterIndex, InputStream x, long length, boolean hasLength) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmInputStreamBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmInputStreamBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmInputStreamBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (x == null) {
            this.setNullInner(parameterIndex);
            return;
        }
        if (this.m_paramObjects[parameterIndex - 1] == null) {
            this.m_paramObjects[parameterIndex - 1] = new DmInputStreamParam[this.m_rowsAllocated];
        }
        ((DmInputStreamParam[])this.m_paramObjects[parameterIndex - 1])[this.m_rowIndex] = hasLength ? new DmInputStreamParam(x, length) : new DmInputStreamParam(x);
    }

    public synchronized void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "setAsciiStream()", "colid = " + parameterIndex + ", InputStream is null");
            } else {
                DmdbLog.trace(this, "setAsciiStream()", "colid = " + parameterIndex + ", InputStream is " + x.toString() + ", length = " + length);
            }
        }
        this.paramBindPrepare(parameterIndex);
        this.setInputstreamInner(parameterIndex, x, length, true);
    }

    public synchronized void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "setAsciiStream()", "colid = " + parameterIndex + ", InputStream is null");
            } else {
                DmdbLog.trace(this, "setAsciiStream()", "colid = " + parameterIndex + ", InputStream is " + x.toString());
            }
        }
        this.paramBindPrepare(parameterIndex);
        this.setInputstreamInner(parameterIndex, x, 0L, false);
    }

    public synchronized void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "setUnicodeStream()", "colid = " + parameterIndex + ", inputStream is null");
            } else {
                DmdbLog.trace(this, "setUnicodeStream()", "colid = " + parameterIndex + ", inputStream is " + x + ", length = " + length);
            }
        }
        this.paramBindPrepare(parameterIndex);
        this.setInputstreamInner(parameterIndex, x, length, true);
    }

    public synchronized void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "setBinaryStream()", "colid = " + parameterIndex + ", InputStream is null");
            } else {
                DmdbLog.trace(this, "setBinaryStream()", "colid = " + parameterIndex + ", InputStream is " + x.toString() + ", length = " + length);
            }
        }
        this.paramBindPrepare(parameterIndex);
        this.setInputstreamInner(parameterIndex, x, length, true);
    }

    public synchronized void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "setBinaryStream()", "colid = " + parameterIndex + ", InputStream is null");
            } else {
                DmdbLog.trace(this, "setBinaryStream()", "colid = " + parameterIndex + ", InputStream is " + x.toString() + ", length = " + length);
            }
        }
        this.paramBindPrepare(parameterIndex);
        this.setInputstreamInner(parameterIndex, x, length, true);
    }

    public synchronized void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "setBinaryStream()", "colid = " + parameterIndex + ", InputStream is null");
            } else {
                DmdbLog.trace(this, "setBinaryStream()", "colid = " + parameterIndex + ", InputStream is " + x.toString());
            }
        }
        this.paramBindPrepare(parameterIndex);
        this.setInputstreamInner(parameterIndex, x, 0L, false);
    }

    public void clearOutParamVal() throws SQLException {
        if (this.m_curRow != null) {
            int paramCount = this.getParamCount();
            int i = 0;
            while (i < paramCount) {
                if (this.m_curRow[i] != null && this.m_curRow[i] instanceof DmOutParamBinder) {
                    DmOutParamBinder outBinder = (DmOutParamBinder)this.m_curRow[i];
                    if (this.m_paramsDesc[i].getDType() == 120) {
                        DmdbStatement_bs stmt = (DmdbStatement_bs)this.connection.createStatement();
                        stmt.setFromStandby(this.getFromStandby());
                        outBinder.setCursorStmt(stmt);
                    }
                    outBinder.setOutValue(null);
                    outBinder.setOutNullFlag(false);
                }
                ++i;
            }
        }
    }

    public synchronized void clearParameters() throws SQLException {
        this.initializeParam(false);
    }

    void resetState() throws SQLException {
        super.resetState(false);
        this.printMsg = null;
    }

    public synchronized void close() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "close()", "");
        }
        if (this.closed) {
            return;
        }
        if (this.currentRs != null) {
            this.currentRs.close();
            this.currentRs = null;
        }
        if (this.connection != null && !this.connection.closed && !this.realClose && this.connection.getStmtPoolMaxSize() > 0) {
            this.resetState();
            this.clearWarnings();
            this.clearBatch();
            this.closed = true;
            this.connection.remove_statement(this.handle);
            this.connection.addToPreparedStmtPool(this);
            return;
        }
        super.close();
        this.dbInfo = null;
        this.m_paramsDesc = null;
        this.m_curRow = null;
        this.realClose = false;
        this.initializeParam(true);
    }

    public synchronized void innerClose() throws SQLException {
        if (this.currentRs != null) {
            this.currentRs.close();
            this.currentRs = null;
        }
        super.innerClose();
        this.dbInfo = null;
        this.m_paramsDesc = null;
        this.m_outParamCount = 0;
        this.realClose = false;
    }

    private boolean isValidDecimalObject(Object x) {
        if (x == null) {
            return false;
        }
        return x instanceof BigDecimal || x instanceof Boolean || x instanceof Byte || x instanceof Double || x instanceof Float || x instanceof Integer || x instanceof Long || x instanceof Short || x instanceof String;
    }

    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "setObject()", "colid = " + parameterIndex + ", x is null");
            } else {
                DmdbLog.trace(this, "setObject()", "colid = " + parameterIndex + ", x is " + x.toString());
            }
        }
        this.paramBindPrepare(parameterIndex);
        if ((targetSqlType == 3 || targetSqlType == 2) && this.isValidDecimalObject(x)) {
            String strValue = "";
            strValue = x instanceof Boolean ? ((Boolean)x != false ? "1" : "0") : String.valueOf(x);
            BigDecimal bgd = new BigDecimal(strValue);
            x = bgd.setScale(scale, 4);
        }
        this.setObjectInner(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, this.m_paramsDesc[parameterIndex - 1].getScale());
    }

    public synchronized void setObject(int parameterIndex, Object x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "setObject()", "colid = " + parameterIndex + ", x is null");
            } else {
                DmdbLog.trace(this, "setObject()", "colid = " + parameterIndex + ", x is " + x.toString());
            }
        }
        this.paramBindPrepare(parameterIndex);
        this.setObjectInner(parameterIndex, x);
    }

    public synchronized boolean execute() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "execute()", "");
        }
        this.executeInner(0, 1);
        if (this instanceof DmdbCallableStatement_bs) {
            ((DmdbCallableStatement_bs)this).colsInfo = new ArrayList(((DmdbCallableStatement_bs)this).resultsCount);
            ((DmdbCallableStatement_bs)this).colsInfo.add(this.dbInfo.getColumnsInfo());
            this.rsCache = null;
        }
        return this.dbInfo.getHasResultSet();
    }

    public void addBatch() throws SQLException {
        this.addBatchInner();
    }

    private boolean checkBatch() {
        return this.m_rowIndex >= 0;
    }

    private int[] executeBatchNot() throws SQLException {
        try {
            int nbrCommands = this.m_rowIndex;
            int[] updateCounts = new int[nbrCommands];
            int i = 0;
            while (i < nbrCommands) {
                updateCounts[i] = -3;
                ++i;
            }
            Throwable sqlEx = null;
            int commandIndex = 0;
            while (commandIndex < nbrCommands) {
                try {
                    updateCounts[commandIndex] = this.executeUpdate_ex(commandIndex);
                    this.setPutLobData(2);
                }
                catch (SQLException ex) {
                    updateCounts[commandIndex] = -3;
                    if (this.connection.getContinueBatchOnError()) {
                        sqlEx = ex;
                    }
                    int[] newUpdateCounts = new int[commandIndex];
                    System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                    throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
                }
                ++commandIndex;
            }
            if (sqlEx != null) {
                throw new BatchUpdateException(sqlEx.getMessage(), ((SQLException)sqlEx).getSQLState(), ((SQLException)sqlEx).getErrorCode(), updateCounts);
            }
            int[] nArray = updateCounts != null ? updateCounts : new int[]{};
            return nArray;
        }
        finally {
            this.setPutLobData(1);
            this.clearBatch();
        }
    }

    public int[] executeBatch() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "executeBatch()", "");
        }
        this.checkClosed();
        if (this.connection.isReadOnly()) {
            DBError.throwSQLException(6008);
        }
        if (this.dbInfo.getRetStmtType() == 160 || this.dbInfo.getRetStmtType() == 198) {
            throw new BatchUpdateException(this.res.getString("error.invalidSqlType"), null);
        }
        if (this.m_batchItems != null) {
            return super.executeBatch();
        }
        if (!this.checkBatch()) {
            return new int[0];
        }
        int batchSize = this.m_rowIndex;
        if (this.dbInfo.getRetStmtType() == 162 || !this.getIsPutLobData_In() || batchSize == 0 || batchSize == 1 || this.connection.getBatchType() == 2) {
            return this.executeBatchNot();
        }
        int[] updateCounts = new int[batchSize];
        if (batchSize > 1) {
            this.m_bp_with_err = false;
            try {
                updateCounts = DmdbCSI.executePreparedBatch(this);
            }
            catch (SQLException ex) {
                this.clearBatch();
                throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), updateCounts);
            }
            if (this.m_bp_with_err) {
                this.clearBatch();
                throw new BatchUpdateException(Const.res.getString("warn.bp_with_err"), updateCounts);
            }
        }
        this.clearBatch();
        return updateCounts;
    }

    public synchronized void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (reader == null) {
                DmdbLog.trace(this, "setAsciiStream()", "colid = " + parameterIndex + ", reader is null");
            } else {
                DmdbLog.trace(this, "setAsciiStream()", "colid = " + parameterIndex + ", reader is " + reader.toString() + ", length = " + length);
            }
        }
        this.paramBindPrepare(parameterIndex);
        this.setReaderInner(parameterIndex, reader, length, true);
    }

    private void setReaderInner(int parameterIndex, Reader reader, long length, boolean hasLenght) throws SQLException {
        if (this.m_curRow[parameterIndex - 1] instanceof DmOutParamBinder) {
            this.m_curRow[parameterIndex - 1].setInoutParamBinder(new DmReaderBinder(this));
        } else if (this.m_curRow[parameterIndex - 1] instanceof DmNullBinder) {
            this.m_curRow[parameterIndex - 1] = new DmReaderBinder(this);
        } else if (!(this.m_curRow[parameterIndex - 1] instanceof DmReaderBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (reader == null) {
            this.setNullInner(parameterIndex);
            return;
        }
        if (this.m_paramObjects[parameterIndex - 1] == null) {
            this.m_paramObjects[parameterIndex - 1] = new DmReaderParam[this.m_rowsAllocated];
        }
        ((DmReaderParam[])this.m_paramObjects[parameterIndex - 1])[this.m_rowIndex] = hasLenght ? new DmReaderParam(reader, length) : new DmReaderParam(reader);
    }

    public synchronized void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (reader == null) {
                DmdbLog.trace(this, "setAsciiStream()", "colid = " + parameterIndex + ", reader is null");
            } else {
                DmdbLog.trace(this, "setAsciiStream()", "colid = " + parameterIndex + ", reader is " + reader.toString() + ", length = " + length);
            }
        }
        this.paramBindPrepare(parameterIndex);
        this.setReaderInner(parameterIndex, reader, length, true);
    }

    public synchronized void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (reader == null) {
                DmdbLog.trace(this, "setAsciiStream()", "colid = " + parameterIndex + ", reader is null");
            } else {
                DmdbLog.trace(this, "setAsciiStream()", "colid = " + parameterIndex + ", reader is " + reader.toString());
            }
        }
        this.paramBindPrepare(parameterIndex);
        this.setReaderInner(parameterIndex, reader, 0L, false);
    }

    public void setRef(int i, Ref x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "setRef()", "colid = " + i + ", ref is null");
            } else {
                DmdbLog.trace(this, "setRef()", "colid = " + i + ", ref is " + x);
            }
        }
        this.paramBindPrepare(i);
        if (x != null) {
            throw new SQLException(Const.res.getString("error.unsupportedInterfase"));
        }
        this.setNull(i, 2006);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "setBlob()", "colid = " + i + ", Blob is null");
            } else {
                DmdbLog.trace(this, "setBlob()", "colid = " + i + ", Blob is " + x.toString());
            }
        }
        this.paramBindPrepare(i);
        this.setBlobInner(i, x);
    }

    private void setBlobInner(int i, Blob x) throws SQLException {
        if (this.m_curRow[i - 1] instanceof DmOutParamBinder) {
            this.m_curRow[i - 1].setInoutParamBinder(new DmBlobBinder(this));
        } else if (this.m_curRow[i - 1] instanceof DmNullBinder) {
            this.m_curRow[i - 1] = new DmBlobBinder(this);
        } else if (!(this.m_curRow[i - 1] instanceof DmBlobBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (x == null) {
            this.setNullInner(i);
            return;
        }
        if (this.m_paramObjects[i - 1] == null) {
            this.m_paramObjects[i - 1] = new Blob[this.m_rowsAllocated];
        }
        ((Blob[])this.m_paramObjects[i - 1])[this.m_rowIndex] = x;
    }

    public void setClob(int i, Clob x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "setClob()", "colid = " + i + ", clob is null");
            } else {
                DmdbLog.trace(this, "setClob()", "colid = " + i + ", clob is " + x.toString());
            }
        }
        this.paramBindPrepare(i);
        this.setClobInner(i, x);
    }

    private void setClobInner(int i, Clob x) throws SQLException {
        if (this.m_curRow[i - 1] instanceof DmOutParamBinder) {
            this.m_curRow[i - 1].setInoutParamBinder(new DmClobBinder(this));
        } else if (this.m_curRow[i - 1] instanceof DmNullBinder) {
            this.m_curRow[i - 1] = new DmClobBinder(this);
        } else if (!(this.m_curRow[i - 1] instanceof DmClobBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (x == null) {
            this.setNullInner(i);
            return;
        }
        if (this.m_paramObjects[i - 1] == null) {
            this.m_paramObjects[i - 1] = new Clob[this.m_rowsAllocated];
        }
        ((Clob[])this.m_paramObjects[i - 1])[this.m_rowIndex] = x;
    }

    public void setArray(int i, Array x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "setArray()", "colid = " + i + ", Array is null");
            } else {
                DmdbLog.trace(this, "setArray()", "colid = " + i + ", Array is " + x.toString());
            }
        }
        this.paramBindPrepare(i);
        this.setArrayInner(i, x);
    }

    private void setArrayInner(int i, Array x) throws SQLException {
        if (this.m_curRow[i - 1] instanceof DmOutParamBinder) {
            this.m_curRow[i - 1].setInoutParamBinder(new DmARRAYBinder(this));
        } else if (this.m_curRow[i - 1] instanceof DmNullBinder) {
            this.m_curRow[i - 1] = new DmARRAYBinder(this);
        } else if (!(this.m_curRow[i - 1] instanceof DmARRAYBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (x == null) {
            this.setNullInner(i);
            return;
        }
        if (this.m_paramObjects[i - 1] == null) {
            this.m_paramObjects[i - 1] = new ARRAY[this.m_rowsAllocated];
        }
        ((ARRAY[])this.m_paramObjects[i - 1])[this.m_rowIndex] = (ARRAY)x;
    }

    private void setStructInner(int i, Struct x) throws SQLException {
        if (this.m_curRow[i - 1] instanceof DmOutParamBinder) {
            this.m_curRow[i - 1].setInoutParamBinder(new DmSTRUCTBinder(this));
        } else if (this.m_curRow[i - 1] instanceof DmNullBinder) {
            this.m_curRow[i - 1] = new DmSTRUCTBinder(this);
        } else if (!(this.m_curRow[i - 1] instanceof DmSTRUCTBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (this.m_paramObjects[i - 1] == null) {
            this.m_paramObjects[i - 1] = new STRUCT[this.m_rowsAllocated];
        }
        ((STRUCT[])this.m_paramObjects[i - 1])[this.m_rowIndex] = (STRUCT)x;
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.dbInfo != null && this.dbInfo.getHasResultSet()) {
            return new DmdbResultSetMetaData_bs(this, this.dbInfo.getColumnsInfo(), this.resultSetConcurrency, this.connection.getComOra());
        }
        return null;
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 0);
            return;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(x.getTime());
        this.setDate(parameterIndex, new Date(cal.getTimeInMillis()));
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 0);
            return;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(x.getTime());
        this.setTime(parameterIndex, new Time(cal.getTimeInMillis()));
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 0);
            return;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTime(x);
        Timestamp xn = new Timestamp(cal.getTimeInMillis());
        int nanos = x.getNanos();
        if (nanos != 0) {
            xn.setNanos(nanos);
        }
        this.setTimestamp(parameterIndex, xn);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(paramIndex, sqlType);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (x == null) {
                DmdbLog.trace(this, "setURL()", "colid = " + parameterIndex + ", url is null");
            } else {
                DmdbLog.trace(this, "setURL()", "colid = " + parameterIndex + ", url is " + x);
            }
        }
        this.paramBindPrepare(parameterIndex);
        if (x != null) {
            throw new SQLException(Const.res.getString("error.unsupportedInterfase"));
        }
        this.setNull(parameterIndex, 2000);
    }

    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        return new DmdbParameterMetaData_bs(this, this.connection.getComOra());
    }

    public void setINTERVALYM(int i, DmdbIntervalYM ym) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (ym == null) {
                DmdbLog.trace(this, "setINTERVALYM()", "colid = " + i + ", intervalYM is null");
            } else {
                DmdbLog.trace(this, "setINTERVALYM()", "colid = " + i + ", intervalYM is " + ym.toString());
            }
        }
        this.paramBindPrepare(i);
        this.setINTERVALYMInner(i, ym);
    }

    private void setINTERVALYMInner(int i, DmdbIntervalYM ym) throws SQLException {
        if (this.m_curRow[i - 1] instanceof DmOutParamBinder) {
            this.m_curRow[i - 1].setInoutParamBinder(new DmIntvYMBinder(this));
        } else if (this.m_curRow[i - 1] instanceof DmNullBinder) {
            this.m_curRow[i - 1] = new DmIntvYMBinder(this);
        } else if (!(this.m_curRow[i - 1] instanceof DmIntvYMBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (ym == null) {
            this.setNullInner(i);
            return;
        }
        if (this.m_paramObjects[i - 1] == null) {
            this.m_paramObjects[i - 1] = new DmdbIntervalYM[this.m_rowsAllocated];
        }
        ((DmdbIntervalYM[])this.m_paramObjects[i - 1])[this.m_rowIndex] = ym;
    }

    public void setINTERVALDT(int i, DmdbIntervalDT dt) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (dt == null) {
                DmdbLog.trace(this, "setINTERVALDT()", "colid = " + i + ", intervalDT is null");
            } else {
                DmdbLog.trace(this, "setINTERVALDT()", "colid = " + i + ", intervalDT is " + dt.toString());
            }
        }
        this.paramBindPrepare(i);
        this.setINTERVALDTInner(i, dt);
    }

    private void setINTERVALDTInner(int i, DmdbIntervalDT dt) throws SQLException {
        if (this.m_curRow[i - 1] instanceof DmOutParamBinder) {
            this.m_curRow[i - 1].setInoutParamBinder(new DmIntvDTBinder(this));
        } else if (this.m_curRow[i - 1] instanceof DmNullBinder) {
            this.m_curRow[i - 1] = new DmIntvDTBinder(this);
        } else if (!(this.m_curRow[i - 1] instanceof DmIntvDTBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (dt == null) {
            this.setNullInner(i);
            return;
        }
        if (this.m_paramObjects[i - 1] == null) {
            this.m_paramObjects[i - 1] = new DmdbIntervalDT[this.m_rowsAllocated];
        }
        ((DmdbIntervalDT[])this.m_paramObjects[i - 1])[this.m_rowIndex] = dt;
    }

    public void setTIME(int i, DmdbTime t) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            if (t == null) {
                DmdbLog.trace(this, "setTIME()", "colid = " + i + ", time is null");
            } else {
                DmdbLog.trace(this, "setTIME()", "colid = " + i + ", time is " + t);
            }
        }
        this.paramBindPrepare(i);
        this.setTIMEInner(i, t);
    }

    private void setTIMEInner(int i, DmdbTime t) throws SQLException {
        if (this.m_curRow[i - 1] instanceof DmOutParamBinder) {
            this.m_curRow[i - 1].setInoutParamBinder(new DmdmTimeBinder(this));
        } else if (this.m_curRow[i - 1] instanceof DmNullBinder) {
            this.m_curRow[i - 1] = new DmdmTimeBinder(this);
        } else if (!(this.m_curRow[i - 1] instanceof DmdmTimeBinder)) {
            throw new SQLException("Different object bound with the first row in the same column");
        }
        if (t == null) {
            this.setNullInner(i);
            return;
        }
        if (this.m_paramObjects[i - 1] == null) {
            this.m_paramObjects[i - 1] = new DmdbTime[this.m_rowsAllocated];
        }
        ((DmdbTime[])this.m_paramObjects[i - 1])[this.m_rowIndex] = t;
    }

    protected DmdbInfo preparedExceute(int irow) throws SQLException {
        this.clearOutParamVal();
        this.dbInfo = DmdbCSI.executePrepared(this, irow);
        return this.dbInfo;
    }

    protected synchronized int executeUpdate_ex(int irow) throws SQLException {
        this.executeInner(irow, 3);
        if (this instanceof DmdbCallableStatement_bs) {
            ((DmdbCallableStatement_bs)this).colsInfo = new ArrayList(((DmdbCallableStatement_bs)this).resultsCount);
            ((DmdbCallableStatement_bs)this).colsInfo.add(this.dbInfo.getColumnsInfo());
            this.rsCache = null;
        }
        if (this.dbInfo.getRowCount() > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.dbInfo.getRowCount();
    }

    private void executeInner(int irow, int typeExec) throws SQLException {
        try {
            this.checkClosed();
            if (!this.m_isBatchOpt) {
                this.checkParamBoundInner();
            }
            this.resId = 0;
            boolean getCachedRs = false;
            boolean innerQuery = false;
            switch (typeExec) {
                case 2: {
                    if (!this.dbInfo.isRetStmtTypeQuery()) {
                        DBError.throwSQLException(6009);
                    }
                    getCachedRs = true;
                    break;
                }
                case 3: {
                    if (this.connection.isReadOnly()) {
                        DBError.throwSQLException(6008);
                    }
                    if (!this.dbInfo.isRetStmtTypeUpd()) break;
                    DBError.throwSQLException(6009);
                    break;
                }
                case 1: {
                    getCachedRs = true;
                    break;
                }
                case 4: {
                    innerQuery = true;
                    break;
                }
                default: {
                    DBError.throwSQLException(20005);
                }
            }
            if (getCachedRs) {
                ++DmdbConnection_bs.execSqlNum;
                this.currentRs = this.enableRsCache() ? DmdbCachedResultSetPool.getResultSet(this.connection.getGUID(), this.connection.getSchema(), this.originalSql, this) : null;
                if (this.currentRs != null) {
                    ++DmdbConnection_bs.rsCachedNum;
                    this.dbInfo = this.currentRs.dbInfo;
                    return;
                }
            }
            this.dbInfo = this.preparedExceute(irow);
            this.setPrintMsg(this.dbInfo.getPrintMsg());
            if (this instanceof DmdbCallableStatement_bs) {
                ((DmdbCallableStatement_bs)this).m_paramsDesc = this.dbInfo.getParamsInfo();
            }
            if (this.dbInfo.getHasResultSet()) {
                this.resId = (short)(this.resId + 1);
            }
            this.currentRs = innerQuery ? this.getResultSet(true) : this.getResultSetPrivate(1);
        }
        catch (SQLException sqlEx) {
            this.realClose = true;
            throw sqlEx;
        }
    }

    public String getPrintMsg() throws SQLException {
        return this.printMsg;
    }

    protected void setPrintMsg(String msg) {
        this.printMsg = this.printMsg == null ? msg : String.valueOf(this.printMsg) + "\t" + msg;
    }

    public int getSqlType() throws SQLException {
        int sqlType;
        int retType = this.dbInfo.getRetStmtType();
        switch (retType) {
            case 162: 
            case 178: {
                sqlType = 3;
                break;
            }
            case 160: {
                sqlType = 1;
                break;
            }
            case 152: {
                sqlType = 4;
                break;
            }
            default: {
                sqlType = 2;
            }
        }
        return sqlType;
    }

    public void setParamValue(int colIndex, DmdbParamVal paraVal) throws SQLException {
        this.checkIndexInner(colIndex);
        int jtype = paraVal.getObjType();
        Object obj = paraVal.getObjVal();
        if (obj == null) {
            this.setNull(colIndex, 0);
            return;
        }
        switch (jtype) {
            case 25: {
                if (paraVal.hasTargetScale() && obj instanceof BigDecimal) {
                    this.setObject(colIndex, paraVal.getObjVal(), 3, paraVal.getTargetScale());
                    break;
                }
                this.setObject(colIndex, obj);
                break;
            }
            case 18: {
                if (paraVal.hasLength()) {
                    this.setCharacterStream(colIndex, (Reader)obj, paraVal.getLength());
                    break;
                }
                this.setCharacterStream(colIndex, (Reader)obj);
                break;
            }
            case 19: {
                if (paraVal.hasLength()) {
                    this.setAsciiStream(colIndex, (InputStream)obj, paraVal.getLength());
                    break;
                }
                this.setAsciiStream(colIndex, (InputStream)obj);
                break;
            }
            default: {
                this.setObject(colIndex, obj);
            }
        }
    }

    public ParameterDesc[] getParamsDesc() {
        return this.m_paramsDesc;
    }

    public void clearBatch() throws SQLException {
        super.clearBatch();
        this.clearParameters();
    }

    public void setBpWithErr(boolean b) {
        this.m_bp_with_err = b;
    }
}

