/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.LobDesc;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbLobLocator;
import java.sql.SQLException;

public class DmdbLob
implements Cloneable {
    DmdbConnection_bs m_conn;
    public byte[] m_value;
    private DmdbLobLocator m_lobLocator = null;
    private LobDesc m_lobDesc;
    private byte m_lobFlag = 0;
    private long m_rowid = 0L;
    boolean fromRowSetFlag = false;
    boolean isUpdated = false;
    long offRowLen = -1L;
    boolean m_isFreed = false;
    boolean paramFlag = false;
    boolean m_updatAble = true;
    int m_hdr_size = 13;
    int m_lobMode;

    public DmdbLob(byte[] bs, DmdbConnection_bs conn) {
        this.fromRowSetFlag = true;
        this.m_conn = conn;
        this.m_hdr_size = this.nblob_inrow_hdr_size(conn.getNewLobFlag());
        if (bs == null || bs.length <= 0) {
            this.m_value = new byte[this.m_hdr_size];
            this.m_value[0] = 1;
            Convertion.setInt(this.m_value, 9, 0);
        } else {
            this.m_value = new byte[this.m_hdr_size + bs.length];
            this.m_value[0] = 1;
            Convertion.setInt(this.m_value, 9, bs.length);
            System.arraycopy(bs, 0, this.m_value, this.m_hdr_size, bs.length);
        }
        this.m_lobMode = conn.getLobMode();
    }

    protected DmdbLob(byte[] value, byte lobFlag, LobDesc lobDesc, DmdbConnection_bs conn, boolean updAble) {
        this.m_conn = conn;
        this.m_value = value;
        this.m_updatAble = updAble;
        this.m_lobDesc = lobDesc;
        this.m_lobMode = lobDesc.getLobMode();
        this.m_lobFlag = lobFlag;
        this.m_hdr_size = this.nblob_inrow_hdr_size(conn.getNewLobFlag());
        this.getLobLocator();
    }

    protected void setConnection(DmdbConnection_bs conn) {
        this.m_conn = conn;
        this.m_hdr_size = this.nblob_inrow_hdr_size(conn.getNewLobFlag());
    }

    protected DmdbLobLocator getLobLocator() {
        if (this.m_lobLocator == null || !this.m_lobLocator.IsFilled()) {
            this.m_lobLocator = new DmdbLobLocator(this.m_value, this.m_lobFlag, this.m_lobDesc, this.m_conn.getNewLobFlag());
        }
        return this.m_lobLocator;
    }

    public long getRowId() {
        return this.m_rowid;
    }

    public boolean isValueInRow() {
        return this.m_value[0] != 2;
    }

    public int getLobLen() {
        return Convertion.getInt(this.m_value, 9);
    }

    protected byte[] getValueInRow() throws SQLException {
        int len = Convertion.getInt(this.m_value, 9);
        byte[] val = new byte[len];
        System.arraycopy(this.m_value, this.m_hdr_size, val, 0, len);
        return val;
    }

    public Object clone() {
        DmdbLob lob = null;
        try {
            lob = (DmdbLob)super.clone();
            if (this.m_value != null) {
                lob.m_value = (byte[])this.m_value.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return lob;
    }

    public void setCurToHead() {
        if (this.m_lobLocator != null) {
            this.m_lobLocator.setCurToHead();
        }
    }

    public DmdbConnection_bs getConnection() {
        return this.m_conn;
    }

    void free() throws SQLException {
        if (this.m_isFreed) {
            return;
        }
        if (this.m_conn != null) {
            this.m_conn = null;
        }
        if (this.m_value != null) {
            this.m_value = null;
        }
        this.m_isFreed = true;
    }

    void checkFreed() throws SQLException {
        if (this.m_isFreed) {
            DBError.throwSQLException(20003);
        }
    }

    public int nblob_inrow_hdr_size(boolean new_flag) {
        if (new_flag) {
            return 43;
        }
        return 13;
    }

    void checkConnClosed() throws SQLException {
        if (this.m_conn == null || this.m_conn.closed) {
            DBError.throwSQLException(6060);
        }
    }
}

