/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.CnvtInfo;
import dm.jdbc.dbaccess.AuthInfo;
import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DbAccess;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.desc.DmServerInfo;
import dm.jdbc.desc.DmSvcCfg;
import dm.jdbc.desc.GlobalControlCfg;
import dm.jdbc.driver.DmdbCSI;
import dm.jdbc.driver.DmdbCallableStatement_bs;
import dm.jdbc.driver.DmdbDatabaseMetaData_bs;
import dm.jdbc.driver.DmdbLog;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbResultSet_bs;
import dm.jdbc.driver.DmdbSavepoint;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.driver.DmdbSwitch;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.innerData.DmdbExecOpt;
import dm.jdbc.pool.DmdbPooledConnection_bs;
import dm.jdbc.util.EscapeProcessor;
import dm.jdbc.util.ExecOptProcessor;
import dm.jdbc.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class DmdbConnection_bs
implements Connection {
    private Object msgMutex = new Object();
    private boolean m_msgRelease = true;
    private ConnServAttr m_connServAttr = new ConnServAttr();
    private ConnStrAttr m_connStrAttr = new ConnStrAttr();
    private CnvtInfo m_cnvtInfo = new CnvtInfo();
    private Properties m_connProps = new Properties();
    private ArrayList m_servList = null;
    private int m_servPos = 0;
    private boolean m_isExecute2 = false;
    Hashtable statement_table;
    protected boolean closed;
    DmdbDatabaseMetaData_bs m_dbMetaData;
    private boolean logicalHandle;
    DmdbPooledConnection_bs m_pc;
    private int connectionHoldability;
    private SQLWarning m_warning;
    private boolean m_readOnly = false;
    private DbAccess m_dbaccess;
    private DmdbSwitch m_switch;
    private DmMsgSend m_msg;
    private Statement svptStmt;
    private final ResourceBundle res = Const.res;
    private String random;
    private boolean uKeyFlag = false;
    private Vector stmtPool = null;
    private Map preparedStmtPool = null;
    private List preparedStmtPoolArray = null;
    private Map callableStmtPool = null;
    private List callableStmtPoolArray = null;
    private Vector stmtsVec = null;
    private static final String svptPrefix = "DMDB_SVPT_";
    public static int execSqlNum = 0;
    public static int rsCachedNum = 0;
    private DriverPropertyInfo[] m_clientInfoArray = null;
    private Properties m_clientInfoMapConnStr = null;
    private String m_currentDBName = null;
    private boolean m_transReadonly = true;
    private String m_hostStandby = null;
    private int m_portStandby = 0;
    private Map m_typeMap = new HashMap();
    private static Integer curServer = new Integer(-1);
    public static final int TRANSACTION_NONE = 0;
    public static final int TRANSACTION_READ_UNCOMMITTED = 1;
    public static final int TRANSACTION_READ_COMMITTED = 2;
    public static final int TRANSACTION_REPEATABLE_READ = 4;
    public static final int TRANSACTION_SERIALIZABLE = 8;
    private boolean pwd_encrypt = false;
    private boolean m_rwSeparate = false;

    public void setUKeyFlag(boolean uKeyFlag) {
        this.uKeyFlag = uKeyFlag;
    }

    public boolean getUKeyFlag() {
        return this.uKeyFlag;
    }

    public void setRandom(String random) {
        this.random = random;
    }

    public String getRandom() {
        return this.random;
    }

    public void setCurrentDBName(String dbName) {
        this.m_currentDBName = dbName;
    }

    public String getCurrentDBName() {
        return this.m_currentDBName;
    }

    public void setTransReadonly(boolean readonly) throws SQLException {
        if (this.m_connStrAttr.rwSeparate == 0 || !this.checkHasStandby()) {
            return;
        }
        if (readonly) {
            if ((double)Const.NTRX_P < (double)((Const.NTRX_S + Const.NTRX_P) * (long)this.m_connStrAttr.rwPercent) / 100.0) {
                ++Const.NTRX_P;
                this.m_transReadonly = false;
            } else {
                ++Const.NTRX_S;
                this.m_transReadonly = true;
            }
        } else {
            ++Const.NTRX_P;
            this.m_transReadonly = false;
        }
    }

    public boolean getTransReadonly() {
        return this.m_transReadonly;
    }

    public boolean checkConnToStandby() {
        return this.m_connStrAttr.rwSeparate == 1 && this.getTransLevel() != 8 && this.m_transReadonly && this.m_hostStandby != null && this.m_hostStandby.length() > 0;
    }

    public void setTransStatus(int status) throws SQLException {
        switch (status & 0xFFF) {
            case 0: 
            case 32: 
            case 64: {
                this.setTransReadonly(true);
                break;
            }
        }
    }

    public void setStandbyInfo(String host, int port) {
        this.m_hostStandby = host;
        this.m_portStandby = port;
    }

    public String getStandbyHost() {
        return this.m_hostStandby;
    }

    public int getStandbyPort() {
        return this.m_portStandby;
    }

    public boolean checkHasStandby() {
        return this.m_hostStandby != null && this.m_hostStandby.length() != 0;
    }

    public DmdbConnection_bs(String s, String s1, String s2, String s3, String s4, String s5, Properties properties) throws SQLException {
        this.initialize(s.trim(), s1.trim(), s2.trim(), s3.trim(), s4.trim(), properties);
        this.logicalHandle = false;
    }

    public DmdbConnection_bs getLogicalConnection(DmdbPooledConnection_bs pooledConnection) {
        this.logicalHandle = true;
        this.m_pc = pooledConnection;
        this.connectionHoldability = 1;
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getPhysicalConnection", "");
        }
        return this;
    }

    private void initialize(String s, String s1, String s2, String s3, String s4, Properties props) throws SQLException {
        this.setTz(GlobalControlCfg.getTimeZone());
        if (GlobalControlCfg.getLanguage().getLanguage().equalsIgnoreCase("zh")) {
            this.setLanguage(0);
        } else {
            this.setLanguage(1);
        }
        this.initServList(s1, s2);
        DmServerInfo tempServ = (DmServerInfo)this.m_servList.get(0);
        s1 = tempServ.getSvrName();
        if (tempServ.hasPort()) {
            s2 = String.valueOf(tempServ.getSvrPort());
        }
        this.initConnStrAttr(s, s3, s4, s1, s2, props);
        this.connectionHoldability = 1;
        this.m_dbMetaData = null;
        this.m_pc = null;
        this.m_warning = null;
        this.statement_table = new Hashtable(10);
        this.svptStmt = null;
        this.stmtPool = new Vector(this.m_connStrAttr.stmtPoolSize);
        this.preparedStmtPool = Collections.synchronizedMap(new HashMap(this.m_connStrAttr.stmtPoolSize));
        this.preparedStmtPoolArray = Collections.synchronizedList(new LinkedList());
        this.callableStmtPool = Collections.synchronizedMap(new HashMap(this.m_connStrAttr.stmtPoolSize));
        this.callableStmtPoolArray = Collections.synchronizedList(new LinkedList());
        this.stmtsVec = new Vector();
        this.m_connProps = (Properties)props.clone();
        this.m_connProps.remove("password");
        this.commInit();
    }

    private void initDefaultClientInfo() {
        if (this.m_clientInfoArray == null) {
            DriverPropertyInfo continueBatchOnError = new DriverPropertyInfo("continueBatchOnError", "false");
            continueBatchOnError.description = this.res.getString("desciption.execute.continue");
            DriverPropertyInfo LobMode = new DriverPropertyInfo("LobMode", "1");
            LobMode.description = this.res.getString("desciption.lob.mode");
            DriverPropertyInfo ignoreCase = new DriverPropertyInfo("ignoreCase", "true");
            ignoreCase.description = this.res.getString("description.ignoreCase");
            DriverPropertyInfo comOra = new DriverPropertyInfo("comOra", "false");
            comOra.description = this.res.getString("description.comOra");
            DriverPropertyInfo infoLevel = new DriverPropertyInfo("infoLevel", "1");
            infoLevel.description = this.res.getString("description.infoLevel");
            DriverPropertyInfo batchType = new DriverPropertyInfo("batchType", "1");
            batchType.description = this.res.getString("description.batchType");
            DriverPropertyInfo traceLevel = new DriverPropertyInfo("traceLevel", "0");
            traceLevel.description = this.res.getString("description.traceLevel");
            DriverPropertyInfo appName = new DriverPropertyInfo("ApplicationName", "");
            appName.description = this.res.getString("description.appName");
            DriverPropertyInfo userProp = new DriverPropertyInfo("ClientUser", "");
            userProp.description = this.res.getString("description.user");
            DriverPropertyInfo hostProp = new DriverPropertyInfo("ClientHostname", "localhost");
            hostProp.description = this.res.getString("description.host");
            this.m_clientInfoArray = new DriverPropertyInfo[]{continueBatchOnError, LobMode, ignoreCase, comOra, infoLevel, batchType, traceLevel, appName, userProp, hostProp};
        }
    }

    private void initClientInfoWithConnStr() {
        if (this.m_clientInfoMapConnStr == null) {
            this.m_clientInfoMapConnStr = new Properties();
        }
        this.m_clientInfoMapConnStr.clear();
        this.m_clientInfoMapConnStr.setProperty("comOra", String.valueOf(this.m_connStrAttr.comOra));
        this.m_clientInfoMapConnStr.setProperty("ClientUser", String.valueOf(this.m_connStrAttr.login));
        this.m_clientInfoMapConnStr.setProperty("ClientHostname", String.valueOf(this.m_connStrAttr.host));
        this.m_clientInfoMapConnStr.setProperty("continueBatchOnError", String.valueOf(this.m_connStrAttr.continueBatchOnError));
        this.m_clientInfoMapConnStr.setProperty("LobMode", String.valueOf(this.m_connStrAttr.lob_mode));
        this.m_clientInfoMapConnStr.setProperty("ignoreCase", String.valueOf(this.m_connStrAttr.ignoreCase));
        this.m_clientInfoMapConnStr.setProperty("infoLevel", String.valueOf(this.m_connStrAttr.infoLevel));
        this.m_clientInfoMapConnStr.setProperty("batchType", String.valueOf(this.m_connStrAttr.batchType));
        this.m_clientInfoMapConnStr.setProperty("traceLevel", String.valueOf(this.m_connStrAttr.traceLevel));
        this.m_clientInfoMapConnStr.setProperty("ApplicationName", String.valueOf(this.m_connStrAttr.appName));
        this.m_clientInfoMapConnStr.setProperty("ApplicationName", String.valueOf(this.m_connStrAttr.appName));
    }

    public ResultSet getDefaultClientInfo() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("declare \ntype RowVal is record (NAME varchar(128), MAX_LEN int, DEFAULT_VALUE varchar(50), DESCRIPTION varchar(512)); \ntype RowVals is array RowVal[];\nr RowVal; \nrs RowVals;\n");
        stringBuffer.append("begin \n");
        int len = this.m_clientInfoArray.length;
        stringBuffer.append("rs = new RowVal[" + len + "]; \n");
        int i = 0;
        while (i < len) {
            stringBuffer.append("r.name = '" + this.m_clientInfoArray[i].name + "';\n");
            stringBuffer.append("r.max_len = 128;\n");
            stringBuffer.append("r.default_value = '" + this.m_clientInfoArray[i].value + "';\n");
            stringBuffer.append("r.description = '" + this.m_clientInfoArray[i].description + "';\n");
            int index = i + 1;
            stringBuffer.append("rs[" + index + "] = r;\n");
            ++i;
        }
        stringBuffer.append("select * from array rs;\n");
        stringBuffer.append("end;");
        DmdbStatement_bs stmt = (DmdbStatement_bs)this.createStatement();
        DmdbResultSet_bs rs = (DmdbResultSet_bs)stmt.executeQuery(stringBuffer.toString(), 1);
        stringBuffer = null;
        stmt.close();
        stmt = null;
        return rs;
    }

    private void resetClientInfo() {
        this.initClientInfoWithConnStr();
    }

    private void initServList(String host, String port) {
        DmSvcCfg svcCfg = new DmSvcCfg();
        DmServerInfo tmp = null;
        this.m_servList = svcCfg.getServerStrct(host);
        if (this.m_servList == null || this.m_servList.size() <= 0) {
            this.m_servList = new ArrayList();
            tmp = new DmServerInfo(host, Integer.parseInt(port));
            this.m_servList.add(tmp);
            return;
        }
    }

    private void KerberosProtocal(String kerberosUser, String loginPath) throws SQLException {
        AuthInfo clientAuthInfo = this.m_dbaccess.getAuthInfo(kerberosUser, loginPath, 2);
        if (clientAuthInfo == null) {
            DBError.throwSQLException(6001);
        }
        String user = "///" + clientAuthInfo.getUserName();
        this.setLoginName(user);
    }

    IOException tryConnInner(int[] valid, int curSvr, boolean tryValid) {
        DmServerInfo tmp = (DmServerInfo)this.m_servList.get(curSvr);
        IOException io = null;
        if (tryValid && tmp.isValid() || !tryValid && !tmp.isValid()) {
            this.setHostName(tmp.getSvrName());
            if (tmp.hasPort()) {
                this.setHostPort(tmp.getSvrPort());
            } else {
                this.setHostPort(Integer.valueOf(this.m_connProps.getProperty("port", "5236")));
            }
            try {
                this.m_dbaccess = new DbAccess(this);
                this.m_dbaccess.setSoTimeout(this.getSocketTimeout());
                this.setNetworkPacketSize(this.m_dbaccess.getNetPacketSize());
                this.setServPos(curSvr);
            }
            catch (IOException tio) {
                tmp.setValid(false);
                valid[curSvr] = -1;
                io = tio;
            }
        } else {
            valid[curSvr] = -1;
            io = new IOException(Const.res.getString("error.cumunationError"));
        }
        return io;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IOException tryConnWellDistributed(int serverCount, boolean tryValid) {
        int i = 0;
        int curSvr = 0;
        IOException ioTemp = null;
        int[] valid = new int[serverCount];
        i = 0;
        while (i < serverCount) {
            valid[i] = i;
            ++i;
        }
        i = 0;
        while (i < serverCount) {
            Integer n = curServer;
            synchronized (n) {
                curSvr = curServer >= 0 ? (curServer + 1) % serverCount : (int)(Math.random() * 1.0E9) % serverCount;
                curServer = new Integer(curSvr);
            }
            if (valid[curSvr] >= 0) {
                ioTemp = this.tryConnInner(valid, curSvr, tryValid);
                if (ioTemp == null) {
                    break;
                }
            } else {
                --i;
            }
            ++i;
        }
        if (i == serverCount) {
            return ioTemp;
        }
        return null;
    }

    IOException tryConnRandom(int serverCount, boolean tryValid) {
        int fold = (int)(Math.random() * 1.0E9);
        int rand = fold % serverCount;
        IOException ioTemp = null;
        int i = 0;
        int[] valid = new int[serverCount];
        i = 0;
        while (i < serverCount) {
            valid[i] = i;
            ++i;
        }
        i = 0;
        while (i < serverCount) {
            if (valid[rand] >= 0) {
                ioTemp = this.tryConnInner(valid, rand, tryValid);
                if (ioTemp == null) {
                    break;
                }
            } else {
                --i;
            }
            rand = (rand + 1) % serverCount;
            ++i;
        }
        if (i == serverCount) {
            return ioTemp;
        }
        return null;
    }

    void tcpIpProtocal() throws IOException {
        int serverCount = this.m_servList.size();
        IOException io = null;
        if (this.m_connStrAttr.wellDistributed ? (io = this.tryConnWellDistributed(serverCount, true)) != null && (io = this.tryConnWellDistributed(serverCount, false)) != null : (io = this.tryConnRandom(serverCount, true)) != null && (io = this.tryConnRandom(serverCount, false)) != null) {
            throw io;
        }
    }

    private void commInit() throws SQLException {
        this.m_switch = new DmdbSwitch(this);
        this.m_msg = new DmMsgSend();
        this.openConnection();
    }

    private void commUnInit() {
        this.m_msg = null;
        if (this.m_dbaccess != null) {
            this.m_dbaccess.close();
            this.m_dbaccess = null;
        }
        this.m_switch = null;
    }

    private void conCommLayer() throws SQLException, IOException {
        this.tcpIpProtocal();
        String user = this.getLoginName();
        if (user.length() > 2 && user.startsWith("///")) {
            this.KerberosProtocal(user.substring(3), this.m_connStrAttr.kerberosLoginConfPath);
        }
    }

    private void openConnection() throws SQLException {
        try {
            this.conCommLayer();
            DmdbCSI.connToServer(this);
            this.closed = false;
        }
        catch (IOException io) {
            this.commUnInit();
            this.closed = true;
            DBError.throwSQLException(6001);
        }
        catch (SQLException e) {
            this.commUnInit();
            this.closed = true;
            throw e;
        }
    }

    public void setClientInfo(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        this.m_clientInfoMapConnStr.setProperty(name, value);
        if (name.equalsIgnoreCase("traceLevel")) {
            Const.TRACE_LEVEL = Integer.parseInt(value);
        }
    }

    public void setClientInfo(Properties props) {
        if (props == null || props.size() == 0) {
            this.m_clientInfoMapConnStr.clear();
            return;
        }
        this.m_clientInfoMapConnStr = (Properties)props.clone();
    }

    public String getClientInfo(String name) {
        if (name.equalsIgnoreCase("appName")) {
            name = "ApplicationName";
        }
        if (name.equalsIgnoreCase("user")) {
            name = "ClientUser";
        }
        if (name.equalsIgnoreCase("host")) {
            name = "ClientHostname";
        }
        return this.m_clientInfoMapConnStr.getProperty(name);
    }

    public Properties getClientInfo() {
        return (Properties)this.m_clientInfoMapConnStr.clone();
    }

    public boolean isLogicalConnection() {
        return this.logicalHandle;
    }

    public void unLogicalConnection() {
        this.logicalHandle = false;
    }

    public synchronized Statement createStatement() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "createStatement()", "");
        }
        this.clearWarnings();
        this.checkClosed();
        DmdbStatement_bs dmStatement = null;
        if (this.stmtPool.size() > 0) {
            dmStatement = this.getFromStmtPool();
            dmStatement.initializeReuseStmt(this);
        } else {
            dmStatement = new DmdbStatement_bs(this, this.m_connStrAttr.resultSetType, 1007, this.connectionHoldability);
        }
        this.addStmt(dmStatement);
        return dmStatement;
    }

    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, this.m_connStrAttr.resultSetType, 1007, this.connectionHoldability);
    }

    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, this.m_connStrAttr.resultSetType, 1007, this.connectionHoldability);
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        EscapeProcessor escPro = new EscapeProcessor();
        escPro.setExcpThrow(true);
        return escPro.escapeSQL(sql, this.m_connStrAttr.m_process_escapes, false);
    }

    String nativeSQL(String sql, boolean escape) throws SQLException {
        EscapeProcessor escPro = new EscapeProcessor();
        return escPro.escapeSQL(sql, escape, false);
    }

    DmdbExecOpt nativeSQL_ExecOpt(String sql, boolean escap) throws SQLException {
        EscapeProcessor escPro = new EscapeProcessor();
        String escSql = escPro.escapeSQL(sql, escap, true);
        ExecOptProcessor execPro = new ExecOptProcessor(this.getServerEncoding(), escPro.hasError(), escPro.getWordList());
        return execPro.getExecOpt(escSql);
    }

    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setAutoCommit(boolean)", "autoCommit = " + String.valueOf(autoCommit));
        }
        this.checkClosed();
        this.m_connStrAttr.auto_commit = autoCommit;
    }

    public boolean getAutoCommit() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getAutoCommit()", "");
        }
        return this.m_connStrAttr.auto_commit;
    }

    public synchronized void commit() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "commit()", "");
        }
        this.checkClosed();
        if (this.getAutoCommit()) {
            if (this.m_connStrAttr.alwayseAllowCommit) {
                return;
            }
            DBError.throwSQLException(6042);
        }
        DmdbCSI.commitWork(this, this.connectionHoldability);
        this.setTransReadonly(true);
    }

    public synchronized void rollback() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "rollback()", "");
        }
        this.checkClosed();
        if (this.getAutoCommit()) {
            if (this.m_connStrAttr.alwayseAllowCommit) {
                return;
            }
            DBError.throwSQLException(6043);
        }
        DmdbCSI.rollbackWork(this, this.connectionHoldability);
        this.setTransReadonly(true);
    }

    void checkClosed() throws SQLException {
        if (this.isClosed()) {
            DBError.throwSQLException(6060);
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void close() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "close()", "");
        }
        if (this.closed) {
            return;
        }
        try {
            try {
                this.close_statements();
                if (this.svptStmt != null) {
                    this.svptStmt.close();
                    this.svptStmt = null;
                }
                this.invalidAllStmt();
            }
            catch (Exception var1_1) {
                // empty catch block
            }
            try {
                if (this.logicalHandle) {
                    this.logicalClose();
                    return;
                }
                ** GOTO lbl-1000
            }
            catch (Exception var1_2) {
                if (this.m_dbaccess != null) {
                    this.m_dbaccess.close();
                }
                if (this.m_switch != null) {
                    this.m_switch.close();
                }
                if (this.m_msg != null) {
                    this.m_msg.clear();
                }
                this.m_hostStandby = null;
                this.m_portStandby = 0;
                this.m_transReadonly = true;
            }
        }
        finally {
            if (!this.logicalHandle) {
                this.cleanup();
                this.closed = true;
            }
        }
    }

    public synchronized void closeSimple() throws SQLException {
        if (this.closed) {
            return;
        }
        this.invalidAllStmt();
        if (this.m_dbaccess != null) {
            this.m_dbaccess.close();
        }
        this.closed = true;
    }

    public void resetCloseFlag() {
        this.closed = false;
    }

    public synchronized void closeForAgent() throws SQLException {
        if (this.closed) {
            return;
        }
        try {
            if (this.m_dbaccess != null) {
                this.m_dbaccess.close();
            }
            if (this.m_switch != null) {
                this.m_switch.close();
            }
        }
        finally {
            this.cleanup();
            this.closed = true;
        }
    }

    public synchronized void logicalClose() throws SQLException {
        if (this.m_pc != null) {
            this.m_pc.logicalClose();
        }
        this.resetClientInfo();
    }

    private void cleanup() {
        if (this.statement_table != null) {
            this.statement_table.clear();
        }
        this.statement_table = null;
        this.m_pc = null;
        this.m_dbMetaData = null;
        this.m_clientInfoArray = null;
        this.m_dbaccess = null;
        this.m_switch = null;
        this.m_warning = null;
    }

    public boolean isClosed() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "isClosed()", "");
        }
        return this.closed;
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getMetaData()", "");
        }
        this.checkClosed();
        if (this.m_dbMetaData == null) {
            this.m_dbMetaData = new DmdbDatabaseMetaData_bs(this);
        }
        return this.m_dbMetaData;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setReadOnly(boolean)", "readOnly = " + String.valueOf(readOnly));
        }
        this.checkClosed();
        if (this.m_readOnly == readOnly) {
            return;
        }
        Statement stmt = this.createStatement();
        if (!this.m_connStrAttr.auto_commit) {
            this.commit();
        }
        this.setTransReadonly(false);
        if (readOnly) {
            stmt.execute("SP_SET_SESSION_READONLY(1)");
        } else {
            stmt.execute("SP_SET_SESSION_READONLY(0)");
        }
        if (!this.m_connStrAttr.auto_commit) {
            this.commit();
        }
        stmt.close();
        stmt = null;
        this.m_readOnly = readOnly;
    }

    public boolean isReadOnly() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "isReadOnly", "");
        }
        return this.m_readOnly;
    }

    public void setCatalog(String catalog) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setCatalog(String)", "catalog = " + catalog);
        }
    }

    public String getCatalog() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getCatalog()", "");
        }
        return null;
    }

    public final String getUserName() throws SQLException {
        DmdbStatement_bs stmt = (DmdbStatement_bs)this.createStatement(1004, 1007, 1);
        ResultSet rs = stmt.executeQuery("select user()", 1);
        rs.next();
        String s = rs.getString(1);
        rs.close();
        stmt.close();
        return s;
    }

    public final boolean isCompress() {
        return this.m_connStrAttr.isCompress;
    }

    public synchronized void setTransactionIsolation(int level) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setTransactionIsolation(int)", "level = " + level);
        }
        this.checkClosed();
        switch (level) {
            case 0: {
                this.m_connServAttr.trans_level = level;
                break;
            }
            case 2: {
                DmdbCSI.setSessionIsoLevel(1, this);
                this.m_connServAttr.trans_level = 2;
                break;
            }
            case 8: {
                DmdbCSI.setSessionIsoLevel(3, this);
                this.m_connServAttr.trans_level = 8;
                break;
            }
            case 1: {
                DmdbCSI.setSessionIsoLevel(3, this);
                this.m_connServAttr.trans_level = 1;
                break;
            }
            default: {
                DBError.throwSQLException(6038);
            }
        }
    }

    public int getTransactionIsolation() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getTransactionIsolation()", "");
        }
        return this.m_connServAttr.trans_level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLWarning getWarnings() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getWarnings()", "");
        }
        this.checkClosed();
        if (this.m_warning != null) {
            SQLWarning sQLWarning = this.m_warning;
            synchronized (sQLWarning) {
                return this.m_warning;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWarnings() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "clearWarnings()", "");
        }
        if (this.m_warning != null) {
            SQLWarning sQLWarning = this.m_warning;
            synchronized (sQLWarning) {
                this.m_warning = null;
            }
        }
    }

    private void addWarningsExec(SQLWarning warn) {
        if (this.m_warning == null) {
            this.m_warning = warn;
        } else {
            this.m_warning.setNextWarning(warn);
        }
    }

    public void addWarnings(SQLWarning warn) {
        if (warn != null) {
            this.addWarningsExec(warn);
        }
    }

    void add_statement(long handle, Statement statement) {
        this.statement_table.put(new Long(handle), statement);
    }

    void remove_statement(long handle) {
        this.statement_table.remove(new Long(handle));
    }

    void close_all_resultSet() throws SQLException {
        Enumeration e = this.statement_table.elements();
        while (e.hasMoreElements()) {
            DmdbStatement_bs stmt = (DmdbStatement_bs)e.nextElement();
            if (stmt.currentRs == null) continue;
            stmt.currentRs.close();
        }
    }

    public long getCurpos(long handle) throws SQLException {
        long curPos = 0L;
        if (this.statement_table.containsKey(new Long(handle))) {
            DmdbStatement_bs stmt = (DmdbStatement_bs)this.statement_table.get(new Long(handle));
            if (stmt == null) {
                return curPos;
            }
            DmdbResultSet_bs rs = (DmdbResultSet_bs)stmt.getResultSet();
            if (rs == null) {
                return curPos;
            }
            curPos = rs.getCurrentRowNum();
        }
        return curPos;
    }

    private void close_statements() throws SQLException {
        Enumeration enumeration = this.statement_table.elements();
        while (enumeration.hasMoreElements()) {
            DmdbStatement_bs stmt = (DmdbStatement_bs)enumeration.nextElement();
            if (stmt == null) continue;
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.remove_statement(stmt.handle);
            Object var2_2 = null;
        }
    }

    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "createStatement(int, int)", "resultSetType = " + resultSetType + "resultSetConcurrency = " + resultSetConcurrency);
        }
        DmdbStatement_bs dmStatement = null;
        this.clearWarnings();
        this.checkClosed();
        if (resultSetType == 1005) {
            this.addWarnings(new SQLWarning(this.res.getString("warn.notSupportedResultType")));
            resultSetType = 1004;
        }
        if (this.stmtPool.size() > 0) {
            dmStatement = this.getFromStmtPool();
            dmStatement.initializeReuseStmt(this);
            dmStatement.resultSetType = resultSetType;
            dmStatement.resultSetConcurrency = resultSetConcurrency;
            dmStatement.resultSetHoldability = this.connectionHoldability;
        } else {
            dmStatement = new DmdbStatement_bs(this, resultSetType, resultSetConcurrency, this.connectionHoldability);
        }
        this.addStmt(dmStatement);
        return dmStatement;
    }

    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.connectionHoldability);
    }

    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, this.connectionHoldability);
    }

    public Map getTypeMap() throws SQLException {
        return this.m_typeMap;
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        this.m_typeMap = map;
    }

    public synchronized void setHoldability(int holdability) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setHoldability(int)", "holdability = " + holdability);
        }
        if (holdability == 1 || holdability == 2) {
            this.connectionHoldability = holdability;
        } else {
            DBError.throwSQLException(6055);
        }
    }

    public int getHoldability() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "getHoldability()", "");
        }
        return this.connectionHoldability;
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setSavepoint()", "");
        }
        this.checkClosed();
        if (this.m_connStrAttr.auto_commit) {
            DBError.throwSQLException(6039);
        }
        DmdbSavepoint savepoint = new DmdbSavepoint();
        String s = "SAVEPOINT DMDB_SVPT_" + savepoint.getSavepointId();
        if (this.svptStmt == null) {
            this.svptStmt = this.createStatement(1003, 1007, 1);
        }
        this.svptStmt.executeUpdate(s);
        return savepoint;
    }

    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "setSavepoint(String)", "name = " + name);
        }
        this.checkClosed();
        if (this.m_connStrAttr.auto_commit) {
            DBError.throwSQLException(6039);
        }
        if (name == null || name.trim().length() == 0) {
            DBError.throwSQLException(6051);
        }
        DmdbSavepoint savepoint = new DmdbSavepoint(name);
        String s = "SAVEPOINT \"" + StringUtil.getEscObjName(name) + "\"";
        if (this.svptStmt == null) {
            this.svptStmt = this.createStatement(1003, 1007, 1);
        }
        this.svptStmt.executeUpdate(s);
        return savepoint;
    }

    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "rollback(Savepoint)", "");
        }
        this.checkClosed();
        if (this.m_connStrAttr.auto_commit) {
            if (this.m_connStrAttr.alwayseAllowCommit) {
                return;
            }
            DBError.throwSQLException(6043);
        }
        if (savepoint == null) {
            DBError.throwSQLException(6064);
        }
        if (((DmdbSavepoint)savepoint).getReleasedFlag()) {
            DBError.throwSQLException(6053);
        }
        String s = "ROLLBACK TO SAVEPOINT \"";
        try {
            s = String.valueOf(s) + StringUtil.getEscObjName(savepoint.getSavepointName());
            s = String.valueOf(s) + "\"";
        }
        catch (SQLException sqlexception) {
            s = String.valueOf(s) + svptPrefix + savepoint.getSavepointId();
            s = String.valueOf(s) + "\"";
        }
        if (this.svptStmt == null) {
            this.svptStmt = this.createStatement(1003, 1007, 1);
        }
        this.svptStmt.executeUpdate(s);
        this.setTransReadonly(true);
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "rollback(Savepoint)", "");
        }
        this.checkClosed();
        if (this.m_connStrAttr.auto_commit) {
            DBError.throwSQLException(6041);
        }
        if (savepoint == null) {
            DBError.throwSQLException(6064);
        }
        ((DmdbSavepoint)savepoint).setReleasedFlagTrue();
    }

    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "createStatement(int, int)", "resultSetType = " + resultSetType + ",resultSetConcurrency = " + resultSetConcurrency + ",resultSetHoldability = " + resultSetHoldability);
        }
        DmdbStatement_bs dmStatement = null;
        this.clearWarnings();
        this.checkClosed();
        if (!this.checkResultSetType(resultSetType, resultSetConcurrency, resultSetHoldability)) {
            DBError.throwSQLException(6065);
        }
        if (resultSetType == 1005) {
            this.addWarnings(new SQLWarning(this.res.getString("warn.notSupportedResultType")));
            resultSetType = 1004;
        }
        if (this.stmtPool.size() > 0) {
            dmStatement = this.getFromStmtPool();
            dmStatement.initializeReuseStmt(this);
            dmStatement.resultSetType = resultSetType;
            dmStatement.resultSetConcurrency = resultSetConcurrency;
            dmStatement.resultSetHoldability = resultSetHoldability;
        } else {
            dmStatement = new DmdbStatement_bs(this, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        this.addStmt(dmStatement);
        return dmStatement;
    }

    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbPreparedStatement_bs pstmt = null;
        if (sql == null || sql.length() == 0) {
            DBError.throwSQLException(6003);
        }
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "prepareStatement(String, int, int, int)", "sql = " + sql + ", resultSetType = " + resultSetType + ", resultSetConcurrency = " + resultSetConcurrency + ", resultSetHoldability = " + resultSetHoldability);
        }
        if (!this.checkResultSetType(resultSetType, resultSetConcurrency, resultSetHoldability)) {
            DBError.throwSQLException(6065);
        }
        if (resultSetType == 1005) {
            this.addWarnings(new SQLWarning(this.res.getString("warn.notSupportedResultType")));
            resultSetType = 1004;
        }
        this.checkClosed();
        pstmt = this.getFromPreparedStmtPool(sql);
        if (pstmt != null) {
            pstmt.initializeReusePreparedStmt(this, sql);
            pstmt.resultSetType = resultSetType;
            pstmt.resultSetConcurrency = resultSetConcurrency;
            pstmt.resultSetHoldability = resultSetHoldability;
        } else {
            pstmt = new DmdbPreparedStatement_bs(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        this.addStmt(pstmt);
        return pstmt;
    }

    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbCallableStatement_bs cstmt = null;
        if (sql == null || sql.length() == 0) {
            DBError.throwSQLException(6003);
        }
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "prepareCall(String, int, int, int)", "sql = " + sql + ", resultSetType = " + resultSetType + ", resultSetConcurrency = " + resultSetConcurrency + ", resultSetHoldability = " + resultSetHoldability);
        }
        if (!this.checkResultSetType(resultSetType, resultSetConcurrency, resultSetHoldability)) {
            DBError.throwSQLException(6065);
        }
        if (resultSetType == 1005) {
            this.addWarnings(new SQLWarning(this.res.getString("warn.notSupportedResultType")));
            resultSetType = 1004;
        }
        if ((cstmt = this.getFromCallableStmtPool(sql)) != null) {
            cstmt.initializeReuseCallableStmt(this, sql);
            cstmt.resultSetType = resultSetType;
            cstmt.resultSetConcurrency = resultSetConcurrency;
            cstmt.resultSetHoldability = resultSetHoldability;
        } else {
            cstmt = new DmdbCallableStatement_bs(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        this.addStmt(cstmt);
        return cstmt;
    }

    public synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        DmdbPreparedStatement_bs pstmt = null;
        if (sql == null || sql.length() == 0) {
            DBError.throwSQLException(6003);
        }
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "prepareStatement(String, int)", "sql = " + sql + ", autoGeneratedKeys = " + autoGeneratedKeys);
        }
        this.checkClosed();
        pstmt = this.getFromPreparedStmtPool(sql);
        if (pstmt != null) {
            pstmt.initializeReusePreparedStmt(this, sql);
            pstmt.resultSetType = this.m_connStrAttr.resultSetType;
            pstmt.resultSetConcurrency = 1007;
            pstmt.resultSetHoldability = this.connectionHoldability;
        } else {
            pstmt = new DmdbPreparedStatement_bs(this, sql, this.m_connStrAttr.resultSetType, 1007, this.connectionHoldability, autoGeneratedKeys);
        }
        this.addStmt(pstmt);
        return pstmt;
    }

    public synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        DmdbPreparedStatement_bs pstmt = null;
        if (sql == null || sql.length() == 0) {
            DBError.throwSQLException(6003);
        }
        StringBuffer indexStr = new StringBuffer("sql = " + sql);
        indexStr.append(", columnIndexes = ");
        if (columnIndexes == null || columnIndexes.length <= 0) {
            indexStr.append("");
        } else {
            int i = 0;
            while (i < columnIndexes.length) {
                if (i != 0) {
                    indexStr.append(", ");
                }
                indexStr.append(columnIndexes[i]);
                ++i;
            }
        }
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "prepareStatement(String, int[])", indexStr.substring(0, indexStr.length()));
        }
        this.checkClosed();
        pstmt = this.getFromPreparedStmtPool(sql);
        if (pstmt != null) {
            pstmt.initializeReusePreparedStmt(this, sql);
            pstmt.resultSetType = this.m_connStrAttr.resultSetType;
            pstmt.resultSetConcurrency = 1007;
            pstmt.resultSetHoldability = this.connectionHoldability;
        } else {
            pstmt = new DmdbPreparedStatement_bs(this, sql, this.m_connStrAttr.resultSetType, 1007, this.connectionHoldability, columnIndexes);
        }
        this.addStmt(pstmt);
        return pstmt;
    }

    public synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        DmdbPreparedStatement_bs pstmt = null;
        if (sql == null || sql.length() == 0) {
            DBError.throwSQLException(6003);
        }
        StringBuffer indexStr = new StringBuffer("sql = " + sql);
        indexStr.append(", columnIndexes = ");
        if (columnNames == null || columnNames.length <= 0) {
            indexStr.append("");
        } else {
            int i = 0;
            while (i < columnNames.length) {
                if (i != 0) {
                    indexStr.append(", ");
                }
                if (columnNames[i] == null) {
                    indexStr.append("null");
                } else {
                    indexStr.append(columnNames[i]);
                }
                ++i;
            }
        }
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "prepareStatement(String, String[])", indexStr.substring(0, indexStr.length()));
        }
        this.checkClosed();
        pstmt = this.getFromPreparedStmtPool(sql);
        if (pstmt != null) {
            pstmt.initializeReusePreparedStmt(this, sql);
            pstmt.resultSetType = this.m_connStrAttr.resultSetType;
            pstmt.resultSetConcurrency = 1007;
            pstmt.resultSetHoldability = this.connectionHoldability;
        } else {
            pstmt = new DmdbPreparedStatement_bs(this, sql, this.m_connStrAttr.resultSetType, 1007, this.connectionHoldability, columnNames);
        }
        this.addStmt(pstmt);
        return pstmt;
    }

    public String getExplainInfo(String sqlToExplain) throws SQLException {
        String explainInfo = null;
        if (sqlToExplain == null || sqlToExplain.trim().length() == 0) {
            DBError.throwSQLException(6003);
        }
        if (!sqlToExplain.equalsIgnoreCase("show_pln_stat")) {
            sqlToExplain = "EXPLAIN " + sqlToExplain;
        }
        DmdbStatement_bs stmt = (DmdbStatement_bs)this.createStatement();
        try {
            stmt.execute(sqlToExplain);
            explainInfo = stmt.getDmdbInfo().getExplain();
        }
        finally {
            stmt.close();
        }
        return explainInfo;
    }

    public String getSessionTrace(String sql) throws SQLException {
        String retstr;
        DmdbStatement_bs stmt = (DmdbStatement_bs)this.createStatement();
        try {
            stmt.executeUpdate(sql);
            retstr = stmt.getExplain();
        }
        finally {
            stmt.close();
        }
        return retstr;
    }

    public final boolean getDDL_Autocommit() throws SQLException {
        return this.m_connServAttr.ddl_auto_commit;
    }

    public final void setDDL_Autocommit(boolean autoCommit) throws SQLException {
        DmdbStatement_bs stmt = (DmdbStatement_bs)this.createStatement(1003, 1007, 1);
        if (autoCommit) {
            stmt.executeQuery("SELECT DM_SET_SESSION_AUTOCMT(1)");
            this.m_connServAttr.ddl_auto_commit = true;
        } else {
            stmt.executeQuery("SELECT DM_SET_SESSION_AUTOCMT(0)");
            this.m_connServAttr.ddl_auto_commit = false;
        }
        stmt.close();
    }

    public DbAccess getDbAccess() {
        return this.m_dbaccess;
    }

    public void setDbAccess(DbAccess dbaccess) {
        this.m_dbaccess = dbaccess;
    }

    public DmdbSwitch getDbSwitch() {
        return this.m_switch;
    }

    public AuthInfo getKerberosAuth() {
        if (this.m_dbaccess != null) {
            return this.m_dbaccess.getAuthInfo();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmMsgSend getMsg() throws SQLException {
        Object object = this.msgMutex;
        synchronized (object) {
            try {
                while (!this.m_msgRelease) {
                    Thread.sleep(3L);
                }
            }
            catch (InterruptedException e) {
                throw new SQLException(e.getMessage());
            }
            this.m_msgRelease = false;
            return this.m_msg;
        }
    }

    public void returnMsg() {
        this.m_msgRelease = true;
    }

    public void reset() throws SQLException {
        if (this.m_dbaccess != null) {
            this.m_dbaccess.reset();
            this.invalidAllStmt();
            this.openConnection();
        }
    }

    private void addStmt(Statement stmt) {
        this.stmtsVec.add(stmt);
    }

    public void delStmt(Statement stmt) {
        if (this.stmtsVec == null || this.stmtsVec.isEmpty()) {
            return;
        }
        this.stmtsVec.remove(stmt);
    }

    private void invalidAllStmt() {
        DmdbStatement_bs stmt = null;
        if (this.stmtsVec == null || this.stmtsVec.isEmpty()) {
            return;
        }
        try {
            int i = 0;
            while (i < this.stmtsVec.size()) {
                stmt = (DmdbStatement_bs)this.stmtsVec.get(i);
                if (stmt != null && !stmt.closed) {
                    stmt.closeSimple();
                }
                ++i;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.stmtsVec.clear();
    }

    final ArrayList getHosts() {
        return this.m_servList;
    }

    void setServPos(int pos) {
        this.m_servPos = pos;
    }

    int getServPos() {
        return this.m_servPos;
    }

    public boolean hasOneSvr() {
        return this.m_servList.size() == 1;
    }

    public int getStmtPoolSize() {
        return this.stmtPool.size();
    }

    public void addToStmtPool(DmdbStatement_bs stmt) {
        this.stmtPool.add(stmt);
    }

    public DmdbStatement_bs getFromStmtPool() {
        DmdbStatement_bs stmt = (DmdbStatement_bs)this.stmtPool.firstElement();
        this.stmtPool.remove(0);
        return stmt;
    }

    public void addToPreparedStmtPool(DmdbPreparedStatement_bs pstmt) {
        if (this.preparedStmtPoolArray.size() >= this.getStmtPoolMaxSize()) {
            DmdbPreparedStatement_bs pstmt2 = (DmdbPreparedStatement_bs)this.preparedStmtPoolArray.remove(0);
            this.preparedStmtPool.remove(pstmt2.originalSql);
            try {
                pstmt2.innerClose();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.preparedStmtPool.put(pstmt.originalSql, pstmt);
        this.preparedStmtPoolArray.add(pstmt);
    }

    public DmdbPreparedStatement_bs getFromPreparedStmtPool(String sql) {
        DmdbPreparedStatement_bs pstmt = (DmdbPreparedStatement_bs)this.preparedStmtPool.get(sql);
        if (pstmt != null) {
            this.preparedStmtPool.remove(sql);
            this.preparedStmtPoolArray.remove(pstmt);
        }
        return pstmt;
    }

    public void addToCallableStmtPool(DmdbCallableStatement_bs cstmt) {
        if (this.callableStmtPool.size() >= this.getStmtPoolMaxSize()) {
            DmdbCallableStatement_bs cstmt2 = (DmdbCallableStatement_bs)this.callableStmtPoolArray.remove(0);
            this.callableStmtPool.remove(cstmt2.originalSql);
            try {
                cstmt2.innerClose();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.callableStmtPool.put(cstmt.originalSql, cstmt);
        this.callableStmtPoolArray.add(cstmt);
    }

    public DmdbCallableStatement_bs getFromCallableStmtPool(String sql) {
        DmdbCallableStatement_bs cstmt = (DmdbCallableStatement_bs)this.callableStmtPool.get(sql);
        if (cstmt != null) {
            this.callableStmtPool.remove(sql);
            this.callableStmtPoolArray.remove(cstmt);
        }
        return cstmt;
    }

    private boolean checkResultSetType(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        boolean checked = true;
        switch (resultSetType) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                return !checked;
            }
        }
        switch (resultSetConcurrency) {
            case 1007: 
            case 1008: {
                break;
            }
            default: {
                return !checked;
            }
        }
        switch (resultSetHoldability) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                checked = false;
            }
        }
        return checked;
    }

    public int getStmtPoolMaxSize() {
        return this.m_connStrAttr.stmtPoolSize;
    }

    public boolean getIgnoreCase() {
        String value = this.m_clientInfoMapConnStr.getProperty("ignoreCase");
        if (value == null) {
            return this.m_connStrAttr.ignoreCase;
        }
        return Boolean.valueOf(value);
    }

    public boolean getComOra() {
        String value = this.m_clientInfoMapConnStr.getProperty("comOra");
        if (value == null) {
            return this.m_connStrAttr.comOra;
        }
        return Boolean.valueOf(value);
    }

    protected int getBatchType() {
        String value = this.m_clientInfoMapConnStr.getProperty("batchType");
        if (value == null) {
            return this.m_connStrAttr.batchType;
        }
        return Integer.parseInt(value);
    }

    public final void setLanguage(int language) {
        this.m_connServAttr.language = language;
    }

    public final int getLanguage() {
        return this.m_connServAttr.language;
    }

    public final void setTransAccessMode(int accessMode) {
        this.m_connServAttr.tranAccessMode = accessMode;
    }

    public final int getTransAccessMode() {
        return this.m_connServAttr.tranAccessMode;
    }

    public void setTz(short tz) {
        this.m_connServAttr.tz = tz;
        this.m_cnvtInfo.setTimeZone(tz);
    }

    public short getTz() {
        return this.m_connServAttr.tz;
    }

    public String getOsName() {
        return this.m_connServAttr.osName;
    }

    public void setMaxRowSize(short maxRowSize) {
        this.m_connServAttr.maxRowSize = maxRowSize;
    }

    public short getMaxRowSize() {
        return this.m_connServAttr.maxRowSize;
    }

    public void setMaxSession(int maxSession) {
        this.m_connServAttr.maxSession = maxSession;
    }

    public int getMaxSession() {
        return this.m_connServAttr.maxSession;
    }

    public void setDDL_Auto_commit(boolean auto_commit) {
        this.m_connServAttr.ddl_auto_commit = auto_commit;
    }

    public boolean getDDL_Auto_Commit() {
        return this.m_connServAttr.ddl_auto_commit;
    }

    public void setTransLevel(int level) {
        this.m_connServAttr.trans_level = level;
    }

    public int getTransLevel() {
        return this.m_connServAttr.trans_level;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.m_connServAttr.caseSensitive = caseSensitive;
    }

    public boolean getCaseSensitive() {
        return this.m_connServAttr.caseSensitive;
    }

    public void setBackslashEscape(boolean escape) {
        this.m_connServAttr.backslash_escape = escape;
    }

    public boolean getBackslashEscape() {
        return this.m_connServAttr.backslash_escape;
    }

    public void setSvrMode(int svrMode) {
        this.m_connServAttr.svrMode = svrMode;
    }

    public int getSvrMode() {
        return this.m_connServAttr.svrMode;
    }

    public void setSvrStat(int svrStat) {
        this.m_connServAttr.svrStat = svrStat;
    }

    public int getSvrStat() {
        return this.m_connServAttr.svrStat;
    }

    public void setConstParaOpt(byte opt) {
        this.m_connServAttr.const_para_opt = 1 == opt;
    }

    public boolean getConstParaOpt() {
        return this.m_connServAttr.const_para_opt;
    }

    public void setDbTz(int tz) {
        this.m_connServAttr.db_tz = tz;
        this.m_cnvtInfo.setDbTz((short)tz);
    }

    public int getDbTz() {
        return this.m_connServAttr.db_tz;
    }

    public void setInstanceName(String instName) {
        this.m_connServAttr.instanceName = instName;
    }

    public String getInstanceName() {
        return this.m_connServAttr.instanceName;
    }

    public void setSchema(String schema) {
        this.m_connServAttr.schema = schema;
    }

    public String getSchema() {
        return this.m_connServAttr.schema;
    }

    public void setLastLoginIP(String lastLoginIP) {
        this.m_connServAttr.lastLoginIP = lastLoginIP;
    }

    public String getLastLoginIP() {
        return this.m_connServAttr.lastLoginIP;
    }

    public void setLastLoginTime(String lastLoginTime) {
        this.m_connServAttr.lastLoginTime = lastLoginTime;
    }

    public String getLastLoginTime() {
        return this.m_connServAttr.lastLoginTime;
    }

    public void setFailedAttempt(int failedAttempt) {
        this.m_connServAttr.failedAttempts = failedAttempt;
    }

    public int getFailedAttempt() {
        return this.m_connServAttr.failedAttempts;
    }

    public void setLoginWarningID(int loginWarningID) {
        this.m_connServAttr.loginWarningID = loginWarningID;
    }

    public int getLoginWarningID() {
        return this.m_connServAttr.loginWarningID;
    }

    public void setGraceTimeRemainder(int gracetimeRemainder) {
        this.m_connServAttr.gracetimeRemainder = gracetimeRemainder;
    }

    public int getGraceTimeRemainder() {
        return this.m_connServAttr.gracetimeRemainder;
    }

    public void setEncryptMsg(int encryptMsg) {
        this.m_connServAttr.encryptMsg = encryptMsg;
    }

    public int getEncryptMsg() {
        return this.m_connServAttr.encryptMsg;
    }

    public boolean getIsExecute2() {
        return this.m_isExecute2;
    }

    public void setDmServerVersion(String version) {
        this.m_connServAttr.dmServerVersion = version;
        this.m_isExecute2 = DmdbConnection_bs.isExecute2(version, DmdbType.getGlobalVersion());
    }

    public final String getDmServerVersion() {
        return this.m_connServAttr.dmServerVersion;
    }

    public void setGlobalServerSeries(int series) {
        this.m_connServAttr.global_server_series = series;
    }

    public int getGlobalServerSeries() {
        return this.m_connServAttr.global_server_series;
    }

    public void setServerEncoding(String serverEncoding) {
        this.m_connServAttr.m_serverEncoding = serverEncoding;
        this.m_cnvtInfo.setServerEncoding(serverEncoding);
    }

    public String getServerEncoding() {
        return this.m_connServAttr.m_serverEncoding;
    }

    public void setComprMsg(int compr) {
        this.m_connServAttr.comprMsg = compr;
    }

    public int getComprMsg() {
        return this.m_connServAttr.comprMsg;
    }

    protected void setNetworkPacketSize(int packetSize) {
        this.m_connServAttr.networkPacketSize = packetSize;
    }

    public int getNetworkPacketSize() {
        return this.m_connServAttr.networkPacketSize;
    }

    public String getHostMchName() {
        String hostName = "";
        try {
            InetAddress ia = null;
            ia = InetAddress.getLocalHost();
            if (ia != null) {
                hostName = ia.getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostName;
    }

    public CnvtInfo getCnvtInfo() {
        return this.m_cnvtInfo;
    }

    private void initConnStrAttr(String url, String user, String pwd, String host, String port, Properties props) {
        this.initDefaultClientInfo();
        this.m_connStrAttr.url = url;
        this.m_connStrAttr.login = user;
        this.m_connStrAttr.password = pwd;
        this.m_connStrAttr.host = host;
        this.m_connStrAttr.port = Integer.parseInt(port);
        String info = String.valueOf(url) + "->url;" + user + "->user;";
        if (Const.TRACE_LEVEL > 0) {
            DmdbLog.trace(this, "create Connection", info);
        }
        if (props != null) {
            this.m_connStrAttr.socketTimeout = Integer.parseInt(props.getProperty("socketTimeout", "0"));
            this.m_connStrAttr.continueBatchOnError = Boolean.valueOf(props.getProperty("continueBatchOnError", "false"));
            this.m_connStrAttr.m_process_escapes = Boolean.valueOf(props.getProperty("escapeProcess", "true"));
            this.m_connStrAttr.maxRows = Integer.parseInt(props.getProperty("maxRows", "0"));
            this.m_connStrAttr.default_row_prefetch = Integer.parseInt(props.getProperty("rowPrefetch", "10"));
            this.m_connStrAttr.auto_commit = Boolean.valueOf(props.getProperty("autoCommit", "true"));
            this.m_connStrAttr.maxCachedPstmtSize = Integer.parseInt(props.getProperty("maxCachedPstmtSize", "0"));
            this.m_connStrAttr.lob_mode = Integer.parseInt(props.getProperty("LobMode", "1"));
            this.m_connStrAttr.stmtPoolSize = Integer.parseInt(props.getProperty("StmtPoolSize", "0"));
            this.m_connStrAttr.ignoreCase = Boolean.valueOf(props.getProperty("ignoreCase", "true"));
            this.m_connStrAttr.comOra = Boolean.valueOf(props.getProperty("comOra", "false"));
            this.m_connStrAttr.infoLevel = Integer.parseInt(props.getProperty("infoLevel", "1"));
            this.m_connStrAttr.alwayseAllowCommit = Boolean.valueOf(props.getProperty("alwayseAllowCommit", "true"));
            this.m_connStrAttr.batchType = Integer.parseInt(props.getProperty("batchType", "1"));
            Const.TRACE_LEVEL = this.m_connStrAttr.traceLevel = Integer.parseInt(props.getProperty("traceLevel", "0"));
            this.m_connStrAttr.appName = props.getProperty("appName", "");
            this.m_connStrAttr.isCompress = Boolean.valueOf(props.getProperty("isCompress", "false"));
            this.m_connStrAttr.sessionTimeout = Integer.parseInt(props.getProperty("sessionTimeout", "0"));
            this.m_connStrAttr.connectTimeout = Integer.parseInt(props.getProperty("connectTimeout", "0"));
            this.m_connStrAttr.sslFilesPath = props.getProperty("sslFilesPath", "");
            this.m_connStrAttr.sslKeystorePass = props.getProperty("sslKeystorePass", "");
            this.m_connStrAttr.resultSetType = Integer.parseInt(props.getProperty("resultSetType", String.valueOf(1003)));
            this.m_connStrAttr.kerberosLoginConfPath = props.getProperty("kerberosLoginConfPath", "");
            this.m_connStrAttr.mppLocal = Boolean.valueOf(props.getProperty("mppLocal", "false"));
            this.m_connStrAttr.rwSeparate = Integer.parseInt(props.getProperty("rwSeparate", "0"));
            this.m_connStrAttr.rwPercent = Integer.parseInt(props.getProperty("rwPercent", "75"));
            this.m_connStrAttr.dbmdChkPrv = Boolean.valueOf(props.getProperty("dbmdChkPrv", "false"));
            this.m_connStrAttr.uKeyName = props.getProperty("uKeyName", "");
            this.m_connStrAttr.uKeyPin = props.getProperty("uKeyPin", "");
            this.m_connStrAttr.wellDistributed = Boolean.valueOf(props.getProperty("wellDistributed", "false"));
            this.m_connStrAttr.isBdtaRS = Boolean.valueOf(props.getProperty("isBdtaRS", "true"));
            this.m_connStrAttr.multiRsCaches = Boolean.valueOf(props.getProperty("multiRsCaches", "false"));
            this.m_connStrAttr.rsCacheCount = Integer.parseInt(props.getProperty("rsCacheCount", "2")) > 5 ? 5 : Integer.parseInt(props.getProperty("rsCacheCount", "2"));
            this.m_connStrAttr.columnNameUpperCase = Boolean.valueOf(props.getProperty("columnNameUpperCase", "false"));
            this.m_connStrAttr.doSwitch = Boolean.valueOf(props.getProperty("doSwitch", "false"));
        }
        if (this.m_connStrAttr.traceLevel > 0) {
            String path = "";
            path = System.getProperty("os.name").startsWith("Win") ? "c:\\jdbc_log.txt" : "/home/jdbc_log.txt";
            try {
                File f = new File(path);
                if (!f.exists()) {
                    f.createNewFile();
                }
                DriverManager.setLogWriter(new PrintWriter(new FileOutputStream(path, true)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.initClientInfoWithConnStr();
    }

    public boolean getRwSeparate() {
        return this.m_connStrAttr.rwSeparate == 1;
    }

    public int getLobMode() {
        String value = this.m_clientInfoMapConnStr.getProperty("LobMode");
        if (value == null) {
            return this.m_connStrAttr.lob_mode;
        }
        return Integer.parseInt(value);
    }

    public int getTraceLevel() {
        String value = this.m_clientInfoMapConnStr.getProperty("traceLevel");
        if (value == null) {
            return this.m_connStrAttr.traceLevel;
        }
        return Integer.parseInt(value);
    }

    public int getInfoLevel() {
        return this.m_connStrAttr.infoLevel;
    }

    public String getAppName() {
        return this.m_connStrAttr.appName;
    }

    public int getConnectTimeout() {
        return this.m_connStrAttr.connectTimeout;
    }

    public int getSessionTimeout() {
        return this.m_connStrAttr.sessionTimeout;
    }

    public final int getSocketTimeout() {
        return this.m_connStrAttr.socketTimeout;
    }

    public boolean getMppLocal() {
        return this.m_connStrAttr.mppLocal;
    }

    public final int getDefaultRowPrefetch() {
        return this.m_connStrAttr.default_row_prefetch;
    }

    public final int getMaxRows() {
        return this.m_connStrAttr.maxRows;
    }

    public final boolean getContinueBatchOnError() {
        String value = this.m_clientInfoMapConnStr.getProperty("continueBatchOnError");
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public final String getURL() {
        return this.m_connStrAttr.url;
    }

    public final String getHostName() {
        return this.m_connStrAttr.host;
    }

    public final void setHostName(String host) {
        this.m_connStrAttr.host = host;
    }

    public boolean getEscape() {
        return this.m_connStrAttr.m_process_escapes;
    }

    public void setEscape(boolean escapeFlag) {
        this.m_connStrAttr.m_process_escapes = escapeFlag;
    }

    public final void setHostPort(int port) {
        this.m_connStrAttr.port = port;
    }

    public final String getLoginName() {
        return this.m_connStrAttr.login;
    }

    public final void setLoginName(String user) {
        this.m_connStrAttr.login = user;
    }

    public final String getPassword() {
        return this.m_connStrAttr.password;
    }

    public final String getPortNumber() {
        return String.valueOf(this.m_connStrAttr.port);
    }

    public final boolean getEscapesProcessing() {
        return this.m_connStrAttr.m_process_escapes;
    }

    public Properties getProperties() {
        return this.m_connProps;
    }

    public String getGUID() {
        return this.m_connServAttr.guid;
    }

    public void setGUID(String guid) {
        this.m_connServAttr.guid = guid;
    }

    public void setDbmdChkPrivileges(boolean chk) {
        this.m_connStrAttr.dbmdChkPrv = chk;
    }

    public boolean getDbmdChkPrivileges() {
        return this.m_connStrAttr.dbmdChkPrv;
    }

    public void setNewLobFlag(byte flag) {
        this.m_connServAttr.new_lob_flag = flag != 0;
    }

    public boolean getNewLobFlag() {
        return this.m_connServAttr.new_lob_flag;
    }

    private static boolean isExecute2(String serverVersion, String globalVersion) {
        String[] serStrs = serverVersion.split("\\.");
        String[] globalStrs = globalVersion.split("\\.");
        int i = 0;
        while (i < serStrs.length) {
            Integer ser = Integer.valueOf(serStrs[i]);
            Integer global = Integer.valueOf(globalStrs[i]);
            if (ser > global) {
                return true;
            }
            if (ser.intValue() != global.intValue()) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public boolean isBdtaRS() {
        return this.m_connStrAttr.isBdtaRS;
    }

    public void setIsBdta(boolean isBdta) {
        this.m_connStrAttr.isBdtaRS = isBdta;
    }

    public int getRscacheCount() {
        return this.m_connStrAttr.rsCacheCount;
    }

    public boolean getMultiRsCaches() {
        return this.m_connStrAttr.multiRsCaches;
    }

    public boolean pwd_encrypt() {
        return this.pwd_encrypt;
    }

    public void setPwdEncrypt(boolean pwd_encrypt) {
        this.pwd_encrypt = pwd_encrypt;
    }

    public DmdbPooledConnection_bs getMpc() {
        return this.m_pc;
    }

    public double getRwPercent() {
        return this.m_connStrAttr.rwPercent;
    }

    public boolean isRwSeparate() {
        return this.m_rwSeparate;
    }

    public void setRwSeparate(boolean b) {
        this.m_rwSeparate = b;
    }

    public boolean getColumnNameUpperCase() {
        return this.m_connStrAttr.columnNameUpperCase;
    }

    public boolean doSwitch() {
        return this.m_connStrAttr.doSwitch;
    }

    class ConnServAttr {
        int language = 0;
        int tranAccessMode = 0;
        short tz = Const.TIME_ZONE_DEFAULT;
        String osName = System.getProperty("os.name", "");
        short maxRowSize;
        int maxSession;
        boolean ddl_auto_commit;
        int trans_level = -1;
        boolean caseSensitive = true;
        boolean backslash_escape;
        int svrMode;
        int svrStat;
        boolean const_para_opt = false;
        int db_tz = 0;
        String instanceName;
        String schema;
        String lastLoginIP;
        String lastLoginTime;
        int failedAttempts;
        int loginWarningID;
        int gracetimeRemainder;
        String guid;
        boolean new_lob_flag;
        int encryptMsg = 0;
        int comprMsg = 0;
        String dmServerVersion = null;
        int global_server_series = 0;
        String m_serverEncoding = null;
        int networkPacketSize;

        ConnServAttr() {
        }
    }

    class ConnStrAttr {
        String url;
        String login;
        String password;
        String host;
        int port;
        boolean mppLocal = false;
        int socketTimeout = 0;
        boolean continueBatchOnError = true;
        boolean m_process_escapes = true;
        int connectTimeout = 0;
        boolean auto_commit = true;
        int maxRows = 0;
        int default_row_prefetch = 10;
        int lob_mode = 1;
        int stmtPoolSize = 0;
        boolean ignoreCase = true;
        boolean comOra = false;
        int infoLevel = 1;
        boolean alwayseAllowCommit = true;
        int batchType = 1;
        int maxCachedPstmtSize;
        int traceLevel = 0;
        String appName = "";
        int sessionTimeout = 0;
        boolean isCompress = false;
        String sslFilesPath = "";
        String sslKeystorePass = "";
        int resultSetType = 1003;
        String kerberosLoginConfPath = "";
        int rwSeparate = 0;
        int rwPercent = 25;
        boolean dbmdChkPrv = false;
        String uKeyName = "";
        String uKeyPin = "";
        boolean wellDistributed = false;
        boolean isBdtaRS = true;
        int rsCacheCount = 2;
        boolean multiRsCaches = false;
        boolean columnNameUpperCase = false;
        boolean doSwitch = false;

        ConnStrAttr() {
        }
    }
}

