/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbCallableStatement_bs;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbDatabaseMetaData_bs;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.innerData.DmdbConnAgent;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;

public class DmdbConnection
extends DmdbConnAgent
implements Connection {
    DmdbDatabaseMetaData m_dbMetaData = null;

    public DmdbConnection(DmdbConnection_bs conn) {
        super(conn);
    }

    public boolean isLogicalConnection() {
        return this.rConn.isLogicalConnection();
    }

    @Override
    public synchronized Statement createStatement() throws SQLException {
        DmdbStatement stmt = new DmdbStatement((DmdbStatement_bs)this.rConn.createStatement(), this);
        return stmt;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        DmdbPreparedStatement pstmt = new DmdbPreparedStatement((DmdbPreparedStatement_bs)this.rConn.prepareStatement(sql), this);
        return pstmt;
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        DmdbCallableStatement cstmt = new DmdbCallableStatement((DmdbCallableStatement_bs)this.rConn.prepareCall(sql), this);
        return cstmt;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.rConn.nativeSQL(sql);
    }

    @Override
    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.rConn.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.rConn.getAutoCommit();
    }

    @Override
    public synchronized void commit() throws SQLException {
        this.rConn.commit();
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.rConn.rollback();
    }

    @Override
    public synchronized void close() throws SQLException {
        this.rConn.close();
    }

    public synchronized void closeForAgent() throws SQLException {
        this.rConn.closeForAgent();
    }

    public synchronized void logicalClose() throws SQLException {
        this.rConn.logicalClose();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.rConn.isClosed();
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        if (this.m_dbMetaData == null) {
            DmdbDatabaseMetaData_bs bs = (DmdbDatabaseMetaData_bs)this.rConn.getMetaData();
            if (bs == null) {
                return null;
            }
            this.m_dbMetaData = new DmdbDatabaseMetaData(bs);
        }
        return this.m_dbMetaData;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.rConn.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.rConn.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.rConn.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.rConn.getCatalog();
    }

    public final String getUserName() throws SQLException {
        return this.rConn.getUserName();
    }

    public final boolean isCompress() {
        return this.rConn.isCompress();
    }

    @Override
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        this.rConn.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.rConn.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.rConn.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.rConn.clearWarnings();
    }

    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        DmdbStatement stmt = new DmdbStatement((DmdbStatement_bs)this.rConn.createStatement(resultSetType, resultSetConcurrency), this);
        return stmt;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        DmdbPreparedStatement pstmt = new DmdbPreparedStatement((DmdbPreparedStatement_bs)this.rConn.prepareStatement(sql, resultSetType, resultSetConcurrency), this);
        return pstmt;
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        DmdbCallableStatement cstmt = new DmdbCallableStatement((DmdbCallableStatement_bs)this.rConn.prepareCall(sql, resultSetType, resultSetConcurrency), this);
        return cstmt;
    }

    public Map getTypeMap() throws SQLException {
        return this.rConn.getTypeMap();
    }

    @Override
    public synchronized void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.rConn.setTypeMap((Map)map);
    }

    @Override
    public synchronized void setHoldability(int holdability) throws SQLException {
        this.rConn.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.rConn.getHoldability();
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        return this.rConn.setSavepoint();
    }

    @Override
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        return this.rConn.setSavepoint(name);
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.rConn.rollback(savepoint);
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.rConn.releaseSavepoint(savepoint);
    }

    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbStatement stmt = new DmdbStatement((DmdbStatement_bs)this.rConn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this);
        return stmt;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbPreparedStatement pstmt = new DmdbPreparedStatement((DmdbPreparedStatement_bs)this.rConn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this);
        return pstmt;
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbCallableStatement cstmt = new DmdbCallableStatement((DmdbCallableStatement_bs)this.rConn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this);
        return cstmt;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        DmdbPreparedStatement pstmt = new DmdbPreparedStatement((DmdbPreparedStatement_bs)this.rConn.prepareStatement(sql, autoGeneratedKeys), this);
        return pstmt;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        DmdbPreparedStatement pstmt = new DmdbPreparedStatement((DmdbPreparedStatement_bs)this.rConn.prepareStatement(sql, columnIndexes), this);
        return pstmt;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        DmdbPreparedStatement pstmt = new DmdbPreparedStatement((DmdbPreparedStatement_bs)this.rConn.prepareStatement(sql, columnNames), this);
        return pstmt;
    }

    public String getExplainInfo(String str) throws SQLException {
        return this.rConn.getExplainInfo(str);
    }

    public String getSessionTrace(String str) throws SQLException {
        return this.rConn.getSessionTrace(str);
    }

    public int getGlobalServerSeries() {
        return this.rConn.getGlobalServerSeries();
    }

    public String getLastLoginIP() {
        return this.rConn.getLastLoginIP();
    }

    public String getLastLoginTime() {
        return this.rConn.getLastLoginTime();
    }

    public int getLoginWarningID() {
        return this.rConn.getLoginWarningID();
    }

    public int getGraceTimeRemainder() {
        return this.rConn.getGraceTimeRemainder();
    }

    public int getFailedAttempt() {
        return this.rConn.getFailedAttempt();
    }

    public Boolean getNetworkEncypted() {
        return this.rConn.getEncryptMsg() == 1;
    }

    public int getNetworkPacketSize() {
        return this.rConn.getNetworkPacketSize();
    }

    public int getConnectTimeout() {
        return this.rConn.getConnectTimeout();
    }

    public int getEncryptMsg() {
        return this.rConn.getEncryptMsg();
    }

    public String getHostName() {
        return this.rConn.getHostName();
    }

    public String getHostPort() {
        return this.rConn.getPortNumber();
    }

    public Boolean getEscape() {
        return this.rConn.getEscape();
    }

    public void setEscape(Boolean escapeFlag) {
        this.rConn.setEscape(escapeFlag);
    }

    public int getLanguage() {
        return this.rConn.getLanguage();
    }

    @Override
    public Clob createClob() throws SQLException {
        return new DmdbClob(this);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return new DmdbBlob(this);
    }

    @Override
    public NClob createNClob() throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            this.rConn.checkClosed();
            Statement stmt = this.rConn.createStatement();
            stmt.execute("select 1 from dual");
            stmt.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (name == null || value == null) {
            String reason = "Invalid Parameters\uff0cProperty name or value is null";
            throw new SQLClientInfoException(reason, null);
        }
        this.rConn.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.rConn.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        if (name == null) {
            DBError.throwSQLException("Invalid Property Name which is null");
        }
        return this.rConn.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.rConn.getClientInfo();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public void reset() throws SQLException {
        this.rConn.reset();
    }

    public void setDbmdChkPrivileges(boolean chk) {
        this.rConn.setDbmdChkPrivileges(chk);
    }

    public boolean getDbmdChkPrivileges() {
        return this.rConn.getDbmdChkPrivileges();
    }

    public boolean isRwSeparate() {
        return this.rConn.isRwSeparate();
    }

    public double getRwPercent() {
        return this.rConn.getRwPercent();
    }
}

