/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.ColumnDesc;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbType;
import dm.sql.TypeDescriptor;
import java.sql.SQLException;

public class DmdbColumn
implements Cloneable {
    private ColumnDesc m_desc = new ColumnDesc();
    private DmdbConnection_bs m_conn = null;

    public DmdbColumn(DmdbConnection_bs conn) {
        this.m_conn = conn;
    }

    public ColumnDesc getDesc() {
        return this.m_desc;
    }

    public int checkComplexType(byte[] buf, int offset) throws SQLException {
        if (!this.m_desc.isComplexType()) {
            return offset;
        }
        TypeDescriptor strDesc = new TypeDescriptor(this.m_conn);
        offset = strDesc.unpack(buf, offset);
        this.m_desc.setTypeDescriptor(strDesc);
        return offset;
    }

    public int getDisplaySize() {
        return DmdbType.displaySizeByJdbcType(this.getSqlType(), this.m_desc.getPrec(), this.m_desc.getDTypeInfo().getLocalScale());
    }

    public int getSqlPrec() {
        int rPrec = 0;
        switch (this.m_desc.getDType()) {
            case 20: 
            case 21: {
                rPrec = this.m_desc.getScale() >> 4 & 0xF;
                break;
            }
            default: {
                rPrec = DmdbType.CPrecToJdbcPrec(this.getSqlType(), this.m_desc.getPrec(), this.m_desc.getDTypeInfo().getLocalScale());
            }
        }
        return rPrec;
    }

    public int getSqlScale() {
        int rScale = this.m_desc.getScale();
        switch (this.m_desc.getDType()) {
            case 20: 
            case 21: {
                rScale &= 0xF;
                break;
            }
            case 12: {
                if (rScale != 5) break;
                rScale = 0;
                break;
            }
            default: {
                rScale = this.m_desc.getDTypeInfo().getLocalScale();
            }
        }
        return rScale;
    }

    public int getSqlType() {
        if (this.m_desc.isComplexType()) {
            return 2002;
        }
        return DmdbType.DTypeToSqlType(this.m_desc.getDType(), this.m_desc.getTypeName());
    }

    public String getTypeName() throws SQLException {
        if (this.m_desc.isComplexType()) {
            return this.m_desc.getTypeDescriptor().getFulName();
        }
        return this.m_desc.getTypeName();
    }

    public static int getMaxTupleLen(DmdbColumn[] cols, int maxRowSize) {
        int tmp_tuple_len = 0;
        int i = 0;
        while (i < cols.length) {
            int dType = cols[i].getDesc().getDTypeInfo().getDType();
            if (dType == 12 || dType == 19) {
                tmp_tuple_len = maxRowSize;
                break;
            }
            tmp_tuple_len += cols[i].getDesc().getPrec();
            i = (short)(i + 1);
        }
        if (tmp_tuple_len > maxRowSize) {
            tmp_tuple_len = maxRowSize;
        }
        return tmp_tuple_len += 10 + 2 * cols.length + 8;
    }

    public Object clone() {
        DmdbColumn col = null;
        try {
            col = (DmdbColumn)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return col;
    }
}

