/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.CnvtInfo;
import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmBinder;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.sql.DmdbDateTime;
import dm.sql.DmdbTime;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;

public class DmTimestampBinder
extends DmBinder {
    public DmTimestampBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
    }

    void init() {
        this.recDType = 16;
        this.recPrec = 8;
        this.recScale = 0;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        Timestamp x = ((Timestamp[])this.pstmt.m_paramObjects[icol])[irow];
        CnvtInfo cnvtInfo = this.pstmt.connection.getCnvtInfo();
        String serverEncoding = cnvtInfo.getServerEncoding();
        short dbTz = cnvtInfo.getDbTz();
        short ltz = cnvtInfo.getTimeZone();
        byte[] ret = DmTimestampBinder.toDbBytes(x, this.destDType, this.destPrec, this.srcScale, serverEncoding, ltz, dbTz);
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public static byte[] toDbBytes(Timestamp x, int destDType, int destPrec, int srcScale, String serverEncoding, short ltz, short dbTz) throws SQLException {
        byte[] ret = null;
        DmdbDateTime dt = null;
        switch (destDType) {
            case 14: {
                dt = new DmdbDateTime(new Date(x.getTime()).toString(), srcScale, 0);
                ret = Convertion.DateToByteArray(dt);
                break;
            }
            case 15: {
                String time = x.toString();
                int timeind = time.indexOf(" ");
                time = time.substring(timeind + 1, time.length());
                DmdbTime t = new DmdbTime(time, srcScale);
                ret = Convertion.TimeToByteArray(t);
                break;
            }
            case 16: {
                dt = new DmdbDateTime(x.toString(), srcScale, 2);
                ret = Convertion.TimeStampToByteArray(dt, destDType, srcScale, dbTz, ltz);
                break;
            }
            case 0: 
            case 1: {
                ret = Convertion.String_char_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                break;
            }
            case 2: 
            case 19: {
                ret = Convertion.String_varchar_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                break;
            }
            case 22: {
                String str = x.toString();
                int ind = str.indexOf(" ");
                str = str.substring(ind + 1, str.length());
                ret = Convertion.String_javaObj_2CType(str, destDType, srcScale, destPrec, ltz);
                break;
            }
            case 20: 
            case 21: 
            case 23: {
                ret = Convertion.String_javaObj_2CType(x.toString(), destDType, srcScale, destPrec, ltz);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return ret;
    }
}

