/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.CnvtInfo;
import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmBinder;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.jdbc.driver.DmdbType;
import dm.sql.DmdbDateTime;
import dm.sql.DmdbTime;
import java.sql.SQLException;

public class DmStringBinder
extends DmBinder {
    boolean new_lob_flag = false;
    private int m_strRealLen = 0;

    public DmStringBinder(DmdbPreparedStatement_bs pstmt, int prec) {
        super(pstmt);
        this.m_strRealLen = prec;
        this.new_lob_flag = pstmt.getConnection_bs().getNewLobFlag();
    }

    void init() {
        this.recDType = 2;
        this.recPrec = 8188;
        this.recScale = 0;
    }

    void checkType(int icol, boolean forBatch) throws SQLException {
        if (this.m_checkType) {
            return;
        }
        this.m_checkType = true;
        if (this.paramsDesc == null) {
            this.paramsDesc = this.pstmt.getParamsDesc();
        }
        byte typeFlag = this.paramsDesc[icol].getTypeFlag();
        int dType = this.paramsDesc[icol].getDType();
        int prec = this.paramsDesc[icol].getPrec();
        int scale = this.paramsDesc[icol].getScale();
        byte ioType = this.paramsDesc[icol].getIOType();
        if (ioType != 1 && typeFlag != 1) {
            this.destDType = this.recDType;
            this.destPrec = this.recPrec;
            this.destScale = this.recScale;
            if (!forBatch && DmdbType.isNumberType(dType)) {
                this.destPrec = this.m_strRealLen < 8188 ? this.m_strRealLen : 8188;
            } else if (!forBatch && dType == 2) {
                this.destPrec = this.m_strRealLen < prec ? prec : this.m_strRealLen;
            }
        } else {
            this.destDType = dType;
            this.destPrec = prec;
            this.destScale = scale;
        }
        this.destIoType = ioType;
        this.srcScale = scale;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        String x = ((String[])this.pstmt.m_paramObjects[icol])[irow];
        CnvtInfo cnvtInfo = this.pstmt.connection.getCnvtInfo();
        byte[] ret = DmStringBinder.toDbBytes(x, this.destDType, this.destPrec, this.destScale, cnvtInfo.getServerEncoding(), cnvtInfo.getTimeZone(), cnvtInfo.getDbTz());
        if ((this.destDType == 12 || this.destDType == 19) && ret.length > 2048) {
            return -1;
        }
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public static byte[] toDbBytes(String x, int destDType, int destPrec, int destScale, String serverEncoding, short ltz, short dtz) throws SQLException {
        byte[] ret = null;
        switch (destDType) {
            case 0: 
            case 1: {
                ret = Convertion.String_char_2CType(x, destPrec, destDType, serverEncoding);
                break;
            }
            case 2: {
                ret = Convertion.String_varchar_2CType(x, destPrec, destDType, serverEncoding);
                break;
            }
            case 18: {
                ret = Convertion.stringToBinary(x, destPrec);
                break;
            }
            case 17: {
                ret = Convertion.stringToBinary(x, destPrec);
                break;
            }
            case 12: {
                ret = Convertion.stringToBinary(x, destPrec);
                break;
            }
            case 19: {
                ret = Convertion.getBytes(x, serverEncoding);
                break;
            }
            case 3: {
                byte val = 1;
                if (x.charAt(0) == '0' || "false".equalsIgnoreCase(x)) {
                    val = 0;
                }
                ret = Convertion.byteToByteArray(val);
                break;
            }
            case 5: {
                ret = Convertion.byteToByteArray(Byte.parseByte(x.trim()));
                break;
            }
            case 6: {
                ret = Convertion.shortToByteArray(Short.parseShort(x.trim()));
                break;
            }
            case 7: {
                ret = Convertion.IntToByteArray(Integer.parseInt(x.trim()));
                break;
            }
            case 8: {
                ret = Convertion.longToByteArray(Long.parseLong(x.trim()));
                break;
            }
            case 10: {
                ret = Convertion.floatToByteArray(Float.parseFloat(x.trim()));
                break;
            }
            case 11: {
                ret = Convertion.doubleToByteArray(Double.parseDouble(x.trim()));
                break;
            }
            case 9: 
            case 24: {
                ret = Convertion.BigDecimalToByteArray(x, destPrec, destScale);
                break;
            }
            case 13: {
                boolean b = false;
                if (!x.trim().equalsIgnoreCase("0") || Boolean.valueOf(x).booleanValue()) {
                    b = true;
                }
                ret = Convertion.booleanToByteArray(b);
                break;
            }
            case 14: {
                DmdbDateTime dt = new DmdbDateTime(x.trim(), destScale, 0);
                ret = Convertion.DateToByteArray(dt);
                break;
            }
            case 15: {
                DmdbTime t = new DmdbTime(x.trim(), destScale);
                ret = Convertion.TimeToByteArray(t);
                break;
            }
            case 16: {
                int[] ts = DmdbDateTime.stringToDT(x.trim(), destDType, destScale, ltz);
                DmdbDateTime dt = new DmdbDateTime(ts, destScale, 2);
                ret = Convertion.TimeStampToByteArray(dt, destDType, destScale, dtz, ltz);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                ret = Convertion.String_javaObj_2CType(x, destDType, destScale, destPrec, ltz);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return ret;
    }

    public int bindLobCyc(DmMsgSend lobMsg, int irow, int icol) throws SQLException {
        int leftLen;
        String str = ((String[])this.pstmt.m_paramObjects[icol])[irow];
        String serverEncoding = this.pstmt.connection.getServerEncoding();
        int maxLen = 8000;
        if (this.offset_var >= str.length()) {
            this.clearVars();
            return 0;
        }
        if (this.offset_var == -1) {
            this.offset_var = 0;
        }
        int readLen = (leftLen = str.length() - this.offset_var) < maxLen ? leftLen : maxLen;
        int endLen = this.offset_var + readLen;
        String subStr = str.substring(this.offset_var, endLen);
        this.offset_var += readLen;
        byte[] strbs = Convertion.getBytes(subStr, serverEncoding);
        return lobMsg.appendOffRowBytes(strbs, 0, strbs.length, this.new_lob_flag, subStr.length());
    }
}

