/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmBinder;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.sql.DmdbDateTime;
import dm.sql.DmdbTime;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class DmLongBinder
extends DmBinder {
    public DmLongBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
    }

    void init() {
        this.recDType = 8;
        this.recPrec = 8;
        this.recScale = 0;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        long x = ((long[])this.pstmt.m_paramObjects[icol])[irow];
        String serverEncoding = this.pstmt.connection.getServerEncoding();
        byte[] ret = DmLongBinder.toDbBytes(x, this.destDType, this.destPrec, this.destScale, serverEncoding, this.destIoType, this.destIoType);
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public static byte[] toDbBytes(long x, int destDType, int destPrec, int destScale, String serverEncoding, short ltz, short dbTz) throws SQLException {
        byte[] ret = null;
        switch (destDType) {
            case 8: {
                ret = Convertion.longToByteArray(x);
                break;
            }
            case 3: {
                if (x > 127L || x < -128L) {
                    DBError.throwSQLException(6004);
                }
                ret = Convertion.byteToByteArray((byte)(x != 0L ? 1 : 0));
                break;
            }
            case 5: {
                if (x > 127L || x < -128L) {
                    DBError.throwSQLException(6004);
                }
                ret = Convertion.byteToByteArray((byte)x);
                break;
            }
            case 6: {
                if (x > 32767L || x < -32768L) {
                    DBError.throwSQLException(6004);
                }
                ret = Convertion.shortToByteArray((int)x);
                break;
            }
            case 7: {
                if (x > Integer.MAX_VALUE || x < Integer.MIN_VALUE) {
                    DBError.throwSQLException(6004);
                }
                ret = Convertion.IntToByteArray((int)x);
                break;
            }
            case 10: {
                ret = Convertion.floatToByteArray(x);
                break;
            }
            case 11: {
                ret = Convertion.doubleToByteArray(x);
                break;
            }
            case 9: 
            case 24: {
                ret = Convertion.BigDecimalToByteArray(String.valueOf(x), destPrec, destScale);
                break;
            }
            case 13: {
                ret = Convertion.booleanToByteArray(x != 0L);
                break;
            }
            case 0: 
            case 1: {
                ret = Convertion.String_char_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                break;
            }
            case 2: 
            case 19: {
                ret = Convertion.String_varchar_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                break;
            }
            case 17: {
                ret = Convertion.longToBinary(x, destPrec);
                break;
            }
            case 16: {
                if (x > 255611203200L) {
                    DBError.throwSQLException(-2512);
                }
                DmdbDateTime ts = new DmdbDateTime(new Timestamp(x * 1000L - 2209017600000L).toString(), destScale, 2);
                ret = Convertion.TimeStampToByteArray(ts, destDType, destScale, dbTz, ltz);
                break;
            }
            case 15: {
                ret = Convertion.TimeToByteArray(new DmdbTime(String.valueOf(new Time(x * 1000L)), destScale));
                break;
            }
            case 14: {
                if (x > 2958463L) {
                    DBError.throwSQLException(-2512);
                }
                DmdbDateTime dt = new DmdbDateTime(new Date(x * 24L * 60L * 60L * 1000L - 2209017600000L).toString(), destScale, 0);
                ret = Convertion.DateToByteArray(dt);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return ret;
    }
}

