/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmBinder;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.sql.DmdbIntervalDT;
import java.sql.SQLException;

public class DmIntvDTBinder
extends DmBinder {
    private boolean exactType;

    public DmIntvDTBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
    }

    void init() {
        this.recDType = 21;
        this.recPrec = 0;
        this.recScale = 0;
    }

    void checkType(int icol, boolean forBatch) throws SQLException {
        if (this.m_checkType) {
            return;
        }
        this.m_checkType = true;
        if (this.paramsDesc == null) {
            this.paramsDesc = this.pstmt.getParamsDesc();
        }
        byte typeFlag = this.paramsDesc[icol].getTypeFlag();
        int dType = this.paramsDesc[icol].getDType();
        int prec = this.paramsDesc[icol].getPrec();
        int scale = this.paramsDesc[icol].getScale();
        byte ioType = this.paramsDesc[icol].getIOType();
        if (ioType != 1 && typeFlag != 1) {
            this.destDType = this.recDType;
            this.destPrec = this.recPrec;
            this.destScale = scale;
            this.exactType = false;
        } else {
            this.destDType = dType;
            this.destPrec = prec;
            this.destScale = scale;
            this.exactType = true;
        }
        this.destIoType = ioType;
        this.srcScale = scale;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        DmdbIntervalDT dt = ((DmdbIntervalDT[])this.pstmt.m_paramObjects[icol])[irow];
        String serverEncoding = this.pstmt.connection.getServerEncoding();
        int scale = this.destScale;
        if (!this.exactType) {
            scale = dt.getPrecForSvr();
        }
        byte[] ret = DmIntvDTBinder.toDbBytes(dt, this.destDType, this.destPrec, scale, serverEncoding);
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public static byte[] toDbBytes(DmdbIntervalDT dt, int destDType, int destPrec, int scale, String serverEncoding) throws SQLException {
        byte[] ret = null;
        switch (destDType) {
            case 21: {
                ret = Convertion.InterDtToByteArray(dt, scale);
                break;
            }
            case 0: 
            case 1: {
                ret = Convertion.String_char_2CType(String.valueOf(dt), destPrec, destDType, serverEncoding);
                break;
            }
            case 2: 
            case 19: {
                ret = Convertion.String_varchar_2CType(String.valueOf(dt), destPrec, destDType, serverEncoding);
                break;
            }
            case 17: {
                ret = Convertion.stringToBinary(String.valueOf(dt), destPrec);
                break;
            }
            case 12: 
            case 18: {
                ret = Convertion.stringToBinary(String.valueOf(dt), destPrec);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return ret;
    }
}

