/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmBinder;
import dm.jdbc.driver.DmInputStreamParam;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import dm.sql.TypeData;
import dm.sql.TypeDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class DmInputStreamBinder
extends DmBinder {
    boolean toBindLobCyc = false;
    boolean new_lob_flag = false;
    byte[] ret = null;
    int retLen = 0;

    public DmInputStreamBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
        this.new_lob_flag = pstmt.getConnection_bs().getNewLobFlag();
    }

    void init() {
        this.recDType = 12;
        this.recPrec = Integer.MAX_VALUE;
        this.recScale = 0;
    }

    void checkType(int icol, boolean forBatch) throws SQLException {
        byte ioType;
        if (this.m_checkType) {
            return;
        }
        this.m_checkType = true;
        if (this.paramsDesc == null) {
            this.paramsDesc = this.pstmt.getParamsDesc();
        }
        byte typeFlag = this.paramsDesc[icol].getTypeFlag();
        int dType = this.paramsDesc[icol].getDType();
        int prec = this.paramsDesc[icol].getPrec();
        int scale = this.paramsDesc[icol].getScale();
        this.destIoType = ioType = this.paramsDesc[icol].getIOType();
        this.srcScale = scale;
        if (typeFlag == 1 || ioType == 1) {
            this.destDType = dType;
            this.destPrec = prec;
            this.destScale = scale;
            return;
        }
        switch (dType) {
            case 0: 
            case 1: 
            case 2: 
            case 17: 
            case 18: {
                this.destDType = 18;
                this.destPrec = 8188;
                this.destScale = 0;
                break;
            }
            case 12: 
            case 19: {
                this.destDType = 12;
                this.destPrec = Integer.MAX_VALUE;
                this.destScale = 0;
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
    }

    private byte[] readLeftCompletelyWithTry(DmInputStreamParam inParm) throws IOException {
        int readLen;
        InputStream in = inParm.m_in;
        long targetLen = inParm.m_targetLen;
        byte[] ret = null;
        if (this.streamReadOver) {
            ret = new byte[this.streamReadTryLen];
            System.arraycopy(this.streamReadTry, 0, ret, 0, this.streamReadTryLen);
            return ret;
        }
        int maxLen = 32000;
        byte[] totalBuf = new byte[maxLen];
        int count = 0;
        do {
            if (count < maxLen) continue;
            byte[] totalTemp = new byte[maxLen += 16000];
            System.arraycopy(totalBuf, 0, totalTemp, 0, count);
            totalBuf = totalTemp;
        } while ((readLen = in.read(totalBuf, count, maxLen - count)) > 0 && (targetLen == -1L || (long)((count += readLen) + this.streamReadTryLen) < targetLen));
        if (targetLen != -1L) {
            ret = new byte[(int)targetLen];
            System.arraycopy(this.streamReadTry, 0, ret, 0, this.streamReadTryLen);
            System.arraycopy(totalBuf, 0, ret, this.streamReadTryLen, (int)(targetLen - (long)this.streamReadTryLen));
        } else {
            ret = new byte[count + this.streamReadTryLen];
            System.arraycopy(this.streamReadTry, 0, ret, 0, this.streamReadTryLen);
            System.arraycopy(totalBuf, 0, ret, this.streamReadTryLen, count);
        }
        this.streamReadOver = true;
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        DmInputStreamParam inParam = ((DmInputStreamParam[])this.pstmt.m_paramObjects[icol])[irow];
        InputStream in = inParam.m_in;
        long targetLen = inParam.m_targetLen;
        TypeDescriptor typeDesc = this.paramsDesc[icol].getTypeDescriptor();
        if (this.toBindLobCyc) {
            return -1;
        }
        if (this.ret != null) {
            int realLen = msg.appendBytesWithLen2(this.ret, 0, this.retLen);
            this.ret = null;
            this.retLen = 0;
            return realLen;
        }
        try {
            int maxLen = 16000;
            this.streamReadTry = new byte[maxLen];
            this.streamReadTryLen = in.read(this.streamReadTry, 0, maxLen);
            if (this.streamReadTryLen < maxLen) {
                if (this.streamReadTryLen == -1) {
                    this.streamReadTryLen = 0;
                }
                this.streamReadOver = true;
            }
            this.retLen = this.streamReadTryLen;
            if (targetLen != -1L && (long)this.retLen > targetLen) {
                this.retLen = (int)targetLen;
                this.streamReadOver = true;
            }
            if ((this.destDType == 12 || this.destDType == 19) && this.retLen > 2048) {
                this.toBindLobCyc = true;
                return -1;
            }
            switch (this.destDType) {
                case 0: 
                case 1: 
                case 2: 
                case 12: 
                case 17: 
                case 18: 
                case 19: 
                case 119: {
                    if (this.streamReadOver) {
                        this.ret = this.streamReadTry;
                    } else {
                        this.ret = this.readLeftCompletelyWithTry(inParam);
                        this.retLen = this.ret.length;
                    }
                    if (this.destDType != 119 || typeDesc == null) break;
                    this.ret = TypeData.objBlobToBytes(this.ret, typeDesc);
                    this.retLen = this.ret.length;
                    break;
                }
                default: {
                    DBError.throwSQLException(6007);
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        this.clearVars();
        return msg.appendBytesWithLen2(this.ret, 0, this.retLen);
    }

    public int bindLobCyc(DmMsgSend lobMsg, int irow, int icol) throws SQLException {
        byte[] ret;
        int maxLen;
        int retLen;
        long targetLen;
        block8: {
            DmInputStreamParam inParam = ((DmInputStreamParam[])this.pstmt.m_paramObjects[icol])[irow];
            InputStream in = inParam.m_in;
            targetLen = inParam.m_targetLen;
            int realLen = 0;
            retLen = 0;
            this.toBindLobCyc = false;
            if (this.streamReadTry != null) {
                realLen = this.streamReadTryLen;
                if (targetLen != -1L && (long)this.streamReadTryLen > targetLen) {
                    realLen = (int)targetLen;
                }
                retLen = lobMsg.appendOffRowBytes(this.streamReadTry, 0, realLen, this.new_lob_flag, -1);
                this.streamReadTry = null;
                return retLen;
            }
            if (this.streamReadOver) {
                this.clearVars();
                return 0;
            }
            maxLen = 16000;
            ret = new byte[maxLen];
            try {
                retLen = in.read(ret, 0, maxLen);
                if (retLen != -1) break block8;
                this.clearVars();
                return 0;
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
        }
        if (retLen < maxLen) {
            this.streamReadOver = true;
        }
        this.streamReadTryLen += retLen;
        if (targetLen != -1L && (long)this.streamReadTryLen >= targetLen) {
            this.streamReadOver = true;
            retLen = (int)((long)retLen - ((long)this.streamReadTryLen - targetLen));
        }
        return lobMsg.appendOffRowBytes(ret, 0, retLen, this.new_lob_flag, -1);
    }

    public void clearRetValue() {
        this.ret = null;
        this.retLen = 0;
    }
}

