/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmBinder;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import java.sql.SQLException;

public class DmByteBinder
extends DmBinder {
    public DmByteBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
    }

    void init() {
        this.recDType = 5;
        this.recPrec = 1;
        this.recScale = 0;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        String serverEncoding = this.pstmt.connection.getServerEncoding();
        byte x = ((byte[])this.pstmt.m_paramObjects[icol])[irow];
        byte[] ret = DmByteBinder.toDbBytes(x, this.destDType, this.destPrec, this.destScale, serverEncoding);
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public static byte[] toDbBytes(byte x, int destDType, int destPrec, int destScale, String serverEncoding) throws SQLException {
        byte[] ret = null;
        switch (destDType) {
            case 3: {
                ret = Convertion.byteToByteArray((byte)(x != 0 ? 1 : 0));
                break;
            }
            case 5: {
                ret = Convertion.byteToByteArray(x);
                break;
            }
            case 6: {
                ret = Convertion.shortToByteArray(x);
                break;
            }
            case 7: {
                ret = Convertion.IntToByteArray(x);
                break;
            }
            case 8: {
                ret = Convertion.longToByteArray(x);
                break;
            }
            case 10: {
                ret = Convertion.floatToByteArray(x);
                break;
            }
            case 11: {
                ret = Convertion.doubleToByteArray(x);
                break;
            }
            case 9: 
            case 24: {
                ret = Convertion.BigDecimalToByteArray(String.valueOf(x), destPrec, destScale);
                break;
            }
            case 13: {
                ret = Convertion.booleanToByteArray(x != 0);
                break;
            }
            case 0: 
            case 1: {
                ret = Convertion.String_char_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                break;
            }
            case 2: 
            case 19: {
                ret = Convertion.String_varchar_2CType(String.valueOf(x), destPrec, destDType, serverEncoding);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return ret;
    }
}

