/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmBinder;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import java.sql.SQLException;

public class DmByteArrBinder
extends DmBinder {
    boolean new_lob_flag = false;

    public DmByteArrBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
        this.new_lob_flag = pstmt.getConnection_bs().getNewLobFlag();
    }

    void init() {
        this.recDType = 18;
        this.recPrec = 8188;
        this.recScale = 0;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        byte[] x = ((byte[][])this.pstmt.m_paramObjects[icol])[irow];
        if (this.destDType == 12 ? x.length > 2048 : this.destDType == 19 && x.length * 2 > 2048) {
            return -1;
        }
        byte[] bs = DmByteArrBinder.toDbBytes(x, this.destDType, this.destPrec);
        return msg.appendBytesWithLen2(bs, 0, bs.length);
    }

    public static byte[] toDbBytes(byte[] x, int destDType, int destPrec) throws SQLException {
        byte[] bs = null;
        switch (destDType) {
            case 17: {
                bs = x;
                break;
            }
            case 18: {
                bs = x;
                break;
            }
            case 12: {
                bs = x;
                break;
            }
            case 19: {
                bs = Convertion.binaryArrToString(x, destPrec, destDType);
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                bs = Convertion.binaryArrToString(x, destPrec, destDType);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return bs;
    }

    public int bindLobCyc(DmMsgSend lobMsg, int irow, int icol) throws SQLException {
        int readLen;
        byte[] x;
        int maxLen = 16000;
        if (this.destDType == 19) {
            maxLen = 8000;
        }
        if (this.offset_var >= (x = ((byte[][])this.pstmt.m_paramObjects[icol])[irow]).length) {
            this.clearVars();
            return 0;
        }
        if (this.offset_var == -1) {
            this.offset_var = 0;
        }
        int retLen = 0;
        int n = readLen = x.length - this.offset_var > maxLen ? maxLen : x.length - this.offset_var;
        if (this.destDType == 12) {
            retLen = lobMsg.appendOffRowBytes(x, this.offset_var, readLen, this.new_lob_flag, -1);
        } else if (this.destDType == 19) {
            byte[] cvt = Convertion.binaryArrToClob_bin(x, this.offset_var, readLen);
            retLen = lobMsg.appendOffRowBytes(cvt, 0, cvt.length, this.new_lob_flag, -1);
        }
        this.offset_var += readLen;
        return retLen;
    }
}

