/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmBinder;
import dm.jdbc.driver.DmdbPreparedStatement_bs;
import java.sql.SQLException;

public class DmBooleanBinder
extends DmBinder {
    public DmBooleanBinder(DmdbPreparedStatement_bs pstmt) {
        super(pstmt);
    }

    void init() {
        this.recDType = 5;
        this.recPrec = 1;
        this.recScale = 0;
    }

    public int bindData(DmMsgSend msg, int irow, int icol, boolean forBatch) throws SQLException {
        boolean x = ((boolean[])this.pstmt.m_paramObjects[icol])[irow];
        String serverEncoding = this.pstmt.connection.getServerEncoding();
        byte[] ret = DmBooleanBinder.toDbBytes(x, this.destDType, this.destPrec, this.destScale, serverEncoding);
        return msg.appendBytesWithLen2(ret, 0, ret.length);
    }

    public static byte[] toDbBytes(boolean x, int destDType, int destPrec, int destScale, String serverEncoding) throws SQLException {
        int value = x ? 1 : 0;
        byte[] ret = null;
        switch (destDType) {
            case 13: {
                ret = Convertion.booleanToByteArray(x);
                break;
            }
            case 3: 
            case 5: {
                ret = Convertion.byteToByteArray((byte)value);
                break;
            }
            case 6: {
                ret = Convertion.shortToByteArray((short)value);
                break;
            }
            case 7: {
                ret = Convertion.IntToByteArray(value);
                break;
            }
            case 8: {
                ret = Convertion.longToByteArray(value);
                break;
            }
            case 10: {
                ret = Convertion.floatToByteArray(value);
                break;
            }
            case 11: {
                ret = Convertion.doubleToByteArray(value);
                break;
            }
            case 9: 
            case 24: {
                ret = Convertion.BigDecimalToByteArray(String.valueOf(value), destPrec, destScale);
                break;
            }
            case 0: 
            case 1: {
                ret = Convertion.String_char_2CType(String.valueOf(value), destPrec, destDType, serverEncoding);
                break;
            }
            case 2: 
            case 19: {
                ret = Convertion.String_varchar_2CType(String.valueOf(value), destPrec, destDType, serverEncoding);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return ret;
    }
}

