/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import com.jcraft.jzlib.ZlibUtil;
import dm.jdbc.dbaccess.Auth;
import dm.jdbc.dbaccess.AuthInfo;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgRecv;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.dbaccess.MsgSecurity;
import dm.jdbc.dbaccess.SymmCipherDesc;
import dm.jdbc.dbaccess.ssl.MakeSSLSocket;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.util.IPAddressUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.sql.SQLException;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.interfaces.DHPublicKey;

public class DbPureAccess {
    private OutputStream dmOutput = null;
    private InputStream dmInput = null;
    private Socket dmConnection = null;
    private int netPort = 5236;
    private String hostName = null;
    private Properties props = null;
    private int netPacketSize = 8192;
    private int ifCompress = 0;
    private AuthInfo m_kerberosAuth = null;
    private int connTimeout = 0;
    private KeyPair clientKeyPair = null;
    private Cipher encryptCipher = null;
    private Cipher decryptCipher = null;
    private int msgEncryptType = -1;
    private boolean isLocal = false;

    public DbPureAccess(DmdbConnection_bs conn) throws IOException {
        if (conn.getPortNumber() != null) {
            this.netPort = Integer.parseInt(conn.getPortNumber());
        }
        this.setHostName(conn.getHostName());
        this.props = conn.getProperties();
        this.connTimeout = conn.getConnectTimeout();
        this.changeSocket(this.createSocket(this.hostName, this.netPort, this.connTimeout));
    }

    public DbPureAccess(DmdbConnection_bs conn, String host, int port) throws IOException {
        this.netPort = port;
        this.setHostName(host);
        this.props = conn.getProperties();
        this.connTimeout = conn.getConnectTimeout();
        this.changeSocket(this.createSocket(this.hostName, this.netPort, this.connTimeout));
    }

    public void tryEnableSSL(boolean useSSLSocket) throws IOException, SQLException {
        MakeSSLSocket ssl = new MakeSSLSocket();
        ssl.convert(this, this.props, useSSLSocket);
    }

    public synchronized DmMsgRecv access(DmMsgSend sendMsg) throws SQLException, IOException {
        this.send(sendMsg);
        return this.readPacket();
    }

    public void setSocketInfo(String host, String port) throws UnknownHostException, IOException {
        this.setHostName(host);
        this.netPort = Integer.parseInt(port);
        this.changeSocket(this.createSocket(this.hostName, this.netPort, this.connTimeout));
    }

    public void setCompress(int isCompr) {
        this.ifCompress = isCompr;
    }

    public void changeSocket(Socket socket) throws IOException {
        this.dmConnection = socket;
        this.dmConnection.setTcpNoDelay(true);
        this.dmConnection.setKeepAlive(true);
        this.dmInput = new BufferedInputStream(this.dmConnection.getInputStream(), this.netPacketSize);
        this.dmOutput = new BufferedOutputStream(this.dmConnection.getOutputStream(), this.netPacketSize);
    }

    public final Socket getSocket() {
        return this.dmConnection;
    }

    public final String getHostName() {
        return this.hostName;
    }

    public final void setHostName(String host) {
        this.hostName = host;
        if (host != null && host.length() > 0) {
            this.isLocal = DbPureAccess.isLocalHost(host);
        }
    }

    private static boolean isLocalHost(String host) {
        String localhostIP;
        String host2;
        if ("localhost".equalsIgnoreCase(host) || "127.0.0.1".equals(host) || "::1".equals(host)) {
            return true;
        }
        try {
            host2 = InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException x) {
            host2 = host;
        }
        try {
            localhostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException x) {
            localhostIP = null;
        }
        return host2.equalsIgnoreCase(localhostIP);
    }

    public final int getPortNumber() {
        return this.netPort;
    }

    public final void close() {
        this.clientKeyPair = null;
        this.encryptCipher = null;
        this.decryptCipher = null;
        this.msgEncryptType = -1;
        try {
            if (this.dmInput != null) {
                this.dmInput.close();
                this.dmInput = null;
            }
        }
        catch (Exception Ex) {
            this.dmInput = null;
        }
        try {
            if (this.dmOutput != null) {
                this.dmOutput.close();
                this.dmOutput = null;
            }
        }
        catch (Exception Ex) {
            this.dmOutput = null;
        }
        try {
            if (this.dmConnection != null) {
                this.dmConnection.close();
                this.dmConnection = null;
            }
        }
        catch (Exception Ex) {
            this.dmConnection = null;
        }
    }

    protected void finalize() {
        this.close();
    }

    private final DmMsgRecv readPacket_only() throws IOException {
        DmMsgRecv msg = new DmMsgRecv();
        int ret_len = this.readOnce(this.dmInput, msg.getBuffer(), 0, 32640);
        if (ret_len <= 0) {
            throw new IOException();
        }
        long msgLen = msg.res_get_len();
        if ((msgLen += 64L) > (long)msg.getBufLength()) {
            msg.setBuffer((int)msgLen);
        }
        if ((long)ret_len < msgLen) {
            this.readFully(this.dmInput, msg.getBuffer(), ret_len, (int)(msgLen - (long)ret_len));
        }
        return msg;
    }

    private final DmMsgRecv readPacket() throws IOException, SQLException {
        DmMsgRecv msg = this.readPacket_only();
        if (!msg.checkCRC()) {
            DBError.throwSQLException(6002);
        }
        if (this.msgEncryptType != -1 && msg.res_get_len() != 0L) {
            int srcLen = (int)msg.res_get_len();
            byte[] tmp = new byte[srcLen];
            System.arraycopy(msg.getBuffer(), 64, tmp, 0, srcLen);
            byte[] decomBuf = this.symmetricDecrypto(tmp, srcLen, true);
            int desLen = decomBuf.length;
            if (desLen + 64 > msg.getBufLength()) {
                msg.setBuffer(desLen + 64);
            }
            msg.res_set_len(desLen);
            System.arraycopy(decomBuf, 0, msg.getBuffer(), 64, desLen);
        }
        long resLen = msg.res_get_len();
        if (this.ifCompress == 1 && resLen > 0L || this.ifCompress == 2 && msg.res_get_compress() == 1) {
            byte[] tmp = new byte[(int)msg.res_get_len()];
            System.arraycopy(msg.getBuffer(), 68, tmp, 0, (int)(msg.res_get_len() - 4L));
            byte[] decomBuf = ZlibUtil.uncompress(tmp);
            int desLen = decomBuf.length;
            if (desLen + 64 > msg.getBufLength()) {
                msg.setBuffer(desLen + 64);
            }
            msg.res_set_len(desLen);
            System.arraycopy(decomBuf, 0, msg.getBuffer(), 64, desLen);
        }
        return msg;
    }

    private final int readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < len) {
            int count = in.read(b, off + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
        return n;
    }

    private final int readOnce(InputStream in, byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int count = in.read(b, off, len);
        return count;
    }

    private final DmMsgSend pre_send(DmMsgSend msg) throws SQLException {
        int offset;
        byte[] tmp;
        int reqLen = msg.req_get_len();
        if (this.ifCompress == 1 && reqLen > 0 || this.ifCompress == 2 && !this.isLocal && reqLen > 8192) {
            tmp = msg.getFromOffsetWithLen(64, reqLen);
            byte[] comBuf = ZlibUtil.compress(tmp);
            offset = 64;
            msg.setInt(reqLen, offset);
            msg.req_set_len(comBuf.length + 4);
            msg.req_set_compress((byte)1);
            msg.replaceFromOffset(offset += 4, comBuf);
        } else {
            msg.req_set_compress((byte)0);
        }
        reqLen = msg.req_get_len();
        if (this.msgEncryptType != -1 && reqLen != 0) {
            tmp = msg.getFromOffsetWithLen(64, reqLen);
            byte[] encBuf = this.symmetricEncrypto(tmp, reqLen, true);
            offset = 64;
            msg.req_set_len(encBuf.length);
            msg.replaceFromOffset(offset, encBuf);
        }
        msg.setCRC(msg.calculateCRC());
        return msg;
    }

    private final void send(DmMsgSend msgIn) throws IOException, SQLException {
        DmMsgSend msgExtend = this.pre_send(msgIn);
        msgExtend.resetListPointer();
        DmMsgSend.BufferNode node = msgExtend.getFirstNode();
        while (node != null) {
            if (node.getBufferLen() != 0) {
                this.dmOutput.write(node.buffer, 0, node.getBufferLen());
                this.dmOutput.flush();
            }
            if (node == msgExtend.getBufferList().getTail()) break;
            node = msgExtend.getNextNode();
        }
    }

    public final int getNetPacketSize() {
        return this.netPacketSize;
    }

    public AuthInfo getAuthInfo(String kerberosUser, String loginPath, int authType) throws SQLException {
        if (this.m_kerberosAuth != null) {
            this.m_kerberosAuth = null;
        }
        Auth auth = null;
        try {
            if (loginPath != null && loginPath.length() > 0) {
                System.setProperty("java.security.auth.login.config", loginPath);
            }
            if (kerberosUser != null && kerberosUser.length() > 0) {
                System.setProperty("sun.security.krb5.principal", String.valueOf(kerberosUser) + "@DAMENG.ORG");
            }
            auth = new Auth(this.dmConnection.getInetAddress().getCanonicalHostName(), authType);
        }
        catch (UnknownHostException e1) {
            DBError.throwSQLException(6063);
        }
        this.m_kerberosAuth = auth.getAuthInfo();
        return this.m_kerberosAuth;
    }

    public AuthInfo getAuthInfo() {
        return this.m_kerberosAuth;
    }

    public void reset() throws SQLException {
        try {
            if (this.dmConnection != null) {
                this.dmConnection.close();
            }
        }
        catch (IOException ioex) {
            throw new SQLException(ioex.getMessage());
        }
    }

    private Socket createSocket(String hostName, int netPort, int timeOut) throws IOException {
        byte[] addr = IPAddressUtil.textToNumericFormatV4(hostName);
        if (addr == null) {
            addr = IPAddressUtil.textToNumericFormatV6(hostName);
        }
        Socket socket = new Socket();
        InetSocketAddress socketAddress = null;
        if (addr != null) {
            InetAddress address = InetAddress.getByAddress(hostName, addr);
            socketAddress = new InetSocketAddress(address, netPort);
        } else {
            socketAddress = new InetSocketAddress(hostName, netPort);
        }
        socket.connect(socketAddress, timeOut);
        return socket;
    }

    public byte[] getClientPubKey() throws SQLException {
        if (this.clientKeyPair == null) {
            this.clientKeyPair = MsgSecurity.newClientKeyPair();
        }
        return MsgSecurity.bn2Bytes(((DHPublicKey)this.clientKeyPair.getPublic()).getY(), 64);
    }

    public PrivateKey getClientPrivKey() throws SQLException {
        if (this.clientKeyPair == null) {
            this.clientKeyPair = MsgSecurity.newClientKeyPair();
        }
        return this.clientKeyPair.getPrivate();
    }

    public final void genMsgCiphers(int msgCipherType, byte[] tempSessionKey) throws SQLException {
        byte[] sessionKey = null;
        SymmCipherDesc cipherDesc = null;
        if (-1 == msgCipherType) {
            this.encryptCipher = null;
            this.decryptCipher = null;
            return;
        }
        cipherDesc = new SymmCipherDesc(msgCipherType);
        int keySize = cipherDesc.getKeyLength();
        if (256 == cipherDesc.getAlgorithmType()) {
            keySize += 8;
        }
        sessionKey = new byte[keySize];
        System.arraycopy(tempSessionKey, 0, sessionKey, 0, keySize);
        if (256 == cipherDesc.getAlgorithmType()) {
            System.arraycopy(tempSessionKey, 0, sessionKey, keySize - 8, 8);
        }
        try {
            this.encryptCipher = MsgSecurity.newCipher(1, cipherDesc, sessionKey);
            this.decryptCipher = MsgSecurity.newCipher(2, cipherDesc, sessionKey);
        }
        catch (Exception e) {
            this.encryptCipher = null;
            this.decryptCipher = null;
            DBError.throwSQLException(6061);
        }
    }

    protected byte[] symmetricEncrypto(byte[] byteSource, int length, boolean gen_digest) throws SQLException {
        try {
            if (!gen_digest) {
                return this.encryptCipher.doFinal(byteSource, 0, length);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(length + 16);
            baos.write(this.encryptCipher.doFinal(byteSource, 0, length));
            baos.write(this.genMessageDigest(4352, byteSource));
            return baos.toByteArray();
        }
        catch (Exception e) {
            DBError.throwSQLException(e.getMessage());
            return new byte[0];
        }
    }

    private byte[] symmetricDecrypto(byte[] byteSource, int length, boolean gen_digest) throws SQLException {
        byte[] digest = new byte[16];
        byte[] plain_text = null;
        try {
            if (gen_digest) {
                System.arraycopy(byteSource, length - 16, digest, 0, 16);
                plain_text = this.decryptCipher.doFinal(byteSource, 0, length - 16);
                this.checkMessageDigest(4352, plain_text, digest);
            } else {
                plain_text = this.decryptCipher.doFinal(byteSource, 0, length);
            }
            return plain_text;
        }
        catch (Exception e) {
            DBError.throwSQLException(e.getMessage());
            return new byte[0];
        }
    }

    private final byte[] genMessageDigest(int algorithm, byte[] msg_text) throws NoSuchAlgorithmException {
        MessageDigest md = null;
        byte[] msg_digest = null;
        switch (algorithm) {
            case 4352: {
                md = MessageDigest.getInstance("MD5");
                break;
            }
        }
        if (md == null) {
            return null;
        }
        md.reset();
        md.update(msg_text);
        msg_digest = md.digest();
        return msg_digest;
    }

    private final boolean checkMessageDigest(int algorithm, byte[] msg_text, byte[] digest) throws NoSuchAlgorithmException {
        byte[] msg_digest = null;
        msg_digest = this.genMessageDigest(algorithm, msg_text);
        if (digest.length != msg_digest.length) {
            return false;
        }
        int i = 0;
        while (i < digest.length) {
            if (digest[i] != msg_digest[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setMsgEncryptType(int msgEncryptType) {
        this.msgEncryptType = msgEncryptType;
    }

    public int getMsgEncryptType() {
        return this.msgEncryptType;
    }
}

