/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.dbaccess.AuthInfo;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DbPureAccess;
import dm.jdbc.dbaccess.DmMsgRecv;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.driver.DmdbConnection_bs;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.PrivateKey;
import java.sql.SQLException;

public class DbAccess {
    private DbPureAccess m_accessPrimary = null;
    private DbPureAccess m_accessStandby = null;
    private DmdbConnection_bs m_connInner = null;

    public DbAccess(DmdbConnection_bs conn) throws IOException {
        this.m_connInner = conn;
        this.m_accessPrimary = new DbPureAccess(conn);
    }

    public DbPureAccess getAccessPrimary() {
        return this.m_accessPrimary;
    }

    public DbPureAccess getAccessStandby() {
        return this.m_accessStandby;
    }

    public void addStandby() throws IOException {
        this.m_accessStandby = new DbPureAccess(this.m_connInner, this.m_connInner.getStandbyHost(), this.m_connInner.getStandbyPort());
    }

    public DmMsgRecv access(DmMsgSend sendMsg) throws SQLException, IOException {
        int type = 1;
        DmMsgRecv recvMsg = null;
        DmMsgRecv standbyRecvMsg = null;
        int sqlcode = 0;
        if (this.m_connInner.checkConnToStandby()) {
            type = 0;
        }
        try {
            int i = 0;
            while (i < 2) {
                switch (type) {
                    case 1: {
                        recvMsg = this.m_accessPrimary.access(sendMsg);
                        recvMsg.setFromStandby(false);
                        break;
                    }
                    case 0: {
                        standbyRecvMsg = this.m_accessStandby.access(sendMsg);
                        standbyRecvMsg.setFromStandby(true);
                        sqlcode = standbyRecvMsg.res_get_sqlcode();
                        if (sqlcode != -6010 && sqlcode != -6007) break;
                        this.close();
                        DBError.throwSQLException(6001);
                    }
                }
                if (i != 0 || !this.m_connInner.checkHasStandby()) break;
                if (type == 0 && sqlcode < 0) {
                    this.m_connInner.setTransReadonly(false);
                    type = 1;
                } else {
                    short ret_type;
                    short s = ret_type = type == 0 ? standbyRecvMsg.res_execute_get_ret_type() : recvMsg.res_execute_get_ret_type();
                    if (ret_type != 165 && ret_type != 166 && ret_type != 147 && ret_type != 148 && ret_type != 153) break;
                    type = type == 0 ? 1 : 0;
                }
                ++i;
            }
        }
        catch (IOException ioe) {
            if (this.m_connInner.checkHasStandby()) {
                this.close();
                DBError.throwSQLException(6001);
            }
            throw ioe;
        }
        return recvMsg != null ? recvMsg : standbyRecvMsg;
    }

    public DmMsgRecv accessPrimary(DmMsgSend sendMsg) throws SQLException, IOException {
        DmMsgRecv recv = this.m_accessPrimary.access(sendMsg);
        recv.setFromStandby(false);
        return recv;
    }

    public DmMsgRecv accessStandby(DmMsgSend sendMsg) throws SQLException, IOException {
        if (this.m_accessStandby == null) {
            return null;
        }
        DmMsgRecv recv = this.m_accessStandby.access(sendMsg);
        recv.setFromStandby(true);
        return recv;
    }

    public void setCompress(int comprMsg) {
        this.m_accessPrimary.setCompress(comprMsg);
        if (this.m_accessStandby != null) {
            this.m_accessStandby.setCompress(comprMsg);
        }
    }

    public void tryEnableSSL(boolean useSSLSocket) throws IOException, SQLException {
        this.m_accessPrimary.tryEnableSSL(useSSLSocket);
        if (this.m_accessStandby != null) {
            this.m_accessStandby.tryEnableSSL(useSSLSocket);
        }
    }

    public AuthInfo getAuthInfo() {
        return this.m_accessPrimary.getAuthInfo();
    }

    public void reset() throws SQLException {
        this.m_accessPrimary.reset();
        if (this.m_accessStandby != null) {
            this.m_accessStandby.reset();
        }
    }

    public void close() {
        this.m_accessPrimary.close();
        if (this.m_accessStandby != null) {
            this.m_accessStandby.close();
        }
    }

    public AuthInfo getAuthInfo(String kerberosUser, String loginPath, int kerberosAuth) throws SQLException {
        return this.m_accessPrimary.getAuthInfo(kerberosUser, loginPath, kerberosAuth);
    }

    public int getNetPacketSize() {
        return this.m_accessPrimary.getNetPacketSize();
    }

    public void setSoTimeout(int socketTimeout) throws SocketException {
        this.m_accessPrimary.getSocket().setSoTimeout(socketTimeout);
        if (this.m_accessStandby != null) {
            this.m_accessStandby.getSocket().setSoTimeout(socketTimeout);
        }
    }

    public void setSocketInfo(String hostName, String portNumber) throws UnknownHostException, IOException {
        this.m_accessPrimary.setSocketInfo(hostName, portNumber);
    }

    public byte[] getClientPubKey(boolean isPrimary) throws SQLException {
        if (isPrimary) {
            return this.m_accessPrimary.getClientPubKey();
        }
        return this.m_accessStandby.getClientPubKey();
    }

    public PrivateKey getClientPrivKey(boolean isPrimary) throws SQLException {
        if (isPrimary) {
            return this.m_accessPrimary.getClientPrivKey();
        }
        return this.m_accessStandby.getClientPrivKey();
    }

    public final void genMsgCiphers(boolean isPrimary, int msgCipherType, byte[] tempSessionKey) throws SQLException {
        if (isPrimary) {
            this.m_accessPrimary.genMsgCiphers(msgCipherType, tempSessionKey);
        } else {
            this.m_accessStandby.genMsgCiphers(msgCipherType, tempSessionKey);
        }
    }

    protected byte[] symmetricEncrypto(boolean isPrimary, byte[] byteSource, int length, boolean gen_digest) throws SQLException {
        if (isPrimary) {
            return this.m_accessPrimary.symmetricEncrypto(byteSource, length, gen_digest);
        }
        return this.m_accessStandby.symmetricEncrypto(byteSource, length, gen_digest);
    }

    public void setMsgEncryptType(int msgEncryptType, boolean toPrimary) {
        if (toPrimary) {
            this.m_accessPrimary.setMsgEncryptType(msgEncryptType);
        } else {
            this.m_accessStandby.setMsgEncryptType(msgEncryptType);
        }
    }
}

