/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion;

import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.DTypeInfo;
import dm.jdbc.desc.LobDesc;
import dm.jdbc.driver.DmdbCSI;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbLobLocator;
import dm.jdbc.driver.DmdbNumeric;
import dm.sql.DmdbDateTime;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbTime;
import dm.sql.DmdbTimeZone;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class Convertion {
    public static final byte[] booleanToByteArray(boolean b) {
        byte[] b_array = new byte[]{(byte)(b ? 1 : 0)};
        return b_array;
    }

    public static final byte[] byteToByteArray(byte b) {
        byte[] b_array = new byte[]{b};
        return b_array;
    }

    public static final byte[] doubleToByteArray(double d) {
        long l = Double.doubleToLongBits(d);
        return Convertion.longToByteArray(l);
    }

    public static final byte[] floatToByteArray(float f) {
        int i = Float.floatToIntBits(f);
        return Convertion.IntToByteArray(i);
    }

    public static final byte[] shortToByteArray(int i) {
        byte[] b = new byte[2];
        int position = 0;
        b[position++] = (byte)(i & 0xFF);
        b[position] = (byte)(i >>> 8);
        return b;
    }

    public static final byte[] IntToByteArray(int i) {
        byte[] b = new byte[4];
        int position = 0;
        b[position++] = (byte)(i & 0xFF);
        b[position++] = (byte)(i >>> 8 & 0xFF);
        b[position++] = (byte)(i >>> 16 & 0xFF);
        b[position] = (byte)(i >>> 24 & 0xFF);
        return b;
    }

    public static final byte[] longToByteArray(long i) {
        byte[] b = new byte[8];
        int position = 0;
        b[position++] = (byte)(i & 0xFFL);
        b[position++] = (byte)(i >>> 8);
        b[position++] = (byte)(i >>> 16);
        b[position++] = (byte)(i >>> 24);
        b[position++] = (byte)(i >>> 32);
        b[position++] = (byte)(i >>> 40);
        b[position++] = (byte)(i >>> 48);
        b[position++] = (byte)(i >>> 56);
        return b;
    }

    public static final byte[] BigDecimalToByteArray(String x, int prec, int scale) throws SQLException {
        DmdbNumeric num = new DmdbNumeric();
        byte[] inValueBytes = num.StrToDec(x, prec, scale);
        return inValueBytes;
    }

    public static final byte[] DateToByteArray(DmdbDateTime dt) {
        return DmdbDateTime.dateEncodeFast(dt.getByteArrayValue());
    }

    public static final byte[] TimeToByteArray(DmdbTime t) throws SQLException {
        return DmdbTime.TimeEncodeFast(t.getByteArrayValue());
    }

    public static final byte[] TimeStampToByteArray(DmdbDateTime dt, int dType, int scale, short dbTz, short ltz) throws SQLException {
        byte[] ret = dt.getByteArrayValue();
        return DmdbDateTime.dmdtEncodeFast(ret);
    }

    public static final byte[] InterDtToByteArray(DmdbIntervalDT dt) throws SQLException {
        return dt.convertStrToBs(dt.getPrecForSvr());
    }

    public static final byte[] InterDtToByteArray(DmdbIntervalDT dt, int scale) throws SQLException {
        return dt.convertStrToBs(scale);
    }

    public static final byte[] InterYMToByteArray(DmdbIntervalYM ym) {
        return ym.getByteArrayValue();
    }

    public static final byte[] InterYMToByteArray(DmdbIntervalYM ym, int prec) throws SQLException {
        return ym.convertStrToBs(prec);
    }

    public static final byte[] TimeZoneToByteArray(DmdbTimeZone tz) throws SQLException {
        return DmdbTimeZone.timeZoneEncodeFast(tz.getValueBytes());
    }

    public static final byte[] DateTimeZoneToByteArray(DmdbTimeZone tz) throws SQLException {
        return DmdbTimeZone.datetimeZoneEncodeFast(tz.getValueBytes());
    }

    public static final short twoByteToShort(byte[] byte1) {
        long n = 0L;
        int p = 2;
        int i = 0;
        while (i < 2) {
            long b = 0xFF & byte1[--p];
            n = b | n << 8;
            ++i;
        }
        return (short)(0xFFFFFFFFFFFFFFFFL & n);
    }

    public static final int fourByteToInt(byte[] byte1) {
        if (byte1.length == 2) {
            return Convertion.twoByteToShort(byte1);
        }
        long n = 0L;
        int p = 4;
        int i = 0;
        while (i < 4) {
            long b = 0xFF & byte1[--p];
            n = b | n << 8;
            ++i;
        }
        return (int)(0xFFFFFFFFFFFFFFFFL & n);
    }

    public static final int bytesToInt(byte[] byte1) throws SQLException {
        if (byte1.length > 4) {
            int j = 0;
            while (j < byte1.length - 4 - 1) {
                if (byte1[j] != 0) {
                    DBError.throwSQLException(6007);
                }
                ++j;
            }
        }
        int n = 0;
        int b = 0;
        int len = byte1.length > 4 ? 4 : byte1.length;
        int j = 0;
        while (j < len) {
            b = 0xFF & byte1[j];
            n = b | n << 8;
            ++j;
        }
        return n;
    }

    public static final long eightByteToLong(byte[] byte1) {
        long n = 0L;
        int p = 8;
        int i = 0;
        while (i < 8) {
            long b = 0xFF & byte1[--p];
            n = b | n << 8;
            ++i;
        }
        return n;
    }

    public static final long bytesToLong(byte[] byte1) throws SQLException {
        if (byte1.length > 8) {
            int j = 0;
            while (j < byte1.length - 8 - 1) {
                if (byte1[j] != 0) {
                    DBError.throwSQLException(6007);
                }
                ++j;
            }
        }
        long n = 0L;
        long b = 0L;
        int len = byte1.length > 8 ? 8 : byte1.length;
        int j = 0;
        while (j < len) {
            b = 0xFF & byte1[j];
            n = b | n << 8;
            ++j;
        }
        return n;
    }

    public static final BigDecimal bytesToBigDecimal(byte[] val, int scale, int prec) throws SQLException {
        DmdbNumeric num = new DmdbNumeric();
        String s = num.decToString(val);
        BigDecimal dec = new BigDecimal(s);
        if (scale != 0 || prec != 0) {
            dec = dec.setScale(scale, 4);
        }
        return dec;
    }

    public static final boolean bytesToBoolean(byte[] val) {
        return val[0] != 0;
    }

    public static final Date bytesToDate(byte[] val, int scale, short dbTz, short lTz) throws SQLException {
        DmdbDateTime dt = new DmdbDateTime(val, 14, scale, dbTz, lTz);
        return dt.getDate();
    }

    public static final Time bytesToTime(byte[] val, int scale, short dbTz, short lTz) throws SQLException {
        DmdbDateTime dt = new DmdbDateTime(val, 15, scale, dbTz, lTz);
        return dt.getTime();
    }

    public static final Timestamp bytesToTimeStamp(byte[] val, int scale, short dbTz, short lTz) throws SQLException {
        DmdbDateTime dt = new DmdbDateTime(val, 16, scale, dbTz, lTz);
        return dt.getTimestamp();
    }

    public static final DmdbIntervalDT bytesToInterDT(byte[] val, int scale) {
        int secPrec = scale & 0xF;
        int loadPrec = scale >> 4 & 0xF;
        return new DmdbIntervalDT(val, loadPrec, secPrec);
    }

    public static final DmdbIntervalYM bytesToInterYM(byte[] val, int scale) {
        int loadPrec = scale >> 4 & 0xF;
        return new DmdbIntervalYM(val, loadPrec);
    }

    public static final DmdbTimeZone bytesToTimeZone(byte[] val, int scale) {
        return new DmdbTimeZone(val, scale, 1);
    }

    public static final DmdbTimeZone bytesToDateTimeZone(byte[] val, int scale) {
        return new DmdbTimeZone(val, scale, 2);
    }

    public static final float bytesToFloat(byte[] val) {
        return Float.intBitsToFloat(Convertion.fourByteToInt(val));
    }

    public static final double bytesToDouble(byte[] val) {
        return Double.longBitsToDouble(Convertion.eightByteToLong(val));
    }

    public static final byte[] setRowid(byte[] locator) {
        byte[] rowid_high = new byte[4];
        byte[] rowid_low = new byte[4];
        byte[] tmplocator = (byte[])locator.clone();
        int i = 0;
        while (i < 4) {
            rowid_low[i] = locator[9 - i];
            ++i;
        }
        i = 0;
        while (i < 4) {
            rowid_high[i] = locator[13 - i];
            ++i;
        }
        i = 0;
        while (i < 4) {
            tmplocator[6 + i] = rowid_low[i];
            ++i;
        }
        i = 0;
        while (i < 4) {
            tmplocator[10 + i] = rowid_high[i];
            ++i;
        }
        return tmplocator;
    }

    public static final byte[] truncate_rowid(byte[] rowid) {
        byte[] new_rowid = new byte[5];
        System.arraycopy(rowid, 4, new_rowid, 0, 4);
        System.arraycopy(rowid, 0, new_rowid, 4, 1);
        return new_rowid;
    }

    public static final void setByte(byte[] buf, int off, byte val) {
        buf[off] = val;
    }

    public static final void setBytes(byte[] buf, int offset, byte[] in) {
        System.arraycopy(in, 0, buf, offset, in.length);
    }

    public static final void setShort(byte[] buf, int off, short val) {
        buf[off] = (byte)(val & 0xFF);
        buf[off + 1] = (byte)(val >> 8 & 0xFF);
    }

    public static final void setInt(byte[] buf, int off, int val) {
        buf[off++] = (byte)(val & 0xFF);
        buf[off++] = (byte)((val >>= 8) & 0xFF);
        buf[off++] = (byte)((val >>= 8) & 0xFF);
        buf[off++] = (byte)((val >>= 8) & 0xFF);
        val >>= 8;
    }

    public static final void setLong(byte[] buf, int off, long val) {
        buf[off++] = (byte)(val & 0xFFL);
        buf[off++] = (byte)((val >>= 8) & 0xFFL);
        buf[off++] = (byte)((val >>= 8) & 0xFFL);
        buf[off++] = (byte)((val >>= 8) & 0xFFL);
        buf[off++] = (byte)((val >>= 8) & 0xFFL);
        buf[off++] = (byte)((val >>= 8) & 0xFFL);
        buf[off++] = (byte)((val >>= 8) & 0xFFL);
        buf[off++] = (byte)((val >>= 8) & 0xFFL);
        val >>= 8;
    }

    public static final byte getByte(byte[] buf, int off) {
        return buf[off];
    }

    public static final short getShort(byte[] buf, int off) {
        byte low = buf[off];
        byte high = buf[off + 1];
        return (short)(high << 8 | 0xFF & low);
    }

    public static final int getUShort(byte[] buf, int off) {
        int b = 0xFF & buf[off];
        int n = 0xFF & buf[off + 1];
        n = b | n << 8;
        return 0xFFFF & n;
    }

    public static final int getInt(byte[] buf, int off) {
        short low = Convertion.getShort(buf, off);
        short high = Convertion.getShort(buf, off + 2);
        return high << 16 | 0xFFFF & low;
    }

    public static final long getUInt(byte[] buffer, int offset) {
        int size = 4;
        int p = offset + size;
        long n = 0xFF & buffer[--p];
        long b = 0xFF & buffer[--p];
        n = b | n << 8;
        b = 0xFF & buffer[--p];
        n = b | n << 8;
        b = 0xFF & buffer[--p];
        n = b | n << 8;
        return 0xFFFFFFFFFFFFFFFFL & n;
    }

    public static final long getLong(byte[] buf, int off) {
        long low = Convertion.getInt(buf, off);
        long high = Convertion.getInt(buf, off + 4);
        return high << 32 | 0xFFFFFFFFFFFFFFFFL & low;
    }

    public static final byte[] getBytes(String str, String serverEncoding) throws SQLException {
        byte[] buf = null;
        if (serverEncoding != null) {
            try {
                buf = str.getBytes(serverEncoding);
            }
            catch (UnsupportedEncodingException ex) {
                System.out.println("encoding methods not supported!");
                throw new SQLException(ex.getMessage());
            }
        } else {
            buf = str.getBytes();
        }
        return buf;
    }

    public static final byte[] getBytes(String str, int offset, int len, String charsetName) {
        byte[] buf = null;
        if (str == null) {
            return buf;
        }
        if (charsetName != null) {
            try {
                buf = str.substring(offset, offset + len).getBytes(charsetName);
            }
            catch (UnsupportedEncodingException ex) {
                System.out.println("encoding methods not supported!");
            }
        } else {
            buf = str.substring(offset, offset + len).getBytes();
        }
        return buf;
    }

    public static final String getString(byte[] buffer, int offset, int bytelen) {
        if (buffer == null) {
            return null;
        }
        return new String(buffer, offset, bytelen);
    }

    public static final String getString(byte[] buffer, int offset, int byteLen, String charsetName) {
        String str = null;
        if (buffer == null) {
            return str;
        }
        if (charsetName == null) {
            str = new String(buffer, offset, byteLen);
        } else {
            try {
                str = new String(buffer, offset, byteLen, charsetName);
            }
            catch (UnsupportedEncodingException ex) {
                System.out.println("encoding methods not supported!");
            }
        }
        return str;
    }

    public static final void setString(byte[] buffer, String str, int offset) {
        byte[] buf = str.getBytes();
        int len = buf.length;
        int i = 0;
        while (i < len) {
            buffer[offset++] = buf[i];
            ++i;
        }
    }

    public static final byte[] setStringWithNTS(byte[] buffer, int offset, byte[] buf) {
        int len = buf.length;
        if (len + offset >= buffer.length) {
            byte[] buf2 = new byte[len + offset + 1024];
            System.arraycopy(buffer, 0, buf2, 0, buffer.length);
            buffer = buf2;
        }
        System.arraycopy(buf, 0, buffer, offset, len);
        buffer[offset + len] = 0;
        return buffer;
    }

    public static final byte[] getBytesFrmLob(byte[] lob, DTypeInfo dType, LobDesc lobDesc, int stmtHandle, DmdbConnection_bs conn) throws SQLException {
        int nblob_inrow_hdr_size;
        int len = lob.length;
        int n = nblob_inrow_hdr_size = conn.getNewLobFlag() ? 43 : 13;
        if (len < nblob_inrow_hdr_size) {
            DBError.throwSQLException(Const.res.getString("error.Lob.length"));
        }
        byte[] buf = null;
        if (lob[0] == 1) {
            byte[] s1 = new byte[4];
            System.arraycopy(lob, 9, s1, 0, 4);
            len = Math.min(len - nblob_inrow_hdr_size, Convertion.fourByteToInt(s1));
            buf = new byte[len];
            System.arraycopy(lob, nblob_inrow_hdr_size, buf, 0, len);
            return buf;
        }
        if (lob[0] == 2) {
            byte flag = 0;
            flag = dType.getDType() == 12 ? (byte)0 : 1;
            DmdbLobLocator lobLocator = new DmdbLobLocator(lob, flag, lobDesc, conn.getNewLobFlag());
            return DmdbCSI.getBlobData(stmtHandle, conn, lobLocator);
        }
        DBError.throwSQLException(6033);
        return null;
    }

    public static final byte[] getBytes(byte[] buffer, int offset, int len) {
        if (buffer == null) {
            return null;
        }
        byte[] buf = new byte[len];
        System.arraycopy(buffer, offset, buf, 0, len);
        return buf;
    }

    public static final byte[] getBytes(byte[] buffer, int offset, int len, String charsetName, String destCharsetName) {
        if (buffer == null) {
            return null;
        }
        byte[] buf = new byte[len];
        System.arraycopy(buffer, offset, buf, 0, len);
        if (charsetName != null && destCharsetName != null) {
            try {
                String str = new String(buf, charsetName);
                buf = str.getBytes(destCharsetName);
            }
            catch (UnsupportedEncodingException ex) {
                System.out.println("encoding methods not supported!");
            }
        }
        return buf;
    }

    public static final byte[] getBytes(char[] buffer, int offset, int len, String charsetName, String destCharsetName) {
        if (buffer == null) {
            return null;
        }
        String str = new String(buffer, offset, len);
        return Convertion.getBytes(str, offset, len, charsetName, destCharsetName);
    }

    public static final byte[] getBytes(String str, int offset, int len, String charsetName, String destCharsetName) {
        byte[] buf = null;
        if (str == null) {
            return null;
        }
        if (destCharsetName != null) {
            try {
                buf = str.getBytes(destCharsetName);
            }
            catch (UnsupportedEncodingException ex) {
                System.out.println("encoding methods not supported!");
            }
        } else {
            buf = str.getBytes();
        }
        return buf;
    }

    public static final String bytesToHexString(byte[] bs) {
        if (bs == null) {
            return null;
        }
        if (bs.length == 0) {
            return "";
        }
        String hexDigits = "0123456789ABCDEF";
        String ret = "";
        int i = 0;
        while (i < bs.length) {
            int high = 0xF & bs[i] >> 4;
            int low = 0xF & bs[i];
            ret = String.valueOf(ret) + hexDigits.charAt(high);
            ret = String.valueOf(ret) + hexDigits.charAt(low);
            ++i;
        }
        return ret;
    }

    public static final String intToHex(int num) {
        return Convertion.intToHex(num, true);
    }

    private static final String intToHex(int num, boolean prefix) {
        String ret = "";
        if (prefix) {
            ret = String.valueOf(ret) + "0x";
        }
        int i = 0;
        while (i < 2) {
            int a;
            if (i == 0) {
                a = num & 0xF0;
                a >>= 4;
            } else {
                a = num & 0xF;
            }
            if (a < 10) {
                ret = String.valueOf(ret) + a;
            } else {
                switch (a) {
                    case 10: {
                        ret = String.valueOf(ret) + "A";
                        break;
                    }
                    case 11: {
                        ret = String.valueOf(ret) + "B";
                        break;
                    }
                    case 12: {
                        ret = String.valueOf(ret) + "C";
                        break;
                    }
                    case 13: {
                        ret = String.valueOf(ret) + "D";
                        break;
                    }
                    case 14: {
                        ret = String.valueOf(ret) + "E";
                        break;
                    }
                    case 15: {
                        ret = String.valueOf(ret) + "F";
                        break;
                    }
                    default: {
                        return "";
                    }
                }
            }
            ++i;
        }
        return ret;
    }

    public static final String rowIdToHex(int high, int low) {
        byte[] low_tmp = Convertion.IntToByteArray(low);
        String tmp = "";
        int i = 0;
        while (i < 4) {
            tmp = String.valueOf(tmp) + Convertion.intToHex(low_tmp[i], false);
            ++i;
        }
        tmp = String.valueOf(tmp) + Convertion.intToHex(high, false);
        return tmp;
    }

    public static final byte[] intToBinary(int x, int prec) {
        byte[] b = Convertion.IntToByteArray(x);
        byte[] c = new byte[prec];
        int position = 3;
        b[position--] = (byte)(x & 0xFF);
        b[position--] = (byte)(x >>> 8);
        b[position--] = (byte)(x >>> 16);
        b[position--] = (byte)(x >>> 24);
        if (prec <= b.length) {
            System.arraycopy(b, b.length - prec, c, 0, prec);
        } else {
            System.arraycopy(b, 0, c, prec - b.length, b.length);
        }
        return c;
    }

    public static final byte[] longToBinary(long x, int prec) {
        byte[] b = new byte[8];
        byte[] c = new byte[prec];
        int position = 7;
        b[position--] = (byte)(x & 0xFFL);
        b[position--] = (byte)(x >>> 8);
        b[position--] = (byte)(x >>> 16);
        b[position--] = (byte)(x >>> 24);
        b[position--] = (byte)(x >>> 32);
        b[position--] = (byte)(x >>> 40);
        b[position--] = (byte)(x >>> 48);
        b[position--] = (byte)(x >>> 56);
        if (prec <= 8) {
            System.arraycopy(b, 8 - prec, c, 0, prec);
        } else {
            System.arraycopy(b, 0, c, prec - b.length, b.length);
        }
        return c;
    }

    private static int findHexNum(char c) throws SQLException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        DBError.throwSQLException(6068);
        return 0;
    }

    private static byte mkByteByNum(int left, int right) {
        byte ret = (byte)(left & 0xF);
        ret = (byte)(ret << 4 | right & 0xF);
        return ret;
    }

    public static final byte[] stringToBinary(String str, int prec) throws SQLException {
        if (str == null) {
            return new byte[0];
        }
        if ((str = str.trim()).length() == 0) {
            return new byte[0];
        }
        int len = str.length();
        int destLen = len / 2;
        if (len % 2 != 0) {
            ++destLen;
            str = "0" + str;
        }
        byte[] retBs = new byte[destLen];
        int i = destLen - 1;
        while (i >= 0) {
            int left = Convertion.findHexNum(str.charAt(i * 2));
            int right = Convertion.findHexNum(str.charAt(i * 2 + 1));
            retBs[i] = Convertion.mkByteByNum(left, right);
            --i;
        }
        return retBs;
    }

    static final byte getCharByNumVal(int val) throws SQLException {
        if (val >= 0 && val <= 9) {
            return (byte)(val + 48);
        }
        if (val >= 10 && val <= 15) {
            return (byte)(val + 65 - 10);
        }
        DBError.throwSQLException(6068);
        return 0;
    }

    static final byte[] binaryToChar(byte bt) throws SQLException {
        byte[] ret = new byte[]{Convertion.getCharByNumVal(bt >> 4 & 0xF), Convertion.getCharByNumVal(bt & 0xF)};
        return ret;
    }

    public static final byte[] binaryArrToString(byte[] bsArr, int prec, int dType) throws SQLException {
        if (bsArr == null || bsArr.length == 0) {
            return null;
        }
        int realLen = bsArr.length * 2;
        byte[] bsRet = new byte[realLen];
        byte[] bsTemp = null;
        int i = 0;
        while (i < bsArr.length) {
            bsTemp = Convertion.binaryToChar(bsArr[i]);
            bsRet[i * 2] = bsTemp[0];
            bsRet[i * 2 + 1] = bsTemp[1];
            ++i;
        }
        return bsRet;
    }

    public static final byte[] binaryArrToClob_bin(byte[] bsArr, int offset, int len) throws SQLException {
        if (bsArr == null || bsArr.length == 0) {
            return null;
        }
        int realLen = len * 2;
        byte[] bsRet = new byte[realLen];
        byte[] bsTemp = null;
        int i = 0;
        while (i < len) {
            bsTemp = Convertion.binaryToChar(bsArr[i + offset]);
            bsRet[i * 2] = bsTemp[0];
            bsRet[i * 2 + 1] = bsTemp[1];
            ++i;
        }
        return bsRet;
    }

    public static byte[] String_char_2CType(String str, int prec, int cType, String serverEncoding) throws SQLException {
        if (str == null) {
            return null;
        }
        byte[] bs = Convertion.getBytes(str, serverEncoding);
        return bs;
    }

    public static byte[] String_varchar_2CType(String str, int prec, int dType, String serverEncoding) throws SQLException {
        byte[] inValueBytes = Convertion.getBytes(str, serverEncoding);
        return inValueBytes;
    }

    public static byte[] String_javaObj_2CType(String x, int dType, int scale, int prec, short ltz) throws SQLException {
        byte[] ret = null;
        if ((x = x.trim()).length() > 0) {
            int secPrec = scale & 0xF;
            int loadPrec = scale >> 4 & 0xF;
            switch (dType) {
                case 21: {
                    DmdbIntervalDT dt = new DmdbIntervalDT(x, loadPrec, secPrec);
                    ret = Convertion.InterDtToByteArray(dt, scale);
                    break;
                }
                case 20: {
                    DmdbIntervalYM ym = new DmdbIntervalYM(x, loadPrec);
                    ret = Convertion.InterYMToByteArray(ym, scale);
                    break;
                }
                case 22: 
                case 23: {
                    DmdbTimeZone tz = null;
                    if (dType == 22) {
                        tz = new DmdbTimeZone(x, 1, ltz);
                        ret = Convertion.TimeZoneToByteArray(tz);
                        break;
                    }
                    tz = new DmdbTimeZone(x, 2, ltz);
                    ret = Convertion.DateTimeZoneToByteArray(tz);
                    break;
                }
                default: {
                    DBError.throwSQLException(6014);
                    break;
                }
            }
        } else {
            ret = null;
        }
        return ret;
    }
}

