/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.web.service.admin;

import com.cpi.framework.web.dao.admin.CodeGenerateDao;
import com.cpi.framework.web.entity.admin.CodeGenerateBean;
import com.cpi.framework.web.entity.admin.CodeGenerateParam;
import com.cpi.framework.web.entity.admin.FormField;
import com.cpi.framework.web.entity.admin.GridField;
import com.cpi.framework.web.entity.admin.OriginalColumns;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CodeGenerateService {
    @Autowired
    private CodeGenerateDao codeGenerateDao;

    public boolean checkTabExists(String tableName) {
        return Long.parseLong(this.codeGenerateDao.checkTabExists(tableName.toUpperCase()).toString()) > 0L;
    }

    public void gernerateToFile(CodeGenerateBean obj, Object contextPath, List<GridField> gridFieldList, List<FormField> formFieldList, List<GridField> queryFieldList) throws IOException, ServletException {
        FileWriter out;
        File file;
        Template t;
        Configuration cfg = new Configuration();
        cfg.setServletContextForTemplateLoading(contextPath, "static/templete/");
        CodeGenerateParam param = new CodeGenerateParam();
        param.setBussiPackage("com.cpi");
        param.setTableName(obj.getTableName().toUpperCase());
        param.setTableComment(this.codeGenerateDao.getTableComment(obj.getTableName().toUpperCase()));
        param.setEntityPackage(obj.getPackgeName());
        param.setEntityName(this.tableToEntity(obj.getTableName().toLowerCase()));
        param.setPk(this.codeGenerateDao.getPK(obj.getTableName().toUpperCase()));
        param.setPkName(this.codeGenerateDao.fieldToLower(param.getPk()));
        param.setFtl_description(param.getTableName() + "-" + param.getTableComment());
        param.setFtl_create_time(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        List<OriginalColumns> columList = this.codeGenerateDao.findTableInfo(obj.getTableName().toUpperCase());
        param.setOriginalColumns(columList);
        param.setGridType(obj.getGridType());
        param.setLayoutType(obj.getLayoutType());
        if (obj.getHasEntity() != null && obj.getHasEntity().booleanValue()) {
            t = cfg.getTemplate("entityTemplate.ftl");
            file = this.newFile(obj, "/java/com/cpi/entity/", param.getEntityName() + ".java");
            out = new FileWriter(file);
            try {
                t.process((Object)param, (Writer)out);
            }
            catch (TemplateException e) {
                throw new ServletException("\u5904\u7406entityTemplate\u6a21\u7248\u4e2d\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            }
        }
        if (obj.getHasDao() != null && obj.getHasDao().booleanValue()) {
            t = cfg.getTemplate("daoTemplate.ftl");
            file = this.newFile(obj, "/java/com/cpi/dao/jpa/framework/", param.getEntityName() + "Dao.java");
            out = new FileWriter(file);
            try {
                t.process((Object)param, (Writer)out);
            }
            catch (TemplateException e) {
                throw new ServletException("\u5904\u7406daoTemplate\u6a21\u7248\u4e2d\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            }
        }
        if (obj.getHasService() != null && obj.getHasService().booleanValue()) {
            param.setQueryFieldList(queryFieldList);
            param.setGridFieldList(gridFieldList);
            t = cfg.getTemplate("serviceTemplate.ftl");
            file = this.newFile(obj, "/java/com/cpi/service/", param.getEntityName() + "Service.java");
            out = new FileWriter(file);
            try {
                t.process((Object)param, (Writer)out);
            }
            catch (TemplateException e) {
                throw new ServletException("\u5904\u7406serviceTemplate\u6a21\u7248\u4e2d\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            }
        }
        if (obj.getHasController() != null && obj.getHasController().booleanValue()) {
            param.setQueryFieldList(queryFieldList);
            t = cfg.getTemplate("controllerTemplate.ftl");
            file = this.newFile(obj, "/java/com/cpi/web/controller/", param.getEntityName() + "Controller.java");
            out = new FileWriter(file);
            try {
                t.process((Object)param, (Writer)out);
            }
            catch (TemplateException e) {
                throw new ServletException("\u5904\u7406controllerTemplate\u6a21\u7248\u4e2d\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            }
        }
        if (!obj.getGridType().equals("")) {
            param.setFormFieldList(formFieldList);
            param.setGridFieldList(gridFieldList);
            param.setQueryFieldList(queryFieldList);
            t = null;
            if (obj.getGridType().equals("grid")) {
                t = cfg.getTemplate("gridTemplate.ftl");
            } else if (obj.getGridType().equals("editorGrid")) {
                t = cfg.getTemplate("editorGridTemplate.ftl");
            }
            file = this.newFile(obj, "/webapp/static/js/", param.getEntityName().substring(0, 1).toLowerCase() + param.getEntityName().substring(1) + ".js");
            out = new FileWriter(file);
            try {
                t.process((Object)param, (Writer)out);
            }
            catch (TemplateException e) {
                throw new ServletException("\u5904\u7406gridTemplate\u6a21\u7248\u4e2d\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            }
        }
    }

    private String tableToEntity(String tableName) {
        String[] strArr = tableName.toLowerCase().split("_");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strArr.length; ++i) {
            sb.append(Character.toUpperCase(strArr[i].charAt(0)));
            sb.append(strArr[i].substring(1));
        }
        return sb.toString();
    }

    private File newFile(CodeGenerateBean obj, String filePath, String fileType) throws IOException {
        String fileName;
        File file;
        String dir = obj.getPath() + filePath + obj.getPackgeName();
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        if (!(file = new File(fileName = dir + "/" + fileType)).exists()) {
            file.createNewFile();
        }
        return file;
    }

    public List<OriginalColumns> queryTableField(String tabName) {
        return this.codeGenerateDao.findTableInfo(tabName);
    }
}

