/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.service.jpa;

import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.transaction.annotation.Transactional;

@Transactional(value="jpatm")
public abstract class BaseService<M, ID extends Serializable> {
    protected JpaRepository<M, ID> jpaRepository;
    @PersistenceContext
    protected EntityManager entityManager;

    @Autowired
    public void setBaseRepository(JpaRepository<M, ID> jpaRepository) {
        this.jpaRepository = jpaRepository;
    }

    protected abstract JpaRepository<M, ID> getRepository();

    public M save(M m) {
        return (M)this.jpaRepository.save(m);
    }

    public M saveAndFlush(M m) {
        m = this.save(m);
        this.jpaRepository.flush();
        return m;
    }

    public M update(M m) {
        return (M)this.jpaRepository.save(m);
    }

    public void delete(ID id) {
        this.jpaRepository.delete(id);
    }

    public void delete(M m) {
        this.jpaRepository.delete(m);
    }

    @Transactional(value="jpatm", readOnly=true)
    public M findOne(ID id) {
        return (M)this.jpaRepository.findOne(id);
    }

    @Transactional(value="jpatm", readOnly=true)
    public boolean exists(ID id) {
        return this.jpaRepository.exists(id);
    }

    @Transactional(value="jpatm", readOnly=true)
    public long count() {
        return this.jpaRepository.count();
    }

    @Transactional(value="jpatm", readOnly=true)
    public List<M> findAll() {
        return this.jpaRepository.findAll();
    }

    @Transactional(value="jpatm", readOnly=true)
    public List<M> findAll(Sort sort) {
        return this.jpaRepository.findAll(sort);
    }

    @Transactional(value="jpatm", readOnly=true)
    public Page<M> findAll(Pageable pageable) {
        return this.jpaRepository.findAll(pageable);
    }
}

