/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.modules.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class DateUtils {
    private static final String[] parsePatterns = new String[]{"yyyy/MM/dd", "yyyy-MM-dd", "yyyy-M-dd", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd HH:mm:ss.SSS"};

    public static boolean isValidDate(String date) {
        if (date == null || date.length() < 8) {
            return false;
        }
        try {
            String[] format;
            boolean result = false;
            char dateSpace = date.charAt(4);
            if (dateSpace == '-' || dateSpace == '/') {
                format = new String[4];
                String strDateSpace = Character.toString(dateSpace);
                format[0] = "yyyy" + strDateSpace + "MM" + strDateSpace + "dd";
                format[1] = "yyyy" + strDateSpace + "MM" + strDateSpace + "d";
                format[2] = "yyyy" + strDateSpace + "M" + strDateSpace + "dd";
                format[3] = "yyyy" + strDateSpace + "M" + strDateSpace + "d";
            } else {
                format = new String[]{"yyyyMMdd"};
            }
            for (int i = 0; i < format.length; ++i) {
                String aFormat = format[i];
                SimpleDateFormat formatter = new SimpleDateFormat(aFormat);
                formatter.setLenient(false);
                String tmp = formatter.format(formatter.parse(date));
                if (!date.equals(tmp)) continue;
                result = true;
                break;
            }
            return result;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidTime(String date) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            formatter.setLenient(false);
            formatter.parse(date);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static Date strToDate(String date) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        formatter.setLenient(false);
        return formatter.parse(date);
    }

    public static Date strToTime(String date) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        formatter.setLenient(false);
        return formatter.parse(date);
    }

    public static Date strToTimeH(String date) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH");
        formatter.setLenient(false);
        return formatter.parse(date);
    }

    public static String getStringDate() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static String dateToStr(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(date);
    }

    public static String timeToStr(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(date);
    }

    public static String getNow() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date Now = new Date();
        return formatter.format(Now);
    }

    public static String getDate() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date Now = new Date();
        return formatter.format(Now);
    }

    public static String getTime() {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        Date Now = new Date();
        return formatter.format(Now);
    }

    public static int getYear() {
        Date Now = new Date();
        return DateUtils.getYear(Now);
    }

    public static int getYear(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy");
        return Integer.parseInt(formatter.format(date));
    }

    public static int getMonth() {
        Date Now = new Date();
        return DateUtils.getMonth(Now);
    }

    public static int getMonth(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("M");
        return Integer.parseInt(formatter.format(date));
    }

    public static String getMonthFirstDay(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-01");
        return formatter.format(date);
    }

    public static String getMonthMaxDay(Date date) {
        Calendar cal = Calendar.getInstance();
        int maxDay = cal.getActualMaximum(5);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-" + maxDay);
        return formatter.format(date);
    }

    public static String getYearFirstDay(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-01-01");
        return formatter.format(date);
    }

    public static String getYearMaxDay(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-12-30");
        return formatter.format(date);
    }

    public static int getDay() {
        Date Now = new Date();
        return DateUtils.getDay(Now);
    }

    public static int getDay(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("d");
        return Integer.parseInt(formatter.format(date));
    }

    public static Date addDay(Date date, int addCount) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.strToDate(DateUtils.dateToStr(date)));
        calendar.add(5, addCount);
        return calendar.getTime();
    }

    public static Date addMonth(Date date, int addCount) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.strToDate(DateUtils.dateToStr(date)));
        calendar.add(2, addCount);
        return calendar.getTime();
    }

    public static Date parseDate(String dateStr) throws ParseException {
        return org.apache.commons.lang.time.DateUtils.parseDate((String)dateStr, (String[])parsePatterns);
    }

    public static void main(String[] args) {
        System.out.println(DateUtils.getMonthFirstDay(new Date()));
    }
}

