/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.modules.security.shiro;

import com.cpi.framework.modules.mapper.JsonMapper;
import com.cpi.framework.modules.utils.AjaxUtil;
import com.cpi.framework.web.common.ResponseData;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CPIFormAuthenticationFilter
extends FormAuthenticationFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CPIFormAuthenticationFilter.class);

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (!AjaxUtil.isAjaxRequest(httpRequest)) {
            this.issueSuccessRedirect(request, response);
        } else {
            httpResponse.setCharacterEncoding("UTF-8");
            PrintWriter out = httpResponse.getWriter();
            out.println(JsonMapper.nonEmptyMapper().toJson(ResponseData.SUCCESS_NO_DATA));
            out.flush();
            out.close();
        }
        return false;
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        if (!AjaxUtil.isAjaxRequest((HttpServletRequest)request)) {
            this.setFailureAttribute(request, e);
            return true;
        }
        try {
            response.setCharacterEncoding("UTF-8");
            PrintWriter out = response.getWriter();
            String message = e.getClass().getSimpleName();
            if ("IncorrectCredentialsException".equals(message)) {
                out.println(JsonMapper.nonEmptyMapper().toJson(new ResponseData(false, "\u5bc6\u7801\u9519\u8bef")));
            } else if ("UnknownAccountException".equals(message)) {
                out.println(JsonMapper.nonEmptyMapper().toJson(new ResponseData(false, "\u8d26\u53f7\u4e0d\u5b58\u5728")));
            } else if ("LockedAccountException".equals(message)) {
                out.println(JsonMapper.nonEmptyMapper().toJson(new ResponseData(false, "\u8d26\u53f7\u88ab\u9501\u5b9a")));
            } else {
                out.println(JsonMapper.nonEmptyMapper().toJson(new ResponseData(false, "\u672a\u77e5\u9519\u8bef")));
            }
            out.flush();
            out.close();
        }
        catch (IOException ioe) {
            LOGGER.error(ioe.getMessage());
        }
        return false;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        if (this.isLoginRequest(request, response)) {
            if (this.isLoginSubmission(request, response)) {
                return this.executeLogin(request, response);
            }
            return true;
        }
        if (!AjaxUtil.isAjaxRequest((HttpServletRequest)request)) {
            this.redirectToLogin(request, response);
            return false;
        }
        response.setCharacterEncoding("UTF-8");
        ((HttpServletResponse)response).addHeader("sessionstatus", "timeout");
        PrintWriter out = response.getWriter();
        out.println(JsonMapper.nonEmptyMapper().toJson(new ResponseData(false, "\u4f1a\u8bdd\u8d85\u65f6,\u8bf7\u91cd\u65b0\u767b\u5f55!")));
        out.flush();
        out.close();
        return true;
    }
}

