/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.dao.key.impl;

import com.cpi.framework.dao.key.CacheValue;
import com.cpi.framework.dao.key.UniqueTableApp;
import com.cpi.framework.modules.exception.DBAccessException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class DefaultUniqueTableApp
implements UniqueTableApp {
    private static final Logger logger = LoggerFactory.getLogger(DefaultUniqueTableApp.class);
    protected String selectSQL = null;
    protected String updateSQL = null;
    protected String insertSQL = null;
    protected JdbcTemplate jdbcTemplate = null;

    public DefaultUniqueTableApp(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.selectSQL = "SELECT code FROM FW_PRIMARYKEY WHERE name = ? FOR UPDATE";
        this.updateSQL = "UPDATE FW_PRIMARYKEY SET code = code + ? WHERE name = ? ";
        this.insertSQL = "INSERT INTO FW_PRIMARYKEY (code, name) VALUES (?, ?)";
    }

    @Override
    public CacheValue getCacheValue(int cacheNum, String name) {
        Assert.isTrue((boolean)TransactionSynchronizationManager.isSynchronizationActive(), (String)"Transaction must be running");
        CacheValue cache = null;
        try {
            cache = this.getCurrCode(name);
            if (cache == null) {
                this.insert(name);
                cache = this.getCurrCode(name);
            }
            this.update(cacheNum, name);
            cache.setMaxVal(cache.getMinVal() + (long)cacheNum);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4e3b\u952e\u5931\u8d25", (Throwable)e);
        }
        return cache;
    }

    private CacheValue getCurrCode(String name) {
        CacheValue value = null;
        try {
            Long code = this.jdbcTemplate.queryForLong(this.selectSQL, new Object[]{name});
            value = new CacheValue();
            value.setMinVal(code + 1L);
        }
        catch (EmptyResultDataAccessException e) {
            logger.debug(name + " \u6ca1\u6709\u627e\u5230\u8bb0\u5f55");
        }
        catch (Exception e) {
            throw new DBAccessException(name + " \u83b7\u53d6\u4e3b\u952e\u5931\u8d25");
        }
        return value;
    }

    private void insert(String name) {
        this.jdbcTemplate.update(this.insertSQL, new Object[]{0, name});
    }

    private void update(int cacheNum, String name) {
        this.jdbcTemplate.update(this.updateSQL, new Object[]{cacheNum, name});
    }

    public void setSelectSQL(String selectSQL) {
        this.selectSQL = selectSQL;
    }

    public void setUpdateSQL(String updateSQL) {
        this.updateSQL = updateSQL;
    }

    public void setInsertSQL(String insertSQL) {
        this.insertSQL = insertSQL;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

