/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.core.support;

import com.cpi.framework.core.support.MonitorAnnotation;
import com.cpi.framework.modules.utils.AjaxUtil;
import com.cpi.framework.modules.utils.SecurityContextUtil;
import com.cpi.framework.web.common.OpMonitorHolder;
import com.cpi.framework.web.common.ShiroUser;
import com.cpi.framework.web.entity.admin.FwOpMonitor;
import java.lang.reflect.Method;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class TraceInterceptor
implements MethodInterceptor {
    @Autowired(required=true)
    private HttpServletRequest request;
    @Value(value="${monitor.log}")
    private boolean isMonitor;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Logger logger = LoggerFactory.getLogger(invocation.getClass());
        boolean result = true;
        long startTime = System.currentTimeMillis();
        try {
            logger.info("------------\u3010" + invocation.getMethod().getName() + "\u3011:BEGIN!--(cpi-framework)------------");
            logger.info("Class \u540d\u79f0\uff1a" + invocation.getMethod().getDeclaringClass().getName());
            Class<?>[] clazz = invocation.getMethod().getParameterTypes();
            for (int i = 0; i < clazz.length; ++i) {
                logger.info("arg[" + i + "]\u7c7b\u578b: " + clazz[i]);
            }
            Object i = invocation.proceed();
            return i;
        }
        catch (Exception e) {
            logger.error("Error happened in class {},in method {}", (Object)invocation.getMethod().getDeclaringClass().getName(), (Object)invocation.getMethod().getName());
            Object[] argus = invocation.getArguments();
            for (int i = 0; i < argus.length; ++i) {
                logger.error("arg[" + i + "]: " + argus[i]);
            }
            result = false;
            throw e;
        }
        finally {
            logger.info("------------\u3010" + invocation.getMethod().getName() + "\u3011:END!--(cpi-framework)------------");
            if (this.isMonitor) {
                this.afterInvoke(invocation.getMethod(), startTime, result);
            }
        }
    }

    private void afterInvoke(Method method, long startTime, boolean result) {
        MonitorAnnotation mAnnotation = method.getAnnotation(MonitorAnnotation.class);
        if (null != mAnnotation) {
            FwOpMonitor opLog = new FwOpMonitor();
            opLog.setOpActioname(mAnnotation.actionName());
            opLog.setOpContent(mAnnotation.methodDescr());
            opLog.setOpResult(result ? "1" : "0");
            opLog.setOpOptime(Calendar.getInstance().getTime());
            opLog.setOpTotaltime(opLog.getOpOptime().getTime() - startTime);
            opLog.setOpUrl(this.request.getRequestURI());
            opLog.setOpIp(AjaxUtil.getIpAddr(this.request));
            ShiroUser loginUser = SecurityContextUtil.getCurrentUser();
            if (null != loginUser) {
                opLog.setOpUserid(loginUser.getId());
                opLog.setOpUsername(loginUser.getName());
                this.setCacheData(opLog);
            }
        }
    }

    private void setCacheData(FwOpMonitor opLog) {
        OpMonitorHolder.putOptionLogs(opLog);
    }
}

