/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.core.spring;

import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringApplicationContextHolder
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public synchronized void setApplicationContext(ApplicationContext applicationContext) {
        SpringApplicationContextHolder.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        SpringApplicationContextHolder.checkApplicationContext();
        return applicationContext;
    }

    public static <T> T getBean(String name) {
        SpringApplicationContextHolder.checkApplicationContext();
        return (T)applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        SpringApplicationContextHolder.checkApplicationContext();
        return (T)applicationContext.getBeansOfType(clazz);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> clazz) {
        SpringApplicationContextHolder.checkApplicationContext();
        return SpringApplicationContextHolder.getApplicationContext().getBeansOfType(clazz);
    }

    public static void cleanApplicationContext() {
        applicationContext = null;
    }

    private static void checkApplicationContext() {
        if (applicationContext == null) {
            throw new IllegalStateException("applicaitonContext\u672a\u6ce8\u5165,\u8bf7\u5728applicationContext.xml\u4e2d\u5b9a\u4e49SpringContextHolder");
        }
    }
}

