/**
 * @author leili
 * @description 角色管理 
 * http://beansoft.blogjava.net/
 */
 
Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif';  //本地图形化

var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';     //需要补充的空格


var ROLEINFO_STORE_URL="getAllRole.action"
var ROLENAME_STORE_URL="getAllRoleName.action"
var pageSize=13;
var Role = Ext.data.Record.create([
           // 下面的 "name" 匹配读到的标签名称
           {name: 'id', type: 'string'},
           {name: 'name', type: 'string'},
           {name: 'tmlId', type: 'int'}          
      ]);

 

Ext.onReady(function(){
    Ext.QuickTips.init();
	Ext.form.Field.prototype.msgTarget = "side";

    // 弄个缩写的别名
    var fm = Ext.form;


    // 列模型定义了表格所有列的信息, 
	// dataIndex 将特定的列映射到数据源(Data Store)中的数据列(在后面创建)
    var cm = new Ext.grid.ColumnModel([
    		{
           id:'id',
           header: "角色编号",
           dataIndex: 'id',
           width: 100,
           editor: new fm.TextField({
               allowBlank: false// 不能为空
           })
        },        
		{
           id:'name',
           header: "角色名称",
           dataIndex: 'name',
           width: 250,
           editor: new fm.TextField({
               allowBlank: false// 不能为空
           })
        },
		
		{
           header: "角色地区",
           dataIndex: 'tmlId',
           width: 100,
           editor: new fm.TextField({
               allowBlank: false// 不能为空
           })
           
        }		
    ]);

    // 默认情况下列是可排序的
    cm.defaultSortable = true;

    // 定义一个用户对象,这样便于我们动态的添加记录,虽然也可以设置成匿名内置对象
    

    // 创建  Role Data Store
    var roleStore = new Ext.data.Store({
        // 使用 HTTP 加载
       proxy: new Ext.data.HttpProxy({url: ROLEINFO_STORE_URL, method: 'POST'}),
        reader: new Ext.data.JsonReader({totalProperty:"results",
			root:"items",
			fields:[{name:'id'},{name:'name'},{name:"tmlId"}]})
       });
      
       
       //创建  RoleName Data Store
       var roleNameStore = new Ext.data.Store({
        // 使用 HTTP 加载
       proxy: new Ext.data.HttpProxy({url: ROLENAME_STORE_URL, method: 'POST'}),
        reader: new Ext.data.JsonReader({
        	totalProperty:"results",        	
			root:"items",			
			fields:[{name:'tmlId'},{name:"tmlName"}]})
       });
       roleNameStore.load({params:{start:0, limit:pageSize}});
       
//       alert(roleNameStore.length);


    // 创建编辑器表格
    var roleGrid = new Ext.grid.EditorGridPanel({
        store: roleStore,
        cm: cm,
        renderTo:"roleMng",
        width: 570,
        height: 450,
        autoExpandColumn:'name',
        frame:true,
        clicksToEdit:1,//设置点击几次才可编辑
        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),//设置单行选中模式, 否则将无法删除数据

		// 顶部工具栏按钮
        tbar: [
		
		{
            text: '添加角色',
			iconCls:'add',//按钮图标的CSS名称
			 
            handler : addRole
        },{
            text: '保存所选',
			iconCls:'save',
            handler : saveRole
            
        },{
            text: '删除所选',
			iconCls:'remove',
            handler : deleteRole
            
        },{
            text: '操作所选',
			iconCls: 'role-operate',
			handler : operateRole
            
        }],
        bbar: new Ext.PagingToolbar({
            pageSize: pageSize,
            store: roleStore, 
            displayInfo: true,
            displayMsg: '当前 {0} 到 {1} 共 {2}',
            emptyMsg: "No topics to display"
        })   
    });
	



    // 触发数据加载
    roleStore.load({params:{start:0, limit:pageSize}});

    /*
     * 添加角色数据
     */
    function addRole(){
       
       var n = roleGrid.getStore().getCount();// 获得总行数
       var d=n+1;
       var p = new Role({id:d,name:"管理员",tmlId:551});
               
       roleGrid.stopEditing();// 停止编辑				
       roleStore.insert(n, p);// 插入到最后一行
       roleGrid.startEditing(n, 1);// 开始编辑1单元格
 
    }
    
    /*
     * 保存角色数据
     */
    function saveRole(){
    	
       var r= roleGrid.getSelectionModel().getSelected();
       if( typeof(r) =='undefined'){
       	Ext.Msg.alert('系统提示', blankStr + '请添加一条角色记录' + blankStr);
            return;
       }
       var rr=r.data.id+"@"+r.data.name+"@"+r.data.tmlId;
       RoleInfoManager.findByRoleId(r.data.id, function(datax) {
                       if(datax) {
                       		RoleInfoManager.savex(rr,function(datar) {
                         	      if(datar) {
                         	      	  Ext.MessageBox.alert("系统提示:", blankStr + "保存成功" + blankStr);
                                      roleGrid.store.load({params:{start:0, limit:pageSize}});
                         	      } else {
                         	      	  Ext.MessageBox.alert("系统提示：", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
                         	      }
                         	  });
                       } else {
                            Ext.MessageBox.alert("系统提示：", blankStr + "角色编号已经存在,请重新输入新的角色名称！" + blankStr); 
                       }
                    });
                   
    }
    
    /*
     *  删除角色数据
     */
    function deleteRole(){
    	
    	var data = [];
    	
    	data= roleGrid.getSelectionModel().getSelections();
       if( data.length==0 ){
      
       	Ext.Msg.alert('系统提示', blankStr + '请选择一条角色记录' + blankStr);
            return;
       }
      
                RoleInfoManager.deleteRole(data[0].get("id"), function(data){
                   if(data) {
                       Ext.MessageBox.alert("系统提示:", blankStr + "删除成功" + blankStr);
                       roleGrid.store.load({params:{start:0, limit:pageSize}});
                   }
                });
       
    	
    }
    
/*    
     * 重置信息
     
    function resetRole(){
    	roleGrid.getSelectionModel();
    }*/
    
    
    
    
    /*
     * 操作角色
     */
    function operateRole(){
    	var data = [];    	
    	data= roleGrid.getSelectionModel().getSelections();
    	if( data.length==0 ){
      
       	Ext.Msg.alert('系统提示', blankStr + '请选择一条角色记录' + blankStr);
            return;
       }
       var id=data[0].get("id");
       var tmlId=data[0].get("tmlId");
    	window.navigate('/CINAS/systemMng/operateRole.jsp?id='+id+'&tmlId='+tmlId);
    }    
    
});

