Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif';   // 指定空白图片的位置

/**
 * 变量定义
 * @type 
 */
// 用于创建左边表格一条记录的record
var bndictBusintypeRecord;
// 左边表格的属性列
var cm1;
// 左边表格数据
var store1;
// 左边表格
var grid1;
// 加载后左边表格的记录个数
var count1;
// 右边表格的行选择模式
var sm;
// 用于创建右边表格一条记录的record
var bndictDictionaryRecord;
// 右边表格数据
var store2;
// 右边表格
var grid2;
// 加载后右边表格的记录个数
var count2;
// 每页显示的记录条数
var pagesize = 15;
// 设置某一列的编辑器
var statusEditor;
var allowLength = 64;


function changeStyle(style) {
    Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + style + ".css");
}

/**
 * 页面初始化
 */
Ext.onReady(function() {
	Ext.QuickTips.init(); // 初始化快捷提示
    Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + window.parent.styleCssValue);
    
    Ext.Ajax.on('requestcomplete',checkUserSessionStatus, this); 
	function checkUserSessionStatus(conn,response,options) {     
        var sessionStatus = response.getResponseHeader["sessionstatus"]; 
        
        if(typeof(sessionStatus) != "undefined"){   
            Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
			    if (btn == 'ok'){   
			        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
			        window.location = redirect;   
			    }   
            });   
         }     
    }   
	// 编辑代码按钮
	function renderBusinId(store){
		return "<input type='button' name='query' value='编辑代码' height='10' onclick='getDetail();'/>"
	}
	// grid1的属性列
	cm1 = new Ext.grid.ColumnModel([
		{header:'业务类型编码',dataIndex:'busintypeid',width:217.4,editor:new Ext.grid.GridEditor(new Ext.form.TextField({allowBlank:false}))},
		{header:'业务类型名称',dataIndex:'busintypename',width:217.4,editor:new Ext.grid.GridEditor(new Ext.form.TextField({allowBlank:true}))}
		//{header:'业务代码',dataIndex:'businid',renderer:renderBusinId}
		//{header:'标志',dataIndex:'delflg',hidden:true}
	]);
	// grid1属性列的排序
	cm1.defaultSortable = false;
	// store1的record
	var record1 = [
		{name:'busintypeid'},
		{name:'busintypename'}
		//{name:'businid'}
	];
	// grid1的store
	store1 = new Ext.data.JsonStore({
		url:'bndictBusintype.action',
	    root: 'bndictBusintypeResult',
	    fields: record1,
	    pruneModifiedRecords:true,
	    autoLoad :false,
	    totalProperty :'bndictBusintypeCount'
	});
	// store1加载函数
	store1.load({
		params : {
		start :0,
		limit :pagesize
		}
	});
	// 行的选择模式
	var rm = new Ext.grid.RowSelectionModel({singleSelect:true});
	// 左边的表格
	grid1 = new Ext.grid.EditorGridPanel({
		title:'业务字典维护',  // <div style="height:21;position:relative;top:10%;}">业务字典维护</div>
		stripeRows:true,
		loadMask:true,
		deferowrender:true,
		trackMouseOver:true,
		cm:cm1,
		sm:rm,
		store:store1,
		width:500,
		height : Ext.getBody().getViewSize().height - 30 ,
		enableHdMenu:false, 
		enableColumnHide:false, 
		draggable:false,
		enableColumnMove:false,
		frame:true,
		tbar: new Ext.PagingToolbar({
			pageSize:pagesize,
			store:store1,
			displayInfo:true,
			emptyMsg:'<div style="position:absolute;right:150">没有记录</div>',
			displayMsg:'<div style="position:absolute;right:135">显示{0}-{1}条，共{2}条</div>',
			items:['->','-',{
				iconCls:'new',
				tooltip:'添加',
				handler:addBndictBusintype
			},'-',{
				iconCls:'delete',
				tooltip:'删除',
				handler:removeBndictBusintype
			},'-',{
				iconCls:'save',
				tooltip:'保存',
				handler:saveBndictBusintype
			},'-'//,{
				//iconCls:'refresh'}
			]
		})
	});
	
	// 增加行用的record
	bndictBusintypeRecord = new Ext.data.Record.create([
		{name:'busintypeid',mapping:0},
		{name:'busintypename',mapping:1}//,
		//{name:'businid',mapping:2}
	]);
	
//	sm = new Ext.grid.CheckboxSelectionModel({
//		header:'<div class="x-grid3-hd-checker"></div>'
//	});
	// grid2 的行选择模式
	sm = new Ext.grid.RowSelectionModel({singleSelect:true});
	// 状态列的编辑器
	statusEditor = new Ext.form.ComboBox({allowBlank:true,store:[['0','0'],['1','1']],triggerAction: 'all'});
	// grid2 的属性列
	var cm2 = new Ext.grid.ColumnModel([
		{header:'业务类型编码',dataIndex:'busintypeid',hidden:true},
		{header:'业务代码',dataIndex:'businid',width:100,editor:new Ext.grid.GridEditor(new Ext.form.TextField({allowBlank:false}))},
		{header:'业务名称',dataIndex:'businname',width:100,editor:new Ext.grid.GridEditor(new Ext.form.TextField({allowBlank:true}))},
		{header:'过滤值',dataIndex:'privilege',width:144,editor:new Ext.grid.GridEditor(new Ext.form.NumberField({allowBlank:true}))},
		{header:'状态',dataIndex:'status',width:90,editor:new Ext.grid.GridEditor(statusEditor)}
		//sm
	]);
	// store2的record
	var record2 = [
	{name:'busintypeid'},
	{name:'businid'},
	{name:'businname'},
	{name:'privilege'},
	{name:'status'}
	];
	// grid2的store
	store2 = new Ext.data.JsonStore({
		url:'bndictDictionary.action',
	    root: 'bndictDictionaryResult',
	    fields: record2,
	    pruneModifiedRecords:true,
	    autoLoad :false,
	    totalProperty :'bndictDictionaryCount'
	});
	// store2的加载函数
	store2.load({
		params:{
			act:'INIT'
		}
	});
	// 右边的表格
	grid2 = new Ext.grid.EditorGridPanel({
		title:' <div style="height:14;position:relative;}"></div>',   // <div align="right"><button id="btnRefresh" class="x-btn" onclick="btnClick()">刷新服务器缓存中的业务字典</button></div>
		stripeRows:true,
		loadMask:true,
		trackMouseOver:true,
		cm:cm2,
		sm:sm,
		store:store2,
		width : Ext.getBody().getViewSize().width - 530 ,
		height : Ext.getBody().getViewSize().height - 30 ,
		frame:true,
		enableHdMenu:false, 
		enableColumnHide:false, 
		draggable:false,
		enableColumnMove:false,
		tbar:
			new Ext.Toolbar(['->','-',{
				iconCls:'new',
				tooltip:'添加',
				handler:addBndictDictionary
				},'-',{
				iconCls:'delete',
				tooltip:'删除',
				handler:removeBndictDictionary
				},'-',{
				iconCls:'save',
				tooltip:'保存',
				handler:saveBndictDictionary
				},'-'//,{
				//iconCls:'refresh'}
				])
	});
	// 用来增加行的record
	bndictDictionaryRecord = new Ext.data.Record.create([
		{name:'busintypeid',mapping:0},
		{name:'businid',mapping:1},
		{name:'businname',mapping:2},
		{name:'privilege',mapping:3},
		{name:'status',mapping:4}
	]);

	// 绑定到页面的panel
	var panel = new Ext.Panel({
		title:'',
		layout:'column',
		frame:true,
		width : Ext.getBody().getViewSize().width - 10 ,
		height : Ext.getBody().getViewSize().height - 10 ,
		applyTo:'panel',
		dafault:{
			bodyStyle:'background-color:#FFFFFF',
			frame:true
		},
		items:[
			grid1,
			grid2
		]
	});
	
	/**
	 * grid中行的可编辑性的判断
	 */
	store1.on('load',function(){
		count1 = grid1.getStore().getCount();

		if(count1 > 0) {
			cm1.defaultSortable = true;
			grid1.getSelectionModel().selectFirstRow();
			store2.reload({params:{act:'',busintypeId:grid1.getSelectionModel().getSelected().get('busintypeid')}});
		}
	});
	
	grid1.on('beforeedit',function(e){
		var rec1 = grid1.getStore().getAt(e.row);
		
		if(rec1.get('busintypeid') != '' && e.row < count1 && e.field == 'busintypeid') {
			return false;
		}
	});
	
	store2.on('load',function(){
		count2 = grid2.getStore().getCount();
		
		if(count2 > 0) {
			cm2.defaultSortable = true;
		}
	});
	
	grid2.on('beforeedit',function(e){
		var rec2 = grid2.getStore().getAt(e.row);
		
		if(rec2.get('businid') != '' && e.row < count2 && e.field == 'businid') {
			return false;
		}
	});
	
	rm.on('rowselect',function(rm,rowIndex,record){
		var id = record.get('busintypeid');
		store2.reload({
			params:{
				act:'',
				busintypeId:id
			}
		});
	});
	
//	statusEditor.on('change',function(field,newValue,oldValue){
//		alert(field.getValue());
//		if(newValue) {
//			field.setValue('0');
//		} else {
//			field.setValue('1');
//		}
//	});
	/**
	 * 添加行操作
	 */
	function addBndictBusintype() {
		TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
					var initValue = {busintypeid:'',busintypename:''};
					var p = new bndictBusintypeRecord(initValue);
					var row = store1.getCount();
					grid1.stopEditing();
					store1.insert(row,p);
					grid1.startEditing(row,0);
					
					p.dirty = false;
					p.modified = initValue;
					if(store1.modified.indexOf(p) == -1) {
						store1.modified.push(p);
					}
			}
		});
	}
	
	/**
	 * 删除行操作
	 */
	function removeBndictBusintype() {
		TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
					var smTemp = grid1.getSelectionModel();
					var recordTemp = smTemp.getSelected();
					
					if(recordTemp == null) {
						Ext.Msg.alert('提示','没有选择任何行');
						return;
					}
					
					Ext.Msg.confirm('提示','确认要删除该条记录么？',function(btn){
						if(btn == 'yes') {
							if(recordTemp.isModified('busintypeid')) {
								store1.remove(recordTemp);
							} else if(recordTemp.isModified('busintypeid') == null) {
								var bndictBusintypeArray = [];
								bndictBusintypeArray.push(recordTemp.data);
								// 提交数据
								Ext.Ajax.request({
									url:'deleteBndictBusintype.action',
									params:{deleteBndictBusintypeJson:encodeURIComponent(Ext.encode(bndictBusintypeArray))},
									success:function(response,options){
										if(!isNullOrEmpty(response.responseText)) {
											Ext.Msg.alert('提示','业务类型编码为"'+ response.responseText +'"的记录已经被删除了！',function(){
												store1.reload({params:{start:grid1.getTopToolbar().cursor, limit:pagesize}});
											});
										} else{
											Ext.Msg.alert('消息','数据已经成功地删除了！',function(){
											store1.reload({params:{start:grid1.getTopToolbar().cursor, limit:pagesize}});
											});
										}
									},
									failure:function(){
										Ext.Msg.alert('错误','数据删除失败！');
									}
								});
							}
						}
					});
			}
		});
	}
	
	/**
	 * 保存数据
	 */
	function saveBndictBusintype() {
		TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
					Ext.Msg.confirm('提示','确认要保存这些记录么？',function(btn){
						if(btn == 'yes') {
							var m = store1.modified.slice(0);
							if(m.length == 0) {
								Ext.Msg.alert('提示','没有记录被修改或增加！');
								return;
							}
							// 关键字不能为空的检查
							var i;
							var businTypeId;
							var businTypeName;
							for(i = 0; i < m.length; i++) {
								businTypeId = m[i].get('busintypeid');
								businTypeName = m[i].get('busintypename');
								if(isNullOrEmpty(businTypeId)) {
									Ext.Msg.alert('错误','业务类型编码不能为空！',function(btn){
										if(btn == 'ok') {
											grid1.startEditing(store1.indexOf(m[i]),0);
										}
									});
									return;
								}
								// 字符的长度check
								if(getLength(businTypeId) > allowLength) {
									Ext.Msg.alert('错误','业务类型编码最大长度为64位！',function(btn){
										if(btn == 'ok') {
											grid1.startEditing(store1.indexOf(m[i]),0);
										}
									});
									return;
								}
								
								// 字符的长度check
								if(getLength(businTypeName) > allowLength) {
									Ext.Msg.alert('错误','业务类型名称最大长度为64位！',function(btn){
										if(btn == 'ok') {
											grid1.startEditing(store1.indexOf(m[i]),1);
										}
									});
									return;
								}
							}
							// 关键字不能重复的检查（仅当前页面，与以前未被修改的比较）
							var oldStore = grid1.getStore();
							var j;
							for(i = 0; i < m.length; i++) {
								for(j = 0; j < count1; j++) {
									if(oldStore.getAt(j).isModified('busintypeid') == null){
										if(m[i].get('busintypeid') == oldStore.getAt(j).get('busintypeid')) {
											Ext.Msg.alert('错误','业务类型编码不能重复！',function(btn){
												if(btn == 'ok') {
													grid1.startEditing(store1.indexOf(m[i]),0);
												}
											});
											return;
										}
									}
								}
							}
							// 关键字不能重复的检查（仅当前页面，范围是增加和修改）
							var r,s;
							for(r = 0; r < m.length -1; r++) {
								for(s = r + 1; s < m.length; s++) {
									if(m[r].get('busintypeid') == m[s].get('busintypeid')) {
										Ext.Msg.alert('错误','业务类型编码不能重复！',function(btn){
											if(btn == 'ok') {
												grid1.startEditing(store1.indexOf(m[i]),0);
											}
										});
										return;
									}
								}
							}
							
							var bndictBusintypeArray = [];
							Ext.each(m,function(item){
								var bndictBusintypeObj = {
									busintypeid:'',
									busintypename:''
								}
								
								bndictBusintypeObj.busintypeid = item.get('busintypeid');
								bndictBusintypeObj.busintypename = item.get('busintypename');
								bndictBusintypeArray.push(bndictBusintypeObj);
							});
							
							if(bndictBusintypeArray == '') {
								Ext.Msg.alert('提示','没有记录被修改或增加！');
								return;
							}
							// 提交数据
							Ext.Ajax.request({
								url:'saveBndictBusintype.action',
								params:{saveBndictBusintypeJson:encodeURIComponent(Ext.encode(bndictBusintypeArray))},
								success:function(response,options){
									Ext.Msg.alert('消息','数据已经成功地保存了！',function(){
										store1.reload({params:{start:grid1.getTopToolbar().cursor, limit:pagesize}});
									});
								},
								failure:function(response){
									Ext.Msg.alert('错误','数据保存失败！');
								}
							});
						}
					});
			}
		});
	}
	/**
	 * 添加行操作
	 */
	function addBndictDictionary() {
		TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
					var smTemp = grid1.getSelectionModel();
					var recordTemp = smTemp.getSelected();
					
					if(recordTemp == null) {
						Ext.Msg.alert('提示','请选择左边表格中的任一行！');
						return;
					}
					
					if(isNullOrEmpty(recordTemp.get('busintypeid'))) {
						var selRec = grid1.getSelectionModel().getSelected();
						var rowNum1 = grid1.getStore().indexOf(selRec);
						Ext.Msg.alert('提示','业务类型编码不能为空！',function(btn){
							if(btn == 'ok') {
								grid1.startEditing(rowNum1,0);
							}
						});
						
						return;
					}
					
					var busintypeId = recordTemp.get('busintypeid');
					var initValue = {busintypeid:busintypeId,businid:'',businname:'',privilege:'',status:'0'};
						var p = new bndictDictionaryRecord(initValue);
						var row = store2.getCount();
						grid2.stopEditing();
						store2.insert(row,p);
						grid2.startEditing(row,1);
						
						p.dirty = false;
						p.modified = initValue;
						if(store2.modified.indexOf(p) == -1) {
							store2.modified.push(p);
						}
			}
		});
	}
	/**
	 * 删除行操作
	 */
	function removeBndictDictionary() {
		TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
					var smTemp = grid2.getSelectionModel();
					var recordTemp = smTemp.getSelected();
					
					if(recordTemp == null) {
						Ext.Msg.alert('提示','没有选择任何行！');
						return;
					}
					
					Ext.Msg.confirm('提示','确认要删除该条记录么？',function(btn){
						if(btn == 'yes') {
							if(recordTemp.isModified('businid')) {
								store2.remove(recordTemp);
							} else if(recordTemp.isModified('businid') == null) {
								var bndictBusintypeArray = [];
								bndictBusintypeArray.push(recordTemp.data);
								// 提交数据
								Ext.Ajax.request({
									url:'deleteBndictDictionary.action',
									params:{deleteBndictDictionaryJson:encodeURIComponent(Ext.encode(bndictBusintypeArray))},
									success:function(response,options){
										if(!isNullOrEmpty(response.responseText)) {
											Ext.Msg.alert('提示','业务代码为"'+ response.responseText +'"的记录已经被删除了！',function(){
												store2.reload({params:{act:'',busintypeId:grid1.getSelectionModel().getSelected().get('busintypeid')}});
											});
										} else{
											Ext.Msg.alert('消息','数据已经成功地删除了！',function(){
												//store1.reload({params:{start:grid1.getTopToolbar().cursor, limit:pagesize}});
												store2.reload({params:{act:'',busintypeId:grid1.getSelectionModel().getSelected().get('busintypeid')}});
											});
										}
									},
									failure:function(){
										Ext.Msg.alert('错误','数据删除失败！');
									}
								});
							}
						}
					});
			}
		});
	}
	/*
	 * 保存数据
	 */
	function saveBndictDictionary() {
		TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
					Ext.Msg.confirm('提示','确认要保存这些记录么?',function(btn){
						if(btn == 'yes') {
							var m = store2.modified.slice(0);
							// 判断是否有数据被修改或增加
							if(m.length == 0) {
								Ext.Msg.alert('提示','没有记录被修改或增加！');
								return;
							}
							var i;
							// 关键字不能为空的检查
							var varBusinId;
							var varBusinName;
							for(i = 0; i < m.length; i++) {
								varBusinId = m[i].get('businid');
								if(isNullOrEmpty(varBusinId)) {
									Ext.Msg.alert('错误','业务代码不能为空！',function(btn){
										if(btn == 'ok') {
											grid2.startEditing(store2.indexOf(m[i]),1);
										}
									});
									return;
								}
								
								if(getLength(varBusinId) > 16) {
									Ext.Msg.alert('错误','业务代码最大长度为16位！',function(btn){
										if(btn == 'ok') {
											grid2.startEditing(store2.indexOf(m[i]),1);
										}
									});
									return;
								}
								
								varBusinName = m[i].get('businname');
								if(getLength(varBusinName) > 256) {
									Ext.Msg.alert('错误','业务名称最大长度为256位！',function(btn){
										if(btn == 'ok') {
											grid2.startEditing(store2.indexOf(m[i]),2);
										}
									});
									return;
								}
								
								// 过滤值格式的检查
								if(!isNullOrEmpty(m[i].get('privilege'))) {
									if(!isDigit(m[i].get('privilege').toString())) {
										Ext.Msg.alert('错误','过滤值的格式应为999999！',function(btn){
											if(btn == 'ok') {
												grid2.startEditing(store2.indexOf(m[i]),3);
											}
										});
										
										return;
									}
									
									if(m[i].get('privilege').toString().length > 6) {
										Ext.Msg.alert('错误','过滤值的长度不能超过6！',function(btn){
											if(btn == 'ok') {
												grid2.startEditing(store2.indexOf(m[i]),3);
											}
										});
										return;
									}
								}
							}
							// 关键字不能重复的检查（仅当前页面）
							var j;
							var oldStore = grid2.getStore();
							for(i = 0; i < m.length; i++) {
								for(j = 0; j < count2; j++){
									if(oldStore.getAt(j).isModified('businid') == null) {
										if(m[i].get('businid') == oldStore.getAt(j).get('businid')) {
											Ext.Msg.alert('错误','业务代码不能重复！',function(btn){
												if(btn == 'ok') {
													grid2.startEditing(store2.indexOf(m[i]),1);
												}
											});
											return;
										}
									}
								}
							}
							
							var r,s;
							for(r = 0; r < m.length - 1; r++){
								for(s = r + 1; s < m.length; s++){
									if(m[r].get('businid') == m[s].get('businid')){
										Ext.Msg.alert('错误','业务代码不能重复！',function(btn){
											if(btn == 'ok') {
												grid2.startEditing(store2.indexOf(m[i]),1);
											}
										});
										return;
									}
								}
							}
							
							var bndictDictionaryArray = [];
							Ext.each(m,function(item){
								var bndictDictionaryObj = {
									busintypeid:'',
									businid:'',
									businname:'',
									privilege:'',
									status:''
								}
								
								bndictDictionaryObj.busintypeid = item.get('busintypeid');
								bndictDictionaryObj.businid = item.get('businid');
								bndictDictionaryObj.businname = item.get('businname');
								bndictDictionaryObj.privilege = item.get('privilege');
								bndictDictionaryObj.status = item.get('status');
			//					if(sm.isSelected(item)) {
			//						bndictDictionaryObj.status = '0';
			//					} else {
			//						bndictDictionaryObj.status = '1';
			//					}
								
								bndictDictionaryArray.push(bndictDictionaryObj);
							});
							
							if(bndictDictionaryArray == '') {
								Ext.Msg.alert('提示','没有记录被修改或增加！');
								return;
							}
							/**
							 * 提交数据
							 */
							Ext.Ajax.request({
								url:'saveBndictDictionary.action',
								params:{saveBndictDictionaryJson:encodeURIComponent(Ext.encode(bndictDictionaryArray))},
								success:function(response,options){
									Ext.Msg.alert('消息','数据已经成功地保存了！',function(){
											//store1.reload({params:{start:grid1.getTopToolbar().cursor, limit:pagesize}});
											store2.reload({params:{act:'',busintypeId:grid1.getSelectionModel().getSelected().get('busintypeid')}});
									});
								},
								failure:function(){
									Ext.Msg.alert('错误','数据保存失败！');
								}
							});
						}
					});
			}
		});
	}
});

/**
 * 状态列的显示初始化
 */
function selectRowStatus(value,cellmeta,record,rowIndex,columnIndex,store) {
//	if(value == 0) {
//		sm.selectRow(rowIndex,true);
//		//grid2.getView().getRow(rowIndex).style.backgroundColor="#dfe8f6"; 
//	}
	
	//return '<input type="checkbox" onclick="cbClick(this)" style="height:10px;background-position:2px 2px;background-repeat:no-repeat;background-color:transparent;background-image:url(../../../resources/images/default/grid/row-check-sprite.gif);" name="cb" />';
}

/**
 * 编辑代码按钮事件
 */
function getDetail(){
	var smTemp = grid1.getSelectionModel();
	var recordTemp = smTemp.getSelected();
	var id = recordTemp.get('busintypeid');
	store2.reload({
		params:{
			act:'',
			busintypeId:id
		}
	});
}
/**
 * 判断字符串是否为空或null
 * @param {} str
 * @return {Boolean}
 */
function isNullOrEmpty(str) {
	if(str == null || str == '') {
		return true;
	}
	
	return false;
}

/**
 * 判断是否是数字
 * @param {} ch
 * @return {}
 */
function isDigit(ch) {
	var flg = true;
	var i; 
	for(i = 0; i < ch.length; i++) {
		if(ch.substr(i,1) < '0' || ch.substr(i,1) > '9') {
			flg = false;
			break;
		}
	}
	
	return flg;
}
/**
 * 取得字符串的长度（计算全角字符的长度）
 * @param {} str
 * @return {}
 */
function getLength(str){
	 str = str.replace(/[^\x00-\xff]/g, '**');
	 return str.length;
}

