/*
 * Ext JS Library 2.0.1
 * Copyright(c) 2006-2008, Ext JS, LLC.
 * licensing@extjs.com
 * 
 * http://extjs.com/license
 */

/**
 * 无 DWR Java 后台静态页面演示版本.
 * 简体中文 Demo 制作: 刘长炯 beansoft@126.com
 * http://beansoft.blogjava.net/
 */
 
Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif';  //本地图形化

var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';     //需要补充的空格


var USERINFO_STORE_URL="MngGetAllUser.action"

var pageSize=10;
Ext.onReady(function(){
    Ext.QuickTips.init();
    // 弄个缩写的别名
    var fm = Ext.form;
    var sm = new Ext.grid.CheckboxSelectionModel();
    // 列模型定义了表格所有列的信息, 
	// dataIndex 将特定的列映射到数据源(Data Store)中的数据列(在后面创建)
    var cm = new Ext.grid.ColumnModel([sm,{
           id:'userId',
           header: "用户登录名",
           dataIndex: 'userId',
           width: 100
           },{
           id:'name',
           header: "用户真实姓名",
           dataIndex: 'name',
           width: 250          
           },{
           header: "用户状态",
           dataIndex: 'delFlag',
           width: 100          
           }		
      ]);
    // 默认情况下列是可排序的
    cm.defaultSortable = true;
    // 定义一个用户对象,这样便于我们动态的添加记录,虽然也可以设置成匿名内置对象
    // 创建  User Data Store
    var UserStore = new Ext.data.Store({
        // 使用 HTTP 加载
       proxy: new Ext.data.HttpProxy({url:USERINFO_STORE_URL, method: 'POST'}),
        reader: new Ext.data.JsonReader({totalProperty:"results",
			root:"items",
			fields:[{name:'userId'},{name:'name'},{name:"delFlag"}]})
       });     
    // 创建编辑器表格
    var userGrid= new Ext.grid.GridPanel({
        store: UserStore,
        cm: cm,
        sm:sm,
        renderTo: 'RoleUserInfo',
        width:800,
        height:300,
        autoExpandColumn:'name',
        title:'角色管理',// 标题
        frame:true,
		// 顶部工具栏按钮
        tbar: [		
		{
            text: '添加',
			iconCls:'add',//按钮图标的CSS名称			 
            handler : addUser
        },{
            text: '删除',
			iconCls:'remove',
            handler : deleteUser            
        },{
            text: '返回',
			iconCls: 'reback',
			handler : reback            
        }],
        bbar: new Ext.PagingToolbar({
            pageSize: pageSize,
            store: UserStore, 
            displayInfo: true,
            emptyMsg: "No topics to display"            
        })   
    });
    // 触发数据加载
    UserStore.load({params:{start:0, limit:pageSize,roleId:document.getElementsByName('id')[0].value}});
    
    /***************************************************function*************************************/
    /*
     * 添加用户
     */  
    function addUser(){
    	
    }    
    /*
     * 删除用户
     */
     function deleteUser(){
    	var data = [];
    	var del='';
    	var i=0;
    	data= userGrid.getSelectionModel().getSelections();
       if( data.length==0 ){
      
       	Ext.Msg.alert('系统提示', blankStr + '请至少选择一条角色记录' + blankStr);
            return;
       }       
       while(i < data.length){
       	del=del+data[i].get("userId")+"@";
       	i=i+1;
       }
       UserInfoManager.deleteUserx(del, function(datax){
                   if(datax) {
                       Ext.MessageBox.alert("系统提示:", blankStr + "删除成功" + blankStr);
                       userGrid.store.load({params:{start:0, limit:pageSize,roleId:document.getElementsByName('id')[0].value}});
                   }
                });
       }       
       /*
        * 
        * 返回
        */
     function reback(){
    	window.history.back(-1);
    }  
    
});

