Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif';
var pageTotal = 15;
var msgTemplate;
var servId;
var servManCombox, servCombox;
var serviceListGrid;

function changeStyle(style) {
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + style + ".css");
}

Ext.onReady(function() {
	Ext.QuickTips.init();

	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
			+ window.parent.styleCssValue);
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
			+ window.parent.parent.styleCssValue);

	serviceListGrid = new ServDefineListGrid(gridHeight, gridWidth);
});
/** ****************************************************************************************** */
// 公用 代码区
// combox自动加上"请选择"
var addBlankSelectForCombox = function(combo) { // 自动添加一个空选择项
	combo.on("select", function() {
		if (combo.getValue() == -1) { // 当选择-1时，把值设置为空
			combo.setValue("");
		}
	});
	combo.store.on("datachanged", function(a) {
		var r = new Ext.data.Record({});
		r.set(combo.valueField, ''); // 添加一格值为-1的选项
		r.set(combo.displayField, combo.emptyText);
		a.insert(0, r);
	});
};

// 先建注册服务商下拉列表
var servManfields = Ext.data.Record.create([ {
	name : 'servManId'
}, {
	name : 'servManName'
} ]);
var servManDataStore = new Ext.data.Store(
		{
			proxy : new Ext.data.HttpProxy(
					{
						url : 'serviceSearch/servAffordManRegAction_queryAllRegiteredServMans.action'
					}),
			reader : new Ext.data.JsonReader({
				root : 'servManList'
			}, servManfields),
			remoteSort : true
		});
servManDataStore.load();
servManCombox = new Ext.form.ComboBox({
	fieldLabel : show_name + "名称",
	emptyText : "全部",
	store : servManDataStore,
	editable : false,
	hiddenName : 'servManId',
	valueField : 'servManId',
	displayField : 'servManName',
	typeAhead : true,
	triggerAction : 'all',
	selectOnFocus : true,
	forceSelection : true,
	width : 150,

	initComponent : function() {
		addBlankSelectForCombox(this);
	},
	mode : 'local'
});

// 服务下拉列表
var servFields = Ext.data.Record.create([ {
	name : 'servId'
}, {
	name : 'servName'
} ]);
var servStore = new Ext.data.Store({
	proxy : new Ext.data.HttpProxy({
		url : 'serviceSearch/servAffordManRegAction_queryServByServMan.action?'
	}),
	reader : new Ext.data.JsonReader({
		root : 'servDtoList'
	}, servFields),
	remoteSort : true
});

servCombox = new Ext.form.ComboBox({
	fieldLabel : "服务名称",
	emptyText : "全部",
	store : servStore,
	editable : true, // true：可编辑，false：不可编辑
	value : '',
	hiddenName : 'servId',
	valueField : 'servId',
	displayField : 'servName',
	typeAhead : true,
	triggerAction : 'all',
	selectOnFocus : true,
	width : 150,
	mode : 'remote' // 从远端获取数据，如果从本地为local
});

// 增加一个可输入服务名称，然后模糊匹配的功能
servCombox.on('beforequery', function(qe) {
	var combo = qe.combo;
	// q is the text that user inputed.
	var q = qe.query;
	// 通过对服务商id 和 服务的名称组合，确定一个记录，下次查询如果跟上次查询的条件一样，就不再继续查询
	var value = servManCombox.getValue() + "&" + q;
	forceAll = qe.forceAll;
	if (forceAll === true || (q.length >= combo.minChars)) {
		if (combo.lastQuery !== value) {
			combo.lastQuery = value;
			if (combo.mode == 'local') {
				combo.selectedIndex = -1;
				if (forceAll) {
					combo.store.clearFilter();
				} else {
					combo.store.filterBy(function(record, id) {
						var text = record.get(combo.displayField);
						// 在这里写自己的过滤代码
						return (text.indexOf(q) != -1);
					});
				}
				combo.onLoad();
			} else {
				searchServ(combo, q, servManCombox.getValue());
			}
		} else {
			combo.selectedIndex = -1;
			combo.onLoad();
		}
	} else {
		// 如果服务商和服务都已选择了，那么对服务名称进行模糊匹配
		if ((q != null && q != '')
				|| (servManCombox.getValue() != null && servManCombox
						.getValue() != '')) {
			searchServ(combo, q, servManCombox.getValue());
		}
	}
	return false;
});
// 通过ajax方式到后台获取服务数据
function searchServ(combo, servName, servManId) {
	Ext.Ajax.request({
		method : 'POST', // 发送方式.'POST'或'GET',一般是'POST'
		url : 'serviceSearch/queryServByName.action', // 发送到页面
		success : function(request) { // 发送成功的回调函数
			var message = request.responseText; // 取得从JSP文件out.print(...)传来的文本
			var data = eval("(" + message + ")");
			combo.store.loadData(data);
			combo.expand();
		},
		failure : function() { // 发送失败的回调函数
			Ext.Msg.alert("错误", "与后台联系的时候出现了问题");
		},
		params : {
			servName : servName,
			tempServManId : servManId
		}
	// 发送名为command和members两参数
	});
}

// 二级联动,联动后，原先数据需要清除
servManCombox.on("select", function(comb) {
	// 由于采用模糊匹配，所以这里就不自动加载
	servCombox.setValue('');
});
// 计算form 宽度
var gridWidth = Ext.getBody().getViewSize().width - 22;
if (screen.width == 1024 && screen.height == 768) {
	gridWidth = Ext.getBody().getViewSize().width - 22;
}
var servName = '';

// 定义查询操作
var queryButton = new Ext.Button({
	align : 'center',
	text : '查询',
	iconCls : 'find',
	handler : queryCheck,
	scope : this
});
// 定义重置操作
var resetButton = new Ext.Button({
	align : 'center',
	text : '重置',
	iconCls : 'resume',
	handler : resetQuery,
	scope : this
});

function queryCheck() {
	var servManId = servManCombox.getValue(); // modified by jch
	// 2009/10/20
	if (servManId == '' || servManId == '-1') {
		servManId = 0;
	}
	servName = servCombox.getRawValue();
	servDefineListStore.baseParams = {
		'servId' : servCombox.getValue(),
		'servName' : servName,
		'servManId' : servManId
	};
	servDefineListStore.load({
		params : {
			'page.start' : 0,
			'page.pageSize' : pageTotal
		}
	}); // 传参供查询调用
}

function resetQuery() {
	servManCombox.setValue('');
	servCombox.setValue('');
}

// 创建表格数据
// 定义复选框选择模式变量：加上选择列
var sm = new Ext.grid.CheckboxSelectionModel();
// 创建Grid表格组件
var gridHeight = 315;
if (Ext.getBody().getViewSize().height - 360 > gridHeight) {
	gridHeight = Ext.getBody().getViewSize().height - 360;
}

var columnWidth = gridWidth - 8;

/** ************************ServDefineListGrid服务定义************************************* */
var servDefineListStore = new Ext.data.Store({// 配置分组数据集
	proxy : new Ext.data.HttpProxy({
		url : "serviceSearch/queryService.action",
		method : 'POST'
	}),
	reader : new Ext.data.JsonReader({
		totalProperty : "page.totalCount",
		root : 'page.result',
		fields : [ {
			name : 'servName'
		}, {
			name : 'versionNo'
		}, {
			name : 'servManName'
		}, {
			name : 'servCode'
		}, {
			name : 'servManCode'
		}, {
			name : 'operName'
		}, {
			name : 'servStat'
		}, {
			name : 'servTypeName'
		}, {
			name : 'wsdlOperId'
		}, {
			name : 'responseWsdl'
		}, {
			name : 'protocolDoc'
		}, {
			name : 'wsdlId'
		}, {
			name : 'servManId'
		}, {
			name : 'servDefineId'
		} ]
	})
});
ServDefineListGrid = Ext.extend(UxGrid, {
	servManLabel : null,
	servLabel : null,
	constructor : function(height, width) {
		this.servManLabel = new Ext.form.Label({
			text : '服务商：'
		});
		this.servLabel = new Ext.form.Label({
			text : '服务：'
		});
		ServDefineListGrid.superclass.constructor.call(this, {
			title : ' 服务列表',
			renderTo : 'grid-div',
			width : Ext.getBody().getViewSize().width - 5,
			height : Ext.getBody().getViewSize().height - 10,// height,
			viewConfig : {
				forceFit : true
			},
			loadMask : {
				msg : '正在载入数据,请稍候...'
			},
			sm : new Ext.grid.RowSelectionModel({
				singleSelect : true
			}),
			tbar : new Ext.Toolbar({
				items : [ this.servManLabel, servManCombox, this.servLabel,
						servCombox, queryButton, resetButton ]
			}),
			bbar : new Ext.PagingToolbar({// 分页工具栏
				store : servDefineListStore,// 改变传给服务端的分页参数名。extjs3.1推荐是在Store
				// 里面定义这个参数，可是我试验却失败了。
				paramNames : {
					start : 'page.start',
					limit : 'page.pageSize'
				},
				pageSize : pageTotal,
				beforePageText : '当前',
				afterPageText : '页/共{0}页',
				displayInfo : true,
				displayMsg : '第 {0} 条到 {1} 条，一共 {2} 条',
				emptyMsg : "没有记录"
			}),
			sm : new Ext.grid.RowSelectionModel({
				singleSelect : true
			}),// 设置复选框选择模式
			store : servDefineListStore,
			cm : new Ext.grid.ColumnModel([// 配置表格列
					new Ext.grid.RowNumberer(),
					{
						header : '系统',
						dataIndex : 'servManName',
						width : 160
					},
					{
						header : '服务名称',
						dataIndex : 'servName',
						width : 160
					},
					{
						header : '服务商ID',
						dataIndex : 'servManId',
						hidden : true
					},
					{
						header : '服务编码',
						dataIndex : 'servCode',
						width : 170
					},
					{
						header : '操作名',
						dataIndex : 'operName',
						width : 100
					},
					{
						header : '服务状态',
						dataIndex : 'servStat',
						renderer : function(data) {
							var str = "";
							if (data == '1')
								str = '<font color=green>' + '已注册' + '</font>';
							else if (data == '2')
								str = '<font color=blue>' + '已发布' + '</font>';
							else if (data == '3')
								str = '<font color=red>' + '已注销' + '</font>';
							else
								str = '<font color=red>' + '已暂停' + '</font>';
							return str;
						},
						width : 100
					},
					{
						header : '版本',
						dataIndex : 'versionNo',
						width : 100
					},
					{
						header : '服务操作ID',
						dataIndex : 'wsdlOperId',
						hidden : true
					},
					{
						header : '服务消息类型',
						dataIndex : 'servTypeName',
						width : 100
					},
					{
						header : '代理服务wsdl',
						dataIndex : 'responseWsdl',
						width : 100,
						renderer : function(val, params, record) {
							var servTypeName = record.get("servTypeName");
							if (servTypeName == 'jms')
								return "";
							else
								return '<a href=javascript:getRequestWsdl()>'
										+ '查看' + '</a>';
						}
					},
					{
						header : '协议文档',
						dataIndex : 'protocolDoc',
						width : 80,
						renderer : getDetilPro
					},
					{
						header : '查看参数',
						dataIndex : '',
						renderer : function() {
							return '<a href=javascript:getDisplayParameter()>'
									+ '查看' + '</a>';
						},
						width : 80
					}, {
						header : '测试',
						dataIndex : '',
						renderer : getDetilRuleNew,
						width : 80
					} ]),
			// 替换json字符串中的特殊符号'<'
			dealStrToJson : function(value) {
				if (value != null && value.indexOf('<') != -1)
					value = value.replace(/</g, '&lt');
				return value;
			}
		})
		servDefineListStore.load({
			params : {
				'page.start' : 0,
				'page.pageSize' : 15
			}
		});
	}
})
function getDetilPro(val, params, record) {
	var servManid = record.get("servManId");
	return '<a href=javascript:detDetailPro("' + servManid + '")>'
			+ '<center>查看</center>' + '</a>';

}
function detDetailPro(servManId) {
	var servManIdValue = servManId;
	var hp = new Ext.data.HttpProxy({
		url : 'register/protocolInfoAction_findProtocolInfo.action'
	});
	var storePro = new Ext.data.Store({// 配置分组数据集
		proxy : hp,
		reader : new Ext.data.JsonReader({
			totalProperty : "page.totalCount",
			root : 'page.result',
			fields : [ 'protocolId', 'protocolName', 'filePath', 'servManId' ]
		})
	});
	var gridWidth = Ext.getBody().getViewSize().width - 200;
	if (screen.width == 1024 && screen.height == 768) {
		gridWidth = Ext.getBody().getViewSize().width - 22;
	}
	var gridHeight = Ext.getBody().getViewSize().height - 130;
	var columnWidth = gridWidth - 8;
	var sm1 = new Ext.grid.CheckboxSelectionModel();
	var gridPro = new Ext.grid.GridPanel({
		title : '协议信息列表',
		width : gridWidth,// Ext.getBody().getViewSize().width
		height : gridHeight,// Ext.getBody().getViewSize().height
		frame : true,
		stripeRows : true,
		bbar : new Ext.PagingToolbar({// 分页工具栏
			store : storePro,
			paramNames : {
				start : 'page.start',
				limit : 'page.pageSize'
			},
			pageSize : 16,
			beforePageText : '当前',
			afterPageText : '页/共{0}页',
			displayInfo : true,
			displayMsg : '第 {0} 条到 {1} 条，一共 {2} 条',
			emptyMsg : "没有记录"
		}),
		sm : sm1,// 设置复选框选择模式
		store : storePro,
		loadMask : true,
		viewConfig : {
			forceFit : true
		},
		columns : [// 配置表格列
		sm1, // 复选框选择模式中的checkbox组件将会显示在该列
		new Ext.grid.RowNumberer(), {
			header : "协议名称",
			width : columnWidth / 9,
			sortable : true,
			dataIndex : 'protocolName',
			name : 'protocolName'
		}, {
			header : "文件路径",
			width : columnWidth / 4,
			sortable : true,
			dataIndex : 'filePath',
			name : 'filePath'
		}, {
			header : "文件查看",
			width : columnWidth / 9,
			sortable : true,
			dataIndex : 'filePath',
			name : 'servName',
			renderer : getDetilProtocol
		} ]
	});
	storePro.baseParams = {
		'protocolInfoDto.servManId' : servManIdValue
	};
	storePro.load({
		params : {
			'page.start' : 0,
			'page.pageSize' : 16
		}
	});
	var width = Ext.getBody().getViewSize().width - 600;
	var height = Ext.getBody().getViewSize().height - 100;
	if (screen.width == 1024 && screen.height == 768) {
		width = Ext.getBody().getViewSize().width - 400;
	}
	dslMapWin = new Ext.Window({ // 新建一个窗口
		title : "协议信息查看",
		layout : 'fit',
		modal : true, // 模式窗口
		width : width,
		height : height,
		minimizable : false,
		maximizable : false,
		resizable : false,
		plain : true,
		listeners : {
			"minimize" : function() {
				this.hide();
			},
			"close" : function() {
				this.close();
			}
		},
		items : [ {
			layout : "column",
			items : [ {
				columnWidth : 1.0,
				layout : "fit",
				items : gridPro
			} ]
		} ]
	});
	dslMapWin.show();
}
function getDetilProtocol(val) {
	var filePath = val.replace(/ /g, "~");
	return '<a href=javascript:detDetailProDownload("' + filePath + '")>'
			+ '<center>下载</center>' + '</a>';
}
function detDetailProDownload(val) {
	var filePath = val.replace(/~/g, " ");
	// window.location.href="serviceSearch/download.action?name=协议文档.doc&path="+encodeURIComponent(filePath)
	downLoadFile(filePath);
}
/** ************************ServDefineListGrid服务定义************************************* */
var servDefineStore = new Ext.data.Store({ // Grid Store
	proxy : new Ext.data.HttpProxy({
		url : "serviceSearch/getProxyUrl.action",
		method : 'POST'
	}),
	reader : new Ext.data.JsonReader({
		root : 'root'
	}, [ {
		name : 'servType'
	}, {
		name : 'proxyUrl'
	} ])
});

// 服务测试
function getDetilRuleNew(val, params, record) {
	var servCode = record.get("servCode");
	var wsdlOperId = record.get("wsdlOperId");
	var servManId = record.get("servManId");
	var servManCode = record.get("servManCode");
	var wsdlId = record.get("wsdlId");
	var servDefineId = record.get("servDefineId");
	var versionNo = record.get("versionNo");
	return '<a href=javascript:detDetailServ("' + wsdlId + '","' + servCode
			+ '","' + servManCode + '","' + wsdlOperId + '","' + servManId
			+ '","' + servDefineId + '","' + versionNo + '")>' + '测试' + '</a>';
}
/** *****************************************查看协议文档******************************************************** */
function getProtocolDoc() {
	var record = serviceListGrid.selectedRecord();
	var filePath = record.get('protocolDoc');

	downLoadFile(filePath);
};
/** *******************************************查看代理服务wsdl****************************************************************** */
function getRequestWsdl() {
	var record = serviceListGrid.selectedRecord();
	var requestWsdlText = new Ext.form.TextArea({
		width : Ext.getBody().getViewSize().width * 0.69,
		readOnly : true,
		height : Ext.getBody().getViewSize().height * 0.82
	});

	var viewWin = new Ext.Window({ // 新建一个窗口
		title : "代理服务wsdl查看",
		layout : 'fit',
		modal : true, // 模式窗口
		width : Ext.getBody().getViewSize().width * 0.705,
		height : Ext.getBody().getViewSize().height * 0.9,
		resizable : false,
		plain : true,
		items : [ {
			items : requestWsdlText
		} ]
	});
	requestWsdlText.setValue(record.get('responseWsdl'));
	viewWin.show();
};
/** ************************************查看参数******************************************************************************** */
function getDisplayParameter() {
	var record = serviceListGrid.selectedRecord();
	var operaId = record.get('wsdlOperId');
	var data = {
		root : [ {
			"operName" : record.get("operName"),
			"servManName" : record.get("servManName"),
			"servName" : record.get("servName"),
			"versionStatName" : record.get("versionStatName"),
			"servCode" : record.get("servCode"),
			"versionNo" : record.get("versionNo")
		} ]
	};
	var displayForm = new DisplayParaForm(parseInt(operaId), data);

	wsdlBaseStore.loadData(data);

	var viewWin = new Ext.Window({ // 新建一个窗口
		title : "查看参数",
		layout : 'fit',
		modal : true, // 模式窗口
		width : 600,
		height : Ext.getBody().getViewSize().height,// 500,
		resizable : false,
		plain : true,
		modal : true,
		autoScroll : true,
		items : displayForm
	});
	viewWin.show();
};

/** ******************************************查看参数form*************************************************** */
DisplayParaForm = Ext.extend(Ext.form.FormPanel, {
	inparaGrid : null,
	outparaGrid : null,
	wsdlBaseGrid : null,
	constructor : function(operaId) {
		// var url
		// ="servReleaseService_getServManIps.action"+selServId.substring(5);
		this.inparaGrid = new WsdlParaInGrid(operaId);
		this.outparaGrid = new WsdlParaOutGrid(operaId);
		this.wsdlBaseGrid = new WsdBaseGrid();
		DisplayParaForm.superclass.constructor.call(this, {
			width : 600,
			height : 500,
			frame : true,
			bodyStyle : "padding: 5px 5px 0",
			defaults : {
				width : 560
			},
			items : [ {
				xtype : "fieldset",
				autoHeight : true,
				title : "访问权限",
				items : [ {
					layout : 'form',
					items : [ {
						xtype : "panel",
						id : 'wsdlBasePanel',
						frame : false,
						bodyStyle : 'padding: 5px',
						items : [ this.wsdlBaseGrid ]
					} ]
				} ]
			}, {
				xtype : "fieldset",
				title : "输入参数",
				items : [ {
					layout : 'form',
					items : [ {
						xtype : "panel",
						id : 'inparaPanel',
						frame : false,
						bodyStyle : 'padding: 5px',
						items : [ this.inparaGrid ]
					} ]
				} ]
			}, {
				xtype : "fieldset",
				title : "输出参数",
				items : [ {
					layout : 'form',
					items : [ {
						xtype : "panel",
						id : 'outparaPanel',
						frame : false,
						bodyStyle : 'padding: 5px',
						items : [ this.outparaGrid ]
					} ]
				} ]
			} ]
		})
	}
});
/** ************************WsdlParaInGrid服务定义************************************* */
var wsdlParaInStore = new Ext.data.Store({ // Grid Store
	proxy : new Ext.data.HttpProxy({
		url : "serviceSearch/getWsdlPara.action",
		method : 'POST'
	}),
	reader : new Ext.data.JsonReader({
		root : 'root'
	}, [ {
		name : 'paraName'
	}, {
		name : 'paraDataType'
	}, {
		name : 'paraNs'
	}, {
		name : 'paraDesc'
	} ])
}),

WsdlParaInGrid = Ext.extend(UxGrid, {
	constructor : function(operaId) {
		WsdlParaInGrid.superclass.constructor.call(this, {
			frame : true,
			renderTo : 'editDiv',
			width : 600,
			height : 100,
			viewConfig : {
				forceFit : true
			},
			loadMask : {
				msg : '正在载入数据,请稍候...'
			},
			sm : new Ext.grid.RowSelectionModel({
				singleSelect : true
			}),
			// cm: new Ext.grid.ColumnModel([new
			// Ext.grid.RowNumberer(),
			cm : new Ext.grid.ColumnModel([ new Ext.grid.RowNumberer(), {
				header : '参数名',
				dataIndex : 'paraName'
			}, {
				header : '参数数据类型',
				dataIndex : 'paraDataType',
				width : 100
			}, {
				header : '参数命名空间',
				dataIndex : 'paraNs',
				width : 100
			}, {
				header : '参数描述',
				dataIndex : 'paraDesc',
				width : 100
			} ]),
			ds : wsdlParaInStore
		}), wsdlParaInStore.load({
			params : {
				'operaId' : operaId,
				'paraType' : 1
			}
		});
	}
});
/** ************************WsdlParaOutGrid服务定义************************************* */
var wsdlParaOutStore = new Ext.data.Store({ // Grid Store
	proxy : new Ext.data.HttpProxy({
		url : "serviceSearch/getWsdlPara.action",
		method : 'POST'
	}),
	reader : new Ext.data.JsonReader({
		root : 'root'
	}, [ {
		name : 'paraName'
	}, {
		name : 'paraDataType'
	}, {
		name : 'paraNs'
	}, {
		name : 'paraDesc'
	} ])
}),

WsdlParaOutGrid = Ext.extend(UxGrid, {
	constructor : function(operaId) {
		WsdlParaOutGrid.superclass.constructor.call(this, {
			frame : true,
			renderTo : 'editDiv',
			width : 600,
			height : 100,
			viewConfig : {
				forceFit : true
			},
			loadMask : {
				msg : '正在载入数据,请稍候...'
			},
			sm : new Ext.grid.RowSelectionModel({
				singleSelect : true
			}),
			cm : new Ext.grid.ColumnModel([ new Ext.grid.RowNumberer(), {
				header : '参数名',
				dataIndex : 'paraName'
			}, {
				header : '参数数据类型',
				dataIndex : 'paraDataType',
				width : 100
			}, {
				header : '参数命名空间',
				dataIndex : 'paraNs',
				width : 100
			}, {
				header : '参数描述',
				dataIndex : 'paraDesc',
				width : 100
			} ]),
			ds : wsdlParaOutStore
		}), wsdlParaOutStore.load({
			params : {
				'operaId' : operaId,
				'paraType' : 2
			}
		});
	}
});
/** ************************基本参数************************************* */
var wsdlBaseStore = new Ext.data.Store({ // Grid Store
	proxy : new Ext.data.HttpProxy({
		url : "serviceSearch/getWsdlPara.action",
		method : 'POST'
	}),
	reader : new Ext.data.JsonReader({
		root : 'root'
	}, [ {
		name : 'servName'
	}, {
		name : 'versionNo'
	}, {
		name : 'servManName'
	}, {
		name : 'operName'
	}, {
		name : 'versionStatName'
	}, {
		name : 'servCode'
	} ])
}),

WsdBaseGrid = Ext.extend(UxGrid, {
	constructor : function() {
		WsdBaseGrid.superclass.constructor.call(this, {
			frame : true,
			renderTo : 'editDiv',
			width : Ext.getBody().getViewSize().width - 5,
			height : Ext.getBody().getViewSize().height * 0.19,
			viewConfig : {
				forceFit : true
			},
			loadMask : {
				msg : '正在载入数据,请稍候...'
			},
			sm : new Ext.grid.RowSelectionModel({
				singleSelect : true
			}),
			// cm: new Ext.grid.ColumnModel([new
			// Ext.grid.RowNumberer(),
			cm : new Ext.grid.ColumnModel([ new Ext.grid.RowNumberer(), {
				header : '系统',
				dataIndex : 'servManName',
				width : 160
			}, {
				header : '服务名称',
				dataIndex : 'servName',
				width : 160
			}, {
				header : '服务编码',
				dataIndex : 'servCode',
				width : 170
			}, {
				header : '操作名',
				dataIndex : 'operName',
				width : 100
			}, {
				header : '服务状态',
				dataIndex : 'versionStatName',
				width : 100
			}, {
				header : '版本',
				dataIndex : 'versionNo',
				width : 100
			} ]),
			ds : wsdlBaseStore
		})
	}
});
