/**
 * 用户信息
 * 
 * @author Qinaldo
 * @created 2009年2月18日12:43:28
 */

Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif';  //本地图形化

var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';     //需要补充的空格

var USERINFO_STORE_URL = 'getUserByOrganId.action';
var USERROLEINFO_STORE_URL = 'getRoleByOrganId.action';

var userGrid;
var userRoleGrid;
var organTree;
var userGridCount;
var PAGESIZE = 10;
var oldOrganId;

/***************************************UserRoleGrid组件***************************************************/
UserRoleGrid = Ext.extend(Ext.grid.GridPanel, {
    
    userRoleStore: new Ext.data.Store({
        proxy: new Ext.data.HttpProxy({url: USERROLEINFO_STORE_URL, method: 'POST'}),
        reader: new Ext.data.JsonReader({},[{name:'roleId'},{name:'name'}])
    }),
    userRoleSm: new Ext.grid.CheckboxSelectionModel({header:'',handleMouseDown:Ext.emptyFn}),
    
    constructor: function() {
        UserRoleGrid.superclass.constructor.call(this, {
            renderTo: 'UserRoleGrid',
            title: '角色信息',
            frame: true,
            width: 190,
            height: Ext.getBody().getViewSize().height - 10,
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            sm: this.userRoleSm,
            cm: new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
                this.userRoleSm,
                {header:'id',dataIndex:'roleId',width:120,hidden:true},
                {header:'名称',dataIndex:'name',width:120}
            ]),
            ds: this.userRoleStore,
            bbar: [
                '-', {text: '角色管理', iconCls: 'link', handler:this.onLinkRole, scope: this}
            ],
            listeners: {
                'cellclick': { fn: this.gridCellClick, scope: this}
            }
        });
    },
    onLinkRole: function() {
    	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
                    parent.mainPanel.loadMenuByMenuId(2002);					//角色管理
			}
    	});
    },
    gridCellClick: function(grid, rowIndex, columnIndex, e) {
       /*var r = userGrid.getSelectionModel().getSelected();
       if(typeof(r) === 'undefined') {
           Ext.Msg.alert('系统提示', blankStr + '请选择一条用户记录' + blankStr);
           return;
       }
       if(columnIndex == 1) {
           var record = grid.getStore().getAt(rowIndex); 
           var status = grid.getSelectionModel().isSelected(record);
           if(status) {
               UserInfoManager.saveUserRoleInfo(r.data.userID, record.data.roleId,function(data) {
                
               });
            } else {
                UserInfoManager.delUserRoleInfo(r.data.userID, record.data.roleId,function(data) {
                  
                });
            }
       }*/
    	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
			       var r = userGrid.getSelectionModel().getSelected();
			       if(typeof(r) === 'undefined') {
			           Ext.Msg.alert('系统提示', blankStr + '请选择一条用户记录' + blankStr);
			           return;
			       }
			       if(columnIndex == 1) {
			           var record = grid.getStore().getAt(rowIndex); 
			           var status = grid.getSelectionModel().isSelected(record);
			           if(status) {
			               UserInfoManager.saveUserRoleInfo(r.data.userID, record.data.roleId,function(data) {
			                
			               });
			            } else {
			                UserInfoManager.delUserRoleInfo(r.data.userID, record.data.roleId,function(data) {
			                  
			                });
			            }
			       }
			}
    	});
    }
});


function changeStyle(style) {
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + style + ".css");
}

/*********************onReady 组件渲染及处理*************************************************/
Ext.onReady(function() {
    
    Ext.QuickTips.init();
    Ext.form.Field.prototype.msgTarget = 'side';
    
    Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + window.parent.styleCssValue);
    
    Ext.Ajax.on('requestcomplete',checkUserSessionStatus, this); 
	function checkUserSessionStatus(conn,response,options) {     
        var sessionStatus = response.getResponseHeader["sessionstatus"];       
        if(typeof(sessionStatus) != "undefined"){   
            Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
			    if (btn == 'ok'){   
			        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
			        window.location = redirect;   
			    }   
            });   
         }     
    }   
    
    userGrid = new UserGrid(Ext.getBody().getViewSize().height -10, Ext.getBody().getViewSize().width -420);
    userGrid.render('UserGrid');
    userGrid.setTitle('用户信息');
    userGrid.userPageFlag = true;       //标识是用户页面
    userRoleGrid = new UserRoleGrid();
    
    organTree = new OrganTree();
    // modified by jch
    //organTree.getRootNode().expand();
  	var root = organTree.getRootNode();
    //root.id = document.getElementById('organId').value; 
    //root.setText(document.getElementById('organName').value);
  	 // modified by jch
    // 判断当前用户所在区域是否是省中心 0-省中心
    if(String(document.getElementById('tmlId').value) != '0') {
	    root.id = document.getElementById('organId').value; 
	    root.setText(document.getElementById('organName').value);
    }
    root.expand();
    // modified by jch
    organTree.getSelectionModel().select(organTree.getRootNode());
    
    organTree.on('click', function(node, e) {
    	var bbarItems = userGrid.getBottomToolbar().items;	//bbar下的按钮
    	var nodeId = node.id.substring(6);
    	var userName = userGrid.userNameTf.getValue();
    	var userID = userGrid.userIDTf.getValue();
    	
    	if(node != organTree.getRootNode()) {
    		for (i = 0, len = bbarItems.length; i < len; i++) {
    			bbarItems.itemAt(i).enable();
    		}
            userGrid.organCombo.setValue(nodeId);
    		userGrid.store.load({params: {start: 0, limit: PAGESIZE, recordCount: -1, organId: nodeId, userName:userName, userID:userID}});
    		userRoleGrid.store.load({params: {organId: node.id,pOrganId:node.attributes.pid}});
    	} else {
    		userGrid.organCombo.setValue(-1);
    		userGrid.store.load({params: {start: 0, limit: PAGESIZE, recordCount: -1,organId: nodeId,userName:userName, userID:userID}});
    		userRoleGrid.store.removeAll();
    	}
    });
    userGrid.store.on('beforeload', function() {
    	var selNode = organTree.getSeletedNode();
        var nodeId = selNode.id.substring(6);
        var organId = userGrid.organCombo.getValue();
        if(nodeId !== organId)
            nodeId = organId;
        var userName = userGrid.userNameTf.getValue();
        var userID = userGrid.userIDTf.getValue();
        Ext.apply(this, {baseParams:{recordCount: -1, organId: nodeId,userName:userName, userID:userID}});
    });
});

