/**
* 用户信息列表Grid
* @author pbqi
* @created on 2009年7月2日11:30:11
*/

/***************************************UserForm组件**************************************************/
UserForm = Ext.extend(Ext.ux.Form, {
    
    IdTextField: null,          //"用户标识" 文本框
    NameTextField: null,        //"用户名称" 文本框
    MaleRadio: null,            //"男" 单选按钮
    FeMaleRadio: null,          //"女" 单选按钮
    PhoneTextField: null,       //"电话" 文本框
    MobileTextField: null,      //"手机号码" 文本框
    EmailTextField: null,       //"电子邮箱" 文本框
    ForEverRadio: null,         //"永不过期" 单选按钮
    DefineRadio: null,          //"自定义" 单选按钮
    LimitDateField: null,       //'期限'DateField
    remarkTextField: null,      //备注
    userGrid : null,            //userGrid 用户Grid
    constructor: function(grid) {
        
    	this.userGrid = grid;      //获得userGrid
    	
        this.IdTextField = this.createTextFiled("用户标识",'userID','80%','该选项为必填项,请输入内容...', "usercode");
        this.NameTextField = this.createTextFiled("名称", 'userName', '80%',"用户名称不能为空！",null,15,"用户名称最大长度为15");
        this.MaleRadio = this.createRadio("男",'sex',true,0);
        this.FeMaleRadio = this.createRadio("女",'sex',false,1);
        this.PhoneTextField = this.createTextFiled("电话", 'phone','80%', "电话不能为空！", "phone");
        this.PhoneTextField.allowBlank = true;
        this.MobileTextField = this.createTextFiled("手机号码", 'mobile','80%', "手机号码不能为空！", "mobile");
        this.MobileTextField.allowBlank = true;
        this.EmailTextField = this.createTextFiled("电子邮箱", 'email', '80%',"电子邮箱不能为空！", "email", 50, "电子邮箱最大长度为50");
        this.EmailTextField.allowBlank = true;
        this.ForEverRadio = this.createRadio("永不过期",'limitTimeType',false,0);
        this.DefineRadio = this.createRadio("自定义",'limitTimeType',true,1);
        this.LimitDateField = this.createDateField("有效期", 'limitTime','Y-m-d','80%','已超过使用的有效期限!');
        this.remarkTextField =  this.createTextFiled("备注", 'remark','80%');
        this.remarkTextField.allowBlank = true;
        this.DefineRadio.on('check', function(radio, checked) {
        	var LimitDtf = this.LimitDateField;
            if(checked) {
               LimitDtf.enable(); 
               LimitDtf.focus();
            } else {
                LimitDtf.disable();
                LimitDtf.setValue('');
            }
        }, this);
       
        this.LimitDateField.minValue = new Date();  //有效期限要大于等于今天
        
        UserForm.superclass.constructor.call(this, {
            width: 350,
            height: 300,
            labelWidth: 55,
            frame: true,
            bodyStyle:"padding: 5px 5px 0",
            items:[this.IdTextField, this.NameTextField, {
                fieldLabel:"性别",
                xtype:"panel",
                labelWidth: 1,
                layout:"column",
                isFormField:true,
                labelAlign:"left",
                items: [{
                    columnWidth:.5,
                    layout:"form",
                    labelAlign:"right",
                    items:this.MaleRadio
                },{
                    columnWidth:.5,
                    layout:"form",
                    labelAlign:"right",
                    items:this.FeMaleRadio
                }]
            },this.PhoneTextField, this.MobileTextField,this.EmailTextField,{
                fieldLabel:"期限类型",
                xtype:"panel",
                labelWidth: 1,
                layout:"column",
                isFormField:true,
                labelAlign:"left",
                items: [{
                    columnWidth:.4,
                    layout:"form",
                    labelAlign:"right",
                    items:this.ForEverRadio
                },{
                    columnWidth:.6,
                    layout:"form",
                    labelAlign:"right",
                    items:this.DefineRadio
                }]
            },this.LimitDateField,this.remarkTextField],
            buttons: [
               {text: '添加', id: 'add_user_btn', iconCls: 'new',width: 20, hidden: false, handler: this.addFormClick, scope: this},
               {text: '修改', id: 'update_user_btn',width: 20,iconCls:'update', hidden: true, handler: this.updateFormClick, scope: this},
               {text: '重置', id: 'resume_user_btn',width: 20,iconCls:'resume', hidden: true, handler: this.onResumeClick, scope: this},               
               {text: '清空', id: 'reset_user_btn',width: 20, iconCls:'refresh',  handler: this.resetFormClick, scope: this},
               {text: '关闭', id: 'close_user_btn',width: 20,iconCls:'close', handler: this.onCloseClick, scope: this}
            ]
        })
     },
    onResumeClick: function() {
        var record = this.userGrid.selectedRecord();
        this.getForm().loadRecord(record);
            //处理日期格式
        var limitTime = record.data.limitTime;
        if(limitTime == null || limitTime == '') {
            this.LimitDateField.disable();
        } else {
            this.LimitDateField.enable();
            if(limitTime.constructor && limitTime.constructor == Date) {
                limitTime = Ext.util.Format.date(limitTime, 'Y-m-d');
            } else if (limitTime.constructor && limitTime.constructor == Object) {
                limitTime = formatDate(new Date(limitTime["time"]),"yyyy-MM-dd");
            }
            this.LimitDateField.setValue(limitTime);
        }
        
        this.IdTextField.disable();
    },
    onCloseClick: function(){
        this.ownerCt.hide();
    },
    addFormClick: function() {      //添加用户
    	var userGrid = this.userGrid;
    	
        var userId = this.IdTextField.getValue();
        var name = this.NameTextField.getValue();
        var phone = this.PhoneTextField.getValue();
        var modile = this.MobileTextField.getValue();
        var email = this.EmailTextField.getValue();
        var organId = organTree.getSeletedNode().id.substring(6);
        var organName = organTree.getSeletedNode().text;
        var remark = this.remarkTextField.getValue();
        var limitTime = this.LimitDateField.getValue();
        if(limitTime == '')
            limitTime = null;
        var sex;
        if(this.MaleRadio.getValue())
            sex = 0;
        else 
            sex = 1;
        if(this.ForEverRadio.getValue()) 
            limitTimeType = 0;
        else {
            limitTimeType = 1;
        }
        if(limitTimeType == 1 && limitTime == null) {
            Ext.Msg.alert('系统提示:', "有效期不能为空,请选择日期时间！");
            return;
        }
        if(this.getForm().isValid()) {
            UserInfoManager.findByUserId(userId, function(datax){
               if(datax) {
                   UserInfoManager.save(userId, name, sex, phone, modile,email,organId, limitTime, limitTimeType, remark,function(data){
                       if(data != null) {
                           Ext.MessageBox.alert("系统提示:", blankStr + "添加成功" + blankStr);
                           userGrid.insertUserWindow.hide();
                           var UserRecord = new Ext.data.Record.create([{name:'userID'},{name:'userName'},
                           	    {name:'sex'},{name:'phone'},{name:'mobile'},{name:'organID'},{name:'organName'},
                           	    {name:'email'},{name:'limitTime'},{name:'limitTimeType'},{name:'delFlag'},{name:'remark'}]);
                           var newRecord = new UserRecord({
                               userID: data,
                               userName: name,
                               organName: organName,
                               sex: sex,
                               phone: phone,
                               mobile: modile,
                               email: email,
                               organID: organId,
                               limitTime: limitTime,
                               limitTimeType: limitTimeType,
                               delFlag : 0
                           });
                           userGrid.store.insert(0,newRecord);
                           userGrid.getView().refresh();
                       } else {
                           Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
                       }
                   });
                   if(userGrid.rolePageFlag) {
                       var selReocrd = roleGrid.getSelectionModel().getSelected();  //被选择的记录
                   }
               } else {
                   Ext.MessageBox.alert('系统提示：', blankStr + "用户标识已存在,应唯一！" + blankStr);
               }
            });
        }
       /* else{//add 提示
        	 if(userId==''){
        	     Ext.Msg.alert('系统提示:', blankStr +"用户标识不能为空！" + blankStr);
                 return;
             }
             if(name==''){
        	     Ext.Msg.alert('系统提示:', blankStr +"名称不能为空且最大长度为15！" + blankStr);
                 return;
             }
             if(!this.PhoneTextField.isValid()){
        	     Ext.Msg.alert('系统提示:', blankStr +"电话不能为空，并请注意书写格式！" + blankStr);
                 return;
             }
             if(!this.MobileTextField.isValid()){
        	     Ext.Msg.alert('系统提示:', blankStr +"手机号码不能为空，并请注意书写格式！" + blankStr);
                 return;
             }
             if(!this.EmailTextField.isValid()){
        	     Ext.Msg.alert('系统提示:', blankStr +"邮箱不能为空，并请注意书写格式！" + blankStr);
                 return;
             }
        }*/
    },
    updateFormClick: function() {       //修改用户
    	var userGrid = this.userGrid;      //userGrid;
        var userId = this.IdTextField.getValue();
        var name = this.NameTextField.getValue();
        var phone = this.PhoneTextField.getValue();
        var mobile = this.MobileTextField.getValue();
        var email = this.EmailTextField.getValue();
//        var organId = organTree.getSeletedNode().id.substring(6);
        var organId = userGrid.selectedRecord().data.organID;
        var remark = this.remarkTextField.getValue();
        var limitTime = this.LimitDateField.getValue();
        if(limitTime == '')
            limitTime = null;
            
        if(this.ForEverRadio.getValue()) 
            limitTimeType = 0;
        else {
            limitTimeType = 1;
        }
        
        var sex;
        if(this.MaleRadio.getValue())
            sex = 0;
        else 
            sex = 1;
        
        if(limitTimeType == 1 && limitTime == null) {
            Ext.Msg.alert('系统提示:', "有效期不能为空,请选择日期时间！");
            return;
        }
        /*if(userId==''){
        	Ext.Msg.alert('系统提示:', blankStr +"用户标识不能为空！" + blankStr);
            return;
        }
        if(name==''){
        	Ext.Msg.alert('系统提示:', blankStr +"名称不能为空且最大长度为15！" + blankStr);
            return;
        }
        if(!this.PhoneTextField.isValid()){
        	Ext.Msg.alert('系统提示:', blankStr +"电话不能为空，并请注意书写格式！" + blankStr);
            return;
        }
        if(!this.MobileTextField.isValid()){
        	Ext.Msg.alert('系统提示:', blankStr +"手机号码不能为空，并请注意书写格式！" + blankStr);
            return;
        }
        if(!this.EmailTextField.isValid()){
            Ext.Msg.alert('系统提示:', blankStr +"邮箱不能为空，并请注意书写格式！" + blankStr);
            return;
        }*/
        function updateForm() {         //修改表单函数
            UserInfoManager.update(userId, name, sex, phone, mobile,email, organId, limitTime, limitTimeType, remark,function(data){
               if(data) {
                    record.data.userName = name;
                    record.data.sex = sex;
                    record.data.phone = phone;
                    record.data.mobile = mobile;
                    record.data.organID = organId ;
                    record.data.email =email;
                    record.data.limitTime = limitTime;
                    record.data.limitTimeType = limitTimeType;
                    record.data.remark = remark;
                    Ext.MessageBox.alert("系统提示:", blankStr + "修改成功" + blankStr);
                    userGrid.updateUserWindow.hide();
                    userGrid.refresh();
                    
               } else {
                   Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
               }
            });
        }
        var record = userGrid.selectedRecord();
        
        if(this.getForm().isValid()) {
           if(record.data.userName == name && record.data.sex == sex && record.data.phone == phone && record.data.mobile == mobile && record.data.email == email && record.data.limitTime == limitTime && record.limitTimeType == limitTimeType) {
               Ext.MessageBox.alert("系统提示：", blankStr + "你未做任何改变！" + blankStr);
           } else {
                updateForm();
           }
        }
    },
    resetFormClick: function() {        //清空
        this.getForm().reset();
        if(this.ownerCt.title == '修改用户窗口') {
            var record = this.userGrid.selectedRecord();
            this.IdTextField.setValue(record.data.userID);
        }
    }
});

/***************************************InsertUserWindow组件**************************************************/
InsertUserWindow = Ext.extend(Ext.Window,{
    
    userForm : null,
    
    constructor: function(grid) {
        
        this.userForm = new UserForm(grid);
        
        InsertUserWindow.superclass.constructor.call(this, {
            title: "新建用户窗口",
            width: 370,
            height: 340,
            resizable : false,
            plain: true,
            modal: true,
            autoScroll: true,
            closeAction: 'hide',
            items: [this.userForm]
        });
    }
});

/***************************************UpdateUserWindow组件**************************************************/
UpdateUserWindow = Ext.extend(Ext.Window, {
	
	userForm : null,
    constructor: function(grid) {
    	
    	this.userForm = new UserForm(grid);
    	
        Ext.getCmp('add_user_btn').hide();      //隐藏添加按钮
        Ext.getCmp('update_user_btn').show();   //显示修改按钮
        Ext.getCmp('reset_user_btn').hide();   //隐藏清空按钮
        Ext.getCmp('resume_user_btn').show();   //显示重置按钮
        
        UpdateUserWindow.superclass.constructor.call(this, {
        	title: "修改用户窗口",
            width: 370,
            height: 340,
            resizable : false,
            plain: true,
            modal: true,
            autoScroll: true,
            closeAction: 'hide',
            items: [this.userForm]
        });
    }
});


/**************************UserGrid**************************************/
UserGrid = Ext.extend(UxGrid, {
    
    insertUserWindow : null,
    updateUserWindow : null,
    rightMenu        : null,
    organCombo       : null,
    organLabel       : null,
    
    constructor: function(height, width) {
        
    	this.STORE_URL = "getUserByOrganId.action";    //Grid Store请求的url地址
    	this.userStore = new Ext.data.Store({          //Grid Store
            proxy: new Ext.data.HttpProxy({url: this.STORE_URL, method: 'POST'}),
            reader: new Ext.data.JsonReader({totalProperty: 'totalProperty', root:'root'},[
            	 {name:'userID'},{name:'userName'},{name:'sex'},{name:'phone'},{name:'mobile'},
                 {name:'organID'},{name:'email'},{name:'organName'},{name:'delFlag'},
                 {name:'limitTimeType'},{name:'limitTime'},{name:'remark'}
            ])
        }),
    	
        this.rightMenu = new Ext.menu.Menu({
            items: [
                {text: '修改用户',iconCls: 'update',handler: this.onModifyClick,scope: this},
                {text: '删除用户',iconCls: 'delete',handler: this.onDeleteClick,scope: this},'-',
                {text: '恢复原始密码',iconCls: 'password',handler: this.onRePswClick,scope: this}
            ]
        });
        
        this.insertUserWindow = new InsertUserWindow(this);
        this.updateUserWindow = new UpdateUserWindow(this);
        
        this.userNameTf = this.createTextFiled("userName",90);
        this.userIDTf = this.createTextFiled("userID",90);
        this.organLabel = new Ext.form.Label({
            text: '机构：'
        }),
        this.organCombo = this.createCombo("organId","name","getOrganCombo.action",100);
        this.organCombo.store.load();
        this.organCombo.on('select', this.onOrganComboSelect, this);
        
        UserGrid.superclass.constructor.call(this, {
            frame: true,
            width: width,
            height: height,
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            sm: new Ext.grid.RowSelectionModel({singleSelect:true}),
            cm: new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
                {header:'机构',dataIndex:'organName',width:120,hidden:false,sortable: true},
                {header:'用户标识',dataIndex:'userID',width:120,sortable: true},
                {header:'姓名',dataIndex:'userName',width:120,sortable: true},//yhzhang
                {header:'性别',dataIndex:'sex',width:50,hidden:true,renderer:this.sexChange,scope:this},
                {header:'电话',dataIndex:'phone',width:120},
                {header:'手机号码',dataIndex:'mobile',width:120},
                {header:'邮箱',dataIndex:'email',width:120,hidden:true},
                {header:'是否删除',dataIndex:'delFlag',width:60,hidden:false,renderer: this.delChange, scope: this},
                {header:'期限类型',dataIndex:'limitTimeType',width:50,hidden:true},
                {header:'有效期',dataIndex:'limitTime',width:120,hidden:false,renderer:this.formatTime,scope:this},
                {header:'备注',dataIndex:'remark',width:120,hidden:true}
            ]),
            bbar: new Ext.PagingToolbar({
                firstText:'第一页',
                nextText:'下一页',
                prevText:'上一页',
                refreshText:'刷新',
                lastText:'最后一页',
                beforePageText: '当前',
                afterPageText:'页/共{0}页',
                pageSize:PAGESIZE,
                store:this.userStore,
                displayInfo:false, 
                dsiplayMsg:'本页显示 {0} - {1},共{2}条记录',
                emptyMsg:"没有可显示的记录",
                items:['-',
                    {text:'添加',id: 'bbar_newUser', iconCls: 'new', handler:this.onAddClick,scope:this},'-',
                    {text:'修改',id: 'bbar_updateUser',iconCls: 'update',handler:this.onModifyClick,scope:this},'-',
                    {text:'生效/禁用',id: 'bbar_deleteUser',iconCls: 'delete',handler:this.onDeleteClick,scope:this}, '-',
                    {text:'恢复初始密码',id: 'bbar_password',iconCls: 'password',handler:this.onRePswClick,scope:this}
                ]
            }),
            tbar: new Ext.Toolbar({
                items:[
                '-',this.organLabel, this.organCombo,
                '-','用户姓名：', this.userNameTf,
                '-','用户标识：', this.userIDTf,
                '-',{iconCls: 'find', id: 'findUserIcon', handler: this.queryHandler, scope: this}]
            }),
            ds: this.userStore,
            listeners: {
                "dblclick": { fn: this.onModifyClick, scope: this},
                "cellclick": { fn: this.gridCellClick, scope: this},
                "rowcontextmenu": {fn: this.onRightMenuClick, scope: this}
            }
        });
    },
    queryHandler: function() {  //查询
        var organId = this.organCombo.getValue();
        var userName = this.userNameTf.getValue();
        var userID = this.userIDTf.getValue();
        this.store.load({params: {start:0, limit:PAGESIZE, recordCount: -1, organId:organId, userName:userName, userID: userID}});
    },
    onOrganComboSelect: function(combo, record, index) {
        var organId = combo.getValue();
        var userName = this.userNameTf.getValue();
        var userID = this.userIDTf.getValue();
        this.store.load({params: {start:0, limit:PAGESIZE, recordCount: -1, organId:organId, userName:userName, userID: userID}});
    },
    onRightMenuClick: function(grid, rowIndex, e) {
        this.getSelectionModel().selectRow(rowIndex);
        this.fireEvent("cellclick", grid, rowIndex);
        e.preventDefault();
        this.rightMenu.showAt(e.getXY());
    },
    gridCellClick: function() {
        var r = this.getSelectionModel().getSelections();
        if(this.userPageFlag) {
            if(r.length == 1) {
            	var newOrganId = r[0].data.organID;
            	if(oldOrganId !== newOrganId) {
            		userRoleGrid.store.load({params:{organId: newOrganId}});
            	}
                var newUserGridId = r[0].data.userID;
                userRoleGrid.getSelectionModel().clearSelections();
                UserInfoManager.findUserRoleInfo(newUserGridId,function(data){
                    var store = userRoleGrid.getStore();
                    for(var i=0; i<data.length; i++){
                        var idIndex = store.find('roleId',data[i]);
                        userRoleGrid.getSelectionModel().selectRow(idIndex, true);                 
                    }
                });
            }
            oldOrganId = newOrganId; 
        }
    },
    onRePswClick: function() {  //恢复初始密码
        /*var record = this.selectedRecord();
        if(record) {
            Ext.MessageBox.confirm('系统提示:','你确定要恢复所选用户的原始密码吗？',function(btn){
                if(btn == 'yes') {
                    UserInfoManager.resumePassword(record.data.userID, function(data) {
                        if(data) {
                            Ext.MessageBox.alert('系统提示:', blankStr + '恢复原始密码成功！' + blankStr);
                        } else {
                            
                        }
                    });
                }
            });
        }*/
    	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
		        if(undefined == userGrid.selectedRecord()) {
		        	Ext.Msg.alert('系统提示', blankStr + '请选择一条用户记录' + blankStr);
		        	return;
		        }else{
		        	var record = userGrid.selectedRecord();
		            Ext.MessageBox.confirm('系统提示:','你确定要恢复所选用户的原始密码吗？',function(btn){
		                if(btn == 'yes') {
		                    UserInfoManager.resumePassword(record.data.userID, function(data) {
		                        if(data) {
		                            Ext.MessageBox.alert('系统提示:', blankStr + '恢复原始密码成功！' + blankStr);
		                        } else {
		                            Ext.MessageBox.alert('系统提示:', blankStr + '只能恢复自己的密码！' + blankStr);
		                        }
		                    });
		                }
		            });
		        }
			}
    	});
    },
    onAddClick: function() {
        /*if(!organTree.getSeletedNode()) {
            Ext.MessageBox.alert('系统提示:', '请选择左边机构树上的机构...');
            return;
        } 
        var win = this.insertUserWindow;
        win.userForm.getForm().reset();
        win.show();*/
    	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
			    	if(!organTree.getSeletedNode()) {
			            Ext.MessageBox.alert('系统提示:', '请选择左边机构树上的机构...');
			            return;
			        }
			        if(organTree.getSeletedNode().id.substring(6) == 'root'){
			        	Ext.Msg.alert('系统提示:', '请选择新增用户的具体所在机构...');
			        	return;
			        }
			        var win = userGrid.insertUserWindow;
			        win.userForm.getForm().reset();
			        win.show();
			}
    	});
    },
    onModifyClick: function() {
        /*var selNode = organTree.getSeletedNode();
        if(!selNode) {
            Ext.MessageBox.alert('系统提示:', '请选择左边机构树上的机构...');
            return;
        }
        if(selNode === organTree.getRootNode()) 
            return;
        var record = this.selectedRecord();
        
        var win = this.updateUserWindow;
        var form = win.userForm;
        
        if(record) {
            win.show();
            var limitTime = record.data.limitTime;
            form.getForm().loadRecord(record);
            if(record.data.limitTimeType == 0) {
                form.ForEverRadio.checked = true;
                form.DefineRadio.checked = false;
                form.LimitDateField.disable();
            } else {
                form.LimitDateField.enable();
                if(limitTime.constructor && limitTime.constructor == Date) {
                    limitTime = Ext.util.Format.date(limitTime, 'Y-m-d');
                } else if (limitTime.constructor && limitTime.constructor == Object) {
                    limitTime = formatDate(new Date(limitTime["time"]),"yyyy-MM-dd");
                }
                form.LimitDateField.setValue(limitTime);
                form.ForEverRadio.checked =false;
                form.DefineRadio.checked = true;
            }
            form.IdTextField.disable();
        } else {
            Ext.Msg.alert('系统提示', blankStr + '请选择一条用户记录' + blankStr);
        }*/
    	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
		    	var selNode = organTree.getSeletedNode();
		        if(!selNode) {
		            Ext.MessageBox.alert('系统提示:', '请选择左边机构树上的机构...');
		            return;
		        }
//		        if(selNode === organTree.getRootNode()) 
//		            return;
//		        			        
		        if(undefined == userGrid.selectedRecord()) {
		        	Ext.Msg.alert('系统提示', blankStr + '请选择一条用户记录' + blankStr);
		        	return;
		        } else {
		            var record = userGrid.selectedRecord();
			        var win = userGrid.updateUserWindow;
			        var form = win.userForm;
		            win.show();
		            var limitTime = record.data.limitTime;
		            form.getForm().loadRecord(record);
		            if(record.data.limitTimeType == 0) {
		                form.ForEverRadio.checked = true;
		                form.DefineRadio.checked = false;
		                form.LimitDateField.disable();
		            } else {
		                form.LimitDateField.enable();
		                if(limitTime.constructor && limitTime.constructor == Date) {
		                    limitTime = Ext.util.Format.date(limitTime, 'Y-m-d');
		                } else if (limitTime.constructor && limitTime.constructor == Object) {
		                    limitTime = formatDate(new Date(limitTime["time"]),"yyyy-MM-dd");
		                }
		                form.LimitDateField.setValue(limitTime);
		                form.ForEverRadio.checked =false;
		                form.DefineRadio.checked = true;
		            }
			        form.IdTextField.disable();
			    }
			}
    	});
    },
    //last modify fxy 2011-1-13
    onDeleteClick: function() {
        /*if(!organTree.getSeletedNode()) {
            Ext.MessageBox.alert('系统提示:', '请选择左边机构树上的机构...');
            return;
        }
        var that = this; 
        var record = this.selectedRecord();
        var tipInfo = "";
        var delFlag = record.data.delFlag;
        tipInfo = delFlag === 0 ? "你确定要禁用所选用户吗?" : "你确定要恢复所选已禁用用户吗?";
        var delSucInfo = delFlag === 0 ? "禁用成功！" : "用户已生效！";
        if(record) {
            Ext.MessageBox.confirm('系统提示:',tipInfo,function(btn){
                if(btn == 'yes') {
                	delFlagx = (delFlag === 0) ? 1 : 0 ;
                    UserInfoManager.deleteUser(record.data.userID, delFlagx, function(data){
                       if(data) {
                           Ext.MessageBox.alert("系统提示:", blankStr + delSucInfo + blankStr);
                           //that.remove(record);
                           record.data.delFlag = delFlagx;
                           that.getView().refresh();
                           if(that.userPageFlag)
                              userRoleGrid.getSelectionModel().clearSelections();
                       }
                    });
                }
            });
        } else {
             Ext.Msg.alert('系统提示', blankStr + '请选择一条用户记录' + blankStr);
        }*/
    	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
		    	if(!organTree.getSeletedNode()) {
		            Ext.MessageBox.alert('系统提示:', '请选择左边机构树上的机构...');
		            return;
		        }
		        var that = userGrid; 
		        if(undefined == userGrid.selectedRecord()){
		        	Ext.Msg.alert('系统提示', blankStr + '请选择一条用户记录' + blankStr);
		        	return;
		        }else{
		        	var record = userGrid.selectedRecord();
			        var tipInfo = "";
			        var delFlag = record.data.delFlag;
			        tipInfo = delFlag === 0 ? "你确定要禁用所选用户吗?" : "你确定要恢复所选已禁用用户吗?";
			        var delSucInfo = delFlag === 0 ? "禁用成功！" : "用户已生效！";
			        Ext.MessageBox.confirm('系统提示:',tipInfo,function(btn){
		                if(btn == 'yes') {
		                	delFlagx = (delFlag === 0) ? 1 : 0 ;
		                    UserInfoManager.deleteUser(record.data.userID, delFlagx, function(data){
		                       if(data) {
		                           Ext.MessageBox.alert("系统提示:", blankStr + delSucInfo + blankStr);
		                           //that.remove(record);
		                           record.data.delFlag = delFlagx;
		                           that.getView().refresh();
		                           if(that.userPageFlag)
		                              userGrid.getSelectionModel().clearSelections();
		                       }
		                    });
		                }
		            });
		        }
			}
    	});
    }, 
    selectedRecord: function() {
        var record = this.getSelectionModel().getSelected();
        return record;
    },
    refresh: function(){
        this.getView().refresh();
    },
    remove:function(record){
        this.getStore().remove(record);
    },
    sexChange: function(sex) {
    	return sex === 0 ? "男" : "女";
    },
    formatTime : function(val) {
        if(val) {
            var valStr = val.constructor == Date ? Ext.util.Format.date(val, 'Y-m-d') : formatDate(new Date(val["time"]),"yyyy-MM-dd");         
            var valArr = valStr.split('-');
            var valDate = new Date(valArr[0], valArr[1] - 1, valArr[2]);
            var dt = new Date();
            return (valDate.getTime() >= (new Date(dt.getFullYear(), dt.getMonth(), dt.getDate())).getTime()) ? '<font color=red>' + valStr + '</font>' : '<font color=red>' + '已过期' + '</font>' ;
        } else  {
            return '<font color=blue>永不过期</font>';
        }
    },
    delChange: function(val) {
    	return val === 0 ? "未删除": "<font color=red>已删除</font>";
    }
});