
Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif';          //本地图形化

var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';  //需要补充的空格

var ONLINEUSER_STORE_URL = 'getOnlineUserInfo.action';
var onlineUserGrid;

/***************************************onlineUserGrid组件***************************************************/
OnlineUserGrid = Ext.extend(Ext.grid.GridPanel, {
    
    onlineUserStore: new Ext.data.GroupingStore({
        proxy: new Ext.data.HttpProxy({url: ONLINEUSER_STORE_URL, method: 'POST'}),
        reader: new Ext.data.JsonReader({fields:[{name:'userId',mapping:'userId'},{name:'userName',mapping:'userName'},{name:'organName',mapping:'organName'},{name:'organId',mapping:'organId'},{name:'tmlName',mapping:'tmlName'}]}),
        sortInfo:{field: 'organId', direction: "ASC"},   
        groupField:'tmlName'  
    }),
 
    constructor: function() {
        OnlineUserGrid.superclass.constructor.call(this, {
            renderTo: 'OnlineUserGrid',
            title: '在线用户信息',
            frame: true,
        	animCollapse: false, 
        	iconCls: 'icon-grid',   
            width: Ext.getBody().getViewSize().width,
            height: Ext.getBody().getViewSize().height - 10,
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            cm: new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
                {header:'用户ID',dataIndex:'userId',width:120},
                {header:'用户名',dataIndex:'userName',width:120},
                {header:'机构名称',dataIndex:'organName',width:120},
                {header:'机构ID',dataIndex:'organId',width:120,hidden:true},
                {header:'地区',dataIndex:'tmlName',width:120}   
                
            ]),
            view: new Ext.grid.GroupingView({   
            forceFit:true,   
            groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})'  
        	}),   
  
            ds: this.onlineUserStore
        });
    }
 });
 /*********************onReady 组件渲染及处理*************************************************/
Ext.onReady(function() {
    
    Ext.QuickTips.init();
    Ext.form.Field.prototype.msgTarget = 'side';
    
    Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + window.parent.styleCssValue);
    
    onlineUserGrid = new OnlineUserGrid();
   
    onlineUserGrid.store.load();
  
});



