/**
 * 角色信息
 * 
 * @author Qinaldo
 * @created 2009年2月18日9:10:29
 */

Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif';          //本地图形化

var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';  //需要补充的空格

var ROLEINFO_STORE_URL = 'getRoleByOrganId.action';

var roleGrid;           //角色表格
var organTree;          //机构树
var powerTree;          //菜单树
//var deviceTree;         //设备树
var oldRoleGridId;      //保留的roleGrid一列的id 
var PAGESIZE = 10;

/**************FindUserWin************************/
FindUserWin = Ext.extend(Ext.Window,{
	
	userGrid : null,
    constructor: function() {
    	
    	this.userGrid = new UserGrid(350,580);
    	this.userGrid.remove('cellclick', this.gridCellClick, this);
    	this.userGrid.organLabel.hide();
    	this.userGrid.organCombo.hide();
    	this.userGrid.rolePageFlag = true;         //标识是角色页面
        FindUserWin.superclass.constructor.call(this, {
            title: "本角色关联用户",
            width: 600,
            height: 400,
            resizable : false,
            plain: true,
            modal: true,
            autoScroll: true,
            closeAction: 'hide',
            items: [this.userGrid]
        });
    }
});

/***************************************RoleGrid组件***************************************************/
RoleGrid = Ext.extend(Ext.grid.GridPanel, {
    AddRoleWnd:null,
    ModifyRoleWnd:null,
    findUserWin : null,
    roleStore: new Ext.data.Store({
        proxy: new Ext.data.HttpProxy({url: ROLEINFO_STORE_URL, method: 'POST'}),
        reader: new Ext.data.JsonReader({},[{name:'roleId'},{name:'name'},{name:'remark'}])
    }),
    
    constructor: function() {
        this.AddRoleWnd=new AddRoleWnd();
        this.ModifyRoleWnd=new ModifyRoleWnd();
        this.findUserWin = new FindUserWin();
        
        RoleGrid.superclass.constructor.call(this, {
        	title: '角色',
            //renderTo: 'RoleGrid',
            frame: true,
            width: Ext.getBody().getViewSize().width*0.46,//460,
            height: Ext.getBody().getViewSize().height - 40,
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            sm: new Ext.grid.RowSelectionModel({singleSelect: true}),
            cm: new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
                {header:'id',dataIndex:'roleId',width:120,hidden:true},
                {header:'名称',sortable:true,dataIndex:'name',width:120},
                {header:'备注',sortable:true,dataIndex:'remark',width:120}
            ]),
            ds: this.roleStore,
            bbar: new Ext.Toolbar({
                items:['-',{
                   text:'添加',
                   iconCls: 'new', 
                   handler:this.insertGridClick,
                   scope:this
                },'-',{
                   text:'修改',
                   iconCls: 'update', 
                   handler:this.updateGridClick,
                   scope:this
                },'-', {
                   text:'删除',
                   iconCls: 'delete', 
                   handler:this.deleteGridClick,
                   scope:this
                },'-', {
                   text:'查看关联用户',
                   iconCls: 'find', 
                   handler:this.findUserClick,
                   scope:this
                }]
            }),
            tbar: new Ext.Toolbar({
            	items:[{
            		id: 'tips',
            		xtype: 'label',
            		text: '系统提示:请首先选择左侧的机构...',
            		style: 'color: blue;'
            	}]
            }),
            listeners: {
                "dblclick": { fn: this.updateGridClick, scope: this},
                "cellclick": {fn: this.gridCellClick, scope:this}
            }
        });
    },
    findUserClick: function() { //查看角色下的关联用户
    	/*var r = this.getSelectionModel().getSelected();
        if(typeof(r) === 'undefined') {
            Ext.Msg.alert('系统提示', blankStr + '请选择一条角色记录' + blankStr);
            return;
        }
        var win = this.findUserWin;
        var grid = win.userGrid;
        win.show();
        Ext.getCmp('bbar_newUser').hide();
        grid.userNameTf.setValue("");
        grid.userIDTf.setValue("");
        grid.store.load({params: {start: 0, limit: PAGESIZE, queryFlag:1, recordCount: -1, roleId: r.data.roleId}});*/
    	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
			    	var r = roleGrid.getSelectionModel().getSelected();
			        if(typeof(r) === 'undefined') {
			            Ext.Msg.alert('系统提示', blankStr + '请选择一条角色记录' + blankStr);
			            return;
			        }
			        var win = roleGrid.findUserWin;
			        var grid = win.userGrid;
			        win.show();
			        grid.removeListener('dblclick',grid.onModifyClick);
			        grid.removeListener('rowcontextmenu',grid.onRightMenuClick);
			        Ext.getCmp('bbar_newUser').hide();
			        Ext.getCmp('bbar_updateUser').hide();
			        Ext.getCmp('bbar_deleteUser').hide();
			        Ext.getCmp('bbar_password').hide();
			       
			        grid.userNameTf.setValue("");
			        grid.userIDTf.setValue("");
			        grid.store.load({params: {start: 0, limit: PAGESIZE, queryFlag:1, recordCount: -1, roleId: r.data.roleId}});
			}
    	});
    },
    gridCellClick: function() {             //单击一列触发的事件
    	var r = this.getSelectionModel().getSelected();
    	var newId = r.data.roleId;
    	if(oldRoleGridId != newId) {
    		oldRoleGridId = newId;
    		clearCheckTree(powerTree.getRootNode().childNodes); 
    		powerTree.collapseAll();
    		powerTree.getRootNode().expand();
    		//clearCheckTree(deviceTree.getRootNode().childNodes); 
    		//deviceTree.collapseAll();
    		//deviceTree.getRootNode().expand();
    		
    		RoleInfoManager.getRoleMenuAndFunction(r.data.roleId, function(data) {
    			var jsonData = Ext.decode(data);
    			if(jsonData && jsonData.length) {
	    			for(var i = 0, len = jsonData.length; i < len; i++) {
	    				(function(i){
	    					var path = jsonData[i].path;
	    					var childs = jsonData[i].childs;
	    					powerTree.expandPath(path, null, function(bSuccess, oLastNode){
		    					if(bSuccess) {
			    					if(childs && childs.length) {
										for(var j = 0, leng = childs.length; j < leng; j++) {
											var node = powerTree.getNodeById(childs[j].nodeId);
						                    if(node != null) {
						                    	node.getUI().checkxpx(!node.attributes.checked);
						                    }
										}
									}
		    					}
	    					});
	    				})(i);
	    			}
    			}
    		});
       /* RoleInfoManager.getRoleDevice(r.data.id, function(data) {
    			var jsonData = Ext.decode(data);
    			if(jsonData && jsonData.length) {
	    			for(var i = 0, len = jsonData.length; i < len; i++) {
	    				(function(i){
	    					var path = jsonData[i].path;
	    					var index = path.lastIndexOf("/");
	    					if(index > 0)
	    						path = path.substring(0, index);
	    					var childs = jsonData[i].childs;
	    					deviceTree.expandPath(path, null, function(bSuccess, oLastNode){
		    					if(bSuccess) {
			    					if(childs && childs.length) {
										for(var j = 0, leng = childs.length; j < leng; j++) {
											var node = deviceTree.getNodeById(childs[j].nodeId);
						                    if(node != null) {
						                    	node.getUI().checkxpx(!node.attributes.checked);
						                    }
										}
									}
		    					}
	    					});
	    				})(i);
	    			}
    			}
    		});  */             
    	}
    },
    insertGridClick: function() {
    	/*var node=organTree.getSelectionModel().getSelectedNode();
    	if(node==null)
        {
         Ext.MessageBox.alert("系统提示:", blankStr + "请选择机构!" + blankStr);
          return;
        }
        if(node.id=="organ_root")
        {
          Ext.MessageBox.alert("系统提示:", blankStr + "组织机构下不能添加角色!" + blankStr);
          return;
        }
    	 this.AddRoleWnd.show();
    	 this.AddRoleWnd.RoleForm.getForm().reset();*/
    	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
			    	var node=organTree.getSelectionModel().getSelectedNode();
			    	if(node==null)
			        {
			         Ext.MessageBox.alert("系统提示:", blankStr + "请选择机构!" + blankStr);
			          return;
			        }
			        if(node.id=="organ_root")
			        {
			          Ext.MessageBox.alert("系统提示:", blankStr + "组织机构下不能添加角色!" + blankStr);
			          return;
			        }
			    	 roleGrid.AddRoleWnd.show();
			    	 roleGrid.AddRoleWnd.RoleForm.getForm().reset();
			}
    	});
    },
    updateGridClick: function() {
    	/*var r = this.getSelectionModel().getSelected();
        if(typeof(r) === 'undefined') {
            Ext.Msg.alert('系统提示', blankStr + '请选择一条角色记录' + blankStr);
            return;
        }
        this.ModifyRoleWnd.show();
        this.ModifyRoleWnd.RoleForm.roleInfoTextField.setValue(r.data.name);
        this.ModifyRoleWnd.RoleForm.remarkTextField.setValue(r.data.remark);*/
    	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
			    	var r = roleGrid.getSelectionModel().getSelected();
			        if(typeof(r) === 'undefined') {
			            Ext.Msg.alert('系统提示', blankStr + '请选择一条角色记录' + blankStr);
			            return;
			        }
			        roleGrid.ModifyRoleWnd.show();
			        roleGrid.ModifyRoleWnd.RoleForm.roleInfoTextField.setValue(r.data.name);
			        roleGrid.ModifyRoleWnd.RoleForm.remarkTextField.setValue(r.data.remark);
			}
    	});
    },
    deleteGridClick: function() {
       /* var r = this.getSelectionModel().getSelected();
        if(typeof(r) === 'undefined') {
            Ext.Msg.alert('系统提示', blankStr + '请选择一条角色记录' + blankStr);
            return;
        }
        Ext.MessageBox.confirm('系统提示:','你确定要删除所选角色吗？',function(btn){
            if(btn == 'yes') {
                RoleInfoManager.deleteRole(r.data.roleId, function(data){
                   if(data) {
                       Ext.MessageBox.alert("系统提示:", blankStr + "删除成功" + blankStr);
                       roleGrid.remove(r);
                       roleGrid.getView().refresh();
                       clearCheckboxTree(powerTree);
			    	   powerTree.collapseAll();
			    	   powerTree.getRootNode().expand();
//			    	   clearCheckTree(deviceTree.getRootNode().childNodes); 
//			    	   deviceTree.collapseAll();
//			    	   deviceTree.getRootNode().expand();
                       var node = organTree.getSeletedNode();
                               if(node.id!="organ_root")
							    {
							     var text=node.text.length>6?node.text.substring(0,6)+"...":node.text;
                               	 Ext.get('tips').dom.innerHTML = '<font color=black>所选机构：</font>' +text+ blankStr+ 
    								'<font color=black>角色个数:</font>' + roleGrid.store.getCount();
							    }
                   }
                });
            }
        });*/
    	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
			    	var r = roleGrid.getSelectionModel().getSelected();
			        if(typeof(r) === 'undefined') {
			            Ext.Msg.alert('系统提示', blankStr + '请选择一条角色记录' + blankStr);
			            return;
			        }
			        Ext.MessageBox.confirm('系统提示:','你确定要删除所选角色吗？',function(btn){
			            if(btn == 'yes') {
			                RoleInfoManager.deleteRole(r.data.roleId, function(data){
			                   if(data) {
			                       Ext.MessageBox.alert("系统提示:", blankStr + "删除成功" + blankStr);
			                       roleGrid.remove(r);
			                       roleGrid.getView().refresh();
			                       clearCheckboxTree(powerTree);
						    	   powerTree.collapseAll();
						    	   powerTree.getRootNode().expand();
			//			    	   clearCheckTree(deviceTree.getRootNode().childNodes); 
			//			    	   deviceTree.collapseAll();
			//			    	   deviceTree.getRootNode().expand();
			                       var node = organTree.getSeletedNode();
			                               if(node.id!="organ_root")
										    {
										     var text=node.text.length>6?node.text.substring(0,6)+"...":node.text;
			                               	 Ext.get('tips').dom.innerHTML = '<font color=black>所选机构：</font>' +text+ blankStr+ 
			    								'<font color=black>角色个数:</font>' + roleGrid.store.getCount();
										    }
			                   }
			                });
			            }
			        });
			}
    	});
    },
    refresh: function(){
        this.getView().refresh();
    },
    remove:function(record){
        this.getStore().remove(record);
    }
});

function createRClickMenu(roleGrid)
{
	 var rightClick = new Ext.menu.Menu({
        items : [
        	{text : '增加角色',
            handler:function (){
                roleGrid.insertGridClick();
            }
        }, {
            text : '修改角色',
            handler:function ()
            {
                roleGrid.updateGridClick();
             }
        }, {
            text : '删除角色',
            handler:function ()
            {
               roleGrid.deleteGridClick();
             }
        },'-',{
            text : '查看关联用户',
            handler:function ()
            {
               roleGrid.findUserClick();
             }
        }]
     }); 
     return rightClick;
}

function updatePowerNodeChecked(node, checked)
{   
	var r = roleGrid.getSelectionModel().getSelected();
	if(!r) {
        Ext.MessageBox.alert("系统提示：", blankStr + '请选择角色中一条记录！' + blankStr);
        node.getUI().checkbox.checked = false;
        return;
    }
	var selected_leftGrid_id = r.data.roleId;
    if(selected_leftGrid_id != 0){        
        if(checked) {
            RoleInfoManager.saveRoleMenuAndFunction(selected_leftGrid_id , node.id, function(data){
                if(data) {
                } else {
                    Ext.Msg.alert('系统提示：',blankStr + '添加失败' + blankStr); 
                    node.getUI().checkbox.checked = false;
                }
            });    
        } else {
            RoleInfoManager.deleteRoleMenuAndFunction(selected_leftGrid_id, node.id, function(data){
                 if(data) {
                } else {
                    Ext.Msg.alert('系统提示：', blankStr + '删除失败' + blankStr);  
                    node.getUI().checkbox.checked = true;
                }
            });  
        } 
    }
}
function updateDeviceNodeChecked(node, checked)
{   
    var r = roleGrid.getSelectionModel().getSelected();
    if(!r) {
    	Ext.MessageBox.alert("系统提示：", blankStr + '请选择角色中一条记录！' + blankStr);
    	node.getUI().checkbox.checked = false;
    	return;
    }
    var selected_leftGrid_id = r.data.id;
    if(selected_leftGrid_id != 0 && (node.attributes.leaf === "true" || node.attributes.device === "true")){ 
        if(checked) {
            RoleInfoManager.saveRoleDevice(selected_leftGrid_id , node.id, function(data){
                if(data) {
                	
                } else {
                    Ext.Msg.alert('系统提示：',blankStr + '添加失败' + blankStr); 
                     //node.getUI().checkbox.checked = false;
                }
            });    
        } else {
            RoleInfoManager.deleteRoleDevice(selected_leftGrid_id, node.id, function(data){
                if(data) {
                	
                } else {
                    Ext.Msg.alert('系统提示：',blankStr + '删除失败' + blankStr);  
                     //node.getUI().checkbox.checked = true;
                }
            });  
        } 
    }
}
function onOrganTreeClick(node,e)
{
	oldRoleGridId=null;
    if(node.id!="organ_root")
    {
     var text=node.text.length>6?node.text.substring(0,6)+"...":node.text;
	 roleGrid.store.load({params:{organId:node.id,pOrganId:node.attributes.pid},callback: function(success){
    			if(success) {
    			   Ext.get('tips').dom.innerHTML = '<font color=black>所选机构：</font>' +text+ blankStr+ 
    				'<font color=black>角色个数:</font>' + roleGrid.store.getCount();
    			}}});
	 clearCheckboxTree(powerTree);	 
	}
	else
	{
	 roleGrid.store.removeAll();
	 clearCheckboxTree(powerTree);
	  Ext.get('tips').dom.innerHTML= '系统提示:请选择左侧的机构...'
	}
	
}

function changeStyle(style) {
    Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + style + ".css");
}

RoleForm=Ext.extend(Ext.form.FormPanel,{
 roleInfoTextField:null,
 constructor:function(){
 this.roleInfoTextField=this.createTextField('角色名','name');
 this.remarkTextField = this.createTextField('备注','remark');
 this.remarkTextField.allowBlank = true;
 RoleForm.superclass.constructor.call(this,{
				width: 310,
            	height: 150,
            	labelWidth: 50,
            	frame: true,
            	bodyStyle:"padding: 5px 5px 0",
            	defaults:{ width: 125 },
            	items:
            	[
            	 this.roleInfoTextField,
            	 this.remarkTextField
            	],
            	 buttons: [
               		{text: '添加', id: 'add_user_btn', iconCls: 'new',width: 20, hidden: false, handler: this.addFormClick, scope: this},
               		{text: '修改', id: 'update_user_btn',width: 20,iconCls:'update', hidden: true, handler: this.updateFormClick, scope: this},
               		{text: '清空', id: 'reset_user_btn',width: 20,iconCls:'refresh', hidden: true, handler: this.resetFormClick, scope: this},
               		{text: '重置', id: 'resume_user_btn',width: 20, iconCls:'resume',  handler: this.onResumeClick, scope: this}
            	]
		})
	
 },
 //生成一个通用的TextField
    createTextField: function(fieldLabel, name)
    	{
    		var tf = new Ext.form.TextField({
	            fieldLabel: fieldLabel,
	            readOnly: false,
	            anchor:"95%",
	            labelAlign:'left',
	            name: name,
	            vtype:'roleName',
	            allowBlank:false
        	});
        	return tf;
    	},
  addFormClick:function(){
  	if(this.getForm().isValid())
  	{
  	var text=this.roleInfoTextField.getValue();
  	var remark=this.remarkTextField.getValue();
  	var node=organTree.getSelectionModel().getSelectedNode();
          RoleInfoManager.findByRoleName(text.trim(), function(datax) {
                    if(datax) {
                    	RoleInfoManager.save(text,node.id,remark,function(data) {
                           if(data != null) {
                                Ext.MessageBox.alert("系统提示:", blankStr + "添加成功" + blankStr);
                                var RoleRecord = new Ext.data.Record.create([{name:'roleId'},{name:'name'},{name: 'remark'}]);
                                var newRecord = new RoleRecord({
                                    roleId: data,
                                    name: text,
                                    remark: remark
                               });
                               
                               roleGrid.store.insert(0,newRecord);
                               var node = organTree.getSeletedNode();
                               if(node.id!="organ_root")
							    {
							     var textx=node.text.length>6?node.text.substring(0,6)+"...":node.text;
                               	 Ext.get('tips').dom.innerHTML = '<font color=black>所选机构：</font>' +textx+ blankStr+ 
    								'<font color=black>角色个数:</font>' + roleGrid.store.getCount();
							    }
							   roleGrid.getView().refresh();
                               roleGrid.AddRoleWnd.hide();
                           } else {
                                Ext.MessageBox.alert("系统提示：", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
                           }
                       });
                    } else {
                    	Ext.MessageBox.alert("系统提示：", blankStr + "角色名称已经存在,请重新输入新的角色名称！" + blankStr); 
                    }
                });
              }
            },
     updateFormClick:function()
     {
     	var text=this.roleInfoTextField.getValue();
     	var remark = this.remarkTextField.getValue();
     	var r = roleGrid.getSelectionModel().getSelected();
     	if(text===r.data.name && remark === r.data.remark)
     	{
     		Ext.MessageBox.alert("系统提示:", blankStr + "没有做任何修改!" + blankStr);
     		return;
     	} 
     	if(this.getForm().isValid()){
     	  RoleInfoManager.update(r.data.roleId, text, remark,function(data) {
     	      if(data) {
     	      	  Ext.MessageBox.alert("系统提示:", blankStr + "修改成功" + blankStr);
                  r.data.name = text;
                  r.data.remark = remark;
                  roleGrid.refresh();
                  roleGrid.ModifyRoleWnd.hide();
     	      } else {
     	      	  Ext.MessageBox.alert("系统提示：", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
     	      }
     	  });
     	}
     },
     resetFormClick:function()
     {
      this.getForm().reset();
     },
     onResumeClick:function()
     {
     	var r = roleGrid.getSelectionModel().getSelected();
     	this.roleInfoTextField.setValue(r.data.name);
     	this.remarkTextField.setValue(r.data.remark);
     }  
});
/***************************新角色组件模块*********************************/
	AddRoleWnd=Ext.extend(Ext.Window,{
		 	RoleForm: null,
		 	constructor: function() {      
        		this.RoleForm = new RoleForm(); 
        		Ext.getCmp('add_user_btn').show();      //隐藏添加按钮
        		Ext.getCmp('reset_user_btn').show(); 
        		Ext.getCmp('resume_user_btn').hide(); 
        		Ext.getCmp('update_user_btn').hide();   //显示修改按钮
        		AddRoleWnd.superclass.constructor.call(this, {
            	title: "新增角色窗口",
            	width: 310,
            	height: 190,
            	resizable : false,
            	plain: true,
            	modal: true,
            	autoScroll: false,
            	closeAction: 'hide',
            	items: [this.RoleForm]
        		});
		 	}
	})


/*************************修改角色组件模块*******************************/	
	ModifyRoleWnd=Ext.extend(Ext.Window,{
			RoleForm: null,
		 	constructor: function() { 
		 		
        		this.RoleForm = new RoleForm(); 
        		Ext.getCmp('add_user_btn').hide();      //隐藏添加按钮
        		Ext.getCmp('reset_user_btn').hide(); 
        		Ext.getCmp('resume_user_btn').show(); 
        		Ext.getCmp('update_user_btn').show();   //显示修改按钮
        		
        		ModifyRoleWnd.superclass.constructor.call(this, {
            	title: "修改角色窗口",
            	width: 310,
            	height: 190,
            	resizable : false,
            	plain: true,
            	modal: true,
            	autoScroll: false,
            	closeAction: 'hide',
            	items: [this.RoleForm]
        		});
		 	}
	
	})

/*********************onReady 组件渲染及处理*************************************************/
Ext.onReady(function() {
    
    Ext.QuickTips.init();
    Ext.form.Field.prototype.msgTarget = 'side';
    
    Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + window.parent.styleCssValue);
    
	Ext.Ajax.on('requestcomplete',checkUserSessionStatus, this); 
	function checkUserSessionStatus(conn,response,options) {     
	    var sessionStatus = response.getResponseHeader["sessionstatus"]; 
	    
	    if(typeof(sessionStatus) != "undefined"){   
	        Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
			    if (btn == 'ok'){   
			        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
			        window.location = redirect;   
			    }   
	        });   
	     }     
    }   
    roleGrid = new RoleGrid();
    
    var rightClick=createRClickMenu(roleGrid);
    roleGrid.on('rowcontextmenu',function(grid, index, event){
    	roleGrid.getSelectionModel().selectRow(index); 
    	event.preventDefault();
    	rightClick.showAt(event.getXY());//取得鼠标点击坐标，展示菜单
    });
    
    organTree = new OrganTree();
    var root = organTree.getRootNode();
    
    // modified by jch
    // 判断当前用户所在区域是否是省中心 0-省中心
    if(String(document.getElementById('tmlId').value) != '0') {
	    root.id = document.getElementById('organId').value; 
	    root.setText(document.getElementById('organName').value);
    }
    root.expand();
    organTree.on('click',onOrganTreeClick);
    //角色关联用户UserGrid --load前事件
    roleGrid.findUserWin.userGrid.store.on('beforeload', function() {
    	var roleId = roleGrid.getSelectionModel().getSelected().data.roleId;
        var userName =  roleGrid.findUserWin.userGrid.userNameTf.getValue();
        var userID =  roleGrid.findUserWin.userGrid.userIDTf.getValue();
        Ext.apply(this, {baseParams: {queryFlag: 1, recordCount: -1, userName: userName, roleId: roleId,userID: userID}});
    });
    
    powerTree = createCheckBoxTreex('getChildNodes.action', Ext.getBody().getViewSize().width *0.315, Ext.getBody().getViewSize().height - 40, '菜单树');            
    var powerRoot= createTreeRoot('功能','menu_root');
    powerTree.setRootNode(powerRoot); 
  	powerTree.on('click',node_click);
    powerTree.on("check",updatePowerNodeChecked);
    //powerTree.render(); 
    powerRoot.expand();
  	/*
    var devTreeRightMenu = new Ext.menu.Menu({
		items: [
			{ text: '子全选', handler: function() {
				var selNode = deviceTree.getSelectionModel().getSelectedNode();
				var childs;
				if(!selNode.isExpanded()) {
					selNode.expand(true, true, function(node) {
						childs = node.childNodes;
						if(childs && childs.length) {
							for(var i = 0, len = childs.length; i < len; i++) {
								childs[i].getUI().checkbox.checked = true;  
		                        childs[i].attributes.checked = true; 
		                        deviceTree.fireEvent('check', childs[i], true); 
							}
						}
					});
				} else {
					childs = selNode.childNodes;
					if(childs && childs.length) {
						for(var i = 0, len = childs.length; i < len; i++) {
							childs[i].getUI().checkbox.checked = true;  
	                        childs[i].attributes.checked = true;  
	                        deviceTree.fireEvent('check', childs[i], true); 
						}
					}
				}
			}},
			{ text: '子反选', handler: function() {
				var selNode = deviceTree.getSelectionModel().getSelectedNode();
				var childs;
				if(!selNode.isExpanded()) {
					selNode.expand(true, true, function(node) {
						childs = node.childNodes;
						if(childs && childs.length) {
							for(var i = 0, len = childs.length; i < len; i++) {
								childs[i].getUI().checkbox.checked = !childs[i].getUI().checkbox.checked; 
		                        childs[i].attributes.checked = !childs[i].attributes.checked; 
		                        deviceTree.fireEvent('check', childs[i], childs[i].attributes.checked); 
							}
						}
					});
				} else {
					childs = selNode.childNodes;
					if(childs && childs.length) {
						for(var i = 0, len = childs.length; i < len; i++) {
							childs[i].getUI().checkbox.checked = !childs[i].getUI().checkbox.checked;  
	                        childs[i].attributes.checked = !childs[i].attributes.checked;
							deviceTree.fireEvent('check', childs[i], childs[i].attributes.checked);
						}
					}
				}
			}}
		]
	});
	
    deviceTree = createCheckBoxTreex('getChildNodes.action', 297, Ext.getBody().getViewSize().height - 40, '设备树');            

    var deviceRoot = createTreeRoot('设备','resource_root_1');
    deviceTree.setRootNode(deviceRoot);
    //deviceTree.on('click',node_click);
    deviceTree.on("check",updateDeviceNodeChecked);
   //deviceTree.render(); 
    deviceRoot.expand();
    deviceTree.on('contextmenu',function(node, e){
    	if(node.attributes.device && !node.attributes.leaf) {
    		deviceTree.getSelectionModel().select(node);
    		e.preventDefault();
	        devTreeRightMenu.showAt(e.getXY());
    	}
    });
    */
    var outPanel = new Ext.Panel({
    	title: '<角色 - 菜单>',
    	width: Ext.getBody().getViewSize().width*0.775,//770,
    	frame: false,
    	border: true,
    	height: Ext.getBody().getViewSize().height - 10,
    	renderTo: 'OutPanel',
    	items: [{
    		layout: 'column',
    		items: [{
    			columnWidth:.6,
    			items: roleGrid
    		},{
    			columnWidth:.4,
    			items: powerTree
    		}]
    	}]
    });
});

