/**
 * 角色信息
 * 
 * @author Qinaldo
 * @created 2009年2月18日9:10:29
 */

Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif';          //本地图形化

var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';  //需要补充的空格

var ROLEINFO_STORE_URL = 'getRoleByOrganId.action';

var QUERY_TML_STORE_URL='';
var QUERY_USERTYPE_STORE_URL='';
var QUERY_DEV_STORE_URL=';'

var roleGrid;           //角色表格
var organTree;          //机构树
var oldRoleGridId;      //保留的roleGrid一列的id 
var PAGESIZE = 2;
var selectorgId;
var selectRoleId;



/***************************************RoleGrid组件***************************************************/

var sm = new Ext.grid.RowSelectionModel({singleSelect: true});//角色表的行选择模式

RoleGrid = Ext.extend(Ext.grid.GridPanel, {
    roleStore: new Ext.data.Store({
        proxy: new Ext.data.HttpProxy({url: ROLEINFO_STORE_URL, method: 'POST'}),
        reader: new Ext.data.JsonReader({},[{name:'roleId'},{name:'name'}])
    }),
    
    constructor: function() {
        
        RoleGrid.superclass.constructor.call(this, {
        	title: '角色',
            //renderTo: 'RoleGrid',
            frame: true,
            width: 400.5,
            height: Ext.getBody().getViewSize().height - 40,
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            sm: sm,
            cm: new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
                {header:'id',dataIndex:'roleId',width:120,hidden:true},
                {header:'名称',dataIndex:'name',width:120}
            ]),
            ds: this.roleStore,
            tbar: new Ext.Toolbar({
            	items:[{
            		id: 'tips',
            		xtype: 'label',
            		text: '系统提示:请首先选择左侧的机构...',
            		style: 'color: blue;'
            	}]
            }),
            listeners: {
                "dblclick": { fn: this.updateGridClick, scope: this},
                "cellclick": {fn: this.gridCellClick, scope:this}
            }
        });
    },
    
    gridCellClick: function() {             //单击一列触发的事件
    	var r = this.getSelectionModel().getSelected();
    	var newId = r.data.roleId;
//    	if(oldRoleGridId != newId) {
//    		oldRoleGridId = newId;
//    	//	clearCheckboxTree(powerTree);
//    	//	powerTree.collapseAll();
//    	//	powerTree.getRootNode().expand();
//    	//	clearCheckTree(deviceTree.getRootNode().childNodes); 
//    		//deviceTree.collapseAll();
//    		//deviceTree.getRootNode().expand();
//    		
////    		RoleInfoManager.getRoleFunction(r.data.roleId, function(data) {
////    			var jsonData = Ext.decode(data);
////    			if(jsonData && jsonData.length) {
////	    			for(var i = 0, len = jsonData.length; i < len; i++) {
////	    				(function(i){
////	    					var path = jsonData[i].path;
////	    					var childs = jsonData[i].childs;
////	    					powerTree.expandPath(path, null, function(bSuccess, oLastNode){
////		    					if(bSuccess) {
////			    					if(childs && childs.length) {
////										for(var j = 0, leng = childs.length; j < leng; j++) {
////											var node = powerTree.getNodeById(childs[j].nodeId);
////						                    if(node != null) {
////						                    	node.getUI().checkxp(!node.attributes.checked);
////						                    }
////										}
////									}
////		    					}
////	    					});
////	    				})(i);
////	    			}
////    			}
////    		});
//       /* RoleInfoManager.getRoleDevice(r.data.id, function(data) {
//    			var jsonData = Ext.decode(data);
//    			if(jsonData && jsonData.length) {
//	    			for(var i = 0, len = jsonData.length; i < len; i++) {
//	    				(function(i){
//	    					var path = jsonData[i].path;
//	    					var index = path.lastIndexOf("/");
//	    					if(index > 0)
//	    						path = path.substring(0, index);
//	    					var childs = jsonData[i].childs;
//	    					deviceTree.expandPath(path, null, function(bSuccess, oLastNode){
//		    					if(bSuccess) {
//			    					if(childs && childs.length) {
//										for(var j = 0, leng = childs.length; j < leng; j++) {
//											var node = deviceTree.getNodeById(childs[j].nodeId);
//						                    if(node != null) {
//						                    	node.getUI().checkxpx(!node.attributes.checked);
//						                    }
//										}
//									}
//		    					}
//	    					});
//	    				})(i);
//	    			}
//    			}
//    		});  */             
//    	}
    },
    insertGridClick: function() {},
    updateGridClick: function() {},
    deleteGridClick: function() {},
    refresh: function(){
        this.getView().refresh();
    },
    remove:function(record){
        this.getStore().remove(record);
    }
});

function createRClickMenu(roleGrid)
{
	 var rightClick = new Ext.menu.Menu({
        items : [
        	{text : '增加角色',
            handler:function (){
                roleGrid.insertGridClick();
            }
        }, {
            text : '修改角色',
            handler:function ()
            {
                roleGrid.updateGridClick();
             }
        }, {
            text : '删除角色',
            handler:function ()
            {
               roleGrid.deleteGridClick();
             }
        }]
     }); 
     return rightClick;
}

function updatePowerNodeChecked(node, checked)
{   
	var r = roleGrid.getSelectionModel().getSelected();
	if(!r) {
        Ext.MessageBox.alert("系统提示：", blankStr + '请选择角色中一条记录！' + blankStr);
        node.getUI().checkbox.checked = false;
        return;
    }
	var selected_leftGrid_id = r.data.roleId;
    if(selected_leftGrid_id != 0 && node.attributes.leaf === "true"){        
        if(checked) {
            RoleInfoManager.saveRoleFunction(selected_leftGrid_id , node.id, function(data){
                if(data) {
                } else {
                    Ext.Msg.alert('系统提示：',blankStr + '添加失败' + blankStr); 
                    node.getUI().checkbox.checked = false;
                }
            });    
        } else {
            RoleInfoManager.deleteRoleFunction(selected_leftGrid_id, node.id, function(data){
                 if(data) {
                } else {
                    Ext.Msg.alert('系统提示：', blankStr + '删除失败' + blankStr);  
                    node.getUI().checkbox.checked = true;
                }
            });  
        } 
    }
}
function updateDeviceNodeChecked(node, checked)
{   
    var r = roleGrid.getSelectionModel().getSelected();
    if(!r) {
    	Ext.MessageBox.alert("系统提示：", blankStr + '请选择角色中一条记录！' + blankStr);
    	node.getUI().checkbox.checked = false;
    	return;
    }
    var selected_leftGrid_id = r.data.id;
    if(selected_leftGrid_id != 0 && (node.attributes.leaf === "true" || node.attributes.device === "true")){ 
        if(checked) {
            RoleInfoManager.saveRoleDevice(selected_leftGrid_id , node.id, function(data){
                if(data) {
                	
                } else {
                    Ext.Msg.alert('系统提示：',blankStr + '添加失败' + blankStr); 
                     //node.getUI().checkbox.checked = false;
                }
            });    
        } else {
            RoleInfoManager.deleteRoleDevice(selected_leftGrid_id, node.id, function(data){
                if(data) {
                	
                } else {
                    Ext.Msg.alert('系统提示：',blankStr + '删除失败' + blankStr);  
                     //node.getUI().checkbox.checked = true;
                }
            });  
        } 
    }
}
function onOrganTreeClick(node,e)
{
	oldRoleGridId=null;
    if(node.id!="organ_root")
    {
    	
     var text=node.text.length>6?node.text.substring(0,6)+"...":node.text;
     selectorgId = node.id;
	 roleGrid.store.load({params:{organId:node.id,pOrganId:node.attributes.pid},callback: function(success){
    			if(success) {
    			   Ext.get('tips').dom.innerHTML = '<font color=black>所选机构：</font>' +text+ blankStr+ 
    				'<font color=black>角色个数:</font>' + roleGrid.store.getCount();
    			}}});
	}
	else
	{
	 roleGrid.store.removeAll();
	 Ext.get('tips').dom.innerHTML= '系统提示:请选择左侧的机构...'
	}
	
	
	
}

function changeStyle(style) {
    Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + style + ".css");
}

RoleForm=Ext.extend(Ext.form.FormPanel,{
 roleInfoTextField:null,
 constructor:function(){
 this.roleInfoTextField=this.createTextField('角色名','name');
 
 RoleForm.superclass.constructor.call(this,{
				width: 280,
            	height: 100,
            	labelWidth: 50,
            	frame: true,
            	bodyStyle:"padding: 5px 5px 0",
            	defaults:{ width: 125 },
            	items:
            	[
            	 this.roleInfoTextField
            	],
            	 buttons: [
               		{text: '修改', id: 'update_user_btn',width: 20,iconCls:'update', hidden: true, handler: this.updateFormClick, scope: this},
               		{text: '清空', id: 'reset_user_btn',width: 20,iconCls:'refresh', hidden: true, handler: this.resetFormClick, scope: this},
               		{text: '重置', id: 'resume_user_btn',width: 20, iconCls:'resume',  handler: this.onResumeClick, scope: this}
            	]
		})
	
 },
 //生成一个通用的TextField
    createTextField: function(fieldLabel, name)
    {
    		var tf = new Ext.form.TextField({
	            fieldLabel: fieldLabel,
	            readOnly: false,
	            anchor:"95%",
	            labelAlign:'left',
	            name: name,
	            vtype:'roleName',
	            allowBlank:false
        	});
        	return tf;
    },
  	addFormClick:function(){},
     updateFormClick:function()
     {},
     resetFormClick:function()
     {
      this.getForm().reset();
     },
     onResumeClick:function()
     {
     	var r = roleGrid.getSelectionModel().getSelected();
     	this.roleInfoTextField.setValue(r.data.name);
     }  
});

function wait(type) {
	if (type == 0) {
		Ext.Msg.wait('保存角色权限中，请稍候...', '系统提示');
	} 
	else {
		Ext.Msg.wait('数据加载中，请稍候...', '系统提示');		
	}
}
function hide() {
	Ext.Msg.hide();
}
    


/*********************onReady 组件渲染及处理*************************************************/
Ext.onReady(function() {
    
    Ext.QuickTips.init();
    Ext.form.Field.prototype.msgTarget = 'side';
    
   // Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + window.parent.styleCssValue);
    
    roleGrid = new RoleGrid();
    var rightClick=createRClickMenu(roleGrid);
    //角色列表的右键菜单注释掉了
  /*  roleGrid.on('rowcontextmenu',function(grid, index, event){
    	roleGrid.getSelectionModel().selectRow(index); 
    	event.preventDefault();
    	rightClick.showAt(event.getXY());//取得鼠标点击坐标，展示菜单
    });
  */  
    
  
    organTree = new OrganTree({height:Ext.getBody().getViewSize().height});
    // modified by jch
    //organTree.getRootNode().expand();
	var root = organTree.getRootNode();
    //root.id = document.getElementById('organId').value; 
    //root.setText(document.getElementById('organName').value);
	 // modified by jch
    // 判断当前用户所在区域是否是省中心 0-省中心
    if(String(document.getElementById('tmlId').value) != '0') {
	    root.id = document.getElementById('organId').value; 
	    root.setText(document.getElementById('organName').value);
    }
    root.expand();
    // modified by jch
    organTree.on('click',onOrganTreeClick);
    organTree.getBottomToolbar().disable(); //把树的底部工具条变灰
   // organTree.bbar.hide(); //把树的底部工具条隐藏，不需要
    organTree.removeListener( 'contextmenu',organTree.onRightMenuClick, organTree);//把树的右键菜单去掉，不需要
    
   
    /***************************************************************************/
    // 后台取数据的代理
    
    	//区域
		var fromHp_Tml=new Ext.data.HttpProxy({
			url :'getUnselectedTmlByRoleId.action'
			})
		var toHp_Tml=new Ext.data.HttpProxy({
		url :'getSelectedTmlByRoleId.action'
		})
		
		reader: new Ext.data.JsonReader({},[{name:'roleId'},{name:'name'}])
		//后台取数据的数据集
		var fromStore_Tml= new Ext.data.Store({
		reader : new Ext.data.JsonReader({},[{
								name : 'tmlId'
							}, {
								name : 'tmlName'
							}]
				),
		proxy : fromHp_Tml
		})
		
		
      
		var toStore_Tml= new Ext.data.Store({
		reader : new Ext.data.JsonReader({},[{
								name : 'tmlId'
							}, {
								name : 'tmlName'
							}]
				),
		proxy : toHp_Tml
		})
		
		
		
		//用户类型
		var fromHp_UserType=new Ext.data.HttpProxy({
			url :'queryUserType.action'
			})
		var toHp_UserType=new Ext.data.HttpProxy({
		url :'querySelectUserType.action'
		})
		//后台取数据的数据集
		var fromStore_UserType= new Ext.data.Store({
		reader : new Ext.data.JsonReader({},[{
								name : 'userTypeId'
							}, {
								name : 'userTypeName'
							}]
				),
		proxy : fromHp_UserType
		})
      
		var toStore_UserType= new Ext.data.Store({
		reader : new Ext.data.JsonReader({},[{
								name : 'userTypeId'
							}, {
								name : 'userTypeName'
							}]
				),
		proxy : toHp_UserType
		})
		
		
		
		//设备
		var fromHp_Dev=new Ext.data.HttpProxy({
			url :'queryDev.action'
			})
		var toHp_Dev=new Ext.data.HttpProxy({
		url :'querySelectDev.action'
		})
		//后台取数据的数据集
		var fromStore_Dev= new Ext.data.Store({
		reader : new Ext.data.JsonReader({},[{
								name : 'devId'
							}, {
								name :'devDes'//name : 'devName'//modify by yhzhang
							}]
				),
		proxy : fromHp_Dev
		})
      
		var toStore_Dev= new Ext.data.Store({
		reader : new Ext.data.JsonReader({},[{
								name : 'devId'
							}, {
								name :'devDes'//name : 'devName'
							}]
				),
		proxy : toHp_Dev
		})
		
		 var selTml={
		                xtype:'itemselector',
		                align:"center",
		                name:'Item Selector',
		                id:'iTml',
		                fieldLabel:'ItemSelector',
		                dataFields:['tmlId','tmlName'],
		                msWidth:192,
		                msHeight:200,		                
		                valueField:"tmlId",
		                displayField:"tmlName",
		                toLegend:"已选：",
		                fromLegend:"可选区域：",
		                fromStore:fromStore_Tml,
		                toStore:toStore_Tml,		               
		                toData:[]
		                }
		                
		               
		                
		  var selUserType={
		                xtype:'itemselector',
		                align:"center",
		                name:'Item Selector',
		                id:'iUserType',
		                fieldLabel:'ItemSelector',
		                dataFields:['userTypeId','userTypeName'],
		                msWidth:192,
		                msHeight:200,		                
		                valueField:"userTypeId",
		                displayField:"userTypeName",
		                toLegend:"已选：",
		                fromLegend:"可选用户类型：",
		                toData:[],
		                fromStore:fromStore_UserType,
		                toStore:toStore_UserType
		                }
		    var selDev={
		                xtype:'itemselector',
		                align:"center",
		                name:'Item Selector',
		                id:'iDev',
		                fieldLabel:'ItemSelector',
		               // dataFields:['devId','devName'],	
		                dataFields:['devId','devDes'],
		                msWidth:192,
		                msHeight:200,
		                toData:[],
		                valueField:"devId",
		                displayField:"devDes",//"devName",
		                toLegend:"已选：",
		                fromLegend:"可选网元平台：",
		                fromStore:fromStore_Dev,
		                toStore:toStore_Dev
		                }
		                
	   var editForm = new Ext.form.FormPanel({
		title: "",
		layout:"column",
		width: 420,
		height: Ext.getBody().getViewSize().height - 40,
		applyTo : 'RoleTmlDiv',
		labelWidth: 80,
		labelAlign: "right",
		autoScroll:true,
		frame: true,
		items: [selTml,selUserType,selDev],buttons: [{ text: "保存",handler : saveit},{ text: "重置",handler: changePergana}]
		  });
		  
		  
		  
	function saveit(){
		TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
		if(fromStore_Tml.getCount()!=0 || toStore_Tml.getCount()!=0){
		wait(0);
		 var strTml = editForm.getForm().findField("iTml").getValue();
		 var strUserType = editForm.getForm().findField("iUserType").getValue();
		 var strDev = editForm.getForm().findField("iDev").getValue();		
		if (selectRoleId==null) return;
		//方法1 Dwr保存
		RoleBusinessSaveDwr.save(selectRoleId,strTml,strUserType,strDev,function (data){
		hide();
		Ext.Msg.alert(data.title,data.msg);});
		}
		else
		Ext.Msg.alert("提示","请选择一个角色！");
		
		//方法2：form 提交保存
		//editForm.getForm().url="saveRoleBusiCfg.action";
		//editForm.getForm().submit({params:{roleId:selectRoleId,strTml:strTml,strDev:strDev,strUserType:strUserType}});
			}
		});
	
	}
		  
		  
	/*******************************************************************************/
    
   //点击 角色grid的 某一行 触发事件 -------开始
    	sm.on('rowselect',function(sm,rowIndex,record){
		var id = record.get('roleId');
		selectRoleId =id;
		//Ext.MessageBox.alert(id);
		//刷新三个配制列表数据
		selTml.fromStore.removeAll();
		selTml.toStore.removeAll();
		
		selUserType.fromStore.removeAll();
		selUserType.toStore.removeAll();
		
		selDev.fromStore.removeAll();
		selDev.toStore.removeAll();
		
		selTml.fromStore.load({params:{roleId:id,orgId:selectorgId}});
		selTml.toStore.load({params:{roleId:id}});
		
		selUserType.fromStore.load({params:{roleId:id}});
		selUserType.toStore.load({params:{roleId:id}});	
		
		selDev.fromStore.load({params:{roleId:id}});
		selDev.toStore.load({params:{roleId:id}});	
		
		
	});
	//点击 角色grid的 某一行 触发事件 ---------结束

    
    var outPanel = new Ext.Panel({
    	title: '角色业务权限',
    	width: 770,
    	frame: false,
    	border: true,
    	height: Ext.getBody().getViewSize().height - 10,
    	renderTo: 'OutPanel',
    	items: [{
    		layout: 'column',
    		items: [{
    			columnWidth:.45,
    			items: roleGrid
    		},{
    			columnWidth:.55,
    			items: editForm
    		}]
    	}]
    });
    
    
    /*function changePergana(perganaId)
   	{	
   		//var data=choseForm.form.findField("pergana").getValue();
   		if(perganaId==null)return;
   		else if(perganaId=='请选择')return;
   		else
   		{       //加载未选数据
   				fromHp.conn.url="queryTml.action?queryFlag=other&perganaId="+comb.getValue();
   				//fromStore.load();
   				
   				//加载已选数据
   				toHp.conn.url="queryTml.action?queryFlag=used&perganaId="+comb.getValue();
   				//toStore.load();
   		
   		}
    }*/
    function changePergana(){//yhzhang 2009/10/26
    	selTml.fromStore.reload();
   		selTml.toStore.reload();
   		selUserType.fromStore.reload();
   		selUserType.toStore.reload();
   		selDev.fromStore.reload();
   		selDev.toStore.reload();
    }
	function save()
	{
		var tId=editForm.form.findField("tml").getValue();
		
		
	}
	

    
});

