/**
 * 机构树<共通>
 * @created on 2009年4月9日13:19:06
 */
 
var ORGANTREE_URL='getChildNodes.action';
var ORGANLEVEL_STORE_URL = '';
var TML_TREE_ACTION_URL='queryTmlSonNode.action';
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';     //需要补充的空格 
var organTree;

OrganTree = Ext.extend(TreePanelFil, {
    
    rightMenu: null,
    insertOrganWin: null,
    updateOrganWin: null,
    
    constructor: function() {
        
        this.insertOrganWindow = new InsertOrganWindow();
        this.updateOrganWindow = new UpdateOrganWindow();
        
        this.rightMenu = new Ext.menu.Menu({
            items: [
                { text: '增加子机构', handler: this.addSubOrganClick, scope:this},
                { text: '修改机构', handler: this.modifyOrganClick, scope:this},
                { text: '删除机构', handler: this.deleteOrganClick, scope:this},'-',
                { text: '刷新', handler: this.refreshClick, scope: this}
            ]
        });
        
        OrganTree.superclass.constructor.call(this, {
            renderTo: 'Organ_tree',
            title: '组织机构树',
            autoScroll:true, 
            enableDD:false,//是否支持拖拽效果
            containerScroll: true,//是否支持滚动条
            width: 220,
            //border: true,
            frame: false,
            height:Ext.getBody().getViewSize().height - 40,
            rootVisible:true,//是否显示跟节点
            baseCls: 'x-panel',
            margins:'0 0 0 0',
            loader:new Ext.tree.TreeLoader({  
                dataUrl: ORGANTREE_URL
            }),
            root: new Ext.tree.AsyncTreeNode({
                id: 'organ_root',
                text: '组织机构',
                draggable:false
            }),
            listeners: {
                'contextmenu': {fn: this.onRightMenuClick, scope: this}
            },
            tbar: [
             '-','机构名称:',{xtype:'textfield',width:70, id:'byNameTf'},
             '-',{iconCls:'find', handler: this.filterByName,scope:this}
            ],
            bbar: new Ext.Toolbar({
                items:['-',
                    {text:'添加',id:'Btn_Org_Add',iconCls: 'new', handler:this.onAddClick,scope:this},'-',
                    {text:'修改',id:'Btn_Org_Modify',iconCls: 'update',handler:this.onModifyClick,scope:this},'-', 
                    {text:'删除',id:'Btn_Org_Delete',iconCls: 'delete',handler:this.onDeleteClick,scope:this}
                ]
            })
        });
    }, 
    filterByName: function() {
    	var val = Ext.getCmp('byNameTf').getValue();
    	this.filterNodeByText(val);
        //this.refreshNode(this.getRootNode);
    },
    onAddClick: function() {
        var selNode = this.getSeletedNode();
        var win = this.insertOrganWindow;
        var f = win.organForm;
        
        if(!selNode) {
            Ext.MessageBox.alert('系统提示：', blankStr +'请选择父机构...' + blankStr);
            return;
        }
        win.node = selNode;
        f.POrganNameTf.setValue(selNode.text);
        this.filterLevelStore(f.LevelCombox.store, selNode);
        this.addSubOrganClick();
    },
    onModifyClick: function() {
        var selNode = this.getSeletedNode();
        if(!selNode) {
            Ext.MessageBox.alert('系统提示：', blankStr +'请选择父机构...' + blankStr);
            return;
        }
        this.updateOrganWindow.node = selNode;
        this.insertOrganWindow.organForm.POrganNameTf.setValue(selNode.parentNode.text);
        this.filterLevelStore(this.updateOrganWindow.organForm.LevelCombox.store, selNode);
        this.modifyOrganClick();
    },
    onDeleteClick: function() {
        var selNode = this.getSeletedNode();
        if(!selNode) {
            Ext.MessageBox.alert('系统提示：', blankStr +'请选择父机构...' + blankStr);
            return;
        }
        this.delHandler(selNode);
    },
    onRightMenuClick: function(node,e) {    //右键菜单
        
        this.fireEvent("click", node, e);
        
        this.getSelectionModel().select(node);
        
        this.insertOrganWindow.node = node;
        this.updateOrganWindow.node = node;
        
        this.insertOrganWindow.organForm.PIdHidden.setValue(node.id.substring(6));
        this.updateOrganWindow.organForm.PIdHidden.setValue(node.id.substring(6));
        
        this.filterLevelStore(this.insertOrganWindow.organForm.LevelCombox.store, node);
        this.filterLevelStore(this.updateOrganWindow.organForm.LevelCombox.store, node);
        
        e.preventDefault();
        this.rightMenu.treeNode = node;
        this.rightMenu.showAt(e.getXY());//取得鼠标点击坐标，展示菜单
    },
    addSubOrganClick: function() {  //右键添加
        this.insertOrganWindow.organForm.getForm().reset();
        this.insertOrganWindow.show();
        this.insertOrganWindow.organForm.POrganNameTf.setValue(this.insertOrganWindow.node.text);
    },
    modifyOrganClick: function() {  //右键修改
        if(this.updateOrganWindow.node == this.getRootNode()) {
            Ext.MessageBox.alert("系统提示：", blankStr + "组织机构不能修改" + blankStr);
            return;
        }
            
        this.updateOrganWindow.show();
        this.updateOrganWindow.organForm.getForm().reset();
        this.updateOrganWindow.organForm.POrganNameTf.setValue(this.updateOrganWindow.node.parentNode.text);
        OrganInfoManager.findOrganInfoById(this.updateOrganWindow.node.id.substring(6), function(data) {
            if(data) {
                organTree.updateOrganWindow.organForm.getForm().setValues(Ext.util.JSON.decode(data));
            } else {
                Ext.MessageBox.alert("系统提示：", "操作可能出现了某些错误,请重试！");
            }
        });
    },
    deleteOrganClick: function() {  //右键删除
        var node = this.rightMenu.treeNode;
        this.delHandler(node);
    },
    refreshClick: function() {      //右键刷新
        var node = this.rightMenu.treeNode;
        if(node == this.getRootNode()) {
            this.refreshNode(node);
        } else {
            this.refreshNode(node.parentNode);
        }
    },
    getSeletedNode: function() {
        return this.getSelectionModel().getSelectedNode();
    },
    delHandler: function(node) {    //共通的删除操作<右键、toolbar下的删除>
        var pNode = node.parentNode;
        Ext.MessageBox.confirm('系统提示:','你确定要删除所选机构吗？',function(btn){
            if(btn == 'yes') {
                OrganInfoManager.deleteOrgan(node.id, pNode.id, function(data){
                    if(data) {
                        Ext.MessageBox.alert("系统提示:", blankStr + "删除成功" + blankStr);
                        organTree.refreshNode(pNode);
                    } else {
                        Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
                    }
                });
            }
        });
    },
    refreshNode: function(node) {
        this.getLoader().load(node, function() {
            node.expand();
        });
    },
    filterLevelStore: function(store, node) {   //过滤级别
        if(node == this.getRootNode()) {
            store.clearFilter();
        } else {
            store.filterBy(function(record, id){
                 return record.get('levelId') >= parseInt(node.attributes.level) ? true : false;
            });
        }
    }
});

OrganForm= Ext.extend(Ext.ux.Form, {
    IdHidden: null,             //机构ID
    PIdHidden:null,             //机构父节点ID
    POrganNameTf : null,        //机构父节点Name
    NameTextField:null,         //"机构名称" 文本框
    regidTextField: null,       //"区域"
    PrincipalTextField:null,    //"负责人" 文本框
    PhoneTextField:null,        //"电话"
    FaxTextField:null,          //传真
    EmailTextField:null,        //Email
    LevelCombox:null,           //"机构级别"下拉框
    remarkTextField: null,
    
     constructor: function() {
        
        var jsonData = [{'levelId':1, 'levelName':'集团'},{'levelId':2, 'levelName':'省'},{'levelId':3, 'levelName':'本地网'},{'levelId':4, 'levelName':'部门'},{'levelId':5, 'levelName':'其他'}];
        
        this.IdHidden=this.createHidden("机构标识",'organId');
        this.PIdHidden=this.createHidden("机构父标识",'POrganId');
        this.POrganNameTf = this.createTextFiled('上层机构','pOrganName','80%');
      //  this.regidTextField = this.createTextFiled('区域','regid','80%');
	 	 this.regidTextField = createComboxTree('区域','100%',TML_TREE_ACTION_URL);
        
//        this.regidTextField= new Ext.ux.ComboBoxTree({
//        		fieldLabel :' 区域',  
//					labelWidth: 65,
//					width : '100%',  
//			        xtype : 'combotree',  
//			        hiddenName : 'abcd', 
//			        allowUnLeafClick : true,  
//			        tree : new Ext.tree.TreePanel({  
//			            rootVisible : true,  
//			            root : new Ext.tree.AsyncTreeNode({  
//			                id : '0',  
//			                text : "省中心",  
//			                expanded : true,  
//			                loader : new Ext.tree.TreeLoader({  
//			                    dataUrl : TML_TREE_ACTION_URL
//			                })  
//			            })  
//			        }),  
//			        allowBlank : false
//        });

        this.NameTextField=this.createTextFiled("机构名称", 'name','80%','该输入框为必填项,请输入...',null,15,"机构名称最大长度为15");
        this.PrincipalTextField = this.createTextFiled("负责人",'principal','80%' ,"负责人不能为空！",null,8,"负责人最大长度为8");
        this.PhoneTextField = this.createTextFiled("电话", 'phone','80%', "电话不能为空！","phone");
        this.FaxTextField = this.createTextFiled("传真", 'fax','80%', "传真不能为空！");
        this.EmailTextField = this.createTextFiled("电子邮箱", 'email','80%', "电子邮箱不能为空！", "email");
        this.LevelCombox=this.createMemoryCombo('机构级别','levelId','levelName','80%',jsonData);
        this.LevelCombox.store.load();
        this.remarkTextField = this.createTextFiled("备注", 'remark','80%');
        this.remarkTextField.allowBlank = false;
        this.LevelCombox.lastQuery = '';
        this.POrganNameTf.disable();
        
        OrganForm.superclass.constructor.call(this, {
            width: 360,
            height: 300,
            labelWidth: 65,
            frame: true,
            bodyStyle:"padding: 5px 5px 0",
            defaults:{ width: 125 },
            items:[this.POrganNameTf,   this.IdHidden,           this.PIdHidden,      this.NameTextField, 
                   this.regidTextField, this.PrincipalTextField, this.PhoneTextField, this.FaxTextField,
                   this.EmailTextField, this.LevelCombox,        this.remarkTextField
            ],
            buttons: [
               {text: '添加', id: 'add_organ_btn', iconCls: 'new',width: 20, hidden: false, handler: this.onAddClick, scope: this},
               {text: '修改', id: 'update_organ_btn',width: 20,iconCls:'update', hidden: true, handler: this.onUpdateClick, scope: this},
               {text: '清空', width: 20, iconCls:'refresh',handler: this.onResetClick, scope: this}
            ]
        })
     },
     onAddClick:function(){
        var organName = this.NameTextField.getValue();
        var regid = this.regidTextField.hiddenName;
   		alert('get'+regid);
        var principal = this.PrincipalTextField.getValue();
        var phone = this.PhoneTextField.getValue();
        var fax = this.FaxTextField.getValue();
        var email = this.EmailTextField.getValue();
        var levelId = this.LevelCombox.getValue();
        var remark = this.remarkTextField.getValue();
        
        var pNode = organTree.insertOrganWindow.node;
        if(pNode.id == 0) {
            Ext.MessageBox.alert("系统提示：", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
            return;
        }
        
        if(this.getForm().isValid()) {
            OrganInfoManager.findByOrganName(organName, function(datax){
              if(datax) {
                OrganInfoManager.save(organName,principal,phone, fax, email,levelId, pNode.id,0,regid,remark, function(data) {
                   if(data != null) {
                       Ext.MessageBox.alert("系统提示:", blankStr + "添加成功" + blankStr);
                       organTree.insertOrganWindow.hide();
                       organTree.refreshNode(pNode);
                   } else {
                       Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
                   }
                });
              } else {
                Ext.MessageBox.alert("系统提示:", blankStr + "机构名称已存在,请重新输入新的机构名称！" + blankStr);
              }
           });
        }
     },
     onUpdateClick:function(){
         var organId = this.IdHidden.getValue();
         var organName = this.NameTextField.getValue();
         var regid = this.regidTextField.hiddenName;
         var principal = this.PrincipalTextField.getValue();
         var phone = this.PhoneTextField.getValue();
         var fax = this.FaxTextField.getValue();
         var email = this.EmailTextField.getValue();
         var pId   = this.PIdHidden.getValue();
         var levelId = this.LevelCombox.getValue();
         var remark = this.remarkTextField.getValue();
         
         var selNode = organTree.updateOrganWindow.node;
         if(pId == 0) {
            Ext.MessageBox.alert("系统提示：", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
            return;
         }
         
         function updateHandler() {
             OrganInfoManager.update(organId,organName,principal,phone, fax, email,pId,levelId, 0, regid,remark,function(data) {
                 if(data) {
                     Ext.MessageBox.alert("系统提示:", blankStr + "修改成功" + blankStr);
                     organTree.updateOrganWindow.hide();
                     organTree.refreshNode(organTree.updateOrganWindow.node.parentNode);
                } else {
                   Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
                }
            });
         }
         
         if(this.getForm().isValid()) {
             if(selNode.text != organName) {
                    OrganInfoManager.findByOrganName(organName, function(datax) {
                        if(datax) 
                            updateHandler();
                        else 
                            Ext.MessageBox.alert("系统提示：", blankStr + "机构名称已存在,请重新输入新的机构名称！" + blankStr)
                    });
            } else {
                updateHandler();
            }
         }
     },
     onResetClick:function(){
         var POrganNameTfVal = this.POrganNameTf.getValue();
         this.getForm().reset();
         this.POrganNameTf.setValue(POrganNameTfVal);
     }      
});

/***************************************InsertOrganWindow组件**************************************************/
InsertOrganWindow = Ext.extend(Ext.Window,{
    
    organForm : null,
    node      : null,
    
    constructor: function() {
        
        this.organForm = new OrganForm();
        
        InsertOrganWindow.superclass.constructor.call(this, {
            title: "添加子机构窗口",
            width: 380,
            height: 350,
            resizable : false,
            plain: true,
            modal: true,
            autoScroll: true,
            closeAction: 'hide',
            items: [this.organForm]
        });
    }
});

/***************************************UpdateOrganWindow组件**************************************************/
UpdateOrganWindow = Ext.extend(Ext.Window, {
    
    organForm : null,
    node      : null,   
    
    constructor: function() {
        
        this.organForm = new OrganForm();
        
        Ext.getCmp('add_organ_btn').hide();      //隐藏添加按钮
        Ext.getCmp('update_organ_btn').show();   //显示修改按钮
        
        UpdateOrganWindow.superclass.constructor.call(this, {
            title: "修改机构窗口",
            width: 380,
            height: 350,
            resizable : false,
            plain: true,
            modal: true,
            autoScroll: true,
            closeAction: 'hide',
            items: [this.organForm]
        });
    }
});


QueryForm = Ext.extend(Ext.ux.Form,{
	ByNameTf: null,
    constructor: function() {
    	
    	this.ByNameTf = this.createTextFiled('机构','pOrganName','80%');
        OrganForm.superclass.constructor.call(this, {
        	renderTo: 'QueryForm',
            width: 320,
            //height: 240,
             height: 40,
            labelWidth: 65,
            frame: true,
            bodyStyle:"padding: 5px 5px 0",
            defaults:{ width: 125 },
            items:[this.ByNameTf],
            QueryForm: [
                {text: '添加', id: 'add_organ_btn', iconCls: 'new',width: 20, hidden: false, handler: this.onQueryClick, scope: this}
               
            ]
        })
    }
});

function changeStyle(style) {
    Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + style + ".css");
}

/*********************onReady 组件渲染及处理*************************************************/
Ext.onReady(function() {
    
    Ext.QuickTips.init();
    Ext.form.Field.prototype.msgTarget = 'side';
    
    Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + window.parent.styleCssValue);
   
    organTree = new OrganTree();
    organTree.getRootNode().expand();
    var f = new QueryForm();
    
    //控制页面按钮权限
    //请先设置好功能ID，以及页面按钮ID
    var arr=[2001,2002,2003];				
    UserInfoManager.findCapaByMenuFuncIdArr(arr,function(data){
    	for(var i=0;i<data.length;i++){
    		 if(data[0]!==0)Ext.getCmp('Btn_Org_Add').hide();      	  //隐藏添加按钮
    		 if(data[1]!==0)Ext.getCmp('Btn_Org_Modify').hide();      //隐藏修改按钮
    		 if(data[2]!==0)Ext.getCmp('Btn_Org_Delete').hide();      //隐藏删除按钮
    	}
    }
    );
})


