/**
 * 机构信息
 * 
 * @author Qinaldo
 * @created 2009年2月18日12:43:28
 */
 
 
Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif';

var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';     //需要补充的空格

var ORGANINFO_STORE_URL = 'getAllOrganInfo.action';         //机构GRID请求的.action 地址 

var organGrid = null;

/***************************************OrganForm组件**************************************************/
OrganForm = Ext.extend(Ext.form.FormPanel, {
    
    IdHidden: null,          //"机构ID" 文本框
    NameTextField: null,        //"机构名称" 文本框
    PrincipalTextField: null,   //"负责人" 文本框
    PhoneTextField: null,       //"电话" 文本框
    FaxTextField: null,      //"手机号码" 文本框
    EmailTextField: null,       //"电子邮箱" 文本框
    
     constructor: function() {
        
        this.IdHidden = this.createHidden("机构标识",'organId');
        this.NameTextField = this.createTextFiled("名称",'name',"机构名称不能为空！", null,15,"机构名称最大长度为15");
        this.PrincipalTextField = this.createTextFiled("负责人",'principal', "负责人不能为空！",null,8,"负责人最大长度为8");
        this.PhoneTextField = this.createTextFiled("电话", 'phone', "电话不能为空！","phone");
        this.FaxTextField = this.createTextFiled("传真", 'fax', "传真不能为空！");
        this.EmailTextField = this.createTextFiled("电子邮箱", 'email', "电子邮箱不能为空！", "email");
        
        OrganForm.superclass.constructor.call(this, {
            width: 300,
            height: 210,
            labelWidth: 55,
            frame: true,
            bodyStyle:"padding: 5px 5px 0",
            defaults:{ width: 125 },
            items:[this.IdHidden, this.NameTextField, this.PrincipalTextField, this.PhoneTextField, this.FaxTextField,this.EmailTextField],
            buttons: [
               {text: '添加', id: 'add_organ_btn', iconCls: 'new',width: 20, hidden: false, handler: this.addFormClick, scope: this},
               {text: '修改', id: 'update_organ_btn',width: 20,iconCls:'update', hidden: true, handler: this.updateFormClick, scope: this},
               {text: '清空', width: 20, iconCls:'refresh',handler: this.resetFormClick, scope: this}
            ]
        })
     },
    addFormClick: function() {
    	var organName = this.NameTextField.getValue();
    	var principal = this.PrincipalTextField.getValue();
    	var phone = this.PhoneTextField.getValue();
    	var fax = this.FaxTextField.getValue();
    	var email = this.EmailTextField.getValue();
    	if(this.getForm().isValid()) {
    		OrganInfoManager.findByOrganName(organName, function(datax){
    		  if(datax) {
    		  	OrganInfoManager.save(organName,principal,phone, fax, email,function(data) {
                   if(data != null) {
                       Ext.MessageBox.alert("系统提示:", blankStr + "添加成功" + blankStr);
                       organGrid.insertOrganWindow.hide();
                       var OrganRecord = new Ext.data.Record.create([{name:'organId'},{name:'name'},{name:'principal'},{name:'phone'},{name:'fax'},{name:'email'}]);
                       var newRecord = new OrganRecord({
                           organId: data,
                           name: organName,
                           principal: principal,
                           phone: phone,
                           fax: fax,
                           email: email
                       });
                       organGrid.store.insert(0,newRecord);
                   } else {
                       Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
                   }
                });
    		  } else {
    		  	Ext.MessageBox.alert("系统提示:", blankStr + "机构名称已存在,请重新输入新的机构名称！" + blankStr);
    		  }
    	   });
    	}
    },
    updateFormClick: function() {
    	
    	var organId = this.IdHidden.getValue();
    	var organName = this.NameTextField.getValue();
        var principal = this.PrincipalTextField.getValue();
        var phone = this.PhoneTextField.getValue();
        var fax = this.FaxTextField.getValue();
        var email = this.EmailTextField.getValue();
        
        var record = organGrid.selectedRecord();
        
        function updateForm() {         //更新表单处理函数
        	OrganInfoManager.update(organId,organName,principal,phone, fax, email,function(data) {
               if(data) {
                    organGrid.updateOrganWindow.hide();
                    record.data.name =  organName;
                    record.data.principal = principal;
                    record.data.phone =phone;
                    record.data.fax =fax ;
                    record.data.email =email;
                    Ext.MessageBox.alert("系统提示:", blankStr + "修改成功" + blankStr);
                    organGrid.refresh();
               } else {
                   Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
               }
            });
        }
        
        if(this.getForm().isValid()) {
            if(organName == record.data.name && principal == record.data.principal && phone == record.data.phone && fax == record.data.fax && email == record.data.email) {
            	Ext.MessageBox.alert("系统提示：", blankStr + "你未做任何改变！" + blankStr);
            } else {
            	if(record.data.name != organName) {
            		OrganInfoManager.findByOrganName(organName, function(datax) {
                        if(datax) 
                            updateForm();
                        else 
                            Ext.MessageBox.alert("系统提示：", blankStr + "机构名称已存在,请重新输入新的机构名称！" + blankStr)
                    });
            	} else {
            		updateForm();
            	}
            }
        }
    },
    resetFormClick: function() {
    	this.getForm().reset();
    	var record = organGrid.selectedRecord();
    	this.IdHidden.setValue(record.data.organId);
    },
    createTextFiled: function(fieldLabel, name, blankText,vtype,maxLength,maxLengthText) {    //生成一个通用的TextField
        var tf = new Ext.form.TextField({
            fieldLabel: fieldLabel,
            xtype: 'textfield',
            readOnly: false,
            anchor:"80%",
            name: name,
            allowBlank:false,
            blankText: blankText,
            vtype: vtype,
            maxLength: maxLength,
            maxLengthText: maxLengthText
        });
        return tf;
    },
    createHidden: function(fieldLabel,name) {    //生成一个通用的Hidden
        var h = new Ext.form.Hidden({
            fieldLabel: fieldLabel,
            name: name,
            xtype: 'textfield',
            readOnly: false,
            anchor:"90%"
        });
        return h;
    }
});

/***************************************InsertOrganWindow组件**************************************************/
InsertOrganWindow = Ext.extend(Ext.Window,{
    
    organForm : null,
    
    constructor: function() {
        
        this.organForm = new OrganForm();
        
        InsertOrganWindow.superclass.constructor.call(this, {
            title: "新建机构窗口",
            width: 320,
            height: 250,
            resizable : false,
            plain: true,
            modal: true,
            autoScroll: true,
            closeAction: 'hide',
            items: [this.organForm]
        });
    }
});

/***************************************UpdateOrganWindow组件**************************************************/
UpdateOrganWindow = Ext.extend(Ext.Window, {
	
    organForm : null,
    
    constructor: function() {
        
        this.organForm = new OrganForm();
        
        Ext.getCmp('add_organ_btn').hide();      //隐藏添加按钮
        Ext.getCmp('update_organ_btn').show();   //显示修改按钮
        
        UpdateOrganWindow.superclass.constructor.call(this, {
            title: "修改机构窗口",
            width: 320,
            height: 250,
            resizable : false,
            plain: true,
            modal: true,
            autoScroll: true,
            closeAction: 'hide',
            items: [this.organForm]
        });
    }
});


/***************************************OrganGrid组件***************************************************/
OrganGrid = Ext.extend(Ext.grid.GridPanel, {
    
    insertOrganWindow: null,
    updateOrganWindow: null,
    
    userStore: new Ext.data.Store({
        proxy: new Ext.data.HttpProxy({url: ORGANINFO_STORE_URL, method: 'POST'}),
        reader: new Ext.data.JsonReader({},[{name:'organId'},{name:'name'},{name:'principal'},{name:'phone'},{name:'fax'},{name:'email'}])
    }),
    
    constructor: function() {
        
        this.insertOrganWindow = new InsertOrganWindow();
        this.updateOrganWindow = new UpdateOrganWindow();
        
        OrganGrid.superclass.constructor.call(this, {
        	title: '机构基本信息',
            renderTo: 'OrganGrid',
            frame: true,
            width: Ext.getBody().getViewSize().width - 5,
            height: Ext.getBody().getViewSize().height - 5,
            bodyStyle:'width:100%',
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            autoScroll: true,
            cm: new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
                {header:'ID',dataIndex:'organId',width:120,hidden:true},
                {header:'名称',dataIndex:'name',width:120},
                {header:'负责人',dataIndex:'principal',width:120},
                {header:'电话',dataIndex:'phone',width:120},
                {header:'传真',dataIndex:'fax',width:120},
                {header:'邮箱',dataIndex:'email',width:120}
            ]),
            sm: new Ext.grid.RowSelectionModel({singleSelect:true}),
            ds: this.userStore,
            bbar: new Ext.Toolbar({
                items:['-',{
                   text:'添加',
                   iconCls: 'new', 
                   handler:this.insertGridClick,
                   scope:this
                },'-',{
                   text:'修改',
                   iconCls: 'update', 
                   handler:this.updateGridClick,
                   scope:this
                },'-', {
                   text:'删除',
                   iconCls: 'delete', 
                   handler:this.deleteGridClick,
                   scope:this
                }]
            }),
            listeners: {
                "dblclick": { fn: this.updateGridClick, scope: this}
            }
        });
    },
    insertGridClick: function() {           //Grid底部的添加按钮
        this.insertOrganWindow.show();
        this.insertOrganWindow.organForm.getForm().reset();
    },
    updateGridClick: function() {           //Grid底部的修改按钮
    	var record = this.selectedRecord();
    	if(record) {
        	this.updateOrganWindow.show();
        	this.updateOrganWindow.organForm.getForm().loadRecord(record);
    	} else{
    		Ext.MessageBox.alert('系统提示:', blankStr + '请选择一条机构记录' + blankStr);
    	}
    },
    deleteGridClick: function() {           //Grid底部的删除按钮
        var record = this.selectedRecord();
        if(record) {
        	Ext.MessageBox.confirm('系统提示:','你确定要删除所选机构吗？',function(btn){
                if(btn == 'yes') {
                    OrganInfoManager.deleteOrgan(record.data.organId, function(data){
                       if(data) {
                           Ext.MessageBox.alert("系统提示:", blankStr + "删除成功" + blankStr);
                           organGrid.remove(record);
                       }
                    });
                }
            });
        } else{
        	Ext.MessageBox.alert('系统提示:', blankStr + '请选择一条机构记录' + blankStr);
        }
    },
    selectedRecord: function() {
        var record = this.getSelectionModel().getSelected();
        return record;
    },
    refresh: function(){
        this.getView().refresh();
    },
    remove:function(record){
    	this.getStore().remove(record);
    }
    
});

function changeStyle(style) {
    Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + style + ".css");
}

/*********************onReady 组件渲染及处理*************************************************/
Ext.onReady(function() {
    
    Ext.QuickTips.init();                           //开启快速提示功能
    Ext.form.Field.prototype.msgTarget = 'side';    //提示方式为'side'
    
    Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + window.parent.styleCssValue);
    
    organGrid = new OrganGrid();    
    organGrid.store.load();
});


