/**
 * 角色信息
 * 
 * @author Qinaldo
 * @created 2009年2月18日9:10:29
 */

Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif';          //本地图形化

var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';  //需要补充的空格

var MENU_STORE_URL = 'getOrderMenu.action';
var MENU_TREE_ACTION_URL='getOrderMenuTree.action';


var grid;           //角色表格
var powerTree;          //菜单树

var orderMenuObj= function ()
{
	menuId='';
	menuName='';
	isHome='';
}

/***************************************menuGrid组件***************************************************/
menuGrid = Ext.extend(Ext.grid.GridPanel, {
    menuStore: new Ext.data.Store({
//    	autoLoad : {
////			params : {
////				start : 0,
////				limit : 30
////			}
//		},
        proxy:new Ext.data.HttpProxy({
			url : MENU_STORE_URL
			}),
        reader: new Ext.data.JsonReader({
					//totalProperty : "results",
					//root : "items",
					fields : [{
								name : 'menuId',mapping:'menuId'
							}, {
								name : 'menuName',mapping:'menuName'
							}, {
								name : 'isHome',mapping:'isHome'
							}]
				})
    }),
    
    constructor: function() {
    	menuGrid.superclass.constructor.call(this, {
        	title: '定制菜单',
            renderTo: 'menu_grid',
			buttonAlign : 'center',
            frame: true,
            width: Ext.getBody().getViewSize().width - 100,
            height: Ext.getBody().getViewSize().height - 40,
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            //sm: new Ext.grid.CheckboxSelectionModel({header:'选中首页', singleSelect: true}),
            columns: [new Ext.grid.CheckboxSelectionModel({header:'',width :20, singleSelect: true}),
           		{header:'首页',dataIndex:'isHome',width:10,hidden:true},
                {header:'ID', dataIndex:'menuId',width:10,hidden:true},
                {header:'名称',dataIndex:'menuName',width:120}
           		],
            ds: this.menuStore,
            bbar: new Ext.Toolbar({
                items:['-',{
                   text:'保存',
                   iconCls: 'new', 
                   handler:this.saveAll,
                   scope:this
                }]
            }),
            tbar: new Ext.Toolbar({
            	items:[{
            		id: 'tips',
            		xtype: 'label',
            		text: '选中为首页...',
            		style: 'color: red;'
            	}]
            })
        });
    },
    saveAll: function(){
    	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
			    	var sel=grid.getSelectionModel().getSelected();
			    	var selId;
					if(sel=='undefined'||sel==null)
					{	
							Ext.Msg.alert('系统提示：','请选择一条记录作为首页！');
							return;
					
					}else
					{
						selId=sel.get('menuId');								//首页的ID
					}
			    		
			    	var objArr  =new Array;
			    	var len=0;
			    	var cell = grid.store.each(function(rec)
			    	{ 					//判断是否存在
			    						var tmpId=rec.get('menuId');
			    						var omObj= new orderMenuObj();
										omObj.menuId=tmpId;
										omObj.menuName=rec.get('menuName');
										omObj.isHome='0';						//
										if(selId ==tmpId){
											omObj.isHome='1'				//是首页ID
										}
										objArr[len]=omObj;
										len++;
					});
					OrderMenuManager.saves(objArr,function(data){
						if(data){
							Ext.Msg.alert('系统提示：','定制菜单记主页成功！');
						}
						else{
							Ext.Msg.alert('系统提示：','保存过程发生异常,请刷新页面后重试！');
						}
						
					})
			}
    	});
    },
    refresh: function(){
        this.getView().refresh();
    },
    remove:function(record){
        this.getStore().remove(record);
    },
    add:function(){
    	
    }
    
});


function changeStyle(style) {
    Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + style + ".css");
}

function node_click(rec)
{//以后完善吧
}


/*********************onReady 组件渲染及处理*************************************************/
Ext.onReady(function() {
	
    Ext.QuickTips.init();
    Ext.form.Field.prototype.msgTarget = 'side';
    Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + window.parent.styleCssValue);
    
    var Tree = Ext.tree;
     // set the root node
    powerRoot = new Tree.AsyncTreeNode({
        text: '菜单树',
        draggable:false,
        id:'0'
    });
   powerTree = new Tree.TreePanel({
    	applyTo : 'menu_tree',
      	autoScroll : true,
      	height: Ext.getBody().getViewSize().height - 40,
		root : powerRoot,
		animate : true,
		enableDD : false,
		border : false,
		rootVisible : true,
		containerScroll : true,
        loader: new Tree.TreeLoader({
            dataUrl:MENU_TREE_ACTION_URL
        })
    });
    
 	
    grid=new menuGrid();
    
    powerTree.on('contextmenu',function(node,e)
    {
	    node.select();
//		var rightMenu=new Ext.menu.Menu();														//先删除所有右键菜单，再重新增加
//		rightMenu.removeAll();		
	    //子菜单：'修改' 
		if(node.leaf==true || node.leaf=='true')
		{
			var rightMenu=new Ext.menu.Menu({
			items: [
				{  
					text: '添加到个性菜单', handler: function()
					{	
						var count=grid.store.getCount();
						if(count>=10){
							Ext.Msg.alert('系统提示','最多定制10条菜单！');
							return;
						}
						var isExsit=0;
						var cell = grid.store.each(function(rec){ 								//判断gridzhong是否存在该记录
							var mid=rec.get('menuId');
							var m_id='menu_'+mid;
							if(mid==node.id || m_id==node.id){
								isExsit=1;
								return;
							}
						});
						if(isExsit==1)
						{
							//Ext.Msg.alert('系统提示','已经添加过该菜单！');
							return;
						}
						
						//生成一条Grid记录
						var recObj= new Ext.data.Record.create([{name:'isHome'},{name:'menuId'},{name:'menuName'}]);
						var r = new recObj({
							'isHome':0,
							'menuId':node.id,
							'menuName':node.text
						});
					
						UserInfoManager.findCapaByMenuId('menu_'+node.id,function(data)
						{	
							if(data==0)grid.store.add(r);
							else{
								Ext.Msg.alert('系统提示','您无权定制该菜单！');
							}
						
						});
					}
				},{  
					text: '从个性菜单中移除', handler: function(){
						
						var mid=node.id;
						//var r=grid.store.getById(mid);
						grid.store.each(function(rec){ 							
							var id=rec.get('menuId');										//找到，删除
							if(id==mid)grid.store.remove(rec);
						});
					}
				}]
			});
			
//			var editItem = new Ext.menu.Item({ text: '添加到个性菜单' });						//WARN: 必须重新New一次，这是为什么呢？
//			editItem.href='javaScript:goEdit(\''+node.id+'\',\''+node.name +'\')';	
//			rightMenu.add(editItem);
		}
	    rightMenu.showAt(e.getXY());
    });
    powerRoot.expand();
  
    var outPanel = new Ext.Panel({
    	title: '菜单<定制/首页>',
    	width: Ext.getBody().getViewSize().width-8,//800,
    	frame: false,
    	border: false,
    	height: Ext.getBody().getViewSize().height - 10,
    	renderTo: 'OutPanel',
    	items: [{
    		layout: 'column',
    		items: [{
    			columnWidth:.33,
    			items: powerTree
    		},{
    			columnWidth:.67,
    			items:grid
    		}]
    	}]
    });
    
     //加载并选中首页
    grid.getStore().load({
    					callback : function(){
    					var homeIndex=grid.store.find('isHome','1');
    		 			grid.getSelectionModel().selectRow(homeIndex);						
    					}
    				}
    );
    
});


