/**
* 菜单管理
* @author pbqi
* @created on 2009年7月6日17:16:46
*/

Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif';  //本地图形化
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';     //需要补充的空格
var selNode;
var menuTree;
/***********************OrderMenuTree定制菜单树*****************************************/
MenuTree = Ext.extend(Ext.tree.TreePanel, {
    
    rightMenu: null,
    menuGrid : null,
    menuForm : null,
    constructor: function() {
        
        this.rightMenu = new Ext.menu.Menu({
            items: [
                { text: '添加菜单功能',handler: this.addMenuFuncClick, scope: this, hidden: true},
                '-',
                { text: '增加子菜单', handler: this.addSubMenuClick, scope:this},
                //{ text: '修改菜单', handler: this.modifyMenuClick, scope:this},
                { text: '删除菜单', handler: this.deleteMenuClick, scope:this},'-',
                { text: '刷新', handler: this.refreshClick, scope: this}
            ]
        });
        
        this.menuGrid = new MenuGrid(this);  //实例化
        this.menuForm = new MenuForm(this); //实例化
        
        MenuTree.superclass.constructor.call(this, {
            renderTo: 'MenuTree',
            title: '菜单树',
            autoScroll:true, 
            enableDD:false,//是否支持拖拽效果
            containerScroll: true,//是否支持滚动条
            width: Ext.getBody().getViewSize().width*0.26,//250,
            border: true,
            frame: false,
            height:Ext.getBody().getViewSize().height*0.98,
            rootVisible:true,//是否显示跟节点
            baseCls: 'x-panel',
            margins:'0 0 0 0',
            loader:new Ext.tree.TreeLoader({  
                dataUrl: "getChildNodes.action"
            }),
            root: new Ext.tree.AsyncTreeNode({
                id: 'menu_root',
                text: '菜单树',
                draggable:false
            }),
            listeners: {
            	'click': {fn: this.onLeftClick, scope: this},
                'contextmenu': {fn: this.onRightMenuClick, scope: this}
            }
        });
    },
    onLeftClick: function(node, e) {       //点击
    	
    	Ext.getCmp('addBtn').hide();
        Ext.getCmp('updateBtn').show();
        Ext.getCmp('resumeBtn').show();
        Ext.getCmp('resetBtn').hide();
    	
    	var f = this.menuForm;
    	var tree = this;
    	selNode = node;
    	var gridBbarItems = this.menuGrid.getBottomToolbar().items;
    	
    	if(node === this.getRootNode()) {
    	   f.urlTf.disable();
    	   f.getForm().reset();
    	   f.nameTf.setValue(selNode.text);
    	   f.noIsHeadRadio.setValue(true);
    	   for(var i = 0; i < gridBbarItems.length; i++) {
               gridBbarItems.itemAt(i).disable();
    	   }
    	   return;
    	} 
    	if(node.attributes.isHead === undefined) {
    		selNode = node.parentNode;
    	}
    	var pNode = selNode.parentNode;  //父节点
        
        f.parentTf.setValue(pNode.text);
        f.nameTf.setValue(selNode.text);
    	if(selNode.attributes.isHead === "true" || selNode.attributes.isHead == true) {
    		 for(var i = 0; i < gridBbarItems.length; i++) {
                gridBbarItems.itemAt(i).disable();
             }
            f.urlTf.disable();
            f.urlTf.setValue("");
            f.yesIsHeadRadio.setValue(true);
    	} else {
    		f.urlTf.enable();
    		f.noIsHeadRadio.setValue(true);
            selNode.expand();
    		MenuFuncInfoManager.getMenuInfoByMenuId(selNode.id.substring(5), function(data){
    		    if(data) {
    		    	var jData = Ext.decode(data);
    		    	var url = jData.pageUrl;
    		    	if(url == "null" || !url) {
    		    		url = "";
    		    	} 
    		    	f.urlTf.setValue(url);
    		    	
    		    	if(f.urlTf.getValue()) {
                        for(var i = 0; i < gridBbarItems.length; i++) {
                           gridBbarItems.itemAt(i).enable();
                        }
                    } else {
                        for(var i = 0; i < gridBbarItems.length; i++) {
                           gridBbarItems.itemAt(i).disable();
                        }
                    }
                    var isDis=jData.isDisplay;
                    if(isDis==1){
                    	f.yesDisplayRadio.setValue(1);
                    }
                    else
                    {
                    	f.noDisplayRadio.setValue(0);
                    }
    		    } else {
    		    	Ext.MessageBox.alert("系统提示：", "根据菜单id 获取菜单信息时出错,请重试！");
    		    }
    		});
    	}
    	
    	//resetObj = {};
    	//resetObj.name = f.nameTf.getValue();
    	//resetObj.url = f.urlTf.getValue();
        this.menuGrid.store.load({params: {menuId: selNode.id.substring(5)}});
    	
    },
    onRightMenuClick: function(node, e) {         //右键点击
    	this.fireEvent('click', node, e);
    	
    	//如果菜单上节点为功能节点时
    	if(node !== this.getRootNode() && node.attributes.isHead === undefined) {
    		return;
    	}
    	//如果是页面节点时
    	var addFuncItem = this.rightMenu.items.itemAt(0);
    	var addMenuItem = this.rightMenu.items.itemAt(2);
    	
    	if(node !== this.getRootNode() && (node.attributes.isHead === 'false' || node.attributes.isHead === false)) {
    		MenuFuncInfoManager.getMenuInfoByMenuId(selNode.id.substring(5), function(data){
    		    if(data) {
    		    	var url = Ext.decode(data).pageUrl;
    		    	if(url == "null" || !url) {
                        url = "";
                        addMenuItem.show();
                        addFuncItem.hide();
                    } else {
                    	addMenuItem.hide();
                    	addFuncItem.show();
                    }
    		    } else {
    		    	Ext.MessageBox.alert("系统提示：", "根据菜单id 获取菜单信息时出错,请重试！");
    		    }
    		});
    	} else {
    		addMenuItem.show();
            addFuncItem.hide();
    	}
    	e.preventDefault();
        this.rightMenu.showAt(e.getXY());//取得鼠标点击坐标，展示菜单
    },
    addMenuFuncClick: function() {      //右键添加菜单功能
    	this.menuGrid.onAddClick();
    },
    addSubMenuClick: function() {            //添加
    	Ext.getCmp('addBtn').show();
        Ext.getCmp('updateBtn').hide();
        Ext.getCmp('resumeBtn').hide();
        Ext.getCmp('resetBtn').show();
        var f = this.menuForm;
    	f.getForm().reset();
        f.parentTf.setValue(selNode.text);
        f.parentTf.disable();
    	if(selNode === this.getRootNode()) {
    		f.urlTf.disable();
    		return;
    	}
        if(selNode.attributes.isHead !== 'undefined'&& selNode.attributes.isHead !== undefined ) {
        	f.noIsHeadRadio.setValue(true);
            f.urlTf.enable();
            return;
        }
    	
    	if(selNode.attributes.isHead === undefined) {
            return;
        }
        
    },  
    deleteMenuClick: function() {           //删除
        var tree = this;        
        
    	if(selNode.childNodes && selNode.childNodes.length > 0) {
    		Ext.MessageBox.alert("系统提示：", "有子节点的节点不能删除!");
    	} else {
    		 Ext.MessageBox.confirm('系统提示:',"你确定要删除所选的菜单功能吗？",function(btn){
                if(btn == 'yes') {
                	MenuFuncInfoManager.deleteMenuInfo(selNode.id, selNode.parentNode.id, function(data){
                        if(data) {
                            Ext.MessageBox.alert("系统提示：", blankStr + "删除成功！" + blankStr);
                            tree.refreshNode(selNode.parentNode);
                            tree.menuForm.getForm().reset();
                        } else {
                            
                        }
                    });
                }
    		 });
    	}
    },
    refreshClick: function() {
    	this.getLoader().load(selNode, function() {
            selNode.expand();
        });
    },
    getMenuIdByNodeId: function(nodeId) {   //根据节点id获得menuId
    	return nodeId.substring(5);
    },
    getSelectedNode : function() {          //获得树上被选择的节点
    	if(selNode) {
    		return selNode;
    	} else {
    	    Ext.MessageBox.alert("系统提示：", blankStr + "请选择菜单树上节点" + blankStr);
    	    return;
    	}
    },
    refreshNode: function(node) {
        this.getLoader().load(node, function() {
            node.expand();
        });
    },
    refreshNodeAndClick: function(node) {					//重新加载自己的节点事件，并触发点击事件，用于多次修改			
        pNode=node.parentNode;
        menuId=node.id;
        var t=this;
        this.getLoader().load(pNode, function() {
            pNode.expand();
            var newNode=pNode.findChild('id',menuId)
            t.fireEvent('click', newNode);					//父节点加载，node需要重新获得
        });
    }
});

/**************************************菜单添加修改form**************************************/
MenuForm = Ext.extend(Ext.ux.Form, {
    
    parentTf: null,             //"上级菜单" 文本框
    nameTf:  null,              //"菜单名称" 文本框
    urlTf: null,                //"url" 文本框
    yesDisplayRadio: null,      //"是" 单选按钮
    noDisplayRadio: null,       //"否" 单选按钮
    yesIsHeadRadio: null,       //"是" 单选按钮
    noIsHeadRadio: null,       //"否" 单选按钮
    
    constructor: function(tree) {
        
    	this.menuTree = tree;
    	
        this.parentTf = this.createTextFiled("上级菜单",'pMenuName','80%','该选项为必填项,请输入内容...');
        this.parentTf.disable();
        this.nameTf = this.createTextFiled("菜单名称", 'name', '80%',"菜单名称不能为空！",null,19,"用户名称最大长度为15");
        this.yesDisplayRadio = this.createRadio("是",'isDisplay',true,1);
        this.noDisplayRadio = this.createRadio("否",'isDisplay',false,0);
        this.urlTf = this.createTextFiled("路径",'pageurl','80%');
        this.urlTf.allowBlank = true;
        this.yesIsHeadRadio = this.createRadio("是",'isHead',true,1);
        this.noIsHeadRadio = this.createRadio("否",'isHead',false,0);
        
        
        MenuForm.superclass.constructor.call(this, {
        	title: '菜单配置',
        	renderTo: 'MenuForm',
            width: Ext.getBody().getViewSize().width*0.73,
            height: Ext.getBody().getViewSize().height*0.49,
            labelWidth: 70,
            labelAlign: "right",
            frame: true,
            bodyStyle:"padding: 5px 5px 0",
            items:[{
                fieldLabel:"菜单项",
                xtype:"panel",
                id: 'menuItem',
                labelWidth: 1,
                layout:"column",
                disabled: true,
                isFormField:true,
                labelAlign:"left",
                items: [{
                    width:100,
                    layout:"form",
                    labelAlign:"right",
                    items:this.yesIsHeadRadio
                },{
                    width:100,
                    layout:"form",
                    labelAlign:"right",
                    items:this.noIsHeadRadio
                }]
            },this.parentTf,this.nameTf,this.urlTf, {
                fieldLabel:"显示状态",
                xtype:"panel",
                labelWidth: 1,
                layout:"column",
                isFormField:true,
                labelAlign:"left",
                items: [{
                    width:100,
                    layout:"form",
                    labelAlign:"right",
                    items:this.yesDisplayRadio
                },{
                    width:100,
                    layout:"form",
                    labelAlign:"right",
                    items:this.noDisplayRadio
                }]
            }],
            buttons: [
               {text: '添加', id: 'addBtn', iconCls: 'new',width: 20, hidden: false, handler: this.addFormClick, scope: this},
               {text: '修改', id: 'updateBtn',width: 20,iconCls:'update', hidden: true, handler: this.updateFormClick, scope: this},
               {text: '重置', id: 'resumeBtn',width: 20,iconCls:'resume', hidden: true, handler: this.onResumeClick, scope: this},               
               {text: '清空', id: 'resetBtn',width: 20, iconCls:'refresh',  handler: this.resetFormClick, scope: this}
            ]
        })
     },
     addFormClick: function() {     //添加
     	/*var form = this;
     	var pId = selNode.id;
     	var name = this.nameTf.getValue();
     	var url = this.urlTf.getValue();
     	var isHead = this.yesIsHeadRadio.getValue() ? 1 : 0;
     	var isDisplay = this.yesDisplayRadio.getValue() ? 1 : 0;
     	
     	var tree = this.menuTree;
     	if(this.getForm().isValid()) {
         	MenuFuncInfoManager.addSubMenuInfo(pId, name, url, isHead, isDisplay, function(data) {
         	    if(data) {
         	    	Ext.MessageBox.alert("系统提示：", blankStr + "添加子菜单成功" + blankStr);
         	    	tree.refreshNode(selNode);
         	    	form.nameTf.setValue("");
                    form.urlTf.setValue("");
         	    } else {
         	    	Ext.MessageBox.alert("系统提示：", "操作可能出现了某些失误, 请重试!");
         	    }
         	});
     	}*/
     	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
			     	var form = menuTree.menuForm;
			     	var pId = selNode.id;
			     	var name = menuTree.menuForm.nameTf.getValue();
			     	var url = menuTree.menuForm.urlTf.getValue();
			     	var isHead = menuTree.menuForm.yesIsHeadRadio.getValue() ? 1 : 0;
			     	var isDisplay = menuTree.menuForm.yesDisplayRadio.getValue() ? 1 : 0;
			     	
			     	var tree = menuTree.menuForm.menuTree;
			     	if(menuTree.menuForm.getForm().isValid()) {
			         	MenuFuncInfoManager.addSubMenuInfo(pId, name, url, isHead, isDisplay, function(data) {
			         	    if(data) {
			         	    	Ext.MessageBox.alert("系统提示：", blankStr + "添加子菜单成功" + blankStr);
			         	    	tree.refreshNode(selNode);
			         	    	form.nameTf.setValue("");
			                    form.urlTf.setValue("");
			         	    } else {
			         	    	Ext.MessageBox.alert("系统提示：", "操作可能出现了某些失误, 请重试!");
			         	    }
			         	});
			     	}
			}
     	});
     },
     updateFormClick: function() {
     	
     	/*var tree = this.menuTree;
     	
     	if(selNode == tree.getRootNode())
     	     return;
     	     
     	var url = this.urlTf.getValue();   //先去得url的值进行判断
     	if(selNode.childNodes && selNode.childNodes.length) {
     		var firstChild = selNode.childNodes[0];
     		if(firstChild.id.indexOf('menuFunc_') > -1) {
     		     if(!url) {
     		     	Ext.MessageBox.alert("系统提示：", blankStr + "该菜单具有菜单功能,其路径不能为空！" + blankStr)
     		     	return;
     		     }
     		} else {
     			 if(firstChild.id.indexOf('menu_') > -1) {
     			 	if(url) {
                        Ext.MessageBox.alert("系统提示：", blankStr + "该菜单含有子菜单,其路径只能为空！" + blankStr)
                        return;
     			 	}
                 }
     		}
     	}
     	var pId = selNode.parentNode.id;
        var menuId = selNode.id;
        var name = this.nameTf.getValue();
       
        var isDisplay = this.yesDisplayRadio.getValue() ? 1 : 0;
        var isHead = this.yesIsHeadRadio.getValue() ? 1 : 0;
        
        if(this.getForm().isValid()) {
            MenuFuncInfoManager.updateMenuInfo(pId, menuId, name, url, isDisplay, isHead,function(data) {
                if(data) {
                    Ext.MessageBox.alert("系统提示：", blankStr + "修改菜单成功!``" + blankStr);
                    tree.refreshNodeAndClick(selNode);
                } else {
                    Ext.MessageBox.alert("系统提示：", "操作可能出现了某些失误, 请重试!");
                }
            });
        }*/
     	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
			     	var tree = menuTree.menuForm.menuTree;
			     	
			     	if(selNode == tree.getRootNode())
			     	     return;
			     	     
			     	var url = menuTree.menuForm.urlTf.getValue();   //先去得url的值进行判断
			     	if(selNode.childNodes && selNode.childNodes.length) {
			     		var firstChild = selNode.childNodes[0];
			     		if(firstChild.id.indexOf('menuFunc_') > -1) {
			     		     if(!url) {
			     		     	Ext.MessageBox.alert("系统提示：", blankStr + "该菜单具有菜单功能,其路径不能为空！" + blankStr)
			     		     	return;
			     		     }
			     		} else {
			     			 if(firstChild.id.indexOf('menu_') > -1) {
			     			 	if(url) {
			                        Ext.MessageBox.alert("系统提示：", blankStr + "该菜单含有子菜单,其路径只能为空！" + blankStr)
			                        return;
			     			 	}
			                 }
			     		}
			     	}
			     	var pId = selNode.parentNode.id;
			        var menuId = selNode.id;
			        var name = menuTree.menuForm.nameTf.getValue();
			       
			        var isDisplay = menuTree.menuForm.yesDisplayRadio.getValue() ? 1 : 0;
			        var isHead = menuTree.menuForm.yesIsHeadRadio.getValue() ? 1 : 0;
			        
			        if(menuTree.menuForm.getForm().isValid()) {
			            MenuFuncInfoManager.updateMenuInfo(pId, menuId, name, url, isDisplay, isHead,function(data) {
			                if(data) {
			                    Ext.MessageBox.alert("系统提示：", blankStr + "修改菜单成功!" + blankStr);
			                    tree.refreshNodeAndClick(selNode);
			                } else {
			                    Ext.MessageBox.alert("系统提示：", "操作可能出现了某些失误, 请重试!");
			                }
			            });
			        }
			}
     	});
     },
     onResumeClick: function() {
     	this.menuTree.fireEvent('click', selNode);
     },
     resetFormClick: function() {
     	this.nameTf.setValue("");
        this.urlTf.setValue("");         
     }
});


MenuFuncForm = Ext.extend(Ext.ux.Form, {
	
	IdTextField: null,          //"标识" 文本框
    NameTextField: null,        //"名称" 文本框
    
    constructor: function() {
    	
    	this.IdTextField = this.createTextFiled("权限码",'funcId','95%','功能ID不能为空',"funcId");
        this.NameTextField = this.createTextFiled("功能名称", 'funcName', '66.5%',"功能名称不能为空");
    	this.findBtn = this.createButton("校验",this.findByFuncId,this);
        
    	MenuFuncForm.superclass.constructor.call(this, {
    	    width: 350,
            height: 150,
            labelWidth: 55,
            frame: true,
            bodyStyle:"padding: 5px 5px 0",
            items: [{
                xtype:"panel",    
                layout:"column",
                items:[{
                    columnWidth:.7,    
                    layout:"form",
                    items: this.IdTextField
                },{
                    columnWidth:.2,    
                    layout:"form",
                    items: this.findBtn
                }]},this.NameTextField],
            buttons: [
               {text: '添加', id: 'addFuncBtn', iconCls: 'new',width: 20, hidden: false, handler: this.addFormClick, scope: this},
               {text: '修改', id: 'updateFuncBtn',width: 20,iconCls:'update', hidden: true, handler: this.updateFormClick, scope: this},
               {text: '重置', id: 'resumeFuncBtn',width: 20,iconCls:'resume', hidden: true, handler: this.onResumeClick, scope: this},               
               {text: '清空', id: 'resetFuncBtnn',width: 20, iconCls:'refresh',  handler: this.resetFormClick, scope: this},
               {text: '关闭', id: 'closeFuncbtn',width: 20,iconCls:'close', handler: this.onCloseClick, scope: this}
            ]
    	});
    },
    findByFuncId: function() {  //查找权限码是否唯一
    	var funcId = this.IdTextField.getValue();
    	if(funcId==null||funcId=='') 
    	{
    		Ext.MessageBox.alert("系统提示：", "请输入权限码！"+blankStr);
    		return;
    	}
    	MenuFuncInfoManager.findMenuFuncInfoByFuncId(funcId, function(data) {
	       if(data) {
	       	   Ext.MessageBox.alert("系统提示：", "菜单功能码不存在,可以使用！");
	       } else {
	       	   Ext.MessageBox.alert("系统提示：", "菜单功能码已存在,请重新输入其他...");
	       }
    	});
    },
    addFormClick: function() {
    	var tree = this.menuTree;
    	var funcId = this.IdTextField.getValue();
    	var funcName = this.NameTextField.getValue();
    	
    	var grid = this.menuGrid;          //获得menuGrid的引用
    	var form = this;
    	if(this.getForm().isValid()) {
    		MenuFuncInfoManager.findMenuFuncInfoByFuncId(funcId, function(data) {//查找funcId是否存在
                if(data) {
                    MenuFuncInfoManager.save(selNode.id.substring(5), funcId, funcName, function(data) {
                         if(data) {
                             Ext.MessageBox.alert("系统提示：", blankStr + "添加成功!" + blankStr);
                             form.ownerCt.hide();
                             grid.store.load({params: {menuId: selNode.id.substring(5)}});
                             tree.refreshNode(tree.getNodeById(selNode.id));
                         } else {
                             Ext.MessageBox.alert("系统提示：", "操作可能出现了某些失误, 请重试!");
                         }
                     }); 
                } else {
                     Ext.MessageBox.alert("系统提示：", "菜单功能码已存在,应唯一,请重新输入...");
                }
            });
        	
    	}
    },
    updateFormClick: function() {
    	var grid = this.menuGrid;          //获得menuGrid的引用
    	var form = this;
    	var tree = this.menuTree;          //获得menuTree的引用
    	
    	var selRecord = grid.getSelectionModel().getSelected();
    	var oldFuncId = selRecord.data.funcId;
    	var menuId = selRecord.data.menuId;
    	var funcId = this.IdTextField.getValue();
        var funcName = this.NameTextField.getValue();
        
        if(this.getForm().isValid()) {
        	MenuFuncInfoManager.update(menuId,funcId,funcName,function(data) {
                 if(data) {
                     Ext.MessageBox.alert("系统提示：", blankStr + "修改成功!" + blankStr);
                     form.ownerCt.hide();
                     grid.store.load({params: {menuId: menuId}});
                     tree.refreshNode(tree.getNodeById(selNode.id));
                 } else {
                     Ext.MessageBox.alert("系统提示：", "操作可能出现了某些失误, 请重试!");
                 }
            });  
        }
    },
    onResumeClick: function() {
    	var record = this.menuGrid.selectedRecord();
        this.getForm().loadRecord(record);
    },
    resetFormClick: function() {
    	this.getForm().reset();
    },
    onCloseClick: function() {
    	this.ownerCt.hide();
    }
});

/***************************************UpdateMenuFuncWindow组件**************************************************/
InsertMenuFuncWindow = Ext.extend(Ext.Window,{
    
    menuFuncForm : null,
    
    constructor: function() {
        
        this.menuFuncForm = new MenuFuncForm();
         this.menuFuncForm.findBtn.enable();
        InsertMenuFuncWindow.superclass.constructor.call(this, {
            title: "添加功能窗口",
            width: 370,
            height: 190,
            resizable : false,
            plain: true,
            modal: true,
            autoScroll: true,
            closeAction: 'hide',
            items: [this.menuFuncForm]
        });
    }
});

/***************************************UpdateMenuFuncWindow组件**************************************************/
UpdateMenuFuncWindow = Ext.extend(Ext.Window, {
    
    menuFuncForm : null,
    constructor: function() {
        
        this.menuFuncForm = new MenuFuncForm();
        
        Ext.getCmp('addFuncBtn').hide();      //隐藏添加按钮
        Ext.getCmp('updateFuncBtn').show();   //显示修改按钮
        Ext.getCmp('resetFuncBtnn').hide();    //隐藏清空按钮
        Ext.getCmp('resumeFuncBtn').show();   //显示重置按钮
        this.menuFuncForm.findBtn.disable();
        
        UpdateMenuFuncWindow.superclass.constructor.call(this, {
            title: "修改功能窗口",
            width: 370,
            height: 190,
            resizable : false,
            plain: true,
            modal: true,
            autoScroll: true,
            closeAction: 'hide',
            items: [this.menuFuncForm]
        });
    }
});



/**************************MenuGrid**************************************/
MenuGrid = Ext.extend(UxGrid, {
    
	insertMenuFuncWindow : null,
	updateMenuFuncWindow : null,
	
    constructor: function(tree) {
    	
    	this.menuTree = tree;      //通过传参的方式获得menuTree
    	
        this.rightMenu = new Ext.menu.Menu({
            items: [
                {text: '修改用户',handler: this.onModifyClick,scope: this},
                {text: '删除用户',handler: this.onDeleteClick,scope: this},'-',
                {text: '恢复原始密码',handler: this.onRePswClick,scope: this}
            ]
        });
        
        this.insertMenuFuncWindow = new InsertMenuFuncWindow();
        this.insertMenuFuncWindow.menuFuncForm.menuGrid = this;
        this.insertMenuFuncWindow.menuFuncForm.menuTree = this.menuTree;
        
        this.updateMenuFuncWindow = new UpdateMenuFuncWindow();
        this.updateMenuFuncWindow.menuFuncForm.menuGrid = this;
        this.updateMenuFuncWindow.menuFuncForm.menuTree = this.menuTree;
        
        MenuGrid.superclass.constructor.call(this, {
        	renderTo: 'MenuGrid',
        	title: '菜单功能列表',
            frame: true,
            width: Ext.getBody().getViewSize().width*0.73,//550,
            height: Ext.getBody().getViewSize().height *0.49,//- 210,
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            sm: new Ext.grid.RowSelectionModel({singleSelect:true}),
            cm: new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
                {header:'菜单ID',dataIndex:'menuId',width:120,sortable: true,hidden:true},
                {header:'功能ID',dataIndex:'funcId',width:120,sortable: true, hidden:false},
                {header:'功能名称',dataIndex:'funcName',width:120,sortable: true, align: 'center'}
            ]),
            ds: new Ext.data.Store({
                reader: new Ext.data.JsonReader({}, [{name: 'menuId'},{name: 'funcId'},{name: 'funcName'}]),
                proxy: new Ext.data.HttpProxy({url: 'getMenuFuncByMenuId.action', method: 'POST'})
            }),
            listeners: {
            	'rowdblclick': {fn: this.onRowdblclcik, scope: this}
            },
            bbar: [
                '-',{text:'添加', iconCls: 'new', handler:this.onAddClick,scope:this},'-',
                {text:'修改',iconCls: 'update',handler:this.onModifyClick,scope:this},'-',
                {text:'删除',iconCls: 'delete',handler:this.onDeleteClick,scope:this}, '-'
           ]
        });
    },
    onRowdblclcik: function(grid, rowIndex, e) {
    	this.onModifyClick();
    },
    onAddClick: function() {     //添加
    	/*if(!selNode) {
    		Ext.MessageBox.alert("系统提示：", "请选择左侧菜单树上的节点");
    		return;
    	}
    	var w = this.insertMenuFuncWindow , f = w.menuFuncForm;
    	w.show();
    	f.getForm().reset();
    	f.IdTextField.enable();*/
    	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
			    	if(!selNode) {
			    		Ext.MessageBox.alert("系统提示：", "请选择左侧菜单树上的节点");
			    		return;
			    	}
			    	var w =  menuTree.menuGrid.insertMenuFuncWindow , f = w.menuFuncForm;
			    	w.show();
			    	f.getForm().reset();
			    	f.IdTextField.enable();
			}
    	});
    },
    onModifyClick: function() {  //修改
    	/*if(!selNode) {
            Ext.MessageBox.alert("系统提示：", "请选择左侧菜单树上的节点");
            return;
        }
        var selRecord = this.getSelectionModel().getSelected();
        if(!selRecord) {
        	Ext.MessageBox.alert("系统提示：", "请选择菜单功能列表的一行记录！");
            return;
        }
        var w = this.updateMenuFuncWindow , f = w.menuFuncForm;
        w.show();
        f.getForm().loadRecord(selRecord);
        f.IdTextField.disable();*/
    	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
			        if(!selNode) {
			            Ext.MessageBox.alert("系统提示：", "请选择左侧菜单树上的节点");
			            return;
			        }
			        var selRecord = menuTree.menuGrid.getSelectionModel().getSelected();
			        if(!selRecord) {
			        	Ext.MessageBox.alert("系统提示：", "请选择菜单功能列表的一行记录！");
			            return;
			        }
			        var w = menuTree.menuGrid.updateMenuFuncWindow , f = w.menuFuncForm;
			        w.show();
			        f.getForm().loadRecord(selRecord);
			        f.IdTextField.disable();
			}
    	});
    },
    onDeleteClick: function() {  //删除
    	/*var tree = this.menuTree;
    	var grid = this;
        var menuId = selNode.id.substring(5);  //获得被选择的树节点
    	var selRecord = this.getSelectionModel().getSelected();
        if(!selRecord) {
            Ext.MessageBox.alert("系统提示：", "请选择功能列表中的一行记录!");
            return;
        }
        var funcId = selRecord.data.funcId;
        Ext.MessageBox.confirm('系统提示:',"你确定要删除所选的菜单功能吗？",function(btn){
             if(btn == 'yes') {
                    MenuFuncInfoManager.deleteMenuFuncInfo(funcId, function(data) {
                    if(data) {
                         Ext.MessageBox.alert("系统提示：", blankStr + "删除成功" + blankStr);
                         grid.store.load({params: {menuId: menuId}});
                         tree.refreshNode(tree.getNodeById(selNode.id));
                     } else {
                         Ext.MessageBox.alert("系统提示：", "操作可能出现了某些失误, 请重试!");
                     }
                });
             }
        });*/
    	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
			    	var tree = menuTree.menuGrid.menuTree;
			    	var grid = menuTree.menuGrid;
			        var menuId = selNode.id.substring(5);  //获得被选择的树节点
			    	var selRecord = menuTree.menuGrid.getSelectionModel().getSelected();
			        if(!selRecord) {
			            Ext.MessageBox.alert("系统提示：", "请选择功能列表中的一行记录!");
			            return;
			        }
			        var funcId = selRecord.data.funcId;
			        Ext.MessageBox.confirm('系统提示:',"你确定要删除所选的菜单功能吗？",function(btn){
			             if(btn == 'yes') {
			                    MenuFuncInfoManager.deleteMenuFuncInfo(funcId, function(data) {
			                    if(data) {
			                         Ext.MessageBox.alert("系统提示：", blankStr + "删除成功" + blankStr);
			                         grid.store.load({params: {menuId: menuId}});
			                         tree.refreshNode(tree.getNodeById(selNode.id));
			                     } else {
			                         Ext.MessageBox.alert("系统提示：", "操作可能出现了某些失误, 请重试!");
			                     }
			                });
			             }
			        });
			}
    	});
    }
});

function changeStyle(style) {
    Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + style + ".css");
}

/*********************onReady 组件渲染及处理*************************************************/
Ext.onReady(function() {
    
    Ext.QuickTips.init();
    Ext.form.Field.prototype.msgTarget = 'side';
    
    Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + window.parent.styleCssValue);
    
    Ext.Ajax.on('requestcomplete',checkUserSessionStatus, this); 
	function checkUserSessionStatus(conn,response,options) {     
        var sessionStatus = response.getResponseHeader["sessionstatus"];        
        if(typeof(sessionStatus) != "undefined"){   
            Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
			    if (btn == 'ok'){   
			        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
			        window.location = redirect;   
			    }   
            });   
         }     
    }   
    menuTree  = new MenuTree(); //实例化
    menuTree.getRootNode().expand();    //展开根节点
    
});


