/**
 * 定时任务主页面
 * 
 * @class QueryForm
 * @extends Ext.ux.Form
 */
var queryDicUrl = "getDicAction_queryDictionary.action";
var jobConfig;
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'; // 需要补充的空格
var COUNT_RECORDS = 12;
var JobConfigObj = {
	jobId : '',
	jobName : '',
	jobCode : '',
	jobType : '',
	jobStartStrategy : '',
	jobStatus : '',
	jobParamType : '',
	jobParam : '',
	jobLasttimeStartup : ''
};
Ext
		.onReady(function() {
			Ext.override(Ext.menu.DateMenu, {
				render : function() {
					Ext.menu.DateMenu.superclass.render.call(this);
					if (Ext.isGecko) {
						this.picker.el.dom.childNodes[0].style.width = '178px';
						this.picker.el.dom.style.width = '178px';
					}
				}
			});

			Ext.QuickTips.init();

			Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.styleCssValue);
			Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.parent.styleCssValue);
			var redStar = '<font color=red>' + '*' + '</font>';// 红色星号

			Ext.Ajax.on('requestcomplete', checkUserSessionStatus, this);
			// 检查用户状态 是否session 超时
			function checkUserSessionStatus(conn, response, options) {
				var sessionStatus = response.getResponseHeader["sessionstatus"];
				// Ext.Msg.alert('提示', '会话超时，请重新登录!');
				if (typeof (sessionStatus) != "undefined") {
					Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
						if (btn == 'ok') {
							var redirect = URL_START + document.location.host
									+ LOG_IN_URL + '?flag=true';
							window.location = redirect;
						}
					});
				}
			}
			ServForm = Ext
					.extend(
							Ext.ux.Form,
							{
								taskName : null,
								taskCode : null,
								taskTypeCombo : null,
								runMethod : null,
								runStatusCombo : null,
								paramTypeCombo : null,
								taskExecuteType : null,
								runParam : null,
								runId : null,
								constructor : function() {
									this.taskName = this.createTextFiled("任务名称"
											+ redStar, "jobName", "90%", '',
											'', 100, "", "超出最大长度100");
									this.taskCode = this.createTextFiled("任务编号"
											+ redStar, "jobCode", "90%", '',
											'', 100, "", "超出最大长度100");
									this.taskTypeCombo = this.createCombo2(
											"任务类别" + redStar, "jobType",
											"businname", "businid", "90%",
											queryDicUrl
													+ "?busintypeid=JOB_TYPE&"
													+ new Date(), "dicList",
											"dicCount", false);

									this.taskTypeCombo.initComponent = this
											.addBlankSelectForCombox(this.taskTypeCombo);
									this.taskTypeCombo.store.load();
									this.runMehod = this.createTextFiled(
											"运行策略表达式" + redStar,
											"jobStartStrategy", "90%", '', '',
											100, "", "超出最大长度100");
									this.taskExecuteType = this
											.createTextField("任务执行类",
													"jobExecClass4Busin",
													"90%", "text", 100, true,
													"", "超出最大长度100");
									this.taskExecuteType.disabled = true;
									var jsonData1 = [ {
										servStat : 0,
										servStatName : '停止'
									}, {
										servStat : 1,
										servStatName : '运行'
									} ];
									this.runStatusCombo = this
											.createMemoryCombo("运行状态",
													'servStat', 'servStatName',
													'90%', jsonData1);
									this.runStatusCombo.disabled = true;
									this.runStatusCombo.store.load();
									var jsonData = [ {
										jobParamType : 1,
										jobParamTypeName : 'JSON'
									}, {
										jobParamType : 2,
										jobParamTypeName : 'XML'
									} ];
									this.paramTypeCombo = this
											.createMemoryCombo4AllowBlank(
													"参数类型", 'jobParamType',
													'jobParamTypeName', '90%',
													jsonData, true,
													'jobParamType');
									this.paramTypeCombo.store.load();
									this.runId = this.createHidden("定时任务Id",
											"jobId");
									this.runParam = this
											.createTextArea4AllowBlank("运行参数",
													"jobParam", "150", "95%",
													"text", 100, false, "",
													"超出最大长度100", true);
									taskExecuteType: this.taskTypeCombo
											.on(
													'select',
													function() {
														this.taskExecuteType
																.setValue(this.taskTypeCombo
																		.getValue());
														this.taskExecuteType
																.getValue();
													}, this);
									ServForm.superclass.constructor
											.call(
													this,
													{
														title : "定时任务信息编辑",
														width : 700,
														height : 395,
														labelWidth : 100,
														region : "center",
														bodyStyle : "background-color:white;padding:10px 10px 0 0;",
														labelAlign : "right",
														items : [ {
															layout : "column",
															items : [
																	{
																		layout : "form",
																		items : this.taskName,
																		columnWidth : .5
																	},
																	{
																		layout : "form",
																		items : this.taskCode,
																		columnWidth : .5
																	},
																	{
																		layout : "form",
																		items : this.taskTypeCombo,
																		columnWidth : .5
																	},
																	{
																		layout : "form",
																		items : this.runMehod,
																		columnWidth : .5
																	},
																	{
																		layout : "form",
																		items : this.taskExecuteType,
																		columnWidth : 1.05
																	},
																	{
																		layout : "form",
																		items : this.runStatusCombo,
																		columnWidth : .5
																	},
																	{
																		layout : "form",
																		items : this.paramTypeCombo,
																		columnWidth : .5
																	},
																	{
																		layout : "form",
																		items : this.runParam,
																		columnWidth : 1
																	} ]
														} ],
														buttons : [
																{
																	text : '保存',
																	id : 'query_jobConfig_btn',
																	iconCls : 'save',
																	width : 20,
																	hidden : false,
																	handler : this.saveFormClick,
																	scope : this
																},
																{
																	text : '重置',
																	id : 'resume_jobConfig_btn',
																	width : 20,
																	iconCls : 'resume',
																	hidden : false,
																	handler : this.onResumeClick,
																	scope : this
																} ]

													});
								},
								saveFormClick : function() {
									if (!this.getForm().isValid()) {
										Ext.MessageBox.alert("系统提示", blankStr
												+ "请输入必填信息!" + blankStr);
										return;
									} else {
										var that = this;
										JobConfigObj.jobName = this.taskName
												.getValue();
										JobConfigObj.jobCode = this.taskCode
												.getValue();
										JobConfigObj.jobType = this.taskTypeCombo
												.getRawValue();
										JobConfigObj.jobStartStrategy = this.runMehod
												.getValue();
										JobConfigObj.jobStatus = this.runStatusCombo
												.getValue();
										JobConfigObj.jobParamType = this.paramTypeCombo
												.getValue();
										JobConfigObj.jobParam = this.runParam
												.getValue();

										JobConfigDwr
												.check(
														JobConfigObj.jobCode,
														JobConfigObj.jobStartStrategy,
														function(data) {
															if (data == 'ok') {
																JobConfigDwr
																		.save(
																				JobConfigObj,
																				function(
																						data) {
																					if (data != null) {
																						Ext.MessageBox
																								.alert(
																										"系统提示",
																										blankStr
																												+ "添加定时任务信息成功!"
																												+ blankStr);
																						that
																								.getForm()
																								.reset();
																						jobConfig.insertWindow
																								.hide();
																						jobConfig.store
																								.load({
																									params : {
																										'page.start' : 0,
																										'page.pageSize' : COUNT_RECORDS
																									}
																								});

																					} else {
																						Ext.MessageBox
																								.alert(
																										"系统提示",
																										blankStr
																												+ "添加定时任务信息失败!"
																												+ blankStr);
																					}
																				});
															} else {
																Ext.MessageBox
																		.alert(
																				"系统提示",
																				blankStr
																						+ data
																						+ blankStr);
															}
														});

									}
								},
								onResumeClick : function() {
									jobConfig.insertWindow.servForm.getForm()
											.reset();
								},
								addBlankSelectForCombox : function(combo) {
									combo.on("select", function() {
										if (combo.getValue() == -1) { // 当选择-1时，把值设置为空
											combo.setValue("");
										}
									});
									combo.store.on("datachanged", function(a) {
										var r = new Ext.data.Record({});
										r.set(combo.valueField, ''); // 添加一格值为-1的选项
										r.set(combo.displayField,
												combo.emptyText);
										a.insert(0, r);
									});
								}
							});
			/** ****************************定时任务添加窗口****************************************** */
			InsertDefineWindow = Ext.extend(Ext.Window, {
				servForm : null,
				constructor : function() {
					this.servForm = new ServForm();
					InsertDefineWindow.superclass.constructor.call(this, {
						title : "定时任务添加窗口",
						width : 720,
						height : 430,
						resizable : false,
						plain : true,
						modal : true,
						autoScroll : true,
						closeAction : 'hide',
						items : [ this.servForm ]
					});
				}
			});

			/** ********************************定时任务修改form表单************************************************* */
			JobConfigForm = Ext
					.extend(
							Ext.ux.Form,
							{
								taskName : null,
								taskCode : null,
								taskTypeCombo : null,
								runMethod : null,
								runStatusCombo : null,
								paramTypeCombo : null,
								taskExecuteType : null,
								runParam : null,
								runLastTime : null,
								constructor : function() {
									this.taskName = this.createTextFiled("任务名称"
											+ redStar, "jobName", "90%", '',
											'', 100, "", "超出最大长度100");
									this.taskCode = this.createTextFiled("任务编号"
											+ redStar, "jobCode", "90%", '',
											'', 100, "", "超出最大长度100");
									this.taskCode.disabled = true;
									this.taskTypeCombo = this.createCombo2(
											"任务类别" + redStar, "jobType",
											"businname", "businid", "90%",
											queryDicUrl
													+ "?busintypeid=JOB_TYPE&"
													+ new Date(), "dicList",
											"dicCount", false);
									this.taskTypeCombo.store.load();
									this.runMehod = this.createTextFiled(
											"运行策略表达式" + redStar,
											"jobStartStrategy", "90%", '', '',
											100, "", "超出最大长度100");
									this.taskExecuteType = this
											.createTextField("任务执行类",
													"jobExecClass4Busin",
													"90%", "text", 100, true,
													"", "超出最大长度100");
									this.taskExecuteType.disabled = true;
									this.runId = this.createHidden("定时任务Id",
											"jobId");
									that = this;
									var jsonData1 = [ {
										jobStatus : 0,
										jobStatName : '停止'
									}, {
										jobStatus : 1,
										jobStatName : '运行'
									} ];
									this.runStatusCombo = this
											.createMemoryCombo("运行状态",
													'jobStatus', 'jobStatName',
													'90%', jsonData1);
									this.runStatusCombo.disabled = true;
									this.runStatusCombo.store.load();
									var jsonData = [ {
										jobParamType : 1,
										jobParamTypeName : 'JSON'
									}, {
										jobParamType : 2,
										jobParamTypeName : 'XML'
									} ];
									this.paramTypeCombo = this
											.createMemoryCombo4AllowBlank(
													"参数类型", 'jobParamType',
													'jobParamTypeName', '90%',
													jsonData, true,
													'jobParamType');
									this.paramTypeCombo.store.load();
									this.runParam = this
											.createTextArea4AllowBlank("运行参数",
													"jobParam", "150", "95%",
													"text", 100, false, "",
													"超出最大长度100", true);
									this.runLastTime = this.createHidden(
											"最新启动时间", "jobLasttimeStartup");
									taskExecuteType: this.taskTypeCombo
											.on(
													'select',
													function() {
														this.taskExecuteType
																.setValue(this.taskTypeCombo
																		.getValue());
														this.taskExecuteType
																.getValue();
													}, this);
									ServForm.superclass.constructor
											.call(
													this,
													{
														title : "定时任务信息编辑",
														width : 700,
														height : 395,
														labelWidth : 100,
														region : "center",
														bodyStyle : "background-color:white;padding:10px 10px 0 0;",
														labelAlign : "right",
														items : [ {
															layout : "column",
															items : [
																	{
																		layout : "form",
																		items : this.taskName,
																		columnWidth : .5
																	},
																	{
																		layout : "form",
																		items : this.taskCode,
																		columnWidth : .5
																	},
																	{
																		layout : "form",
																		items : this.taskTypeCombo,
																		columnWidth : .5
																	},
																	{
																		layout : "form",
																		items : this.runMehod,
																		columnWidth : .5
																	},
																	{
																		layout : "form",
																		items : this.taskExecuteType,
																		columnWidth : 1.05
																	},
																	{
																		layout : "form",
																		items : this.runStatusCombo,
																		columnWidth : .5
																	},
																	{
																		layout : "form",
																		items : this.paramTypeCombo,
																		columnWidth : .5
																	},
																	{
																		layout : "form",
																		items : this.runParam,
																		columnWidth : 1
																	},
																	{
																		layout : "form",
																		items : this.runId
																	},
																	{
																		layout : "form",
																		items : this.runLastTime
																	} ]
														} ],
														buttons : [
																{
																	text : '修改',
																	id : 'modify_jobConfig_btn',
																	iconCls : 'update',
																	width : 20,
																	hidden : false,
																	handler : this.onModifyClick,
																	scope : this
																},
																{
																	text : '重置',
																	id : 'resume_jobConfig_btn',
																	width : 20,
																	iconCls : 'resume',
																	hidden : false,
																	handler : this.onResumeClick,
																	scope : this
																} ]

													});
								},
								onModifyClick : function() {
									if (!this.getForm().isValid()) {
										Ext.MessageBox.alert("系统提示", blankStr
												+ "请填写必填信息" + blankStr);
										return;
									} else {

										JobConfigObj.jobId = this.runId
												.getValue();
										JobConfigObj.jobName = this.taskName
												.getValue();
										JobConfigObj.jobCode = this.taskCode
												.getValue();
										JobConfigObj.jobType = this.taskTypeCombo
												.getRawValue();
										JobConfigObj.jobStartStrategy = this.runMehod
												.getValue();
										JobConfigObj.jobStatus = this.runStatusCombo
												.getValue();
										JobConfigObj.jobParamType = this.paramTypeCombo
												.getValue();
										JobConfigObj.jobParam = this.runParam
												.getValue();
										JobConfigObj.jobLasttimeStartup = this.runLastTime
												.getValue();
										JobConfigDwr
												.checkMethod(
														JobConfigObj.jobStartStrategy,
														function(data) {
															if (data == 'ok') {
																JobConfigDwr
																		.update(
																				JobConfigObj,
																				function(
																						data) {
																					if (data) {
																						// url="jobConfigAction_updateLastStartTime.action";
																						Ext.MessageBox
																								.alert(
																										"系统提示",
																										blankStr
																												+ data.msg
																												+ blankStr);
																						jobConfig.updateWindow
																								.hide();
																						jobConfig.store
																								.load({
																									params : {
																										'page.start' : 0,
																										'page.pageSize' : COUNT_RECORDS
																									}
																								});
																					} else {
																						Ext.MessageBox
																								.alert(
																										"系统提示",
																										blankStr
																												+ data.msg
																												+ blankStr);
																					}
																				});
															} else {
																Ext.MessageBox
																		.alert(
																				"系统提示",
																				blankStr
																						+ data
																						+ blankStr);
															}
														});
									}
								},
								onResumeClick : function() {
									record = jobConfig.getSelectionModel()
											.getSelected();
									if (record == null) {
										this.getForm().reset();
									} else {
										this.getForm().loadRecord(record);
									}
								},
								createTextField : function(fieldLabel, name,
										anchor, inputType, maxLength,
										allowBlank, vtype, maxLengthText) { // 生成一个通用的TextField
									var tf = new Ext.form.TextField({
										fieldLabel : fieldLabel,
										name : name,
										xtype : 'textfield',
										readOnly : false,
										allowBlank : allowBlank,
										anchor : anchor,
										blankText : '该选项为必填项,请输入内容...',
										vtype : vtype,
										inputType : inputType,
										maxLength : maxLength,
										maxLengthText : maxLengthText
									});
									return tf;
								}
							});
			/** *****************************定时任务修改窗口**************************************** */
			UpdateJobConfigWindow = Ext.extend(Ext.Window, {
				jobConfigForm : null,
				constructor : function() {
					this.jobConfigForm = new JobConfigForm();
					UpdateJobConfigWindow.superclass.constructor.call(this, {
						title : "定时任务修改窗口",
						width : 720,
						height : 435,
						resizable : false,
						plain : true,
						modal : true,
						autoScroll : true,
						closeAction : 'hide',
						items : [ this.jobConfigForm ]
					});
				},
				onResumeClick : function() {
					record = jobConfig.getSelectionModel().getSelected();
					if (record == null) {
						this.getForm().reset();
					} else {
						this.getForm().loadRecord(record);
					}
				},
				createTextField : function(fieldLabel, name, anchor, inputType,
						maxLength, allowBlank, vtype, maxLengthText) { // 生成一个通用的TextField
					var tf = new Ext.form.TextField({
						fieldLabel : fieldLabel,
						name : name,
						xtype : 'textfield',
						readOnly : false,
						allowBlank : allowBlank,
						anchor : anchor,
						blankText : '该选项为必填项,请输入内容...',
						vtype : vtype,
						inputType : inputType,
						maxLength : maxLength,
						maxLengthText : maxLengthText
					});
					return tf;
				}
			});
			/** *****************************定时任务修改窗口**************************************** */
			UpdateJobConfigWindow = Ext.extend(Ext.Window, {
				jobConfigForm : null,
				constructor : function() {

					this.jobConfigForm = new JobConfigForm();
					UpdateJobConfigWindow.superclass.constructor.call(this, {
						title : "定时任务修改窗口",
						width : 720,
						height : 435,
						resizable : false,
						plain : true,
						modal : true,
						autoScroll : true,
						closeAction : 'hide',
						items : [ this.jobConfigForm ]
					});
				}
			});
			JobConfigGrid = Ext.extend(UxGrid, {
				insertWindow : null,
				updateWindow : null,
				store : null,
				constructor : function() {

					this.store = new Ext.data.Store({ // Grid Store
						proxy : new Ext.data.HttpProxy({
							url : "jobConfigAction_findJob.action",
							method : 'POST'
						}),
						reader : new Ext.data.JsonReader({
							totalProperty : 'page.totalCount',
							root : 'page.result'
						}, [ {
							name : 'jobId'
						}, {
							name : 'jobName'
						}, {
							name : 'jobCode'
						}, {
							name : 'jobType'
						}, {
							name : 'jobStartStrategy'
						}, {
							name : 'jobStatus'
						}, {
							name : 'jobParamType'
						}, {
							name : 'jobParam'
						}, {
							name : 'jobLasttimeStartup'
						}, {
							name : 'jobExecClass4Busin'
						} ])
					}), this.insertWindow = new InsertDefineWindow();
					this.updateWindow = new UpdateJobConfigWindow();
					this.taskTypeLabel = new Ext.form.Label({
						text : '任务类别：'
					}), this.taskTypeCombo = this
							.createCombo2("任务类别", "jobType", "businname",
									"businid", "90%", queryDicUrl
											+ "?busintypeid=JOB_TYPE&"
											+ new Date(), "dicList",
									"dicCount", true);

					this.taskTypeCombo.initComponent = this
							.addBlankSelectForCombox(this.taskTypeCombo);
					this.taskTypeCombo.store.load();
					var jsonData = [ {
						servStat : 1,
						servStatName : '停止'
					}, {
						servStat : 2,
						servStatName : '运行'
					} ];
					this.runStatusLabel = new Ext.form.Label({
						text : '运行状态：'
					}), this.runStatusCombo = this
							.createMemoryCombo4AllowBlank("运行状态", 'servStat',
									'servStatName', '90%', jsonData, true);
					this.runStatusCombo.initComponet = this
							.addBlankSelectForCombox(this.runStatusCombo);
					this.runStatusCombo.store.load();
					this.taskNameLabel = new Ext.form.Label({
						text : '任务名称：'
					}), this.taskName = this.createTextField("任务名称", "jobName",
							"90%", "text", 100, false, "", "超出最大长度100");
					JobConfigGrid.superclass.constructor.call(this, {
						title : '定时任务管理列表',
						frame : true,
						width : Ext.getBody().getViewSize().width - 5,
						renderTo : "grid-div",
						region : "center",
						height : Ext.getBody().getViewSize().height -10,
						viewConfig : {
							forceFit : true
						},
						loadMask : {
							msg : '正在载入数据,请稍候...'
						},
						sm : new Ext.grid.RowSelectionModel({
							singleSelect : true
						}),
						cm : new Ext.grid.ColumnModel([
								new Ext.grid.RowNumberer(), {
									header : '定时任务id',
									dataIndex : 'jobId',
									hidden : true
								}, {
									header : '运行状态',
									dataIndex : 'jobStatus',
									sortable : true,
									width : 60,
									renderer : this.rendRunStates
								}, {
									header : '任务类别',
									dataIndex : 'jobType',
									sortable : true,
									hidden : false,
									width : 140
								}, {
									header : '任务名称',
									dataIndex : 'jobName',
									sortable : true,
									hidden : false
								}, {
									header : '定时任务编号',
									dataIndex : 'jobCode',
									sortable : true,
									width : 100
								}, {
									header : '任务执行类',
									dataIndex : 'jobExecClass4Busin',
									sortable : true,
									width : 200
								}, {
									header : '运行策略表达式',
									dataIndex : 'jobStartStrategy',
									sortable : true,
									width : 100
								}, {
									header : '运行参数',
									dataIndex : 'jobParam',
									sortable : true,
									width : 100
								}, {
									header : '最新启动时间',
									dataIndex : 'jobLasttimeStartup',
									sortable : true,
									width : 100
								} ]),
						bbar : new Ext.PagingToolbar({
							firstText : '第一页',
							nextText : '下一页',
							prevText : '上一页',
							refreshText : '刷新',
							lastText : '最后一页',
							beforePageText : '当前',
							afterPageText : '页/共{0}页',
							pageSize : COUNT_RECORDS,
							paramNames : {
								start : 'page.start',
								limit : 'page.pageSize'
							},
							store : this.store,
							displayInfo : true,
							displayMsg : '本页显示 {0} - {1},共{2}条记录',
							emptyMsg : "没有可显示的记录",
							items : [ '-', {
								text : '新增任务',
								id : 'bbar_newServDefine',
								iconCls : 'new',
								handler : this.onAddClick,
								scope : this
							}, '-', {
								text : '修改任务',
								id : 'bbar_updateServDefine',
								iconCls : 'update',
								handler : this.onModifyClick,
								scope : this
							}, '-', {
								text : '删除任务',
								id : 'bbar_deleteServDefine',
								iconCls : 'delete',
								handler : this.onDeleteClick,
								scope : this
							} ]
						}),
						tbar : new Ext.Toolbar({
							items : [ this.taskTypeLabel, this.taskTypeCombo,
									this.runStatusLabel, this.runStatusCombo,
									this.taskNameLabel, this.taskName, '-', {
										text : '查询',
										iconCls : 'find',
										handler : this.query,
										scope : this
									}, '-', {
										text : '重置',
										iconCls : 'resume',
										handler : this.resume,
										scope : this
									} ]
						}),
						ds : this.store,
						listeners : {
							"rowcontextmenu" : {
								fn : this.onRightMenuClick,
								scope : this
							},
							"dblclick" : {
								fn : this.onDblClick,
								scope : this
							}
						}
					});
				},
				query : function() {
					var jobType = this.taskTypeCombo.getRawValue();
					var jobStatus = this.runStatusCombo.getValue();
					var jobName = this.taskName.getValue();

					if (jobStatus != '') {
						jobStatus = jobStatus - 1;
					}

					jobConfig.store.baseParams = {
						'jobConfigDto.jobType' : jobType,
						'jobConfigDto.jobName' : jobName,
						'jobConfigDto.jobStatus' : jobStatus
					};
					jobConfig.store.load({
						params : {
							'page.start' : 0,
							'page.pageSize' : COUNT_RECORDS
						}
					});
				},
				resume : function() {
					this.runStatusCombo.setValue("");
					this.taskTypeCombo.setValue("");
					this.taskName.setValue("");
				},
				rendRunStates : function(val, params, record) {
					var jobId = record.get("jobId");
					var jobCode = record.get("jobCode");
					var jobStatus = record.get("jobStatus");
					var img = '';
					if (val == 0)
						img = '<img src="../resources/images/stop.png"/>';
					else
						img = '<img src="../resources/images/start.png"/>';
					return '<a href="javascript:changeImg(' + jobId + ',\''
							+ jobCode + '\',' + jobStatus + ');">' + img
							+ '</a>';
				},
				addBlankSelectForCombox : function(combo) {
					combo.on("select", function() {
						if (combo.getValue() == -1) { // 当选择-1时，把值设置为空
							combo.setValue("");
						}
					});
					combo.store.on("datachanged", function(a) {
						var r = new Ext.data.Record({});
						r.set(combo.valueField, ''); // 添加一格值为-1的选项
						r.set(combo.displayField, combo.emptyText);
						a.insert(0, r);
					});
				},
				onAddClick : function() {
					this.insertWindow.show();
					this.insertWindow.servForm.getForm().reset();
				},
				onModifyClick : function() {
					record = jobConfig.getSelectionModel().getSelected();
					if (record == null) {
						Ext.MessageBox.alert("系统提示", blankStr + "请选择一条记录!"
								+ blankStr);
						return;
					}
					this.updateWindow.show();
					this.updateWindow.jobConfigForm.getForm()
							.loadRecord(record);
				},
				onDeleteClick : function() {
					record = this.getSelectionModel().getSelected();
					if (record == null) {
						Ext.MessageBox.alert("系统提示", blankStr + "请选择一条记录!"
								+ blankStr);
						return;
					}
					JobConfigObj.jobId = record.get('jobId');
					JobConfigObj.jobName = record.get('jobName');
					JobConfigObj.jobCode = record.get('jobCode');
					JobConfigObj.jobType = record.get('jobType');
					JobConfigObj.jobStartStrategy = record
							.get('jobStartStrategy');
					JobConfigObj.jobStatus = record.get('jobStatus');
					JobConfigObj.jobParamType = record.get('jobParamType');
					JobConfigObj.jobParam = record.get('jobParam');
					Ext.MessageBox.confirm("系统提示", "确定要删除该定时任务管理吗?", function(
							btn) {
						if (btn == "yes") {
							JobConfigDwr.remove(JobConfigObj, function(data) {
								if (data.optFlag) {
									Ext.MessageBox.alert("系统提示", blankStr
											+ data.msg + blankStr);
									jobConfig.store.load({
										params : {
											'page.start' : 0,
											'page.pageSize' : COUNT_RECORDS
										}
									});
								} else {
									Ext.MessageBox.alert("系统提示", blankStr
											+ data.msg + blankStr);
								}
							});
						}
					});
				},
				onDblClick : function(e) {

					record = this.getSelectionModel().getSelected();
					if (record == null) {
						Ext.MessageBox.alert("系统提示", blankStr + "请选择一条记录!"
								+ blankStr);
						return;
					}
					this.updateWindow.show();
					this.updateWindow.jobConfigForm.getForm()
							.loadRecord(record);
				}
			});
			jobConfig = new JobConfigGrid();
			jobConfig.store.load({
				params : {
					'page.start' : 0,
					'page.pageSize' : COUNT_RECORDS
				}
			});

		});

function changeImg(jobId, jobCode, status) {
	JobConfigDwr.operTrigger(jobId, jobCode, status, function(data) {
		if (data.optFlag) {
			Ext.MessageBox.alert("系统提示", blankStr + data.msg + blankStr);
			jobConfig.store.load({
				params : {
					'page.start' : 0,
					'page.pageSize' : COUNT_RECORDS
				}
			});
		} else {
			Ext.MessageBox.alert("系统提示", blankStr + data.msg + blankStr);
		}
	});
}