/**
 * 系统参数配置
 * 
 * @class EditForm
 * @extends Ext.ux.Form
 */
var connServ;
var editForm;
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'; // 需要补充的空格
var StConfigObj = {
	configId : "",
	configKey : "",
	configValue : "",
	createTime : "",
	creator : "",
	updateTime : "",
	updator : "",
	descn : ""
};

Ext.onReady(function() {
	Ext.override(Ext.menu.DateMenu, {
				render : function() {
					Ext.menu.DateMenu.superclass.render.call(this);
					if (Ext.isGecko) {
						this.picker.el.dom.childNodes[0].style.width = '178px';
						this.picker.el.dom.style.width = '178px';
					}
				}
			});

	Ext.QuickTips.init();

	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.styleCssValue);
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.parent.styleCssValue);
	var redStar = '<font color=red>' + '*' + '</font>';// 红色星号

//	Ext.Ajax.on('requestcomplete', checkUserSessionStatus, this);
	// 检查用户状态 是否session 超时
	function checkUserSessionStatus(conn, response, options) {
		var sessionStatus = response.getResponseHeader["sessionstatus"];

		if (typeof(sessionStatus) != "undefined") {
			Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
						if (btn == 'ok') {
							var redirect = URL_START + document.location.host
									+ LOG_IN_URL + '?flag=true';
							window.location = redirect;
						}
					});
		}
	}

	EditForm = Ext.extend(Ext.ux.Form, {
		configKey : null,
		configValue : null,
		descn : null,
		configId : null,
		profile : null,
		constructor : function() {
			this.configKey = this.createTextField("参数编码", "configKey", "90%",
					"text", 100, false, "", "超出最大长度100");
			this.configValue = this.createTextField("参数内容", "configValue",
					"90%", "text", 100, false, "", "超出最大长度100");
			this.descn = this.createTextField("参数描述", "descn", "90%", "text",
					100, true, "", "超出最大长度100");
			this.configId = this.createHidden("参数Id", "configId");
			this.profile = new Ext.form.TextField({
				fieldLabel : '文件上传',
				name : 'protocolFile',
				id : 'protocolFile1',
				disabled : false,
				inputType : 'file',
				blankText : '请上传文件',
				anchor : '90%'
				});
			that = this;
			EditForm.superclass.constructor.call(this, {
						title : "系统参数编辑",
						width : Ext.getBody().getViewSize().width * 0.999,
						height : Ext.getBody().getViewSize().height * 0.33,
						region : "center",
						applyTo : "queryform",
						fileUpload : true,
						bodyStyle : "padding: 5px 5px 0",
						items : [{
									layout : "column",
									items : [{
												layout : "form",
												items : this.configKey,
												columnWidth : .3333
											}, {
												layout : "form",
												columnWidth : .3333,
												items : this.configValue
											}, {
												layout : "form",
												columnWidth : .3333,
												items : this.descn
											}, {
												layout : "form",
												items : this.profile,
												columnWidth : .3333
											}, {
												layout : "form",
												items : this.configId,
												columnWidth : .3333
											}]
								}],
						buttons : [{
									text : '添加',
									id : 'add_srp_btn',
									iconCls : 'new',
									width : 20,
									hidden : false,
									handler : this.addFormClick,
									scope : this
								}, {
									text : '修改',
									id : 'modify_srp_btn',
									width : 20,
									iconCls : 'resume',
									hidden : false,
									handler : this.onModifyClick,
									scope : this
								}, {
									text : '重置',
									id : 'resume_srp_btn',
									width : 20,
									iconCls : 'resume',
									hidden : false,
									handler : this.onResumeClick,
									scope : this
								}]

					})
		},
		addFormClick : function() {
			if (!this.getForm().isValid()) {
				Ext.MessageBox.alert("系统提示", blankStr + "请输入必填信息!" + blankStr);
				return;
			} else {
				var that = this;
				if (that.getForm().isValid()) {
					that.getForm().submit({
						url : "saveStConf.action",
						params : {'fileName' : that.profile.getValue()},
						success : function(form,action) {
							Ext.MessageBox.alert("系统提示",blankStr + "参数信息添加成功!"+ blankStr);
							that.formReset() ;
							connServ.store.load({params : {'page.start' : 0,'page.pageSize' : 12}
									});
						},
						failure : function(form,action) {
							var  result = Ext.util.JSON.decode(action.response.responseText);
							var responseStr = result.responseStr
							Ext.MessageBox.alert("系统提示",blankStr + responseStr + blankStr);
						}
					});
				}
			}
		},
		onModifyClick : function() {
			if (!this.getForm().isValid()) {
				Ext.MessageBox.alert("系统提示", blankStr + "请填写必填信息" + blankStr);
				return;
			} else {
				var that = this ;
				if (that.getForm().isValid()) {
					that.getForm().submit({
						url : "updateStConf.action",
						params : {'fileName' : that.profile.getValue(),'configKey':this.configKey.getValue()},
						success : function(form,action) {
							Ext.MessageBox.alert("系统提示",blankStr + "参数信息修改成功!"+ blankStr);
							that.formReset() ;
							connServ.store.load({params : {'page.start' : 0,'page.pageSize' : 12}
									});
						},
						failure : function(form,action) {
							var  result = Ext.util.JSON.decode(action.response.responseText);
							var responseStr = result.responseStr
							Ext.MessageBox.alert("系统提示",blankStr + responseStr + blankStr);
						}
					});
				}
			}
		},
		formReset:function(){
			editForm.getForm().getEl().dom.reset();
			editForm.configKey.setDisabled(false);
			document.getElementById("modify_srp_btn").disabled = true;
			document.getElementById("add_srp_btn").disabled = false;
		},
		onResumeClick : function() {
			record = connServ.getSelectionModel().getSelected();
			if (record == null) {
				editForm.getForm().getEl().dom.reset();
			} else {
				editForm.getForm().loadRecord(record);
			}
		},
		createTextField : function(fieldLabel, name, anchor, inputType,
				maxLength, allowBlank, vtype, maxLengthText) { // 生成一个通用的TextField
			var tf = new Ext.form.TextField({
						fieldLabel : fieldLabel,
						name : name,
						xtype : 'textfield',
						readOnly : false,
						allowBlank : allowBlank,
						anchor : anchor,
						blankText : '该选项为必填项,请输入内容...',
						vtype : vtype,
						inputType : inputType,
						maxLength : maxLength,
						maxLengthText : maxLengthText
					});
			return tf;
		}
	});
	editForm = new EditForm();
	document.getElementById("modify_srp_btn").disabled = true;
	ConnServGrid = Ext.extend(UxGrid, {
		sm : null,
		constructor : function() {
			this.servDefineStore = new Ext.data.Store({ // Grid Store
				proxy : new Ext.data.HttpProxy({
							url : "stConfigAction_listConfig.action",
							method : 'POST'
						}),
				reader : new Ext.data.JsonReader({
							totalProperty : 'page.totalCount',
							root : 'page.result'
						}, [{
									name : 'configId'
								}, {
									name : 'configKey'
								}, {
									name : 'configValue'
								}, {
									name : 'descn'
								}])
			}), this.sm = new Ext.grid.CheckboxSelectionModel({
						singleSelect : true
					}), this.sm.on("rowselect", this.rowSelect, this);
			this.sm.on("rowdeselect", this.rowDeselect, this);
			ConnServGrid.superclass.constructor.call(this, {
						title : '系统参数列表',
						frame : true,
						width : Ext.getBody().getViewSize().width * 0.999,
						renderTo : "grid-div",
						region : "center",
						height : Ext.getBody().getViewSize().height * 0.65,
						viewConfig : {
							forceFit : true
						},
						loadMask : {
							msg : '正在载入数据,请稍候...'
						},
						sm : this.sm,
						cm : new Ext.grid.ColumnModel([
								new Ext.grid.RowNumberer(), this.sm, {
									header : '系统参数id',
									dataIndex : 'configId',
									hidden : true
								}, {
									header : '系统参数编码',
									dataIndex : 'configKey',
									sortable : true,
									hidden : false,
									width : 100
								}, {
									header : '系统参数值',
									dataIndex : 'configValue',
									sortable : true,
									hidden : false
								}, {
									header : '系统参数说明',
									dataIndex : 'descn',
									sortable : true,
									width : 100
								}]),
						bbar : new Ext.PagingToolbar({
									firstText : '第一页',
									nextText : '下一页',
									prevText : '上一页',
									refreshText : '刷新',
									lastText : '最后一页',
									beforePageText : '当前',
									afterPageText : '页/共{0}页',
									pageSize : 12,
									paramNames : {
										start : 'page.start',
										limit : 'page.pageSize'
									},
									store : this.servDefineStore,
									displayInfo : true,
									dsiplayMsg : '本页显示 {0} - {1},共{2}条记录',
									emptyMsg : "没有可显示的记录",
									items : ['-', {
												text : '删除',
												id : 'del_srp_btn',
												iconCls : 'delete',
												handler : this.onDeleteClick,
												scope : this
											}, '-', {
												text : '重载缓存',
												id : 'del_srp_btn',
												iconCls : 'refresh',
												handler : this.onFresh,
												scope : this
											}, '-', {
												text : '重载TC',
												id : 'del_srp_btn',
												iconCls : 'refresh',
												handler : this.onFreshTc,
												scope : this
											}

									]
								}),
						ds : this.servDefineStore
					});
		},
		onFresh:function(){
			StConfigDwr.refreshStConfig(function(data) {
				if (data) {
					Ext.MessageBox.alert("系统提示:", blankStr + '缓存已成功加载'+ blankStr);
				} else {
					Ext.MessageBox
							.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！"+ blankStr);
				}
			});
		},
		onFreshTc:function(){
			StConfigDwr.refreshTCConfig(function(data) {
				if (data) {
					Ext.MessageBox.alert("系统提示:", blankStr + 'TC缓存已成功加载'+ blankStr);
				} else {
					Ext.MessageBox
							.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！"+ blankStr);
				}
			});
		},
		onDeleteClick : function() {
			var that = this ;
			var record = this.selectedRecord();
			if (record) {
				configId = record.get('configId');
				Ext.MessageBox.confirm('系统提示:', '您确定要删除所选参数吗？', function(btn) {
					if (btn == 'yes') {
						StConfigDwr.deleteStConfig(configId, function(data) {
							if (data) {
								Ext.MessageBox.alert("系统提示:", blankStr + '删除成功'+ blankStr);
								connServ.store.load({
											params : {
												'page.start' : 0,
												'page.pageSize' : 12
											}
										});
								if (connServ.store.getCount() == 0) // 服务定义列表中无记录添加按钮可用
									document.getElementById("del_srp_btn").disabled = false;
								that.formReset() ;
								document.getElementById("add_srp_btn").disabled = false;
								document.getElementById("modify_srp_btn").disabled = true;

							} else {
								Ext.MessageBox
										.alert("系统提示:", blankStr
														+ "操作可能出现了某些错误,请重试！"
														+ blankStr);
							}
						});
					}
				});
			} else {
				Ext.Msg.alert('系统提示', blankStr + '请选择一条参数定义记录' + blankStr);
			}

		},
		rowSelect : function() {
			record = this.getSelectionModel().getSelected();
			editForm.getForm().loadRecord(record);
			editForm.configKey.setDisabled(true);
			document.getElementById("modify_srp_btn").disabled = false;
			document.getElementById("add_srp_btn").disabled = true;
		},
		rowDeselect : function() {
			this.formReset();
			document.getElementById("add_srp_btn").disabled = false;
			document.getElementById("modify_srp_btn").disabled = true;
		},
		formReset:function(){
			editForm.getForm().getEl().dom.reset();
			Ext.getCmp('protocolFile1').setRawValue("");
			Ext.getCmp("protocolFile1").reset();
			editForm.configKey.setDisabled(false);
		}
	});
	connServ = new ConnServGrid();
	connServ.store.load({
				params : {
					'page.start' : 0,
					'page.pageSize' : 12
				}
			});

});