Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif'; // 本地图形化

var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'; // 需要补充的空格
var providerUrl = "register/servAffordManRegAction_queryAllServMan4combo.action";
var USERINFO_STORE_URL = 'getUserByOrganId.action';
var SERVMANINFO_STORE_URL = 'register/servAffordManRegAction_queryAllServMan.action';
var SERV_LIMIT_URL ='register/servAffordManRegAction_queryLimitServ.action';
var versionStore = null;

var servDefineGrid;
var servGrid;
var servVisitGrid;
var servSubscribGrid;
var servManVisitGrid;
var servTree;
var userGridCount;
var PAGESIZE = 10;
var tabPanel;
var nodeId;

var dialog;
var preNode = null; // 保存前一次点击的节点

var servType;
var dwrLoadMask;

/** *************************************ServVisitLimitGrid组件************************************************** */
ServVisitLimitGrid = Ext.extend(UxGrid, {

	servVisitStore : new Ext.data.Store({
		proxy : new Ext.data.HttpProxy({
			url : SERV_LIMIT_URL,
			method : 'POST'
		}),
		reader : new Ext.data.JsonReader({
			totalProperty : 'totalProperty',
			root : 'servLimitList'
		}, [ {
			name : 'servLimitId'
		}, {
			name : 'servManId'
		}, {
			name : 'servId'
		}, {
			name : 'servName'
		}, {
			name : 'servManName'
		}, {
			name : 'versionNo'
		}, {
			name : 'isConfirm'
		}, {
			name : 'flux'
		}, {
			name : 'frequency'
		}])
	}),
	servVisitSm : new Ext.grid.CheckboxSelectionModel({
		header : '',
		handleMouseDown : Ext.emptyFn
	}),
	constructor : function() {
		ServVisitLimitGrid.superclass.constructor.call(this, {
			frame : true,
			clicksToEdit : 1,
			stripeRows : true,
			width : Ext.getBody().getViewSize().width - 250,
			height : Ext.getBody().getViewSize().height - 65,
			viewConfig : {
				forceFit : true
			},
			loadMask : {
				msg : '正在载入数据,请稍候...'
			},
			sm : this.servVisitSm,
			cm : new Ext.grid.ColumnModel([ new Ext.grid.RowNumberer(),
					 {
						header : '服务id',
						dataIndex : 'servId',
						width : 80,
						hidden : true
					}, {
						header : '服务名称',
						dataIndex : 'servName',
						width : 120
					}, {
						header : '所属'+show_name,
						dataIndex : 'servManName',
						width : 120
					}, {
						header : '服务版本',
						dataIndex : 'versionNo',
						width : 60
					}, {
						header : '是否需要确认',
						dataIndex : 'isConfirm',
						hidden : true,
						id : 'isConfirm',
						width : 60,
						renderer:this.formatConfirm
					},{
						header : '流量配置信息',
						dataIndex : 'flux',
						width : 120
					}, {
						header : '频度控制信息',
						dataIndex : 'frequency',
						width : 120
					} ]),
			ds : this.servVisitStore,
			bbar : new Ext.PagingToolbar({
				firstText : '第一页',
				nextText : '下一页',
				prevText : '上一页',
				refreshText : '刷新',
				lastText : '最后一页',
				beforePageText : '当前',
				afterPageText : '页/共{0}页',
				pageSize : 10,
				store : this.servVisitStore,
				displayInfo : false,
				dsiplayMsg : '本页显示 {0} - {1},共{2}条记录',
				emptyMsg : "没有可显示的记录"
			}),
			listeners : {
			}
		});
	},
	formatConfirm : function(val) {
		value = '';
		if (val == 1 || val == true) {
			value = '是';
		} else if (val == '2') {
			value = '否';
		} else {
			value = '请选择...';
		}
		return value;
	},
	createCombo1 : function(id, name, url, root, width) { // 生成一个通用的ComboBox
		var combo = new Ext.form.ComboBox({
			emptyText : '请选择...',
			isFormField : true,
			mode : 'local',
			triggerAction : 'all',
			width : width,
			readOnly : true,
			displayField : name,
			valueField : id,
			store : new Ext.data.Store({
				proxy : new Ext.data.HttpProxy({
					url : url,
					method : 'POST'
				}),
				reader : new Ext.data.JsonReader({
					root : root
				}, new Ext.data.Record.create([ {
					name : id
				}, {
					name : name
				} ]))
			})
		});
		return combo;
	},
	createCheckBox : function(checked, inputValue, name) {
		var checkBox = new Ext.form.Checkbox({
			checked : checked,
			inputValue : inputValue,
			name : name,
			hideLabel : true,
			labelSeparator : '',
			boxLabel : "是",
			autoShow : true
		});
		return checkBox;

	}
});
/*
 * 流量控制FLUXFORM
 * 
 */
FluxForm = Ext
		.extend(
				Ext.ux.Form,
				{
					servManCombo : null,
					servNoCombox : null,
					fluxtexta : null,
					fluxtextb : null,
					fluxtextc : null,
					fluxtextd : null,
					constructor : function() {
						this.servManCombo = this.createCombo2("服务商",
								"servManName", "servManId", "servManName",
								"90%", providerUrl, "servManList",
								'totalProperty', false);
						this.servNoCombox = this
								.createCombo1(
										"服务版本",
										"versionNo",
										"versionNo",
										"register/servDefineAction_queryServDefineVersion.action",
										"servDefineDtoList", "90%", false);

						
						this.fluxtexta = new Ext.form.NumberField({
							fieldLabel : "流量配置",
							labelWidth : 60,
							name : 'fluxtexta',
							width : 90
						});
						this.fluxtextb = new Ext.form.NumberField({
							name : 'fluxtextb',
							labelWidth : 60,
							width : 90,
							hideLabel : true
						});
						this.fluxtextc = new Ext.form.NumberField({
							fieldLabel : "频度控制",
							name : 'fluxtextc',
							labelWidth : 60,
							width : 90
						});
						this.fluxtextd = new Ext.form.NumberField({
							fieldLabel : "",
							name : 'fluxtextd',
							width : 90,
							labelWidth : 60,
							hideLabel : true
						});
						FluxForm.superclass.constructor.call(this, {
							height : 200,
							labelWidth : 55,
							frame : true,
							autoScroll : false,
							bodyStyle : "padding: 5px 5px 0",
							items : [ this.servManCombo, this.servNoCombox, {
								layout : 'column',
								items : [ {
									columnWidth : .52,
									items : [ {
										layout : 'form',
										labelPad : 2,
										items : this.fluxtexta
									} ]
								}, {
									columnWidth : 0.08,
									items : [ {
										xtype : 'label',
										text : 'KB/'
									} ]
								}, {
									columnWidth : 0.3,
									items : [ this.fluxtextb ]
								}, {
									columnWidth : 0.1,
									items : [ {
										xtype : 'label',
										text : '秒'
									} ]
								} ]
							}, {
								layout : 'column',
								items : [ {
									columnWidth : .52,
									items : [ {
										layout : 'form',
										labelPad : 2,
										items : this.fluxtextc
									} ]
								}, {
									columnWidth : 0.08,
									items : [ {
										xtype : 'label',
										text : '次/'
									} ]
								}, {
									columnWidth : 0.3,
									items : [ this.fluxtextd ]
								}, {
									columnWidth : 0.1,
									items : [ {
										xtype : 'label',
										text : '秒'
									} ]
								} ]

							} ],
							buttons : [ {
								text : '确定',
								id : 'add_serv_btn',
								iconCls : 'new',
								width : 20,
								handler : this.insert,
								scope : this
							}, {
								text : '清空',
								id : "reset_serv_btn",
								width : 20,
								iconCls : 'refresh',
								handler : this.onResetClick,
								scope : this
							}, {
								text : '修改',
								id : 'update_serv_btn',
								width : 20,
								iconCls : 'update',
								handler : this.onUpdateClick,
								scope : this
							}, {
								text : '重置',
								width : 20,
								id : "resume_serv_btn",
								iconCls : 'resume',
								handler : this.onResumeClick,
								scope : this
							}]

						});

					},
					insert : function() { // 增加权限
						if ((!this.servManCombo.isValid())
								|| (!this.servNoCombox.isValid())
								|| ((this.fluxtexta.getValue() == '') ^ (this.fluxtextb
										.getValue() == ''))
								|| ((this.fluxtextc.getValue() == '') ^ (this.fluxtextd
										.getValue() == ''))) {
							Ext.MessageBox.alert("系统提示", blankStr + "请输入必填信息!"
									+ blankStr);
							return;
						} else {
							var that = this;
							var node = servTree.getSeletedNode();
							var servManId = this.servManCombo.getValue();
							var versionNo = this.servNoCombox.getValue();
							var flux = this.fluxtexta.getValue() + "KB/"
									+ this.fluxtextb.getValue() + "秒";

							var frequency = this.fluxtextc.getValue() + "次/"
									+ this.fluxtextd.getValue() + "秒";
							if (flux == "KB/秒") {
								flux = null;
							}
							;
							if ("次/秒" == frequency) {
								frequency = null;
							}
							;
							var servId = node.id.substring(5);
							ServManServRegDwr
									.check(
											servManId,
											servId,
											versionNo,
											function(data) {
												if (data == false) {
													ServManServRegDwr
															.insertServVisitLimit(
																	servManId,
																	servId,
																	versionNo,
																	flux,
																	frequency,
																	function(
																			data) {
																		if (data == true) {
																			Ext.MessageBox
																					.alert(
																							"系统提示",
																							"权限设置成功!");
																			servManVisitGrid.insertFluxMonitorWindow
																					.hide();
																			that
																					.getForm()
																					.reset();
																			queryVisitLimit();
																		} else {
																			Ext.MessageBox
																					.alert(
																							"系统提示",
																							"添加失败!");
																		}
																	});
												} else {
													Ext.MessageBox.alert(
															"系统提示", "禁止重复添加");
												}
											});

						}
					},
					onResetClick : function() {
						this.getForm().reset();
					},
					onUpdateClick : function() { // 修改权限
						if ((!this.servManCombo.isValid())
								|| (!this.servNoCombox.isValid())								
								|| ((this.fluxtexta.getValue() == '') ^ (this.fluxtextb
										.getValue() == ''))
								|| ((this.fluxtextc.getValue() == '') ^ (this.fluxtextd
										.getValue() == ''))) {
							Ext.MessageBox.alert("系统提示", blankStr + "请输入必填信息!"
									+ blankStr);
							return;
						} else {
							var that = this;
							var node = servTree.getSeletedNode();
							var servLimitId = servManVisitGrid
									.getSelectionModel().getSelected().get(
											"servLimitId");
							var servManId = servManVisitGrid
									.getSelectionModel().getSelected().get(
											"servManId");
							var versionNo = this.servNoCombox.getValue();
							var isConfirm = servManVisitGrid
									.getSelectionModel().getSelected().get(
											"isConfirm");

							var flux = this.fluxtexta.getValue() + "KB/"
									+ this.fluxtextb.getValue() + "秒";

							var frequency = this.fluxtextc.getValue() + "次/"
									+ this.fluxtextd.getValue() + "秒";
							if (flux == "KB/秒") {
								flux = null;
							}
							;
							if ("次/秒" == frequency) {
								frequency = null;
							}
							;
							var servId = node.id.substring(5);
							ServManServRegDwr
									.updateServVisitLimita(
											isConfirm,
											servLimitId,
											servManId,
											servId,
											versionNo,
											flux,
											frequency,
											function(data) {
												if (data == true) {
													Ext.MessageBox.alert(
															"系统提示", "修改成功！");
													servManVisitGrid.updateFluxMonitorWindow
															.hide();
													that.getForm().reset();
													queryVisitLimit();
												} else {
													Ext.MessageBox.alert(
															"系统提示", "修改失败!");
												}
											});

						}

					},
					onResumeClick : function() {// 重置回原来数据
						record = servManVisitGrid.getSelectionModel()
								.getSelected();
						if (record == null) {
							this.getForm().reset();
						} else {
							var servManId = record.get("servManId");
							var servLimitId = record.get("servLimitId");
							var servId = record.get("servId");
							var versionNo = record.get("versionNo");
							var isConfirm = record.get("isConfirm");
							var servManName = record.get("servManName");
							if (record.get("flux") != null) {
								var flux = record.get("flux");
								var fluxback = flux.split('KB/');
								var fluxtexta = fluxback[0];
								var fluxbackb = fluxback[1];
								var fluxbackc = fluxbackb.split('秒');
								var fluxtextb = fluxbackc[0];
							} else {
								var fluxtexta = null;
								var fluxtextb = null
							}
							if (record.get("frequency") != null) {
								var frequency = record.get("frequency");
								var frequencyback = frequency.split('次/');
								var frequencybackb = frequencyback[1];
								var frequencybackc = frequencybackb.split('秒');
								var fluxtextc = frequencyback[0];
								var fluxtextd = frequencybackc[0];
							} else {
								var fluxtextd = null;
								var fluxtextc = null
							}
							var TopicRecord = Ext.data.Record.create([ {
								name : 'servManId',
								mapping : 'servManId'
							}, {
								name : 'servLimitId',
								mapping : 'servLimitId'
							}, {
								name : 'servId',
								mapping : 'servId'
							}, {
								name : 'versionNo',
								mapping : 'versionNo'
							}, {
								name : 'servManName',
								mapping : 'servManName'
							}, {
								name : 'isConfirm',
								mapping : 'isConfirm'
							}, {
								name : 'fluxtexta',
								mapping : 'fluxtexta'
							}, {
								name : 'fluxtextb',
								mapping : 'fluxtextb'
							}, {
								name : 'fluxtextc',
								mapping : 'fluxtextc'
							}, {
								name : 'fluxtextd',
								mapping : 'fluxtextd'
							} ]);
							var newrecord = new TopicRecord({
								servManId : servManId,
								servLimitId : servLimitId,
								servId : servId,
								versionNo : versionNo,
								servManName : servManName,
								isConfirm : isConfirm,
								fluxtexta : fluxtexta,
								fluxtextb : fluxtextb,
								fluxtextc : fluxtextc,
								fluxtextd : fluxtextd
							});

							this.getForm().loadRecord(newrecord);
						}
					},
					createCombo1 : function(fieldLabel, id, name, url, root,
							anchor, allowblank) { // 生成一个通用的ComboBox
						var combo = new Ext.form.ComboBox({
							fieldLabel : fieldLabel,
							emptyText : '请选择...',
							isFormField : true,
							mode : 'local',
							triggerAction : 'all',
							anchor : anchor,
							name : name,
							allowBlank : allowblank,
							readOnly : true,

							displayField : name,
							valueField : id,
							store : new Ext.data.Store({
								proxy : new Ext.data.HttpProxy({
									url : url,
									method : 'POST'
								}),
								reader : new Ext.data.JsonReader({
									root : root
								}, new Ext.data.Record.create([ {
									name : id
								}, {
									name : name
								} ]))
							})
						});
						return combo;
					}
				});


/** ****************************************增加流量控制窗口**************************** */

InsertFluxMonitorWindow = Ext.extend(Ext.Window, {
	fluxForm : null,
	constructor : function() {
		this.fluxForm = new FluxForm();
		Ext.getCmp('add_serv_btn').show(); 
		Ext.getCmp('reset_serv_btn').show(); 
		Ext.getCmp('update_serv_btn').hide(); 
	    Ext.getCmp('resume_serv_btn').hide(); 
		InsertFluxMonitorWindow.superclass.constructor.call(this, {
			title : "访问权限配置",
			width : 360,
			height : 233,
			resizable : false,
			plain : true,
			modal : false,
			autoScroll : false,
			closeAction : 'hide',
			items : [ this.fluxForm ]
		});
	}
});
/** ***************************************修改流量控制窗口**************************************** */

UpdateFluxMonitorWindow = Ext.extend(Ext.Window, {
	updatefluxForm : null,
	constructor : function() {
		this.updatefluxForm = new FluxForm();
		Ext.getCmp('add_serv_btn').hide(); // 隐藏添加按钮
		Ext.getCmp('reset_serv_btn').hide(); // 隐藏清空按钮
		Ext.getCmp('update_serv_btn').show(); // 显示修改按钮
	    Ext.getCmp('resume_serv_btn').show(); // 显示重置按钮
		UpdateFluxMonitorWindow.superclass.constructor.call(this, {
			title : "访问权限配置",
			width : 360,
			height : 233,
			resizable : false,
			plain : true,
			modal : false,
			autoScroll : false,
			closeAction : 'hide',
			items : [ this.updatefluxForm ]
		});
	}
});

/** *************************************ServManVisitLimitGrid组件************************************************** */
ServManVisitLimitGrid = Ext.extend(Ext.grid.EditorGridPanel, {

	servManVisitStore : new Ext.data.Store({
		proxy : new Ext.data.HttpProxy({
			url : SERVMANINFO_STORE_URL,
			method : 'POST'
		}),
		reader : new Ext.data.JsonReader({
			totalProperty : 'totalProperty',
			root : 'servManList'
		}, [ {
			name : 'servManId'
		}, {
			name : 'servManName'
		}, {
			name : 'versionNo'
		}, {
			name : 'isConfirm'
		}, {
			name : 'servLimitId'
		}, {
			name : 'flux'
		}, {
			name : 'frequency'
		} ])
	}),
	servManVisitSm : new Ext.grid.CheckboxSelectionModel({
		header : '',
		handleMouseDown : Ext.emptyFn
	}),
	servNoCombox : null,
	servNoCombox1 : null,
	confirmCombox : null,
	cmWebservice : null,
	cmJms : null,
	constructor : function() {
		this.servNoCombox = this.createCombo1("versionNo", "versionNo",
				"register/servDefineAction_queryServDefineVersion.action",
				"servDefineDtoList", 130);
		this.servNoCombox1 = this.createCombo1("versionNo", "versionNo",
				"register/servDefineAction_queryServDefineVersion.action",
				"servDefineDtoList", 130);
		this.confirmCombox = this.createCheckBox(true, 1, 'isConfirm');
		this.insertFluxMonitorWindow = new InsertFluxMonitorWindow();
		this.updateFluxMonitorWindow = new UpdateFluxMonitorWindow();
		this.cmWebservice = new Ext.grid.ColumnModel([
		new Ext.grid.RowNumberer(),

		{
			header : 'id',
			dataIndex : 'servManId',
			width : 120,
			hidden : true
		}, {
			header : show_name,
			dataIndex : 'servManName',
			width : (Ext.getBody().getViewSize().width - 120) / 3
		}, {
			header : '服务版本',
			dataIndex : 'versionNo',
			width : (Ext.getBody().getViewSize().width - 120) / 3,
			renderer : this.formatVersion
		}, {
			header : '流量配置信息',
			dataIndex : 'flux',
			width : (Ext.getBody().getViewSize().width - 120) / 3
		}, {
			header : '频度控制信息',
			dataIndex : 'frequency',
			width : (Ext.getBody().getViewSize().width - 120) / 3
		} ]), this.cmJms = new Ext.grid.ColumnModel([
				new Ext.grid.RowNumberer(), {
					header : 'id',
					dataIndex : 'servManId',
					width : 120,
					hidden : true
				}, {
					header : show_name,
					dataIndex : 'servManName',
					width : (Ext.getBody().getViewSize().width - 250) / 5
				}, {
					header : '服务版本',
					dataIndex : 'versionNo',
					width : (Ext.getBody().getViewSize().width - 250) / 5,
					renderer : this.formatVersion
				}, {
					header : '流量配置信息',
					dataIndex : 'flux',
					width : (Ext.getBody().getViewSize().width - 250) / 5
				}, {
					header : '频度控制信息',
					dataIndex : 'frequency',
					width : (Ext.getBody().getViewSize().width - 250) / 5
				}, {
					header : '是否需要确认',
					dataIndex : 'isConfirm',
					width : (Ext.getBody().getViewSize().width - 250) / 5,
					editor : new Ext.grid.GridEditor(this.confirmCombox),
					renderer : this.formatConfirm
				} ]), ServManVisitLimitGrid.superclass.constructor.call(this, {
			frame : true,
			width : Ext.getBody().getViewSize().width - 250,
			height : Ext.getBody().getViewSize().height - 100,
			autoWidth : true,
			clicksToEdit : 1,
			viewConfig : {
				forceFit : true
			},
			loadMask : {
				msg : '正在载入数据,请稍候...'
			},
			sm : new Ext.grid.RowSelectionModel({
				singleSelect : true
			}),
			cm : this.cmWebservice,
			ds : this.servManVisitStore,
			bbar : new Ext.PagingToolbar({
				firstText : '第一页',
				nextText : '下一页',
				prevText : '上一页',
				refreshText : '刷新',
				lastText : '最后一页',
				beforePageText : '当前',
				afterPageText : '页/共{0}页',
				pageSize : 10,
				store : this.servManVisitStore,
				displayInfo : false,
				dsiplayMsg : '本页显示 {0} - {1},共{2}条记录',
				emptyMsg : "没有可显示的记录",
				items : [ '-', {
					text : '添加',
					id : 'bbar_newServDefine',
					iconCls : 'new',
					handler : this.onAddClick,
					scope : this
				}, '-', {
					text : '修改',
					id : 'bbar_updateServDefine',
					iconCls : 'update',
					handler : this.onModifyClick,
					scope : this
				}, '-', {
					text : '删除',
					iconCls : 'delete',
					handler : this.onDeleteClick,
					scope : this
				} ]
			}),

			listeners : {
				"dblclick" : {
					fn : this.onModifyClick,
					scope : this
				},
				'afteredit' : {
					fn : this.gridCellEdit,
					scope : this
				}

			}
		});
	},
	onAddClick : function() {
		var win = this.insertFluxMonitorWindow;
		win.fluxForm.servNoCombox.reset();
		win.fluxForm.servNoCombox.store.load({
			params : {
				'servDefineDto.servId' : servId4serMan_servReg,
				'servDefineDto.servCode' : ''
			}
		});
		win.fluxForm.servManCombo.reset();
		win.fluxForm.servManCombo.store.load({
			params : {
				servId : servId4serMan_servReg
			}
		});
		win.show();
	},
	onModifyClick : function() {
		var record = servManVisitGrid.getSelectionModel().getSelected();
		var win = this.updateFluxMonitorWindow;
		win.updatefluxForm.servNoCombox.reset();		
		win.updatefluxForm.servNoCombox.store.load({
			params : {
				'servDefineDto.servId' : servId4serMan_servReg,
				'servDefineDto.servCode' : ''
			}
		});
		win.updatefluxForm.servManCombo.disabled=true;
		if (record) {
			var servManId = record.get("servManId");
			var servLimitId = record.get("servLimitId");
			var servId = record.get("servId");
			var versionNo = record.get("versionNo");
			var isConfirm = record.get("isConfirm");
			var servManName = record.get("servManName");
			if (record.get("flux") != null) {
				var flux = record.get("flux");
				var fluxback = flux.split('KB/');
				var fluxtexta = fluxback[0];
				var fluxbackb = fluxback[1];
				var fluxbackc = fluxbackb.split('秒');
				var fluxtextb = fluxbackc[0];
			} else {
				var fluxtexta = null;
				var fluxtextb = null
			}
			if (record.get("frequency") != null) {
				var frequency = record.get("frequency");
				var frequencyback = frequency.split('次/');
				var frequencybackb = frequencyback[1];
				var frequencybackc = frequencybackb.split('秒');
				var fluxtextc = frequencyback[0];
				var fluxtextd = frequencybackc[0];
			} else {
				var fluxtextd = null;
				var fluxtextc = null
			}
			var TopicRecord = Ext.data.Record.create([ {
				name : 'servManId',
				mapping : 'servManId'
			}, {
				name : 'servLimitId',
				mapping : 'servLimitId'
			}, {
				name : 'servId',
				mapping : 'servId'
			}, {
				name : 'versionNo',
				mapping : 'versionNo'
			}, {
				name : 'servManName',
				mapping : 'servManName'
			}, {
				name : 'isConfirm',
				mapping : 'isConfirm'
			}, {
				name : 'fluxtexta',
				mapping : 'fluxtexta'
			}, {
				name : 'fluxtextb',
				mapping : 'fluxtextb'
			}, {
				name : 'fluxtextc',
				mapping : 'fluxtextc'
			}, {
				name : 'fluxtextd',
				mapping : 'fluxtextd'
			} ]);

			var newrecord = new TopicRecord({
				servManId : servManId,
				servLimitId : servLimitId,
				servId : servId,
				versionNo : versionNo,
				servManName : servManName,
				isConfirm : isConfirm,
				fluxtexta : fluxtexta,
				fluxtextb : fluxtextb,
				fluxtextc : fluxtextc,
				fluxtextd : fluxtextd
			});

			win.show();
			this.updateFluxMonitorWindow.updatefluxForm.getForm().loadRecord(
					newrecord);
		} else {
			Ext.Msg.alert('系统提示', '请选择一条权限记录');
		}
		;
	},
	onDeleteClick : function() {
		var record = servManVisitGrid.getSelectionModel().getSelected();

		if (record) {
			Ext.MessageBox.confirm('系统提示', '确认删除吗?', function(btn) {
				if (btn == 'yes') {
					var servManId = record.get("servManId");
					var node = servTree.getSeletedNode();
					var servId = node.id.substring(5);
					ServManServRegDwr.delServVisitLimit(servManId, servId,
							function(data) {
								if (data == true) {
									Ext.MessageBox.alert("系统提示", "删除成功!");
									queryVisitLimit();
								} else {
									Ext.MessageBox.alert("系统提示", "删除失败!");
									queryVisitLimit();
								}
							})
				} else {
					return
				}
			})

		} else {
			Ext.Msg.alert('系统提示', '请选择一条权限记录');
		}
		;
	},
	// 修改异步服务是否需要确定
	gridCellEdit : function(e) {
		var record = servManVisitGrid.getSelectionModel().getSelected();
		var node = servTree.getSeletedNode();
		var flux = record.get("flux");
		var frequency = record.get("frequency");
		var servLimitId = record.get("servLimitId");
		var servManId = record.get("servManId");
		var isConfirm = record.get("isConfirm");
		var versionNo = servManVisitGrid.getSelectionModel().getSelected().get(
				"versionNo");
		var servId = node.id.substring(5);
		if (isConfirm == true) {
			isConfirm = 1;
		} else if (isConfirm == false) {
			isConfirm = 0;
		} else {
			isConfirm = '';
		}
		;
		Ext.MessageBox.confirm('系统提示', '服务是否需要确定标记发生改变是否保存?', function(btn) {
			if (btn == 'yes') {
				ServManServRegDwr.updateServVisitLimita(isConfirm, servLimitId,
						servManId, servId, versionNo, flux, frequency,
						function(data) {
							if (data) {
								dwrLoadMask.hide();
								Ext.MessageBox.alert("系统提示:", blankStr
										+ "标记设置生效" + blankStr, function(btn) {
									if (btn == 'ok') {
										queryVisitLimit();
									}
								});
							} else {
								dwrLoadMask.hide();
								Ext.MessageBox.alert("系统提示:", blankStr
										+ "操作可能出现了某些错误,请重试！" + blankStr);
								e.grid.getSelectionModel().selectRow(e.row,
										true);
							}
						})
			} else {
				e.grid.getSelectionModel().selectRow(e.row, true);
			}
		})

	},
	createCombo1 : function(id, name, url, root, width) { // 生成一个通用的ComboBox
		var combo = new Ext.form.ComboBox({
			emptyText : '请选择...',
			isFormField : true,
			mode : 'local',
			triggerAction : 'all',
			width : width,
			readOnly : true,
			displayField : name,
			valueField : id,
			store : new Ext.data.Store({
				proxy : new Ext.data.HttpProxy({
					url : url,
					method : 'POST'
				}),
				reader : new Ext.data.JsonReader({
					root : root
				}, new Ext.data.Record.create([ {
					name : id
				}, {
					name : name
				} ]))
			})
		});
		return combo;
	},
	createCheckBox : function(checked, inputValue, name) {
		var checkBox = new Ext.form.Checkbox({
			checked : checked,
			inputValue : inputValue,
			name : name,
			hideLabel : true,
			labelSeparator : '',
			boxLabel : "是",
			autoShow : true
		});
		return checkBox;

	},
	formatConfirm : function(val) {
		value = '';
		if (val == 1 || val == true) {
			value = '是';
		} else if (val == '2') {
			value = '否';
		} else {
			value = '请选择...';
		}
		return value;
	},
	formatVersion : function(val) {
		value = '';
		if (val != '0' && val != null) {
			value = 'V' + val;
		} else {
			value = '请选择...';
		}
		return value;
	}
});

/** 服务订阅权限列表 */
ServSubscribeVisitLimitGrid = Ext
		.extend(
				Ext.grid.EditorGridPanel,
				{

					servSubScribeStore : new Ext.data.Store({
						proxy : new Ext.data.HttpProxy({
							url : SERVINFO_STORE_URL,
							method : 'POST'
						}),
						reader : new Ext.data.JsonReader({
							id : "servId",
							root : 'servDtoList'
						}, [ {
							name : 'servManId'
						}, {
							name : 'servManName'
						}, {
							name : 'versionNo'
						}, {
							name : 'subscribeConfId'
						}, {
							name : 'servDefineId'
						}, {
							name : 'servName'
						}, {
							name : 'servId'
						} ])
					}),
					servVisitSm : new Ext.grid.CheckboxSelectionModel({
						header : '',
						handleMouseDown : Ext.emptyFn
					}),
					servSubscribeVisitSm : new Ext.grid.CheckboxSelectionModel(
							{
								header : '',
								handleMouseDown : Ext.emptyFn
							}),
					servNoCombox : null,
					servNoCombox1 : null,
					confirmCombox : null,
					cmWebservice : null,
					cmJms : null,
					constructor : function() {
						this.servNoCombox = this
								.createCombo1(
										"versionNo",
										"versionNo",
										"register/servDefineAction_queryServDefineVersion.action",
										"servDefineDtoList", 130);
						this.confirmCombox = this.createCheckBox(true, 1,
								'isConfirm');
								this.cmWebservice = new Ext.grid.ColumnModel([
										new Ext.grid.RowNumberer(),
										this.servSubscribeVisitSm,
										{
											header : 'id',
											dataIndex : 'servManId',
											width : 120,
											hidden : true
										},
										{
											header : '接入系统',
											dataIndex : 'servManName',
											width : 120
										},
										{
											header : '服务',
											dataIndex : 'servName',
											width : 120
										},
										{
											header : '服务版本',
											dataIndex : 'versionNo',
											width : 120,
											editor : new Ext.grid.GridEditor(
													this.servNoCombox),
											renderer : this.formatVersion
										} ]),
								ServSubscribeVisitLimitGrid.superclass.constructor
										.call(this, {
											width : 745,
											height : 420,
											autoWidth : true,
											clicksToEdit : 1,
											viewConfig : {
												forceFit : true
											},
											loadMask : {
												msg : '正在载入数据,请稍候...'
											},
											sm : this.servSubscribeVisitSm,
											cm : this.cmWebservice,
											ds : this.servSubScribeStore,
											listeners : {
												'cellclick' : {
													fn : this.gridCellClick,
													scope : this
												},
												'afteredit' : {
													fn : this.gridCellEdit,
													scope : this
												},
												'beforeEdit' : {
													fn : this.beforeCellEdit,
													scope : this
												}
											}
										});
					},
					// 为选中的服务增加或取消就订阅的服务与版本
					gridCellClick : function(grid, rowIndex, columnIndex, e) {
						var selNode = servTree.getSeletedNode();
						var pNode = selNode.parentNode;
						/**
						 * 找到上层服务商节点
						 */
						while (pNode.id.indexOf('man') == -1) {
							pNode = pNode.parentNode;
							if (pNode.id.indexOf('serv_directory_level') != -1) {
								Ext.MessageBox.alert('系统提示', '上层节点无服务商操作错误!');
								return;
							}
						}
						if (selNode.id.indexOf('man') != -1) {
							Ext.Msg
									.alert('系统提示', blankStr + '请选择服务'
											+ blankStr);
							return;
						}
						if (!this.servSubscribeVisitSm.isLocked()) {
							if (columnIndex == 1) {
								var record = grid.getStore().getAt(rowIndex);
								var status = grid.getSelectionModel()
										.isSelected(record);
								var versionNo = record.get('versionNo');

								if (versionNo == '请选择...') {
									versionNo = '0.1';
								}
								Ext.MessageBox
										.confirm(
												'系统提示:',
												'您确定要变更服务的订阅配置信息吗？',
												function(btn) {
													if (btn == 'yes') {
														dwrLoadMask.show();
														var subConfId = null;
														if (record.data.subscribeConfId == null) {
															subConfId = 0;
														} else {
															subConfId = record.data.subscribeConfId;
														}
														if (status) {
															ServManServRegDwr
																	.saveOrUpdateSubscribeConf(
																			subConfId,
																			record.data.servManId,
																			servDefineId,
																			record.data.servId,
																			record.data.versionNo,
																			function(
																					data) {
																				if (data) {
																					dwrLoadMask
																							.hide();
																					Ext.MessageBox
																							.alert(
																									"系统提示:",
																									blankStr
																											+ "设置生效"
																											+ blankStr,
																									function(
																											btn) {
																										if (btn == 'ok') {
																											this.servSubScribeStore
																													.load({
																														params : {
																															servAffordManId : pNode
																														},
																														callback : function() { // 加载非选中接入系统注册的服务
																															this
																																	.getSelectionModel()
																																	.clearSelections();
																															dwr.engine
																																	.setAsync(false);
																															servDefineId = that.servDefineIdHidden
																																	.getValue();
																															ServManServRegDwr
																																	.getSubscribeConfById(
																																			servDefineId,
																																			function(
																																					data) {
																																				var store = this
																																						.getStore();
																																				for ( var i = 0; i < data.length; i++) {
																																					var idIndex = store
																																							.indexOfId(data[i].servId); // 根据id查找该记录所在行
																																					this
																																							.getSelectionModel()
																																							.selectRow(
																																									idIndex,
																																									true);
																																					record = store
																																							.getAt(idIndex);
																																					record
																																							.set(
																																									'versionNo',
																																									data[i].versionNo);
																																					record
																																							.set(
																																									'subscribeConfId',
																																									data[i].subscribeConfId);
																																					record
																																							.set(
																																									'servDefineId',
																																									data[i].servDefineId);
																																					record.dirty = false;
																																					record
																																							.commit();
																																				}
																																			});
																															dwr.engine
																																	.setAsync(true);
																															checkPrivilege(arrId);
																														}
																													});
																										}
																									});
																				} else {
																					dwrLoadMask
																							.hide();
																					Ext.MessageBox
																							.alert(
																									"系统提示:",
																									blankStr
																											+ "操作可能出现了某些错误,请重试！"
																											+ blankStr);
																					grid
																							.getSelectionModel()
																							.deselectRow(
																									rowIndex);
																				}
																			});
														} else {
															ServManServRegDwr
																	.deleteSubscribeConf(
																			subConfId,
																			record.data.servDefineId,
																			function(
																					data) {
																				if (data) {
																					dwrLoadMask
																							.hide();
																					Ext.MessageBox
																							.alert(
																									"系统提示:",
																									blankStr
																											+ "设置生效"
																											+ blankStr,
																									function(
																											btn) {
																										if (btn == 'yes') {
																											this.servSubScribeStore
																													.load({
																														params : {
																															servAffordManId : pNode
																														},
																														callback : function() { // 加载非选中接入系统注册的服务
																															this
																																	.getSelectionModel()
																																	.clearSelections();
																															dwr.engine
																																	.setAsync(false);
																															servDefineId = that.servDefineIdHidden
																																	.getValue();
																															ServManServRegDwr
																																	.getSubscribeConfById(
																																			servDefineId,
																																			function(
																																					data) {
																																				var store = this
																																						.getStore();
																																				for ( var i = 0; i < data.length; i++) {
																																					var idIndex = store
																																							.indexOfId(data[i].servId); // 根据id查找该记录所在行
																																					this
																																							.getSelectionModel()
																																							.selectRow(
																																									idIndex,
																																									true);
																																					record = store
																																							.getAt(idIndex);
																																					record
																																							.set(
																																									'versionNo',
																																									data[i].versionNo);
																																					record
																																							.set(
																																									'subscribeConfId',
																																									data[i].subscribeConfId);
																																					record
																																							.set(
																																									'servDefineId',
																																									data[i].servDefineId);
																																					record.dirty = false;
																																					record
																																							.commit();
																																				}
																																			});
																															dwr.engine
																																	.setAsync(true);
																															checkPrivilege(arrId);
																														}
																													});
																										}
																									});
																				} else {
																					dwrLoadMask
																							.hide();
																					Ext.MessageBox
																							.alert(
																									"系统提示:",
																									blankStr
																											+ "操作可能出现了某些错误,请重试！"
																											+ blankStr);
																					grid
																							.getSelectionModel()
																							.selectRow(
																									rowIndex,
																									true);
																				}
																			});

														}
													} else {
														if (status)
															grid
																	.getSelectionModel()
																	.deselectRow(
																			rowIndex);
														else
															grid
																	.getSelectionModel()
																	.selectRow(
																			rowIndex,
																			true);
													}
												});
							}
						}
					},
					// 修改服务的订阅服务
					gridCellEdit : function(e) {
						var selNode = servTree.getSeletedNode();
						if (selNode.id.indexOf('man') != -1) {
							Ext.Msg
									.alert('系统提示', blankStr + '请选择服务'
											+ blankStr);
							return;
						}
						if (!this.servSubscribeVisitSm.isLocked()) {
							if (e.column == 5 || e.column == 4) {
								var record = e.grid.getStore().getAt(e.row);
								var status = e.grid.getSelectionModel()
										.isSelected(record);
								var isConfirm = record.get("isConfirm");
								var versionNo = record.get("versionNo");
								if (versionNo == '请选择...') {
									versionNo = '';
								}
								if (isConfirm == true) {
									isConfirm = 1;
								} else if (isConfirm == false) {
									isConfirm = 0;
								} else {
									isConfirm = '';
								}
								if (status) {
									Ext.MessageBox
											.confirm(
													'系统提示',
													'服务的订阅配置信息发生改变是否保存?',
													function(btn) {
														if (btn == 'yes') {
															ServManServRegDwr
																	.saveOrUpdateSubscribeConf(
																			record.data.subscribeConfId,
																			record.data.servManId,
																			servDefineId,
																			record.data.servId,
																			record.data.versionNo,
																			function(
																					data) {
																				if (data) {
																					dwrLoadMask
																							.hide();
																					Ext.MessageBox
																							.alert(
																									"系统提示:",
																									blankStr
																											+ "设置生效"
																											+ blankStr,
																									function(
																											btn) {
																										if (btn == 'ok') {
																											servSubscribGrid.store
																													.load({
																														params : {
																															servAffordManId : pNode
																														},
																														callback : function() { // 加载非选中接入系统注册的服务
																															servSubscribGrid
																																	.getSelectionModel()
																																	.clearSelections();
																															dwr.engine
																																	.setAsync(false);
																															servDefineId = that.servDefineIdHidden
																																	.getValue();
																															ServManServRegDwr
																																	.getSubscribeConfById(
																																			servDefineId,
																																			function(
																																					data) {
																																				var store = servSubscribGrid
																																						.getStore();
																																				for ( var i = 0; i < data.length; i++) {
																																					var idIndex = store
																																							.indexOfId(data[i].servId); // 根据id查找该记录所在行
																																					servSubscribGrid
																																							.getSelectionModel()
																																							.selectRow(
																																									idIndex,
																																									true);
																																					record = store
																																							.getAt(idIndex);
																																					record
																																							.set(
																																									'versionNo',
																																									data[i].versionNo);
																																					record
																																							.set(
																																									'subscribeConfId',
																																									data[i].subscribeConfId);
																																					record
																																							.set(
																																									'servDefineId',
																																									data[i].servDefineId);
																																					record.dirty = false;
																																					record
																																							.commit();
																																				}
																																			});
																															dwr.engine
																																	.setAsync(true);
																															checkPrivilege(arrId);
																														}
																													});
																										}
																									});
																				} else {
																					dwrLoadMask
																							.hide();
																					Ext.MessageBox
																							.alert(
																									"系统提示:",
																									blankStr
																											+ "操作可能出现了某些错误,请重试！"
																											+ blankStr);
																					e.grid
																							.getSelectionModel()
																							.selectRow(
																									e.row,
																									true);
																				}

																			});
														}
													});
								}
							}
						}
					},
					beforeCellEdit : function(e) {
						var selNode = servTree.getSeletedNode();
						if (!this.servVisitSm.isLocked()) {
							if (e.column == 5) {
								var servId = e.grid.store.getAt(e.row).get(
										'servId');
								// var servManId = selNode.id.substring(9);
								this.servNoCombox.store.load({
									params : {
										'servDefineDto.servId' : servId
									}
								});
							}
						}
					},
					createCombo1 : function(id, name, url, root, width) { // 生成一个通用的ComboBox
						var combo = new Ext.form.ComboBox({
							emptyText : '请选择...',
							isFormField : true,
							mode : 'local',
							triggerAction : 'all',
							width : width,
							readOnly : true,
							displayField : name,
							valueField : id,
							store : new Ext.data.Store({
								proxy : new Ext.data.HttpProxy({
									url : url,
									method : 'POST'
								}),
								reader : new Ext.data.JsonReader({
									root : root
								}, new Ext.data.Record.create([ {
									name : id
								}, {
									name : name
								} ]))
							})
						});
						return combo;
					},
					createCheckBox : function(checked, inputValue, name) {
						var checkBox = new Ext.form.Checkbox({
							checked : checked,
							inputValue : inputValue,
							name : name,
							hideLabel : true,
							labelSeparator : '',
							boxLabel : "是",
							autoShow : true
						});
						return checkBox;
					},
					formatConfirm : function(val) {
						value = '';
						if (val == 1 || val == true) {
							value = '是';
						} else if (val == '2') {
							value = '否';
						} else {
							value = '请选择...';
						}
						return value;
					},
					formatVersion : function(val) {
						value = '';
						if (val != '0' && val != null) {
							value = 'V' + val;
						} else {
							value = '请选择...';
						}
						return value;
					}
				});

function changeStyle(style) {
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + style + ".css");
}

/**
 * *******************onReady
 * 组件渲染及处理************************************************
 */
Ext
		.onReady(function() {

			dwrLoadMask = new Ext.LoadMask(Ext.getBody(), {
				msg : "请稍候..."
			}); // 增加等待提示

			Ext.QuickTips.init();
			Ext.form.Field.prototype.msgTarget = 'side';

			Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.styleCssValue);

			servDefineGrid = new ServDefineGrid(
					Ext.getBody().getViewSize().height - 65, Ext.getBody()
							.getViewSize().width - 250);

			servGrid = new ServGrid(Ext.getBody().getViewSize().height - 65,
					Ext.getBody().getViewSize().width - 250);
			servVisitGrid = new ServVisitLimitGrid();
			servManVisitGrid = new ServManVisitLimitGrid();
			var ServPanel = {
				title : '服务',
				id : 'servPanel',
				frame : true,
				bodyStyle : 'padding: 5px',
				items : [ servGrid ]
			};
			var ServDefinePanel = {
				title : '服务定义',
				id : 'servDefinePanel',
				frame : true,
				bodyStyle : 'padding: 5px',
				items : [ servDefineGrid ]
			};
			// 接入系统可以访问哪些服务
			var ServVisitPanel = {
				title : '可访问服务列表',
				id : 'servVisitPanel',
				frame : true,
				bodyStyle : 'padding: 5px',
				items : [ servVisitGrid ]
			};
			// 服务被哪些接入系统访问
			var ServManVisitPanel = {
				title : '服务访问权限列表',
				id : 'servManVisitPanel',
				frame : true,
				bodyStyle : 'padding: 5px',
				items : [ servManVisitGrid ]
			};
			var FluxMonitorPanel = {
				id : 'fluxMonitorPanel',
				title : '流量控制配置',
				defaultType : 'iframepanel',
				frame : true,
				defaults : {
					closable : true,
					loadMask : {
						hideOnReady : false,
						msg : 'Loading Site...'
					},
					autoShow : true
				},
				items : [ {
					height : Ext.getBody().getViewSize().height - 50,
					width : Ext.getBody().getViewSize().width - 250,
					frameConfig : {
						autoCreate : {
							id : 'fluxMonitorFrame'
						}
					},
					defaultSrc : ''
				} ]
			};
			tabPanel = new Ext.TabPanel({
				renderTo : 'servTabPanel',
				region : 'center',
				id : 'tabPanel',
				height : Ext.getBody().getViewSize().height - 25,
				width : Ext.getBody().getViewSize().width - 260,
				enableTabScroll : true,
				fitToFrame : true,
				activeTab : 0,
				layoutOnTabChange : true,
				deferredRender : true,
				items : [ ServPanel, ServDefinePanel, ServVisitPanel,
						ServManVisitPanel, FluxMonitorPanel ]

			});
			// 初始化登陆隐藏接入系统tab
			tabPanel.hideTabStripItem('servManVisitPanel');
			tabPanel.hideTabStripItem('servDefinePanel');
			tabPanel.hideTabStripItem('fluxMonitorPanel');
			servTree = new ServTree();
			servTree.getRootNode().expand();
			// 点击节点保存前一次点击的节点
			servTree.on('beforeclick', function(node, e) {
				if (servTree.getSeletedNode() != null) {
					preNode = servTree.getSeletedNode();
				}
			});

			servTree
					.on(
							'click',
							function(node, e) {
								selNode = node; // 当前选中的节点
								if (node == servTree.getRootNode())
									;
								// Ext.MessageBox.alert('系统提示：', blankStr
								// +'请选择接入系统或服务...' + blankStr);
								else if (node.id.indexOf('man') != -1) { // 点击接入系统，显示该接入系统下所有服务
									tabPanel.setActiveTab(0);
									tabPanel
											.hideTabStripItem('servManVisitPanel'); // 隐藏服务访问权限列表tab
									tabPanel
											.hideTabStripItem('fluxMonitorPanel'); // 隐藏流量控制配置tab
									tabPanel
											.hideTabStripItem('servDefinePanel'); // 隐藏服务定义tab
									tabPanel
											.unhideTabStripItem('servVisitPanel');// 显示可访问服务列表tab
									tabPanel.unhideTabStripItem('servPanel');// 显示服务列表tab
									nodeId = node.id.substring(9);
									servGrid.servManCombo.setValue(nodeId);
									var servInvokeMode = (servGrid.servInvokeModeCombo
											.getValue() == null || servGrid.servInvokeModeCombo
											.getValue() == "") ? -1
											: servGrid.servInvokeModeCombo
													.getValue();
									// 加载接入系统下所有服务
									servGrid.store.baseParams = {
										recordCount : -1,
										servAffordManId : nodeId,
										servInvokeMode : servInvokeMode
									};
									servGrid.store.load({
										params : {
											start : 0,
											limit : PAGESIZE
										}
									});
								} else if (node.id.indexOf('serv') != -1) { // 点击服务，显示该服务对应的服务定义
									tabPanel.setActiveTab(1);
									tabPanel
											.unhideTabStripItem('servDefinePanel');
									tabPanel
											.unhideTabStripItem('servManVisitPanel');
									tabPanel
											.unhideTabStripItem('fluxMonitorPanel'); // 隐藏流量控制配置tab
									tabPanel.hideTabStripItem('servPanel');
									tabPanel.hideTabStripItem('servVisitPanel');
									var nodeId = node.id.substring(5);
									var parentNodeId = '';
									pNode = node;
									while (pNode.id.indexOf('man') == -1) {
										pNode = pNode.parentNode;
										if (pNode.id == 'serv_directory_level_root') {
											Ext.MessageBox.alert('系统提示',
													'上层节点无服务商操作错误！');
											return;
										}
									}
									parentNodeId = pNode.id.substring(9);
									// combo过滤该接入系统下服务
									servDefineGrid.servCombo.store.proxy.conn.url = 'register/servAffordManRegAction_queryServByServMan.action';
									servDefineGrid.servCombo.store.load({
										params : {
											servAffordManId : parentNodeId
										},
										callback : function() {
											servDefineGrid.servCombo
													.setValue(nodeId);
										}
									});
									servDefineGrid.store.baseParams = {
										recordCount : -1,
										servId : nodeId,
										servManId : 0
									};
									servDefineGrid.store
											.load({
												params : {
													start : 0,
													limit : PAGESIZE
												},
												callback : function() {
													if (servDefineGrid.store
															.getCount() != 0) { // 服务定义记录只可添加一条
														servType = servDefineGrid.store
																.getAt(0)
																.get('servType');
													} else {
														document
																.getElementById("bbar_newServDefine").disabled = false;
													}
												}
											});

								} else {
								}
							});
			tabPanel.on('tabchange',
					function(panel, tab) {
				var node = servTree.getSeletedNode();
				var nodeId = node.id.substring(9);
				if(tab.id == 'servVisitPanel'){
					servVisitGrid.store.baseParams={
						servManId : nodeId
					};
					servVisitGrid.store.load({
						params : {
							start:0,
							limit:10
						}
					});
				}
				else if (tab.id == 'servManVisitPanel') { // 选择服务访问权限tab
							queryVisitLimit();

						} else if (tab.id == 'fluxMonitorPanel') { // 选择流量控制tab
							queryMonitorCfgClick();
						}
					});
		});
