SubScirbeWindow = Ext.extend(Ext.Window, {

	servSubscribGrid : null,
	constructor : function() {
		this.servSubscribGrid = new ServSubscribeVisitLimitGrid();
		InsertDefineWindow.superclass.constructor.call(this, {
			title : "订阅服务权限窗口",
			width : 770,
			height : 460,
			resizable : false,
			plain : true,
			modal : true,
			autoScroll : true,
			closeAction : 'hide',
			items : [ this.servSubscribGrid ]
		});
	}
});

/** *************************************InsertDefineWindow组件************************************************* */
InsertDefineWindow = Ext.extend(Ext.Window, {

	defineForm : null,
	constructor : function() {
		// 原来的添加服务定义窗口，勿删
		// this.defineForm = new DefineForm();
		this.defineForm4AddServ = new Define4AddServForm();
		InsertDefineWindow.superclass.constructor.call(this, {
			title : "新增标准服务版本窗口",
			width : 700,
			height : 475,
			resizable : false,
			plain : true,
			modal : true,
			autoScroll : true,
			closeAction : 'hide',
			items : [ this.defineForm4AddServ ]
		});
	}
});

/** *************************************UpdateDefineWindow组件************************************************* */
UpdateDefineWindow = Ext.extend(Ext.Window, {

	defineForm : null,
	constructor : function() {

		this.defineForm = new DefineForm();
		this.defineForm.atomServRadioY.disabled = true;
		this.defineForm.atomServRadioN.disabled = true;

		Ext.getCmp('add_define_btn').hide(); // 隐藏添加按钮
		Ext.getCmp('update_define_btn').show(); // 显示修改按钮
		Ext.getCmp('reset_define_btn').hide(); // 隐藏清空按钮
		Ext.getCmp('resume_define_btn').show(); // 显示重置按钮

		UpdateDefineWindow.superclass.constructor.call(this, {
			title : "修改标准服务版本窗口",
			width : 700,
			height : 475,
			resizable : false,
			plain : true,
			modal : true,
			autoScroll : true,
			closeAction : 'hide',
			items : [ this.defineForm ]
		});
	}
});

/** ************************ServDefineGrid服务定义************************************* */
ServDefineGrid = Ext
		.extend(
				UxGrid,
				{

					insertDefineWindow : null, // 增加服务定义窗口
					updateDefineWindow : null, // 修改服务定义窗口
					insertAtomWindow : null,// 选择原子服务窗口
					rightMenu : null,
					servCombo : null, // 服务下拉选择框，查询
					servLabel : null,
					sm : new Ext.grid.RowSelectionModel({
						singleSelect : true
					}),
					constructor : function(height, width) {
						that = this;
								this.servDefineStore = new Ext.data.Store(
										{ // Grid Store
											proxy : new Ext.data.HttpProxy(
													{
														url : "register/servDefineAction_queryServDefineById.action",
														method : 'POST'
													}),
											reader : new Ext.data.JsonReader(
													{
														totalProperty : 'totalProperty',
														root : 'servDefineDtoList'
													},
													[
															{
																name : 'servId'
															},
															{
																name : 'servName'
															},
															{
																name : 'servDefineId'
															},
															{
																name : 'servType'
															},
															{
																name : 'servTypeName'
															},
															{
																name : 'servPrivateUrl'
															},
															{
																name : 'protocolConvertFlag'
															},
															{
																name : 'servPubUrl'
															},
															{
																name : 'messageType'
															},
															{
																name : 'requestWsdl'
															},
															{
																name : 'responseWsdl'
															},
															{
																name : 'protocolDoc'
															},
															{
																name : 'wsdlOperId'
															},
															{
																name : 'servManId'
															},
															{
																name : 'versionNo'
															},
															{
																name : 'versionState'
															},
															{
																name : 'verStateName'
															},
															{
																name : 'servProbeFlag'
															},
															{
																name : 'servscribeFlag'
															},
															{
																name : 'protocolConvertFlag'
															},
															{
																name : 'operName'
															},
															{
																name : 'protocolName'
															},
															{
																name : 'protocolId'
															},
															{
																name : 'servCode'
															},
															{
																name : 'servManCode'
															},
															{
																name : 'wsdlId'
															},
															{
																name : 'queueName'
															},
															{
																name : 'subscribeFlag'
															},
															{
																name : 'isAtomServ'
															},
															{
																name : 'routeFlag'
															},
															{
																name : 'routeRole'
															},
															{
																name : 'servInvokeMode'
															} ])
										}),

								this.rightMenu = new Ext.menu.Menu({
									items : [ {
										text : '修改服务定义',
										handler : this.onModifyClick,
										scope : this
									}, {
										text : '删除服务定义',
										handler : this.onDeleteClick,
										scope : this
									} ]
								});

						this.insertDefineWindow = new InsertDefineWindow();
						this.updateDefineWindow = new UpdateDefineWindow();
						this.insertAtomWindow = new InsertAtomWindow();
								this.servLabel = new Ext.form.Label({
									text : '服务：'
								}),
								this.servCombo = this
										.createCombo1(
												"servId",
												"servName",
												"register/servAffordManRegAction_queryAllServ.action",
												"servDtoList", 130);
						this.servCombo.store.load();
						this.servCombo.on('select', this.onServComboSelect,
								this);

						ServDefineGrid.superclass.constructor.call(this, {
							frame : true,
							width : width,
							height : height,
							viewConfig : {
								forceFit : true
							},
							loadMask : {
								msg : '正在载入数据,请稍候...'
							},
							sm : this.sm,
							cm : new Ext.grid.ColumnModel([
									new Ext.grid.RowNumberer(), {
										header : '服务id',
										dataIndex : 'servId',
										hidden : true
									}, {
										header : '服务名称',
										dataIndex : 'servName',
										sortable : true,
										width : 100
									}, {
										header : '服务定义ID',
										dataIndex : 'servDefineId',
										sortable : true,
										hidden : true,
										width : 100
									}, {
										header : '服务消息类型',
										dataIndex : 'servType',
										sortable : true,
										hidden : true
									}, {
										header : '服务消息类型',
										dataIndex : 'servTypeName',
										sortable : true,
										width : 130
									}, {
										header : '业务服务地址',
										dataIndex : 'servPrivateUrl',
										sortable : true,
										renderer : this.dealStrToJson,
										width : 130
									}, {
										header : '服务版本',
										dataIndex : 'versionNo',
										sortable : true,
										width : 80
									}, {
										header : '服务状态',
										dataIndex : 'verStateName',
										sortable : true,
										hidden : false,
										width : 100
									}, {
										header : '业务服务wsdl',
										dataIndex : 'requestWsdl',
										sortable : true,
										width : 100,
										renderer : this.getRequestWsdl
									}, {
										header : '代理服务地址',
										dataIndex : 'servPubUrl',
										sortable : true,
										renderer : this.dealStrToJson,
										width : 140,
										hidden : true
									}, {
										header : '代理服务wsdl',
										dataIndex : 'responseWsdl',
										sortable : true,
										width : 100,
										renderer : this.getResponseWsdl
									}, {
										header : '协议文档',
										dataIndex : 'protocolDoc',
										sortable : true,
										width : 100,
										renderer : this.getProtocolDoc
									}, {
										header : '服务测试',
										dataIndex : 'servId',
										hidden : false,
										sortable : true,
										renderer : getDetilRuleNew,
										width : 100
									}, {
										header : 'wsdl操作id',
										dataIndex : 'wsdlOperId',
										sortable : true,
										hidden : true,
										width : 100
									}, {
										header : '服务商id',
										dataIndex : 'servManId',
										sortable : true,
										hidden : true,
										width : 100
									}, {
										header : '操作名称',
										dataIndex : 'operName',
										sortable : true,
										hidden : false,
										width : 100
									}, {
										header : '协议文档',
										dataIndex : 'protocolName',
										sortable : true,
										hidden : false,
										width : 100
									}, {
										header : '是否动态路由',
										dataIndex : 'routeFlag',
										sortable : true,
										hidden : false,
										renderer : this.getRouteName,
										width : 100
									}, {
										header : '协议转换',
										dataIndex : 'protocolConvertFlag',
										hidden : false,
										sortable : true,
										renderer : this.getFormatConverterWin,
										width : 100
									}

							]),
							bbar : new Ext.PagingToolbar({
								firstText : '第一页',
								nextText : '下一页',
								prevText : '上一页',
								refreshText : '刷新',
								lastText : '最后一页',
								beforePageText : '当前',
								afterPageText : '页/共{0}页',
								pageSize : PAGESIZE,
								store : this.servDefineStore,
								displayInfo : false,
								dsiplayMsg : '本页显示 {0} - {1},共{2}条记录',
								emptyMsg : "没有可显示的记录",
								items : [ '-', {
									text : '添加',
									id : 'bbar_newServDefine',
									iconCls : 'new',
									handler : this.onAddClick,
									scope : this
								}, '-', {
									text : '修改',
									id : 'bbar_updateServDefine',
									iconCls : 'update',
									handler : this.onModifyClick,
									scope : this
								}, '-', {
									text : '删除',
									id : 'bbar_deleteServDefine',
									iconCls : 'delete',
									handler : this.onDeleteClick,
									scope : this
								}, '-'

								]
							}),
							tbar : new Ext.Toolbar({
								items : [ this.servLabel, this.servCombo ]
							}),
							ds : this.servDefineStore,
							listeners : {
								"dblclick" : {
									fn : this.onModifyClick,
									scope : this
								},
								"rowcontextmenu" : {
									fn : this.onRightMenuClick,
									scope : this
								}
							}
						});
					},
					queryHandler : function() { // 查询
						var organId = this.organCombo.getValue();
						var userName = this.userNameTf.getValue();
						var userID = this.userIDTf.getValue();
						this.store.load({
							params : {
								start : 0,
								limit : PAGESIZE,
								recordCount : -1,
								organId : organId,
								userName : userName,
								userID : userID
							}
						});
					},
					// 选择服务，查询该服务对应的服务定义
					onServComboSelect : function(combo, record, index) {
						var servId = combo.getValue();
						this.store.baseParams = {
							recordCount : -1,
							servId : servId
						};
						this.store.load({
							params : {
								start : 0,
								limit : PAGESIZE
							}
						});
					},
					onRightMenuClick : function(grid, rowIndex, e) {
						this.getSelectionModel().selectRow(rowIndex);
						this.fireEvent("cellclick", grid, rowIndex);
						e.preventDefault();
						this.rightMenu.showAt(e.getXY());
					},

					onAddClick : function() {
						selNode = servTree.getSeletedNode();
						if (selNode == null) {
							Ext.MessageBox.alert('系统提示', '请选择左边的服务...');
							return;
						}
						parNode = selNode.parentNode;
						/**
						 * 循环查找服务的上层服务商节点
						 */
						while (parNode.id.indexOf('man') == -1) {
							parNode = parNode.parentNode;
							if (parNode.id == 'serv_directory_level_root') {
								Ext.MessageBox.alert('系统提示', '上层节点无服务商操作错误！');
								return;
							}
						}
						if (!selNode || selNode.id.indexOf('man') != -1
								|| selNode.id == 'serv_root') {
							Ext.MessageBox.alert('系统提示:', '请选择左边服务...');
							return;
						}
						if (parNode != null) {
							nodeId = parNode.id.substring(9);
						}
						servNodeId = selNode.id.substring(5);
						manCode = parNode.attributes.code;
						var win = this.insertDefineWindow;
						win.defineForm4AddServ.getForm().reset();
						win.defineForm4AddServ.servIdHidden.setValue(selNode.id
								.substring(5));
						win.defineForm4AddServ.servNameTextField
								.setValue(selNode.text);
						win.defineForm4AddServ.messageTypeCombo.setValue(0);
						win.defineForm4AddServ.servTypeCombo.setValue(3);
						win.defineForm4AddServ.protocolConvertCombox
								.setValue(0);
						win.defineForm4AddServ.servBusiTypeCombo.store.load();
						win.defineForm4AddServ.servManIdHidden.setValue(nodeId);
						win.defineForm4AddServ.wsdlNameCombo.store.load({
							params : {
								'wsdlConfDto.servManId' : nodeId
							}
						});
						win.defineForm4AddServ.protoNameCombo.store.load({
							params : {
								'protocolInfoDto.servManId' : nodeId
							}
						});
						win.defineForm4AddServ.versionStateCombo.store.load({
							callback : function() {
								win.defineForm4AddServ.versionStateCombo
										.setValue(1);
							}
						});
						var form = win.defineForm4AddServ;
						win.show();
						form.operNameCombo.setValue();
						form.queueNameCombo.hide();
					},
					onModifyClick : function() {
						var record = this.selectedRecord();
						var win = this.updateDefineWindow;
						if (record == null) {
							Ext.MessageBox.alert('系统提示', blankStr
									+ '请选择一条服务记录!' + blankStr);
							return;
						}
						isAtomServ = record.get('isAtomServ');
						var form = win.defineForm;
						form.getForm().reset();
						var servInvokeMode = record.get('servInvokeMode');
						if (isAtomServ == 2) {
							Ext.MessageBox.alert('系统提示', blankStr
									+ '该服务为组合服务，不允许修改信息!' + blankStr);
							return;
						}
						if(servInvokeMode==0){
							form.complexServRadioY.setDisabled(true);
							form.complexServRadioN.setDisabled(true);
						}else{
							form.complexServRadioY.setDisabled(false);
							form.complexServRadioN.setDisabled(false);
						}
						win.addListener("show", this.loadData, this);
						selNode = servTree.getSeletedNode();
						if (selNode == null) {
							Ext.MessageBox.alert('系统提示:', '请选择左边服务...');
							return;
						}
						parNode = selNode.parentNode;
						if (record) {
							servDefineId = record.get('servDefineId');
							dwr.engine.setAsync(true);
							AtomServDefineDwr
									.queryAtomServByRelations(
											servDefineId,
											function(data) {
												if (data != null && data != "") {
													value = Ext.util.JSON
															.decode(data);
													servBusiType = value.servBusitype;
													form.getForm().setValues(
															value);
													win.defineForm.servBusiTypeCombo.store
															.load({
																callback : function() {
																	win.defineForm.servBusiTypeCombo
																			.setValue(servBusiType);
																}
															});
												}
											});
							win.show();

							var subscribeCode;
							dwr.engine.setAsync(false);
							StConfigDwr.queryStConfigValue("SUBSCRIBE_CODE",
									function(data) {
										subscribeCode = data;
									});

							form.getForm().loadRecord(record);
							form.servManIdHidden.setValue(parNode.id
									.substring(9));
							form.servTypeCombo.setValue(record.get('servType'));
							/*
							 * 判断是否为ESB平台，如是则显示组合服务判断，如不是则隐藏
							 */
							if (record.get('servManCode') == subscribeCode) {
							} else {
							}
							form.queueNameCombo.hide();
							// 修改第二次打开服务定义窗口如服务探针标志位为否选择是无法打开参数配置窗口的bug
							if (parNode != null) {
								nodeId = parNode.id.substring(9);
								win.defineForm.servManIdHidden.setValue(nodeId);
							}
						} else {
							Ext.Msg.alert('系统提示', blankStr + '请选择一条服务定义记录'
									+ blankStr);
						}
					},
					privateAddress : function() {
						this.insertDefineWindow.defineForm.operNameCombo.store
								.load({
									params : {
										'wsdlOperDto.wsdlId' : parseInt(this.insertDefineWindow.defineForm.wsdlNameCombo
												.getValue())
									}
								});
						this.insertDefineWindow.defineForm.privateUrlTextField.store
								.load({
									params : {
										'wsdlConfDto.wsdlId' : parseInt(this.insertDefineWindow.defineForm.wsdlNameCombo
												.getValue())
									}
								});
					},
					setWsdlValue : function() {
						if (this.selectedRecord().get('wsdlId') == 0) {
							this.updateDefineWindow.defineForm.wsdlNameCombo
									.setValue()
							this.updateDefineWindow.defineForm.wsdlCombo
									.setValue();
						} else {
							this.updateDefineWindow.defineForm.wsdlNameCombo
									.setValue(this.selectedRecord().get(
											'wsdlId'));
						}
						if (this.updateDefineWindow.defineForm.wsdlNameCombo
								.getValue() != '') {
							this.updateDefineWindow.defineForm.operNameCombo.store
									.load({
										params : {
											'wsdlOperDto.wsdlId' : parseInt(this.updateDefineWindow.defineForm.wsdlNameCombo
													.getValue())
										}
									});
						}
						this.updateDefineWindow.defineForm.privateUrlTextField.store
								.load({
									params : {
										'wsdlConfDto.wsdlId' : this
												.selectedRecord().get('wsdlId')
									}
								});
					},
					setOperValue : function() {
						if (this.selectedRecord().get('wsdlOperId') == 0) {
							this.updateDefineWindow.defineForm.operNameCombo
									.setValue();
						} else {
							this.updateDefineWindow.defineForm.operNameCombo
									.setValue(this.selectedRecord().get(
											'wsdlOperId'));
							var store = this.updateDefineWindow.defineForm.operNameCombo.store;
						}
					},
					setProtoValue : function() {
						if (this.selectedRecord().get('protocolId') == 0) {
							this.updateDefineWindow.defineForm.protoNameCombo
									.setValue();
						} else {
							this.updateDefineWindow.defineForm.protoNameCombo
									.setValue(this.selectedRecord().get(
											'protocolId'));
						}
					},
					setVersionValue : function() {
						if (this.selectedRecord().get('versionState') == 0) {
							this.updateDefineWindow.defineForm.versionStateCombo
									.setValue();
						} else {
							this.updateDefineWindow.defineForm.versionStateCombo
									.setValue(this.selectedRecord().get(
											'versionState'));
						}
					},
					onDeleteClick : function() {
						var record = this.selectedRecord();
						if (record) {
							servDefineId = record.get('servDefineId');
							Ext.MessageBox
									.confirm(
											'系统提示:',
											'您确定要删除所选服务定义吗？',
											function(btn) {
												if (btn == 'yes') {
													dwrLoadMask.show();
													ServDefineDwr
															.deleteServDefine(
																	servDefineId,
																	function(
																			data) {
																		if (data) {
																			dwrLoadMask
																					.hide();
																			Ext.MessageBox
																					.alert(
																							"系统提示:",
																							blankStr
																									+ '删除成功'
																									+ blankStr);
																			servDefineGrid
																					.remove(record);
																			if (servDefineGrid
																					.getStore()
																					.getCount() == 0) // 服务定义列表中无记录添加按钮可用
																				document
																						.getElementById("bbar_newServDefine").disabled = false;
																		} else {
																			dwrLoadMask
																					.hide();
																			Ext.MessageBox
																					.alert(
																							"系统提示:",
																							blankStr
																									+ "操作可能出现了某些错误,请重试！"
																									+ blankStr);
																		}
																	});
												}
											});
						} else {
							Ext.Msg.alert('系统提示', blankStr + '请选择一条服务定义记录'
									+ blankStr);
						}

					},
					loadData : function() {
						that = this;
						record = this.selectedRecord();
						wsdlId = record.get('wsdlId');
						servManId = record.get('servManId');
						versionState = record.get('versionState');
						protocolId = record.get('protocolId');
						if (protocolId == 0) {
							protocolId = '';
						}
						wsdlOperId = record.get('wsdlOperId');
						this.updateDefineWindow.defineForm.wsdlNameCombo.store
								.load({
									params : {
										'wsdlConfDto.servManId' : servManId
									},
									callback : function() {
										// 设置wsdl名称
										that.updateDefineWindow.defineForm.wsdlNameCombo
												.setValue(wsdlId);
										// 加载操作信息，并设置操作名称
										that.updateDefineWindow.defineForm.operNameCombo.store
												.load({
													params : {
														'wsdlOperDto.wsdlId' : parseInt(that.updateDefineWindow.defineForm.wsdlNameCombo
																.getValue())
													},
													callback : function() {
														that.updateDefineWindow.defineForm.operNameCombo
																.setValue(wsdlOperId);

													}
												});
										// 加载业务私有地址信息，并设置私有地址信息
										that.updateDefineWindow.defineForm.privateUrlTextField.store
												.load({
													params : {
														'wsdlConfDto.wsdlId' : that
																.selectedRecord()
																.get('wsdlId')
													},
													callback : function() {
														that.updateDefineWindow.defineForm.privateUrlTextField
																.setValue(wsdlId);
													}
												});
									}
								});
						// 加载协议文档信息，并设置协议文档名称信息
						this.updateDefineWindow.defineForm.protoNameCombo.store
								.load({
									params : {
										'protocolInfoDto.servManId' : this
												.selectedRecord().get(
														'servManId')
									},
									callback : function() {
										that.updateDefineWindow.defineForm.protoNameCombo
												.setValue(protocolId);
									}
								});
						// 加载服务版本信息，并设置服务版本
						this.updateDefineWindow.defineForm.versionStateCombo.store
								.load({
									callback : function() {
										that.updateDefineWindow.defineForm.versionStateCombo
												.setValue(versionState);
									}
								});

					},
					selectedRecord : function() {
						var record = this.getSelectionModel().getSelected();
						return record;
					},
					refresh : function() {
						this.getView().refresh();
					},
					remove : function(record) {
						this.getStore().remove(record);
					},
					// 替换json字符串中的特殊符号'<'
					dealStrToJson : function(value) {
						if (value != null && value.indexOf('<') != -1)
							value = value.replace(/</g, '&lt');
						return value;
					},
					// 转换消息类型number为名称显示
					dealNumToName : function(value) {
						if (value == 0)
							return '同步';
						else if (value == 1)
							return '异步';
					},
					// 查看请求wsdl协议
					getRequestWsdl : function(val) {
						return '<a href=javascript:getRequestWsdl()>' + '查看'
								+ '</a>';
					},
					// 查看响应wsdl协议
					getResponseWsdl : function() {
						return '<a href=javascript:getResponseWsdl()>' + '查看'
								+ '</a>';
					},
					// 设置格式转换脚本
					getFormatConverterWin : function(val) {
						if (val == 0)
							return "";
						else
							return '<a href=javascript:showFormatConverterWin()>'
									+ '设置' + '</a>';
					},
					getRouteName : function(val) {
						if (val == 1)
							return "是";
						else
							return "否";
					},
					// 查看协议文档
					getProtocolDoc : function() {
						return '<a href=javascript:getProtocolDoc()>' + '下载'
								+ '</a>';
					}
				});