Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif';

var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';     //需要补充的空格

var pageTotal = 10;

function changeStyle(style) {
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + style + ".css");
}

Ext.onReady(function() {
	Ext.override(Ext.menu.DateMenu, {
		render : function() {
			Ext.menu.DateMenu.superclass.render.call(this);
			if (Ext.isGecko) {
				this.picker.el.dom.childNodes[0].style.width = '178px';
				this.picker.el.dom.style.width = '178px';
			}
		}
	});

	Ext.QuickTips.init();

	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.styleCssValue);
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.parent.styleCssValue);
	var redStar = '<font color=red>' + '*' + '</font>';// 红色星号

	Ext.Ajax.on('requestcomplete', checkUserSessionStatus, this);
	// 检查用户状态 是否session 超时
	function checkUserSessionStatus(conn, response, options) {
		var sessionStatus = response.getResponseHeader["sessionstatus"];

		if (typeof(sessionStatus) != "undefined") {
			Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
				if (btn == 'ok') {
					var redirect = URL_START + document.location.host
							+ LOG_IN_URL + '?flag=true';
					window.location = redirect;
				}
			});
		}
	}
	// 公用代码区
	// combox自动加上"请选择"

	var addBlankSelectForCombox = function(combo) { // 自动添加一个空选择项
		combo.on("select", function() {
				if (combo.getValue() == -1) { // 当选择-1时，把值设置为空
					combo.setValue("");
				}
			});
		combo.store.on("datachanged", function(a) {
				var r = new Ext.data.Record({});
				r.set(combo.valueField, ''); // 添加一格值为-1的选项
				r.set(combo.displayField, combo.emptyText);
				a.insert(0, r);
			});
	}

	var servManStore = new Ext.data.JsonStore({
			url : 'register/getAllServMan.action',
			root : 'page.result',
			fields : ['servManId', 'servManName' ,'servManCode'],
			autoLoad : {
				params : {
					'page.start' : 0,
					'page.pageSize' : 100
				}
			}
		})

	// 服务消费方下拉列表
	var servConsumeManCombox = new Ext.form.ComboBox({
			fieldLabel : "发送系统",
			emptyText : "请选择…",
			store : servManStore,
			editable : false,
			hiddenName : 'servManId',
			valueField : 'servManCode',
			displayField : 'servManName',
			typeAhead : true,
			triggerAction : 'all',
			selectOnFocus : true,
			forceSelection : true,
			width : 150,
			mode : 'local'
		});
	// 服务提供方下拉列表
	var servAffordManCombox = new Ext.form.ComboBox({
			fieldLabel : "接收系统",
			emptyText : "请选择…",
			store : servManStore,
			editable : false,
			 value:'',
			hiddenName : 'servManId',
			valueField : 'servManId',
			id : 'servAffordMan',
			displayField : 'servManName',
			typeAhead : true,
			triggerAction : 'all',
			selectOnFocus : true,
			forceSelection : true,
			width : 150,
			initComponent : function() {
				addBlankSelectForCombox(this);
			},
			mode : 'local'
		});

	var servStore = new Ext.data.JsonStore({
			url : 'register/servAffordManRegAction_queryServByServMan.action',
			root : 'servDtoList',
			fields : ['servId', 'servName']
		})
	// 服务名称下拉列表
	var servCombox = new Ext.form.ComboBox({
			fieldLabel : "调用服务名称",
			emptyText : "请选择…",
			store : servStore,
			editable : false,
			value : '',
			hiddenName : 'servId',
			valueField : 'servId',
			displayField : 'servName',
			typeAhead : true,
			triggerAction : 'all',
			selectOnFocus : true,
			width : 150,
			value :'',
			mode : 'local',
			initComponent : function() {
				addBlankSelectForCombox(this);
			}
		});
	// 二级联动,联动后，原先数据需要清除
	servAffordManCombox.on("select", function(comb) {
			servStore.load({
						params : {
							servAffordManId : comb.value
						}
					});
						servCombox.setValue('');
			// 当服务框未选择时，二级框置不可用
			if (servAffordManCombox.getValue() == '') {
				servCombox.setDisabled(true)
			} else {
				servCombox.setDisabled(false);
			}
		})

	// 消息ID
	var msgIdFiled = new Ext.form.TextField({
			fieldLabel : "消息ID",
			name : "msgId",
			id : "msgId",
			blankText : '请填写消息ID',
			msgTarget : 'qtip',
			emptyText : '请填写消息ID' ,
			maxLength : 32,
			width : 150
		})

	// 是否重投
	var resendStore = new Ext.data.SimpleStore({
			fields : ['resendFlag', 'resendText'],
			data : [['1', '请选择…'], ['2', '是'], ['3', '否']]
		});
	var resendFlagCombox = new Ext.form.ComboBox({
			fieldLabel : "是否已经重投",
			emptyText : "请选择…",
			store : resendStore,
			editable : false,
			value : '',
			hiddenName : 'resendFlag',
			valueField : 'resendFlag',
			displayField : 'resendText',
			typeAhead : true,
			triggerAction : 'all',
			selectOnFocus : true,
			width : 150,
			value : 1,
			mode : 'local',
			initComponent : function() {
				addBlankSelectForCombox(this);
			}
		});
	//服务调用状态
	var serviceStateHp = new Ext.data.HttpProxy({
			url : 'audit/aipMessageQueryAction_queryServiceState.action'
		});
	var serviceStateStore = new Ext.data.Store({// 配置分组数据集
			proxy : serviceStateHp,
			reader : new Ext.data.JsonReader({
						root : 'list',
						fields : ['businid', 'businname']
					}),
			autoLoad:{
				params:{
				}
			        
			}		
		});
   var serviceStateCombox = new Ext.form.ComboBox({
			fieldLabel : "服务调用状态",
			emptyText : "请选择…",
			store : serviceStateStore,
			editable : false,
			value : '',
			hiddenName : 'businid',
			valueField : 'businid',
			displayField : 'businname',
			typeAhead : true,
			triggerAction : 'all',
			selectOnFocus : true,
			width : 150,
			value : '',
			mode : 'local',
			initComponent : function() {
				addBlankSelectForCombox(this);
			}
		});
	// 服务调用类型
	var msgInvokeStore = new Ext.data.SimpleStore({
			fields : ['servInvokeMode', 'servInvokeText'],
			data : [['1', '请选择…'], ['2', '同步'], ['3', '异步']]
		});
	var msgInvokeCombox = new Ext.form.ComboBox({
			fieldLabel : "服务调用类型",
			emptyText : "请选择…",
			store : msgInvokeStore,
			editable : false,
			value : '',
			hiddenName : 'servInvokeMode',
			valueField : 'servInvokeMode',
			displayField : 'servInvokeText',
			typeAhead : true,
			triggerAction : 'all',
			selectOnFocus : true,
			width : 150,
			value : 1,
			mode : 'local',
			initComponent : function() {
				addBlankSelectForCombox(this);
			}
		});
	// 消息类型
	var msgHp = new Ext.data.HttpProxy({
			url : 'register/servDefineAction_queryServType.action'
		});
	var msgTypeStore = new Ext.data.Store({// 配置分组数据集
			proxy : msgHp,
			reader : new Ext.data.JsonReader({
						root : 'items_SERVTYPE',
						fields : ['servType', 'businid','businname']
					}),
			autoLoad:{
				params:{
				}
			        
			}		
		});
   var msgTypeCombox = new Ext.form.ComboBox({
			fieldLabel : "服务类型",
			emptyText : "请选择…",
			store : msgTypeStore,
			editable : false,
			value : '',
			hiddenName : 'businid',
			valueField : 'businid',
			displayField : 'businname',
			typeAhead : true,
			triggerAction : 'all',
			selectOnFocus : true,
			width : 150,
			value : '',
			mode : 'local',
			initComponent : function() {
				addBlankSelectForCombox(this);
			}
		});
	// 开始时间
	var beginTimeField = new Ext.form.DateField({
			fieldLabel : '开始时间',
			xtype :'xdatetime',
			name : 'beginTime',
			id : 'beginTime',
			width : 150,
			allowBlank : false,
			altFormats : 'Y-m-d H:i:s',
			format : 'Y-m-d H:i:s',
			emptyText : '选择一个日期',
			readOnly : true
		});

	// 结束时间
	var endTimeField = new Ext.form.DateField({
			fieldLabel : '结束时间',
			xtype :'xdatetime',
			name : 'endTime',
			id : 'endTime',
			width : 150,
			allowBlank : false,
			altFormats : 'Y-m-d H:i:s',
			format : 'Y-m-d H:i:s',
			emptyText : '选择一个日期',
			readOnly : true
		});
	//页面大小
	var pageSizeField = new Ext.form.NumberField({
			fieldLabel : "每页显示行数",
			name : "pageSize",
			id : "pageSize",
			blankText : '请填写每页显示的行数！',
			msgTarget : 'qtip',
			emptyText : 10 ,
			maxLength : 32,
			allowBlank : false,
			width : 150
		})		
	// 计算form 宽度
	var gridWidth = Ext.getBody().getViewSize().width - 5;
	if (screen.width == 1024 && screen.height == 768) {
		gridWidth = Ext.getBody().getViewSize().width - 22;
	}
	// 将上面的查询选项放进form 面板 中
	var queryform = new Ext.FormPanel({
			title : "查询条件",
			width : gridWidth,// Ext.getBody().getViewSize().width
			height : Ext.getBody().getViewSize().height*0.3,
			buttonAlign : 'center',
			applyTo : 'queryform',
			labelWidth : 80,
			labelAlign : "right",
			frame : true,
			items : [{
					layout : "column",
					items : [{
								columnWidth : 0.25,
								layout : "form",
								name :"ssendSystem",
								items : servConsumeManCombox
							}, {
								columnWidth : 0.25,
								layout : "form",
								name :"receiveSystem",
								items : servAffordManCombox
							}, {
								columnWidth : 0.25,
								layout : "form",
								name :"servId",
								items : servCombox
							}, {
								columnWidth : 0.25,
								layout : "form",
								name :"msgId",
								items : msgIdFiled
							}, {
								columnWidth : 0.25,
								layout : "form",
								name :"resendFlag",
								items : resendFlagCombox
							}, {
								columnWidth : 0.25,
								layout : "form",
								name :"serviceStateName",
								items : serviceStateCombox
							}, {
								columnWidth : 0.25,
								layout : "form",
								name :"servInvokeMode",
								items : msgInvokeCombox
							}, {
								columnWidth : 0.25,
								layout : "form",
								name :"servTypeName",
								items : msgTypeCombox
							}, {
								columnWidth : 0.25,
								layout : "form",
								name :"beginTime",
								items : beginTimeField
							}, {
								columnWidth : 0.25,
								layout : "form",
								name :"endTime",
								items : endTimeField
							}, {
								columnWidth : 0.25,
								layout : "form",
								items : pageSizeField
							}
							]
					}],
			buttons : [{
						text : "查询",
						iconCls : 'find',
						width : 20,
						hidden : false,
						handler : queryCheck
					}, {
						text : "重置",
						iconCls : 'resume',
						width : 20,
						hidden : false,
						handler : resetQuery
					}]
		});
	var servComboxValue;	
	var beginTimeFieldValue;
	var endTimeFieldValue;
	function check(){
		var msgText =  '时间为必选项，格式应为：yyyy-mm-dd hh:mm:ss！';
		servComboxValue = servCombox.getValue();
		if (servComboxValue == '') {
		servComboxValue = 0;
		}
	   if (!Ext.getCmp('beginTime').isValid()) {
			Ext.MessageBox.alert("信息提示", msgText, function(btn) {
						Ext.getCmp('beginTime').focus();
					});
			return;
		}
	  if (!Ext.getCmp('endTime').isValid()) {
			Ext.MessageBox.alert("信息提示", msgText, function(btn) {
						Ext.getCmp('endTime').focus();
					});
			return;
		}
		beginTimeFieldValue = Ext.get("beginTime").getValue();
        endTimeFieldValue  = Ext.get("endTime").getValue();
        beginTimeValueTemp = new Date(Date.parse(beginTimeFieldValue.replace(/-/g,"/")));
        endTimeValueTemp = new Date(Date.parse(endTimeFieldValue.replace(/-/g,"/")));
        
        var daydiff = (endTimeValueTemp.getTime() - beginTimeValueTemp.getTime())/(1000*60*60*24); 
        if(daydiff < 0){
          Ext.Msg.alert("信息提示","结束时间不能小于开始时间！");
          return ;
         }
	}
	function queryCheck() {
		check();
		msgType = msgTypeCombox.getValue()==null||msgTypeCombox.getValue()=='' ? null:parseInt(msgTypeCombox.getValue());
		msgInvoke = msgInvokeCombox.getValue()==null||msgInvokeCombox.getValue()=='' ? null:parseInt(msgInvokeCombox.getValue());
        store.baseParams = {
        	'aipMessageDto.sendSystem' : servConsumeManCombox.getValue(),
	        'aipMessageDto.receiveSystem' : servAffordManCombox.getValue(),
	        'aipMessageDto.servId'  : servComboxValue,
	        'aipMessageDto.msgId' : msgIdFiled.getValue(),
        	'aipMessageDto.resendFlag' :resendFlagCombox.getValue(),
	        'aipMessageDto.serviceStateName' :serviceStateCombox.getValue(),
	        'aipMessageDto.servInvokeMode' :msgInvoke,
	        'aipMessageDto.servType' :msgType,
	        'aipMessageDto.beginTime' : beginTimeFieldValue,
	        'aipMessageDto.endTime' : endTimeFieldValue
        }; 	
        pageTotal = parseInt(Ext.getCmp("pageSize").getValue());
        if(pageTotal == 0) 
        	pageTotal = 10;
        bbar.pageSize = pageTotal;
		store.load({
					params : {
						'page.start' : 0,
						'page.pageSize' : pageTotal
					}
				}); // 传参供查询调用
	}

   	function resetQuery() {
   		servConsumeManCombox.setValue('');
		servAffordManCombox.setValue('');
		servCombox.setValue('');
		servCombox.setDisabled(true);
		msgIdFiled.setValue('');
		resendFlagCombox.setValue('');
		serviceStateCombox.setValue('');
		msgInvokeCombox.setValue('');
		msgTypeCombox.setValue('');
		beginTimeField.setValue('');
		endTimeField.setValue('');
		pageSizeField.setValue('');
		
	}

		
	/** ********************************************结果列表区*********************************** */
	var resultHp = new Ext.data.HttpProxy({
				url : 'audit/aipMessageQueryAction_msgResendList.action'
			});
	var store = new Ext.data.Store({// 配置分组数据集
			proxy : resultHp,
			reader : new Ext.data.JsonReader({
					totalProperty : "page.totalCount",
					root : 'page.result',
					idProperty : 'id',
					fields : ['id','msgId','csbId','sendSystem','sendSystemName','receiveSystem',
							'receiveSystemName','servName','versionNo','servTypeName','servType',
							'serviceState','serviceStateName','resendCount','receiveTime','requestReceiveTime','servInvokeMode']
			})
	});

   var bbar = new Ext.PagingToolbar({// 分页工具栏
			store : store,
			// 改变传给服务端的分页参数名。extjs3.1推荐是在Store
			// 里面定义这个参数，可是我试验却失败了。
			// 在这里却可以成功，不知道是不是extjs 版本问题
			paramNames : {
				start : 'page.start',
				limit : 'page.pageSize'
			},
			pageSize : pageTotal,
			displayInfo : true,
			displayMsg : '第 {0} 条到 {1} 条，一共 {2} 条',
			emptyMsg : "没有记录",
			items : ['&nbsp&nbsp&nbsp',{
					text : '重投',
					tooltip : '重投被选中的服务消息',
					iconCls : 'resume', // modified by jch
					id : 'resend',
					handler : resendMsg
				},'&nbsp&nbsp&nbsp',{
					text :'导出excel',
					tooltip : '将服务消息导出excel',
					iconCls : 'excel',
					id : 'exportMsg',
					hidden:true,
					handler : exportDetail
				}]
	});

	// 定义复选框选择模式变量：加上选择列
	var sm = new Ext.grid.CheckboxSelectionModel();
	sm.singleSelect = false;
	sm.on('rowselect', selectRow);
	sm.on('rowdeselect',deselectRow);
	// sm.on('rowselect', select);
	// 创建Grid表格组件
	var gridHeight = 340;
	if (Ext.getBody().getViewSize().height - 360 > gridHeight) {
		gridHeight = Ext.getBody().getViewSize().height - 360;
	}
	var columnWidth = gridWidth - 8;
	
	var grid = new Ext.grid.GridPanel({
			title : '服务列表',
			applyTo : 'grid-div',
			width : gridWidth,// Ext.getBody().getViewSize().width
			height : Ext.getBody().getViewSize().height*0.67,//gridHeight,// Ext.getBody().getViewSize().height
			frame : true,
			bbar : bbar,
			sm : sm,// 设置复选框选择模式
			store : store,
			ds: this.store,
			loadMask : true,
			stripeRows :true,
			columns : [// 配置表格列
				sm,	// 复选框选择模式中的checkbox组件将会显示在该列
				new Ext.grid.RowNumberer(), 
				{
					header : "ID",
					width : columnWidth / 11,// Ext.getBody().getViewSize().width
					hidden : true,
					dataIndex : 'id',
					name : 'id'
				},{
					header : "消息ID",
					width : columnWidth / 11,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'msgId',
					name : 'msgId'
				}, {
					header : "服务消费方",
					width : columnWidth / 11,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'sendSystemName',
					name : 'sendSystem'
				}, {
					header : "服务提供方",
					width : columnWidth / 11.5,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'receiveSystemName',
					name : 'receiveSystem'
				},{
					header : "服务名称",
					width : columnWidth / 11.5,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'servName',
					name : 'servName'
				},
				/**	{
					header : "服务版本",
					width : columnWidth / 12,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'versionNo',
					name : 'versionNo'
				},*/
					{
					header : "服务类型",
					width : columnWidth / 12,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'servTypeName',//对应servDefine的servType
					name : 'servType'
				},{
					header : "服务调用状态",
					width : columnWidth / 12,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'serviceStateName',
					name : 'serviceState'
				},{
					header : "重投次数",
					width : columnWidth / 18,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'resendCount',
					name : 'resendCount'
				},{
					header : "接收时间",
					width : columnWidth / 9.5,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'receiveTime',
					name : 'receiveTime'
				},{
					header : "接收转发时长(ms)",
					width : columnWidth / 10,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'requestReceiveTime',
					name : 'requestReceiveTime'
				},{
					header : "消息内容",
					width : columnWidth / 18,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'csbId',
					name : 'csbId',
					renderer : getDetilRule

				}]
		})
	store.load({
			params : {
				'page.start' : 0,
				'page.pageSize' : pageTotal
			}
		});
	function getDetilRule(val, params, record) {
		return '<a href=javascript:detDetail("' + val + '")>' + '查看' + '</a>';
	}
	function selectRow(){
		
	}
	function deselectRow(){
		
	}
	function resendMsg(){
		TimeOutDwr.isTimeOut(function(data) {
				if (data) {
					Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
								if (btn == 'ok') {
									var redirect = URL_START
											+ document.location.host + LOG_IN_URL
											+ '?flag=true';
									window.location = redirect;
								}
							});
				} else {
					var id = '';
					var msg = '';
					var count = 0;
					var cell = grid.getSelectionModel().each(function(rec) {
								id += rec.get('id') + ',';
								count++;
					});
					if (count > 0) {
						Ext.Msg.confirm("提醒信息", "确定要重投这 " + count + " 条信息吗",
							function(btn) {
								if (btn == 'yes') {
									AipMessageDwr.resend(id,
										function(data) {
											Ext.Msg.alert(data.title,blankStr + data.msg + blankStr);
											if (data.optFlag) {
												store.load({
													params : {
														'page.start' : 0,
														'page.pageSize' : pageTotal
													}
												});
											}
										});
								}
							})
					} else {
						Ext.Msg.alert("提醒信息", "请选中指定记录进行重投操作！");
					}
				}
			});
	}
		 //导出Excel
	function exportDetail(){
		check();
        if(queryform.getForm().isValid()) {
        	window.location.href = "excelReport_excelReport.action?aipMessageDto.sendSystem="+servConsumeManCombox.getValue()+
				        "&aipMessageDto.receiveSystem="+servAffordManCombox.getValue()+
				        "&aipMessageDto.servId="+servComboxValue+
				        "&aipMessageDto.msgId="+msgIdFiled.getValue()+
			        	"&aipMessageDto.resendFlag="+resendFlagCombox.getValue()+
				        "&aipMessageDto.serviceStateName="+serviceStateCombox.getValue()+
				        "&aipMessageDto.servInvokeMode="+msgInvokeCombox.getValue()+
				        "&aipMessageDto.servTypeName="+msgTypeCombox.getValue()+
				        "&aipMessageDto.beginTime="+beginTimeFieldValue+
				        "&aipMessageDto.endTime="+endTimeFieldValue;
			//另一种导出excel方法,打开一个窗口
//        	var action = "excelReport_excelReport.action?aipMessageDto.sendSystem="+servConsumeManCombox.getValue()+
//				        "aipMessageDto.receiveSystem="+servAffordManCombox.getValue()+
//				        "aipMessageDto.servId="+servComboxValue+
//				        "aipMessageDto.msgId="+msgIdFiled.getValue()+
//			        	"aipMessageDto.resendFlag="+resendFlagCombox.getValue()+
//				        "aipMessageDto.serviceStateName="+serviceStateCombox.getValue()+
//				        "aipMessageDto.servInvokeMode="+msgInvokeCombox.getValue()+
//				        "aipMessageDto.servTypeName="+msgTypeCombox.getValue()+
//				        "aipMessageDto.beginTime="+beginTimeFieldValue+
//				        "aipMessageDto.endTime="+endTimeFieldValue;
//			window.open(action,"reportExcel","width=400,height=300,top=100,left=150,status=yes,scrollbars=yes");
    	}else{
    		Ext.Msg.alert('提示', '请填写必要的导出查询条件再导出excel!');
    	} 
	}

	})
function detDetail(val) {
   var csbId = val;
   /*
    * 新建请求消息文本域
    * */
   requestText = new Ext.form.TextArea({  
			autoScroll : true,
			title :"请求消息",
			fieldLabel : "请求消息",
			name : "requestPkg",
			id : "requestPkg",
			width: Ext.getBody().getViewSize().width - 400,
			readOnly: true,
			height : Ext.getBody().getViewSize().height - 100
//						autoWidth : true
		});
	 /*
    * 新建响应消息文本域
    * */				
  	responseText = new Ext.form.TextArea({
            title :"响应消息",
            autoScroll : true,
			fieldLabel : "响应消息",
			name : "responsePkg",
			id : "responsePkg",
			width: Ext.getBody().getViewSize().width - 400,
			readOnly: true,
			height :Ext.getBody().getViewSize().height - 100
        });
	var editForm = new Ext.form.FormPanel({
			title : "*左边为请求消息内容*右边为响应消息内容*",
			width : Ext.getBody().getViewSize().width - 100,// Ext.getBody().getViewSize().width - 5,
			height : Ext.getBody().getViewSize().width - 100,
			labelWidth : 120,
			labelAlign : "right",
			frame : true,
			items : [{
					layout : "column",
					items : [
					{
					    columnWidth : 0.48,
						layout : "fit",
						items : requestText
						},
					{
					    columnWidth : 0.48,
						layout : "fit",
						items : responseText
						}]
				}]
		});
	 dslMapWin = new Ext.Window({ // 新建一个窗口
	    title : "消息包属性",
	    layout : 'fit',
	    modal : true, // 模式窗口
	    width : Ext.getBody().getViewSize().width  - 100,
	    height : Ext.getBody().getViewSize().height,
	    minimizable : true,
	    maximizable : true,
	    plain : true,
	    items : [{
				layout: "fit",
				items : [{
						columnWidth : 1.0,
						layout : "form",
						items : editForm
					}
					]
			}]
	  });
    var messageInfostore = new Ext.data.JsonStore({
			url : 'audit/aipMessageInfoQueryAction_list.action',
			root : 'page.result',
			fields :  ['aipId','messageType','msgId', 'requestPkg', 'responsePkg'],
			autoLoad : {
			    params : {
					'aipMessageInfoDto.csbId' : csbId
				}
			},
		listeners:{
		  load:	function(store){
		  requestText.setValue(store.getAt(0).get("requestPkg") );   /* 对请求消息和响应消息文本域内容进行设置*/
          responseText.setValue(store.getAt(0).get("responsePkg"));  
		}	
		}
		})	

   dslMapWin.show();// 让窗口显示出来
}
