/**
 * 日志查询主页面
 * 
 * @class QueryForm
 * @extends Ext.ux.Form
 */
// var areaUrl = "msgChosenAction_findCode.action";
// var servUrl = "servAffordManRegAction_queryAllServInfo.action";
// var servSetUrl = "servInstanceAction_findAllServInfo.action";
var queryDicUrl = 'globalLogAction_getDic.action?busintypeid=PLATFORM_LOG_FLAG';
var connServ;
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'; // 需要补充的空格
Ext.onReady(function() {
	Ext.override(Ext.menu.DateMenu, {
		render : function() {
			Ext.menu.DateMenu.superclass.render.call(this);
			if (Ext.isGecko) {
				this.picker.el.dom.childNodes[0].style.width = '178px';
				this.picker.el.dom.style.width = '178px';
			}
		}
	});

	Ext.QuickTips.init();

	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
			+ window.parent.styleCssValue);
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
			+ window.parent.parent.styleCssValue);
	Ext.Ajax.on('requestcomplete', checkUserSessionStatus, this);
	// 检查用户状态 是否session 超时
	function checkUserSessionStatus(conn, response, options) {
		var sessionStatus = response.getResponseHeader["sessionstatus"];

		if (typeof (sessionStatus) != "undefined") {
			Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
				if (btn == 'ok') {
					var redirect = URL_START + document.location.host
							+ LOG_IN_URL + '?flag=true';
					window.location = redirect;
				}
			});
		}
	}

	// 格式化时间
	Date.prototype.format = function(format) {
		var o = {
			"M+" : this.getMonth() + 1, // month<
			"d+" : this.getDate(),// day
			"h+" : this.getHours(), // hour
			"m+" : this.getMinutes(), // minute
			"s+" : this.getSeconds(), // second
			"q+" : Math.floor((this.getMonth() + 3) / 3),// quarter
			"S" : this.getMilliseconds()
		// millisecond
		};
		if (/(y+)/.test(format))
			format = format.replace(RegExp.$1, (this.getFullYear() + "")
					.substr(4 - RegExp.$1.length));
		for ( var k in o) {
			if (new RegExp("(" + k + ")").test(format))
				format = format.replace(RegExp.$1, RegExp.$1.length == 1 ? o[k]
						: ("00" + o[k]).substr(("" + o[k]).length));
		}
		return format;
	};
	var beginTimeFieldValue;
	var endTimeFieldValue;
	function check() {
		var msgText = '时间为必选项，格式应为：yyyy-mm-dd hh:mm:ss！';
		if (!Ext.getCmp('beginTime').isValid()) {
			Ext.MessageBox.alert("信息提示", msgText, function(btn) {
				Ext.getCmp('beginTime').focus();
			});
			return false;
		}
		if (!Ext.getCmp('endTime').isValid()) {
			Ext.MessageBox.alert("信息提示", msgText, function(btn) {
				Ext.getCmp('endTime').focus();
			});
			return false;
		}
		beginTimeFieldValue = Ext.get("beginTime").getValue();
		endTimeFieldValue = Ext.get("endTime").getValue();
		beginTimeValueTemp = new Date(Date.parse(beginTimeFieldValue.replace(
				/-/g, "/")));
		endTimeValueTemp = new Date(Date.parse(endTimeFieldValue.replace(/-/g,
				"/")));

		var daydiff = (endTimeValueTemp.getTime() - beginTimeValueTemp
				.getTime())
				/ (1000 * 60 * 60 * 24);
		if (daydiff < 0) {
			Ext.Msg.alert("信息提示", "结束时间不能小于开始时间！");
			return false;
			;
		}
		return true;
	}
	/** ********************************信息详情展示form表单************************************************* */
	DetailShownForm = Ext.extend(Ext.ux.Form, {
		platformLogFlagName : null,
		platformLogContent : null,
		constructor : function() {
			this.platformLogFlagName = this.createTextField("模块名称",
					"platformLogFlagName", "90%", "text", 100, true, "",
					"超出最大长度100");
			this.platformLogFlagName.disabled = true;
			this.platformLogContent = this.createTextArea4AllowBlank("日志内容",
					"platformLogContent", "260", "95%", "text", 2000, false,
					"", "超出最大长度2000", true);
			this.platformLogContent.disabled = true;
			this.platformLogTime = this.createTextField("日志产生时间",
					"platformLogTime", "90%", "text", 100, true, "",
					"超出最大长度100");
			this.platformLogTime.disabled = true;
			DetailShownForm.superclass.constructor.call(this, {
				title : "日志信息详情展示",
				width : Ext.getBody().getViewSize().width - 280,
				height : Ext.getBody().getViewSize().height - 100,
				labelWidth : 100,
				region : "center",
				bodyStyle : "background-color:white;padding:10px 10px 0 0;",
				labelAlign : "right",
				items : [ {
					layout : "column",
					items : [ {
						layout : "form",
						items : this.platformLogFlagName,
						columnWidth : 0.5
					}, {
						layout : "form",
						items : this.platformLogTime,
						columnWidth : 0.5
					}, {
						layout : "form",
						items : this.platformLogContent,
						columnWidth : 1.05
					} ]
				} ],
				buttons : [ {
					text : '关闭',
					id : 'resume_msgChosen_btn',
					width : 20,
					iconCls : 'close',
					hidden : false,
					handler : this.closeClick,
					scope : this
				} ]
			});
		},
		closeClick : function() {
			connServ.detailWindow.hide();
		},
		createTextField : function(fieldLabel, name, anchor, inputType,
				maxLength, allowBlank, vtype, maxLengthText) { // 生成一个通用的TextField
			var tf = new Ext.form.TextField({
				fieldLabel : fieldLabel,
				name : name,
				xtype : 'textfield',
				readOnly : false,
				allowBlank : allowBlank,
				anchor : anchor,
				blankText : '该选项为必填项,请输入内容...',
				vtype : vtype,
				inputType : inputType,
				maxLength : maxLength,
				maxLengthText : maxLengthText
			});
			return tf;
		}
	});
	/** *****************************信息详情展示窗口**************************************** */
	DetailShownWindow = Ext.extend(Ext.Window, {
		detailForm : null,
		constructor : function() {

			this.detailForm = new DetailShownForm();
			DetailShownWindow.superclass.constructor.call(this, {
				title : "信息详情展示窗口",
				width : Ext.getBody().getViewSize().width - 260,
				height : Ext.getBody().getViewSize().height - 50,
				resizable : false,
				plain : true,
				modal : true,
				autoScroll : true,
				closeAction : 'hide',
				items : [ this.detailForm ]
			});
		}
	});
	ConnServGrid = Ext.extend(UxGrid, {
		store : null,
		sm : null,
		detailWindow : null,
		constructor : function() {

			this.store = new Ext.data.Store({ // Grid Store
				proxy : new Ext.data.HttpProxy({
					url : "globalLogAction_findPlatformLog.action",
					method : 'POST'
				}),
				reader : new Ext.data.JsonReader({
					totalProperty : 'page.totalCount',
					root : 'page.result'
				}, [ {
					name : 'platformLog'
				}, {
					name : 'platformCode'
				}, {
					name : 'platformLogContent'
				}, {
					name : 'platformLogTime'
				}, {
					name : 'platformLogFlag'
				}, {
					name : 'platformLogFlagName'
				}, {
					name : 'flag'
				} ])
			}), this.sm = new Ext.grid.CheckboxSelectionModel({
				singleSelect : true
			}), this.sm.on("rowselect", this.rowSelect, this);
			this.detailWindow = new DetailShownWindow();
			this.platLabel = new Ext.form.Label({
				text : '平台日志标识：'
			}), this.platCombo = this.createCombo2("平台日志标识", "platformLogFlag",
					"businid", "businname", "70%", queryDicUrl, "dicts",
					"dicCount", true);
			this.platCombo.initComponent = this
					.addBlankSelectForCombox(this.platCombo);
			this.platCombo.store.load();
			// 接口类型
			var nowDate = new Date();
			var startDate = new Date(nowDate.getTime() - 7 * 24 * 60 * 60
					* 1000);
			nowDate = nowDate.format("yyyy-MM-dd hh:mm:ss");
			startDate = startDate.format("yyyy-MM-dd hh:mm:ss");
			// 开始时间
			this.receiveTimeLabel = new Ext.form.Label({
				text : '接收时间：'
			}), this.beginTime = new Ext.form.DateField({
				fieldLabel : '开始时间',
				xtype : 'xdatetime',
				name : 'beginTime',
				id : 'beginTime',
				width : 200,
				anchor : '99%',
				allowBlank : false,
				altFormats : 'Y-m-d H:i:s',
				format : 'Y-m-d H:i:s',
				value : startDate,
				emptyText : '请选择一个日期'
			});

			// 结束时间
			this.endTime = new Ext.form.DateField({
				fieldLabel : '结束时间',
				xtype : 'xdatetime',
				name : 'endTime',
				id : 'endTime',
				width : 200,
				anchor : '99%',
				allowBlank : false,
				altFormats : 'Y-m-d H:i:s',
				format : 'Y-m-d H:i:s',
				value : nowDate,
				emptyText : '请选择一个日期'
			});
			ConnServGrid.superclass.constructor.call(this, {
				title : '日志信息列表',
				frame : true,
				width : Ext.getBody().getViewSize().width - 5,
				renderTo : "grid-div",
				region : "center",
				height : Ext.getBody().getViewSize().height - 10,
				viewConfig : {
					forceFit : true
				},
				loadMask : {
					msg : '正在载入数据,请稍候...'
				},
				sm : this.sm,
				cm : new Ext.grid.ColumnModel([ new Ext.grid.RowNumberer(),
						this.sm, {
							header : '日志id',
							dataIndex : 'platformLog',
							hidden : true
						}, {
							header : '模块编码',
							dataIndex : 'platformLogFlag',
							hidden : true
						}, {
							header : '模块名称',
							dataIndex : 'platformLogFlagName',
							sortable : true,
							width : 100
						}, {
							header : '日志内容',
							dataIndex : 'platformLogContent',
							sortable : true,
							width : 100
						}, {
							header : '日志产生时间',
							dataIndex : 'platformLogTime',
							sortable : true,
							width : 100
						} ]),
				bbar : new Ext.PagingToolbar({
					firstText : '第一页',
					nextText : '下一页',
					prevText : '上一页',
					refreshText : '刷新',
					lastText : '最后一页',
					beforePageText : '当前',
					afterPageText : '页/共{0}页',
					pageSize : 20,
					paramNames : {
						start : 'page.start',
						limit : 'page.pageSize'
					},
					store : this.store,
					displayInfo : true,
					displayMsg : '本页显示 {0} - {1},共{2}条记录',
					emptyMsg : "没有可显示的记录"
				}),
				tbar : new Ext.Toolbar({
					items : [ this.platLabel, this.platCombo,
							this.receiveTimeLabel, this.beginTime, "至",
							this.endTime, '-', {
								text : '查询',
								iconCls : 'find',
								handler : this.query,
								scope : this
							}, '-', {
								text : '重置',
								iconCls : 'resume',
								handler : this.resume,
								scope : this
							} ]
				}),
				ds : this.store,
				listeners : {
					"rowcontextmenu" : {
						fn : this.onRightMenuClick,
						scope : this
					},
					"dblclick" : {
						fn : this.onDblClick,
						scope : this
					}
				}
			});
		},
		query : function() {
			var platformLogFlag = this.platCombo.getValue();
			connServ.store.baseParams = {
				'platformLogDto.platformLogFlag' : platformLogFlag,
				'beginTimeStr' : Ext.get("beginTime").getValue(),
				'endTimeStr' : Ext.get("endTime").getValue()
			};
			connServ.store.load({
				params : {
					'page.start' : 0,
					'page.pageSize' : 20
				}
			});
		},
		resume : function() {
			var nowDate = new Date();
			var startDate = new Date(nowDate.getTime() - 7 * 24 * 60 * 60
					* 1000);
			nowDate = nowDate.format("yyyy-MM-dd hh:mm:ss");
			startDate = startDate.format("yyyy-MM-dd hh:mm:ss");
			this.platCombo.setValue("");
			this.beginTime.setValue(startDate);
			this.endTime.setValue(nowDate);
		},
		rowSelect : function() {
			record = this.getSelectionModel().getSelected();
		},
		onDblClick : function(e) {
			record = this.getSelectionModel().getSelected();
			if (record == null) {
				Ext.MessageBox.alert("系统提示", blankStr + "请选择一条记录!" + blankStr);
				return;
			}
			this.detailWindow.show();
			this.detailWindow.detailForm.getForm().loadRecord(record);
		},
		addBlankSelectForCombox : function(combo) {
			combo.on("select", function() {
				if (combo.getValue() == -1) { // 当选择-1时，把值设置为空
					combo.setValue("");
				}
			});
			combo.store.on("datachanged", function(a) {
				var r = new Ext.data.Record({});
				r.set(combo.valueField, ''); // 添加一格值为-1的选项
				r.set(combo.displayField, combo.emptyText);
				a.insert(0, r);
			});
		}
	});
	connServ = new ConnServGrid();
	var nowDate = new Date();
	var startDate = new Date(nowDate.getTime() - 7 * 24 * 60 * 60 * 1000);
	nowDate = nowDate.format("yyyy-MM-dd hh:mm:ss");
	startDate = startDate.format("yyyy-MM-dd hh:mm:ss");
	connServ.store.baseParams = {
		'platformLogDto.platformLogFlag' : '',
		'beginTimeStr' : startDate,
		'endTimeStr' : nowDate
	};
	connServ.store.load({
		params : {
			'page.start' : 0,
			'page.pageSize' : 20
		}
	});

});
