var upFlag = true; // 更新标识，如果为true的时候，可以弹出服务发布界面
var selServId = "", selServManId, selServManName=""; // 记录被点击的服务id和其对应的服务商id
var pageTotal = 10;
var pageSize = 10;
var servDefineType = '';
/***************************************ServManVisitLimitGridTmp组件***************************************************/

ServManVisitLimitGridTmp = Ext.extend(Ext.grid.GridPanel, {
    
    servManVisitStore: new Ext.data.Store({
        proxy: new Ext.data.HttpProxy({url: SERVMANINFO_STORE_URL, method: 'POST'}),
        reader: new Ext.data.JsonReader({id:"servManId",root:'servManList'},[{name:'servManId'},{name:'servManName'}])
    }),
    servManVisitSm: new Ext.grid.CheckboxSelectionModel({header:'',handleMouseDown:Ext.emptyFn}),
    
    constructor: function() {
        ServManVisitLimitGridTmp.superclass.constructor.call(this, {
           // renderTo: 'ServVisitLimitGrid',
           // title: '服务访问权限列表',
            frame: true,
            width: Ext.getBody().getViewSize().width -250,
            height: Ext.getBody().getViewSize().height - 65,
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            sm: this.servManVisitSm,
            cm: new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
                this.servManVisitSm,
                {header:'id',dataIndex:'servManId',width:120,hidden:true},
                {header:show_name,dataIndex:'servManName',width:120}
            ]),
            ds: this.servManVisitStore,
           /* bbar: [
                '-', {text: '角色管理', iconCls: 'link', handler:this.onLinkRole, scope: this}
            ],*/
            listeners: {
                'cellclick': {fn: this.gridCellClick, scope: this}
            }
        });
    },
   
    //为选中的服务增加或取消访被访问的接入系统
    gridCellClick: function(grid, rowIndex, columnIndex, e) {
       if(selServId.indexOf('man')!=-1) {
           Ext.Msg.alert('系统提示', blankStr + '请选择服务' + blankStr);
           return;
       }
       if(!servManVisitGrid.servManVisitSm.isLocked()){
       if(columnIndex == 1) {
           var record = grid.getStore().getAt(rowIndex); 
           var status = grid.getSelectionModel().isSelected(record);
            Ext.MessageBox.confirm('系统提示:','您确定要变更服务的'+show_name+'访问权限吗？',function(btn){           	
                if(btn == 'yes') { 
                	dwrLoadMask.show();
		           if(status) {
		               ServManServRegDwr.saveServVisitLimit(record.data.servManId,selServId.substring(5),function(data) {
		                	 if(data) {
		                	 	dwrLoadMask.hide();
		                        Ext.MessageBox.alert("系统提示:", blankStr + "权限设置生效" + blankStr);                      
		                    } else {
		                    	dwrLoadMask.hide();
		                        Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
		                        grid.getSelectionModel().deselectRow(rowIndex); 
		                    }
		               });
		            } else {
		                ServManServRegDwr.delServVisitLimit(record.data.servManId,selServId.substring(5),function(data) {
		                  	 if(data) {
		                  	 	dwrLoadMask.hide();
		                        Ext.MessageBox.alert("系统提示:", blankStr + "权限设置生效" + blankStr);                      
		                    } else {
		                    	dwrLoadMask.hide();
		                        Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
		                        grid.getSelectionModel().selectRow(rowIndex,true); 
		                    }
		                });
		            }
                }
                else{
                	 if(status)  grid.getSelectionModel().deselectRow(rowIndex); 
                	 else    grid.getSelectionModel().selectRow(rowIndex,true); 
                }
            })
       }
	}
    }
    	   
});



/*********************************刷新IP配置列表*********************************************/
function refreshIpCfg()
{
	servManIpStore.baseParams = {'servId' : selServId.substring(5)};
	servManIpStore.load();
}
/*********************************刷新流量配置列表*********************************************/
function refreshFluxCfg()
{
	servFluxStore.baseParams = {'servId' : selServId.substring(5)} ;
	servFluxStore.load() ;
}
/*********************************刷新访问权限配置列表*********************************************/
function refreshLimitCfg()
{
	ReleaseServDwr.getServMans(selServId.substring(5),function(data){
		visitLimitTxt.setValue(data) ;
	});
}
/** ************************刷新按钮功能************************************* */
function freash()
{
	ServDefineDwr.getServType(selServId.substring(5),function(data){
		servDefineType = data ;
	});
	
	refreshIpCfg() ;
	refreshFluxCfg() ;
	refreshLimitCfg() ;
}
/** ************************IP配置列表************************************* */
var servManIpStore = new Ext.data.Store({ // Grid Store
					proxy : new Ext.data.HttpProxy({
								url : "getServManIps.action",
								method : 'POST'
							}),
					reader : new Ext.data.JsonReader({root:'root'},[{name:'servManIpId'},{name:'servManId'},{name : 'servManIp'},{name:'delFlag'}])
				});
SerManIpCfgGrid = Ext.extend(UxGrid, {
			constructor : function() {
				//servManIpStore = new ServManIpStore() ;
				SerManIpCfgGrid.superclass.constructor.call(this, {
							frame : true,
							width : Ext.getBody().getViewSize().width - 450,
							height : 100,
							viewConfig : {
								forceFit : true
							},
							loadMask : {
								msg : '正在载入数据,请稍候...'
							},
							sm : new Ext.grid.RowSelectionModel({
										singleSelect : true
									}),
							cm : new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
							{
								header : '服务商IP地址id',
								dataIndex : 'servManIpId',
								hidden : true
							}, {
								header : '服务商Id',
								dataIndex : 'servManId',
								hidden : true
							}, {
								header : 'IP地址',
								dataIndex : 'servManIp',
								width : 100
							}, {
								header : '删除标志',
								dataIndex : 'delFlag',
								hidden : true
							}]),
							ds : servManIpStore
						})
			}
		});
/** ************************流量配置列表************************************* */
var servFluxStore = new Ext.data.Store({ // Grid Store
					proxy : new Ext.data.HttpProxy({
								url : "getServFlux.action",
								method : 'POST'
							}),
					reader : new Ext.data.JsonReader({root:'root'},[{name:'item'},{name:'value'},{name : 'unit'}])
				});
ServFluxGrid = Ext.extend(UxGrid, {
			constructor : function() {
				//servManIpStore = new ServManIpStore() ;
				ServFluxGrid.superclass.constructor.call(this, {
							frame : true,
							width : Ext.getBody().getViewSize().width - 450,
							height : 100,
							viewConfig : {
								forceFit : true
							},
							loadMask : {
								msg : '正在载入数据,请稍候...'
							},
							sm : new Ext.grid.RowSelectionModel({
										singleSelect : true
									}),
							cm : new Ext.grid.ColumnModel([
							{
								header : '',
								dataIndex : 'item'
							}, {
								header : '',
								dataIndex : 'value'
							}, {
								header : '',
								dataIndex : 'unit',
								width : 100
							}]),
							ds : servFluxStore
						})
			}
		});
/** ************************访问控制配置列表************************************* */
var visitLimitTxt = new Ext.form.TextArea({
						width:"99%",
						height:50,
						value:""
					}) ;
/** ******************************************服务发布form*************************************************** */
ReleaseForm = Ext.extend(Ext.form.FormPanel, {
	servManIpCfgGrid:null,
	servFluxGrid:null,
	constructor : function() {
		//var url ="servReleaseService_getServManIps.action"+selServId.substring(5);
		this.servManIpCfgGrid = new SerManIpCfgGrid();
		this.servFluxGrid = new ServFluxGrid() ;
		ReleaseForm.superclass.constructor.call(this, {
					width : '100%',
					height : '100%',
					frame : true,
					bodyStyle : "padding: 5px 5px 0",
					defaults : {
						width : "99%"
					},
					items : [{
								xtype : "fieldset",
								autoHeight : true,
								title : "访问权限",
								// layout: "column" ,
								items : [{
											// xtype : 'container',
											// autoEl : {},
											layout : 'form',
											items : [{
														xtype : "label",
														text : '已配置可访问服务的系统：'
													}, {
														xtype : "panel",
														id : 'servManPanel',
														frame : false,
														bodyStyle : 'padding: 5px',
														items : [visitLimitTxt]
													}, {
														xtype : 'button',
														text : '配置',
														id : 'pzfwqx',
														iconCls : 'new',
														width : 20,
														hidden : false,
														handler : kickQueryLimit,
														scope : this
													}]
										}]
							}, {
								xtype : "fieldset",
								title : "控制配置",
								items : [{
											// xtype : 'container',
											// autoEl : {},
											layout : 'form',
											items : [{
														xtype : "label",
														text : '已配置服务流量信息：'
													}, {
														xtype : "panel",
														id : 'fluxPanel',
														frame : false,
														width:"98%",
														bodyStyle : 'padding: 5px',
														items : [this.servFluxGrid]
													}, {
														xtype : 'button',
														text : '配置',
														id : 'pzfwqx',
														iconCls : 'new',
														width : 20,
														hidden : false,
														handler : kickFlux,
														scope : this
													}]
										}]
							}, {
								xtype : "fieldset",
								title : "IP鉴权验证",

								items : [{
											// layout : 'form',
											items : [{
														xtype : "label",
														text : '已配置IP地址：'
													}, {
														xtype : "panel",
														id : 'ipCfgPanel',
														frame : false,
														autoHeight:true,
														width:'98%',
														bodyStyle : 'padding: 5px',
														items : [this.servManIpCfgGrid]
													}, {
														xtype : 'button',
														text : '配置',
														id : 'pzfwqx',
														iconCls : 'new',
														width : 20,
														hidden : false,
														handler : kickIp,
														scope : this
													}]
										}]
							}
							],
					buttons : [{
								text : '确定',
								id : 'ok_serv_btn',
								iconCls : 'new',
								width : 20,
								hidden : false,
								handler : this.onOkClick,
								scope : this
							}, {
								text : '刷新',
								id : 'refresh_serv_btn',
								width : 20,
								iconCls : 'update',
								hidden : false,
								handler : this.onFreshClick,
								scope : this
							}]
				})
	},
	onOkClick : function() {
		servGrid.updateServWindow.servForm.rwin.hide();
	},
	onFreshClick:function() {
		freash() ;
	}
});
/** *************************************服务发布组件************************************************* */
ReleaseWindow = Ext.extend(Ext.Window, {
			rw : null,
			constructor : function() {
				this.rw = new ReleaseForm();
				ReleaseWindow.superclass.constructor.call(this, {
							title : "服务发布--"+selServManName,
							width : Ext.getBody().getViewSize().width - 360,
							height :  Ext.getBody().getViewSize().height - 25,
							resizable : false,
							plain : true,
							modal : true,
							autoScroll : true,
							closeAction : 'hide',
							items : [this.rw]
						});
			}
		})
/** *********************************************************************访问控制************************************************************************************** */
QueryLimitWindow = Ext.extend(Ext.Window, {

			constructor : function(limitGrid) {
				var grid = limitGrid;
				QueryLimitWindow.superclass.constructor.call(this, {
							title : "配置可访问服务的系统",
							width : Ext.getBody().getViewSize().width - 250,
							height : Ext.getBody().getViewSize().height - 65,
							resizable : false,
							plain : true,
							modal : true,
							autoScroll : true,
							items : [grid]
						});
			},
			listeners : {
				"close" : function() {
					this.close();
				},
				"beforeclose" : function() {
					refreshLimitCfg();
				}
			}
		});

function kickQueryLimit() {
	var nodeId = selServId.substring(5);
	var tempServManVisitGrid = new ServManVisitLimitGridRelease();
	tempServManVisitGrid.store.load({
				params : {
					servId : nodeId
				},
				callback : function() { // 加载非选中服务所属的接入系统
					tempServManVisitGrid.getSelectionModel().clearSelections();
					dwr.engine.setAsync(false);
					ServManServRegDwr.getServManVisitLimitById(nodeId,
							function(data) {
								var store = tempServManVisitGrid.getStore();
								for (var i = 0; i < data.length; i++) {
									var idIndex = store.indexOfId(data[i]); // 根据id查找该记录所在行
									tempServManVisitGrid.getSelectionModel()
											.selectRow(idIndex, true);
								}
							});
					dwr.engine.setAsync(true);
					checkPrivilege(arrId);
				}
			});
	var qlWin = new QueryLimitWindow(tempServManVisitGrid);
	qlWin.show();
		if(servDefineType == '3'){
		  tempServManVisitGrid.servNoCombox1.store.load({params:{'servDefineDto.servId':nodeId}});
		  tempServManVisitGrid.reconfigure(tempServManVisitGrid.store,tempServManVisitGrid.cmWebservice);
		  tempServManVisitGrid.render('tempServManVisitGrid');
		}else if(servDefineType == '4'){
		  tempServManVisitGrid.servNoCombox.store.load({params:{'servDefineDto.servId':nodeId}});
		  tempServManVisitGrid.reconfigure(tempServManVisitGrid.store,tempServManVisitGrid.cmJms);
//			  tempServManVisitGrid.render(document.body);
		  tempServManVisitGrid.render('tempServManVisitGrid');
		}
}
/** *********************************************************************流量配置************************************************************************************** */
FluxCfgWindow = Ext.extend(Ext.Window, {
			constructor : function(cfgPanel) {
				var p = cfgPanel;
				FluxCfgWindow.superclass.constructor.call(this, {
							title : "流量配置窗口",
							width : Ext.getBody().getViewSize().width - 50,
							height : Ext.getBody().getViewSize().height - 10,
							resizable : false,
							plain : true,
							modal : true,
							autoScroll : true,
							items : [p]
						});
			},
			listeners : {
				"close" : function() {
					this.close();
				},
				"beforeclose" : function() {
					refreshFluxCfg();
				}
			}
		});

function kickFlux() {
	var FluxCfgPanel = new Ext.TabPanel({
				region : 'center',
				activeTab : 0,
				width : Ext.getBody().getViewSize().width - 50,
				height : Ext.getBody().getViewSize().height - 10,
				plain : true,
				defaults : {
					autoScroll : true
				},
				items : [{
					xtype : "panel",
					title : "流量配置",
					body : new Ext.ux.ManagedIFrame({
								autoCreate : {
									id : 'fluxCfgFrame', // 设置访问的名称
									src : '../monitor/monitorInfoCfg.jsp?nodeId ='
											+ selServId
											+ '&parentId ='
											+ selServManId,
									frameBorder : 0,
									cls : 'x-panel-body',
									width : '100%',
									height : '100%'
								}
							})
				}]
			});
	// tabPanel.setActiveTab(4);
	var cfgWin = new FluxCfgWindow(FluxCfgPanel);
	cfgWin.show();
}
///** *********************************************************************IP地址配置************************************************************************************** */
//function servManIpCfg(servManIdtemp, servManNametemp) {
//	var servManId = parseInt(servManIdtemp);
//	var servManName = servManNametemp.replace(/~/g, " ");
//	var record = [{
//				name : 'servManIpId'
//			}, {
//				name : 'servManId'
//			}, {
//				name : 'servManIp'
//			}, {
//				name : 'delFlag'
//			}];
//	servManIpConfRecord = new Ext.data.Record.create({
//				name : 'servManIpId',
//				mapping : 0
//			}, {
//				name : 'servManId',
//				mapping : 1
//			}, {
//				name : 'servManIp',
//				mapping : 2
//			}, {
//				name : 'delFlag',
//				mapping : 3
//			})
//	var hp = new Ext.data.HttpProxy({
//				url : 'register/servManIpConfAction_list.action'
//			});
//	var storeAbMsg = new Ext.data.Store({// 配置分组数据集
//		proxy : hp,
//		pruneModifiedRecords : true,
//		reader : new Ext.data.JsonReader({
//					totalProperty : "page.totalCount",
//					root : 'page.result',
//					fields : record
//				})
//	});
//	var gridWidth = Ext.getBody().getViewSize().width - 5;
//	if (screen.width == 1024 && screen.height == 768) {
//		gridWidth = Ext.getBody().getViewSize().width - 22;
//	}
//	var gridHeight = Ext.getBody().getViewSize().height - 225;
//	var columnWidth = gridWidth - 8;
//	var bbar1 = new Ext.PagingToolbar({// 分页工具栏
//		store : storeAbMsg,
//		paramNames : {
//			start : 'page.start',
//			limit : 'page.pageSize'
//		},
//		pageSize : pageTotal,
//		displayInfo : true,
//		displayMsg : '第 {0} 条到 {1} 条，一共 {2} 条',
//		emptyMsg : "没有记录"
//	});
//	var deleteStore = new Ext.data.SimpleStore({
//				fields : ['delFlag', 'delText'],
//				data : [['2', '是'], ['1', '否']]
//			});
//	var comboxDelete = new Ext.form.ComboBox({
//				allowBlank : false,
//				store : deleteStore,
//				hiddenName : 'delFlag',
//				valueField : 'delFlag',
//				displayField : 'delText',
//				editable : true,
//				typeAhead : true,
//				mode : 'local',
//				value : 1,
//				triggerAction : 'all',
//				selectOnFocus : true
//			})
//	var columModel = new Ext.grid.ColumnModel([
//
//			new Ext.grid.RowNumberer(), {
//				header : '接入系统IP的id',
//				dataIndex : 'servManIpId',
//				width : 50,
//				hidden : true
//			}, {
//				header : '接入系统id',
//				dataIndex : 'servManId',
//				hidden : true,
//				width : 150
//			}, {
//				header : '接入系统IP',
//				dataIndex : 'servManIp',
//				editor : new Ext.grid.GridEditor(new Ext.form.TextField({
//							allowBlank : false,
//							blankText : '请设置系统IP'
//						})),
//				width : 300
//			}, {
//				header : '删除标志',
//				dataIndex : 'delFlag',
//				editor : comboxDelete,
//				hidden : true,
//				width : 100
//			}])
//	columModel.defaultSortable = false;
//	var gridAbMsg = new Ext.grid.EditorGridPanel({
//				store : storeAbMsg,
//				cm : columModel,
//				width : Ext.getBody().getViewSize().width - 100,
//				height : Ext.getBody().getViewSize().height - 100,
//				title : servManName,
//				frame : true,
//				trackMousOver : true,
//				clicksToEdit : 1,
//				layout : "fit",
//				stripeRows : true,
//				loadMask : true,
//				sm : new Ext.grid.RowSelectionModel({
//							singleSelect : true
//						})
//			});
//
//	storeAbMsg.baseParams = {
//		'servManIpconfDto.servManId' : servManId
//	};
//	storeAbMsg.load({
//				params : {
//					'page.start' : 0,
//					'page.pageSize' : pageTotal
//				}
//			});
//	var editForm = new Ext.form.FormPanel({
//				width : Ext.getBody().getViewSize().width,// Ext.getBody().getViewSize().width
//				// - 5,
//				height : Ext.getBody().getViewSize().height - 100,
//				labelWidth : 120,
//				labelAlign : "right",
//				frame : true,
//				items : [{
//							layout : "column",
//							items : [{
//										columnWidth : 1.0,
//										layout : "form",
//										items : gridAbMsg
//									}]
//						}]
//			});
//	var wdWidth = Ext.getBody().getViewSize().width - 850;
//	if (screen.width == 1024 && screen.height == 768)
//		wdWidth = Ext.getBody().getViewSize().width - 650;
//	dslMapWin = new Ext.Window({ // 新建一个窗口
//		title : "系统IP配置",
//		layout : 'fit',
//		modal : true, // 模式窗口
//		width : wdWidth,
//		height : Ext.getBody().getViewSize().height - 150,
//		minimizable : true,
//		maximizable : true,
//		// plain : true,
//		listeners : {
//			"minimize" : function() {
//				this.hide();
//			},
//			"close" : function() {
//				this.close();
//			},
//			"beforeclose" : function() {
//				refreshIpCfg() ;//刷新IP配置列表数据
//				var m = storeAbMsg.modified.slice(0);
//
//				if (m.length > 0) {
//
//					Ext.Msg.confirm("提示", "有记录增加或修改，是否保存?", function(btn) {
//								if (btn == "yes") {
//									saveIPConfig();
//									dslMapWin.hide();
//								} else {
//									dslMapWin.hide();
//								}
//							})
//					return false;
//				}
//			}
//		},
//		items : [{
//					layout : "column",
//					items : [{
//								columnWidth : 1.0,
//								layout : "fit",
//								items : editForm
//							}]
//				}],
//		buttonAlign : 'center',
//		buttons : [{
//					text : "新增",
//					id : 'addNewInfo',
//					handler : addNewIp
//				}, {
//					text : "保存",
//					id : 'saveInfo',
//					handler : saveIPConfig
//				}, {
//					text : "删除",
//					handler : deleteIPconfig
//				}]
//	});
//	function close() {
//		dslMapWin.close();
//	}
//	function addNewIp() {
//		var n = storeAbMsg.getCount();
//		var initValue = {
//			servManIpId : '',
//			servManId : servManId,
//			servManIp : '',
//			delFlag : '1'
//		};
//		var r = new servManIpConfRecord(initValue);
//		gridAbMsg.stopEditing();
//		storeAbMsg.insert(n, r);
//		gridAbMsg.startEditing(n, 3);
//		r.dirty = false;
//		r.modified = initValue;
//		if (storeAbMsg.modified.indexOf(r) == -1)
//			storeAbMsg.modified.push(r);
//	}
//	// gridAbMsg.on("afteredit",afteredit,gridAbMsg);
//	// function afteredit(e){
//	// var record = e.record;
//	// Ext.Msg.alert("提示","修改进行中!")
//	// }
//	function saveIPConfig() {
//		var m = storeAbMsg.modified.slice(0);
//		if (m.length == 0) {
//			Ext.Msg.alert("提示", "没有记录被修改或增加!")
//			return;
//		}
//		var servManIPConfigArray = [];
//		Ext.each(m, function(item) {
//					var servManIPconfig = {
//						servManIpId : '',
//						servManId : '',
//						servManIp : '',
//						delFlag : ''
//					};
//					servManIPconfig.servManIpId = item.get("servManIpId");
//					servManIPconfig.servManId = item.get("servManId");
//					servManIPconfig.servManIp = item.get("servManIp");
//					servManIPconfig.delFlag = item.get("delFlag");
//					servManIPConfigArray.push(servManIPconfig);
//				});
//		if (servManIPConfigArray.length == 0) {
//			Ext.Msg.alert("提示", "没有记录被修改或增加!")
//		}
//		Ext.Ajax.request({
//					url : 'register/servManIpConfAction_saveOrupdate.action',
//					params : {
//						saveServManIPConfigtypeJson : encodeURIComponent(Ext
//								.encode
//
//								(servManIPConfigArray))
//					},
//					success : function(response, options) {
//						Ext.Msg.alert('消息', '数据已经成功地保存了！', function() {
//									storeAbMsg.baseParams = {
//										'servManIpconfDto.servManId' : servManId
//									}
//									storeAbMsg.reload({
//												params : {
//													start : 0,
//													limit : pageSize
//												}
//											});
//								});
//					},
//					failure : function(response) {
//						Ext.Msg.alert('错误', '数据保存失败！');
//					}
//				});
//
//	}
//	function deleteIPconfig() {
//		var smTemp = gridAbMsg.getSelectionModel();
//		var recordTemp = smTemp.getSelected();
//		if (recordTemp == null) {
//			Ext.Msg.alert("提示", "请选择一行进行删除!");
//			return;
//		}
//		Ext.Msg.confirm("提示", "确认要删除该条记录吗?", function(btn) {
//			if (btn == "yes") {
//				var servManIPConfigArray = [];
//				var servManIPconfig = {
//					servManIpId : '',
//					servManId : '',
//					servManIp : '',
//					delFlag : ''
//				};
//				servManIPconfig.servManIpId = recordTemp.get("servManIpId");
//				servManIPconfig.servManId = recordTemp.get("servManId");
//				servManIPconfig.servManIp = recordTemp.get("servManIp");
//				servManIPconfig.delFlag = 2;
//				servManIPConfigArray.push(servManIPconfig);
//				Ext.Ajax.request({
//					url : 'register/servManIpConfAction_saveOrupdate.action',
//					params : {
//						saveServManIPConfigtypeJson : encodeURIComponent(Ext
//								.encode
//
//								(servManIPConfigArray))
//					},
//					success : function(response, options) {
//						Ext.Msg.alert('消息', '数据已经成功地删除了！', function() {
//									storeAbMsg.baseParams = {
//										'servManIpconfDto.servManId' : servManId
//									}
//									storeAbMsg.reload({
//												params : {
//													start : 0,
//													limit : pageSize
//												}
//											});
//								});
//					},
//					failure : function(response) {
//						Ext.Msg.alert('错误', '数据删除失败！');
//					}
//				});
//			}
//		})
//	}
//	dslMapWin.show();
//}

function kickIp() {
	var servManNametemp = selServManName.replace(/ /g, "~");
	servManIpCfg(selServManId.substring(9),servManNametemp);
//	servManIpCfg(selServManId.substring(9), servManNametemp);
}


/***************************************ServManVisitLimitGridRelease组件***************************************************/
ServManVisitLimitGridRelease = Ext.extend(Ext.grid.EditorGridPanel, {
    
    servManVisitStore: new Ext.data.Store({
        proxy: new Ext.data.HttpProxy({url: SERVMANINFO_STORE_URL, method: 'POST'}),
        reader: new Ext.data.JsonReader({id:"servManId",root:'servManList'},[{name:'servManId'},{name:'servManName'},
        {name:'versionNo'},{name:'isConfirm'},{name:'servLimitId'}])
    }),
    servManVisitSm: new Ext.grid.CheckboxSelectionModel({header:'',handleMouseDown:Ext.emptyFn}),
    servNoCombox:null,
    servNoCombox1:null,
    confirmCombox:null,
    cmWebservice:null,
    cmJms:null,
    constructor: function() {
    	this.servNoCombox = this.createCombo1("versionNo","versionNo","register/servDefineAction_queryServDefineVersion.action","servDefineDtoList",70);
        this.servNoCombox1 = this.createCombo1("versionNo","versionNo","register/servDefineAction_queryServDefineVersion.action","servDefineDtoList",70);
        this.confirmCombox = this.createCheckBox(true,1,'isConfirm');
        this.cmWebservice = new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
                 this.servManVisitSm,
                {header:'id',dataIndex:'servManId',width:120,hidden:true},
                {header:show_name,dataIndex:'servManName',width:120},
                {header:'服务版本',dataIndex:'versionNo',width:100,editor:new Ext.grid.GridEditor(this.servNoCombox1),renderer:this.formatVersion}
            ]),
        this.cmJms = new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
                 this.servManVisitSm,
                {header:'id',dataIndex:'servManId',width:(Ext.getBody().getViewSize().width -300)/4,hidden:true},
                {header:show_name,dataIndex:'servManName',width:(Ext.getBody().getViewSize().width -300)/3},
                {header:'服务版本',dataIndex:'versionNo',width:(Ext.getBody().getViewSize().width -380)/3,editor:new Ext.grid.GridEditor(this.servNoCombox),renderer:this.formatVersion},
                {header:'是否需要确认',dataIndex:'isConfirm',id:'isConfirm',width:(Ext.getBody().getViewSize().width -380)/3,editor:new Ext.grid.GridEditor(this.confirmCombox),renderer:this.formatConfirm}
            ]),
        ServManVisitLimitGridRelease.superclass.constructor.call(this, {
           // renderTo: 'ServVisitLimitGrid',
           // title: '服务访问权限列表',
            frame: true,
            width: Ext.getBody().getViewSize().width -280,
            height: Ext.getBody().getViewSize().height - 65,
            autoWidth:true,
            clicksToEdit:1,
            viewConfig: {
                forceFit: true
            },
//            loadMask: {
//                msg : '正在载入数据,请稍候...'
//            },
            sm: this.servManVisitSm,
            cm: this.cmWebservice,
            ds: this.servManVisitStore,
           /* bbar: [
                '-', {text: '角色管理', iconCls: 'link', handler:this.onLinkRole, scope: this}
            ],*/
            listeners: {
                'cellclick': {fn: this.gridCellClick, scope: this},
                'afteredit':{fn:this.gridCellEdit,scope: this},
                'show':{fn:this.Render,scope: this}
            }
        });
    },
   
    //为选中的服务增加或取消访被访问的接入系统
    gridCellClick: function(grid, rowIndex, columnIndex, e) {

       if(selServId.indexOf('man')!=-1) {
           Ext.Msg.alert('系统提示', blankStr + '请选择服务' + blankStr);
           return;
       }
       if(!servManVisitGrid.servManVisitSm.isLocked()){
       if(columnIndex == 1) {
           var record = grid.getStore().getAt(rowIndex); 
           var status = grid.getSelectionModel().isSelected(record);
           var versionNo = record.get('versionNo');
           var isConfirm = record.get("isConfirm");
           if(isConfirm == true){
                isConfirm = 1;
            }else if(isConfirm == false){
                isConfirm = 0;
               }else{
                 isConfirm = '';
             }
            if(versionNo == '请选择...'){
               versionNo = '';
            }
            Ext.MessageBox.confirm('系统提示:','您确定要变更服务的'+show_name+'访问权限吗？',function(btn){           	
                if(btn == 'yes') { 
                	dwrLoadMask.show();
		           if(status) {
		               ServManServRegDwr.saveServVisitLimit(record.data.servManId,selServId.substring(5),versionNo,isConfirm,function(data) {
		                	 if(data) {
		                	 	dwrLoadMask.hide();
		                        Ext.MessageBox.alert("系统提示:", blankStr + "权限设置生效" + blankStr,function(btn){
		                          if(btn == 'ok'){
		                          	queryVisitLimit();
		                          }
		                        });                      
		                    } else {
		                    	dwrLoadMask.hide();
		                        Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
		                        grid.getSelectionModel().deselectRow(rowIndex); 
		                    }
		               });
		            } else {
		                ServManServRegDwr.delServVisitLimit(record.data.servManId,selServId.substring(5),function(data) {
		                  	 if(data) {
		                  	 	dwrLoadMask.hide();
		                        Ext.MessageBox.alert("系统提示:", blankStr + "权限设置生效" + blankStr);                      
		                    } else {
		                    	dwrLoadMask.hide();
		                        Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
		                        grid.getSelectionModel().selectRow(rowIndex,true); 
		                    }
		                });
		            }
                }
                else{
                	 if(status)  grid.getSelectionModel().deselectRow(rowIndex); 
                	 else    grid.getSelectionModel().selectRow(rowIndex,true); 
                }
            })
       }
	}
    },
    //修改服务的接入系统访问权限
    gridCellEdit: function(e){

       if(selServId.indexOf('man')!=-1) {
           Ext.Msg.alert('系统提示', blankStr + '请选择服务' + blankStr);
           return;
       }
       if(!servManVisitGrid.servManVisitSm.isLocked()){
          if(e.column == 5 || e.column == 4){
          	var record = e.grid.getStore().getAt(e.row);
          	var status = e.grid.getSelectionModel().isSelected(record);
          	var isConfirm = record.get("isConfirm");
          	var versionNo = record.get("versionNo");
          	if(versionNo == '请选择...'){
          	  versionNo = '';
          	}
           if(isConfirm == true){
                isConfirm = 1;
            }else if(isConfirm == false){
                isConfirm = 0;
               }else{
                 isConfirm = '';
             }
          	if(status){
          	    Ext.MessageBox.confirm('系统提示','服务的'+show_name+'访问权限发生改变是否保存?',function(btn){
          	      if(btn == 'yes'){
          	       ServManServRegDwr.updateServVisitLimit(record.data.servLimitId,record.data.servManId,selServId.substring(5),versionNo,isConfirm,function(data){
          	        if(data) {
		                  	 	dwrLoadMask.hide();
		                        Ext.MessageBox.alert("系统提示:", blankStr + "权限设置生效" + blankStr,function(btn){
		                        	if(btn == 'ok'){
		                                   queryVisitLimit();
		                        	}
		                        }); 
		                    } else {
		                    	dwrLoadMask.hide();
		                        Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
		                        e.grid.getSelectionModel().selectRow(e.row,true); 
		                    }
          	       
          	       });
          	      }
          	    })
          	}
          }
       	}    
    },
      createCombo1: function(id,name,url,root,width) {    //生成一个通用的ComboBox
        var combo = new Ext.form.ComboBox({
            emptyText: '请选择...',
            isFormField: true,
            mode: 'local',
            triggerAction: 'all',
            width: width,
            readOnly: true,
            displayField:name,
            valueField:id,
            store: new Ext.data.Store({
                proxy: new Ext.data.HttpProxy({url: url, method: 'POST'}),
                reader: new Ext.data.JsonReader({root:root},new Ext.data.Record.create([{name:id},{name:name}]))
            })
        });
        return combo;
    },
    createCheckBox:function(checked,inputValue,name){
        var checkBox = new Ext.form.Checkbox({
                	checked:checked,inputValue:inputValue,name:name,hideLabel:true,labelSeparator:'',boxLabel:"是",autoShow:true});
                	return checkBox;
    
    },
    formatConfirm:function(val){
    	 value = '';
             if(val == 1 || val == true){
             	value = '是'; 
             }else if(val == '2'){
             	value = '否';
             }else{
               value = '请选择...';
             }
             return value;
    },
    formatVersion:function(val){
      value = '';
      if(val != '0' && val != null){
       value = 'V' + val; 
      }else {
        value ='请选择...';
//        this.columns[4].Visible = false;
      }
      return value;
    }	   
});



/********ip地址配置**********/

 function servManIpCfg(servManIdtemp,servManNametemp) {
   	   var servManId  = parseInt(servManIdtemp);
   	   var servManName = servManNametemp.replace(/~/g," ");
   	   var record = [{name:'servManIpId'},{name:'servManId'},{name:'servManIp'},{name:'delFlag'}];
	    servManIpConfRecord = new Ext.data.Record.create({name:'servManIpId',mapping:0},{name:'servManId',mapping:1},{name:'servManIp',mapping:2},{name:'delFlag',mapping:3})
	   var hp = new Ext.data.HttpProxy({url : 'register/servManIpConfAction_list.action'});
       var storeAbMsg = new Ext.data.Store({// 配置分组数据集
		        proxy : hp,
		        pruneModifiedRecords:true,
		        reader : new Ext.data.JsonReader({totalProperty : "page.totalCount",root : 'page.result',fields : record})
	          });  
	  var gridWidth = Ext.getBody().getViewSize().width - 5;
		if (screen.width == 1024 && screen.height == 768) {
				gridWidth = Ext.getBody().getViewSize().width - 22;
			}
	  var gridHeight = Ext.getBody().getViewSize().height - 225;
	  var columnWidth = gridWidth - 8;
	  var bbar1 = new Ext.PagingToolbar({// 分页工具栏
							store : storeAbMsg,
							paramNames : {
								 start : 'page.start',
								 limit : 'page.pageSize'
							},
							pageSize : pageTotal,
							displayInfo : true,
							displayMsg : '第 {0} 条到 {1} 条，一共 {2} 条',
							emptyMsg : "没有记录"
						});
	 var deleteStore = new Ext.data.SimpleStore({fields : ['delFlag', 'delText'],data :  [['2', '是'], ['1', '否']]});					
	 var comboxDelete = new Ext.form.ComboBox({allowBlank:false, store:deleteStore,hiddenName:'delFlag',valueField:'delFlag',displayField:'delText',editable:true,typeAhead:true,mode:'local',value:1, triggerAction:'all',selectOnFocus:true})					
	 var columModel = new Ext.grid.ColumnModel([ new Ext.grid.RowNumberer(),
	 	                                        { header:show_name+'IP的id',dataIndex:'servManIpId',width:50,hidden:true},
	                                            { header:show_name+'id',dataIndex:'servManId',hidden:true,width:150},
	                                            { header:show_name+'IP',dataIndex:'servManIp',editor:new Ext.grid.GridEditor(new Ext.form.TextField({allowBlank:false,blankText:'请设置系统IP'})),width:300},
	                                            { header:'删除标志',dataIndex:'delFlag',editor:comboxDelete,hidden:true,width:100 }	 
	                                           ])
	  columModel.defaultSortable = false;                               
     var gridAbMsg = new Ext.grid.EditorGridPanel({store:storeAbMsg,cm:columModel,width:Ext.getBody().getViewSize().width - 100,height:Ext.getBody().getViewSize().height - 240,
                                                   title:servManName,frame:true,trackMousOver:true, clicksToEdit:1,layout:"fit",stripeRows:true,loadMask:true,
                                                   viewConfig:{forceFit:true},
                                                   sm: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                   listeners:{
                                                           'afteredit': aterCellEdit,
                                                           'beforeedit':beforeCellEdit
                                                      }
                                                   });
                                                  
	    storeAbMsg.baseParams = {'servManIpconfDto.servManId':servManId };
        storeAbMsg.load({params : {'page.start' : 0,'page.pageSize' : 10000}});
		 var wdWidth = Ext.getBody().getViewSize().width  - 800;
		 if (screen.width ==1024 && screen.height ==768)wdWidth = Ext.getBody().getViewSize().width  - 600;
         dslMapWin = new Ext.Window({ // 新建一个窗口
           title : "系统IP配置",
           layout : 'fit',
           modal : true, 
           width : wdWidth,
           height : Ext.getBody().getViewSize().height - 160 ,
           minimizable : true,
           maximizable : true,
           listeners:{
                    "minimize":function(){ this.hide();},
                    "close":function() { this.close();},
                    "beforeclose":function(){
                                            var m = storeAbMsg.modified.slice(0);
								              if(m.length>0){
								                             Ext.Msg.confirm("提示","有记录增加或修改，是否保存?"+blankStr,function(btn){
								                                           if(btn == "yes"){
								                                                             saveIPConfig();dslMapWin.hide();
								                                                           }else{dslMapWin.hide();}              
								                                           })  
								                     return false;
								                    }
                                        }
                      },
          items : [{layout: "column",items : [{columnWidth : 1.0,layout : "fit",items : gridAbMsg}]}],
		  buttonAlign:'center',
		  buttons:[{text:"新增",id:'addNewInfo',handler:addNewIp}, {text:"保存",id:'saveInfo',handler:saveIPConfig},{text:"删除" ,handler:deleteIPconfig}]
         });
     function close(){dslMapWin.close();}
     function aterCellEdit(e){
			 if(e.column == 3){
	              var count = gridAbMsg.getStore().getCount();
				      for(i=0;i<count;i++){
				      	if(e.row == i)continue;
			                   var record = gridAbMsg.getStore().getAt(i);
					           if(record.get('servManIp') == e.record.get('servManIp')){
								   Ext.MessageBox.alert('系统提示',blankStr+'IP配置重复!'+blankStr,function(){
								    e.record.set('servManIp',servManIP);
					           	    e.record.dirty = false;
					           	    e.record.commit();
					           	    gridAbMsg.getSelectionModel().selectRow(e.row,true);
								   });
							         return;
															          }
															}
									 }
     }
     function beforeCellEdit(e){
     	   var record = e.record;
     	   servManIP = record.get('servManIp');
     }
     function addNewIp(){
                var n =   storeAbMsg.getCount();
                var initValue = {servManIpId:'',servManId:servManId,servManIp:'',delFlag:'1'  };
                var r = new servManIpConfRecord(initValue);
                gridAbMsg.stopEditing();
                storeAbMsg.insert(n,r);
                gridAbMsg.startEditing(n,3);
                r.dirty = false;
                r.modified = initValue;
                if(storeAbMsg.modified.indexOf(r)== -1)storeAbMsg.modified.push(r);
         }
     function saveIPConfig(){
         var m = storeAbMsg.modified.slice(0);
         if(m.length == 0){
                            Ext.Msg.alert("提示",blankStr+"没有记录被修改或增加!"+blankStr)
                            return ;
                           }
          var servManIPConfigArray = [];
          Ext.each(m,function(item){
          var servManIPconfig = {servManIpId:'',servManId:'',servManIp:'',delFlag:''};
              servManIPconfig.servManIpId = item.get("servManIpId");servManIPconfig.servManId = item.get("servManId");
              servManIPconfig.servManIp = item.get("servManIp");servManIPconfig.delFlag = item.get("delFlag");
              if(servManIPconfig.servManIp == ""|| servManIPconfig.servManIp == null){
              	Ext.Msg.alert('信息提示','有IP配置为空，请重新配置！',function(button){if(button == 'ok'){ return;}});
              	return;
              }
              servManIPConfigArray.push(servManIPconfig);
          });
          if(servManIPConfigArray.length == 0){
             Ext.Msg.alert("信息提示",blankStr+"IP为空或格式不正确，请重新配置!"+blankStr)
             return;
          }
          Ext.Ajax.request({
								url:'register/servManIpConfAction_saveOrupdate.action',
								params:{saveServManIPConfigtypeJson:encodeURIComponent(Ext.encode(servManIPConfigArray))},
								success:function(response,options){
									Ext.Msg.alert('消息',blankStr+'数据已经成功地保存了！'+blankStr,function(){
										storeAbMsg.baseParams = {'servManIpconfDto.servManId':servManId}
										storeAbMsg.load({params:{'page.start':0, 'page.pageSize':10000}});
									});
								},
								failure:function(response){
									Ext.Msg.alert('错误','数据保存失败！');
								}
							});  
          
         }
      function deleteIPconfig(){
          var smTemp = gridAbMsg.getSelectionModel();
          var recordTemp = smTemp.getSelected();
          if(recordTemp == null){
						          Ext.Msg.alert("提示",blankStr+"请选择一行进行删除!"+blankStr);
						          return;
          }
		if( recordTemp.get("servManIp") == ""){
			Ext.Msg.alert("提示",blankStr+"请选择一行进行删除!"+blankStr);
			return;
		}
          Ext.Msg.confirm("提示",blankStr+"确认要删除该条记录吗?"+blankStr,function(btn){
                 if(btn == "yes"){
					          var servManIPConfigArray = [];
					          var servManIPconfig = {servManIpId:'',servManId:'',servManIp:'',delFlag:''};
					              servManIPconfig.servManIpId = recordTemp.get("servManIpId");servManIPconfig.servManId = recordTemp.get("servManId"); servManIPconfig.servManIp = recordTemp.get("servManIp");servManIPconfig.delFlag = 2;
					              servManIPConfigArray.push(servManIPconfig);
					              Ext.Ajax.request({
													url:'register/servManIpConfAction_saveOrupdate.action',
													params:{saveServManIPConfigtypeJson:encodeURIComponent(Ext.encode(servManIPConfigArray))},
													success:function(response,options){
														Ext.Msg.alert('消息',blankStr+'数据已经成功地删除了！'+blankStr,function(){
															storeAbMsg.baseParams = {'servManIpconfDto.servManId':servManId}
															storeAbMsg.load({params:{'page.start':0, 'page.pageSize':10000}});
														});
													},
													failure:function(response){
														Ext.Msg.alert('错误',blankStr+'数据删除失败！'+blankStr);
													}
												});  
             }
          })      
         }
         dslMapWin.show();
       }