/**
 * @author
 * @date 2010-3-15
 * @description 接入系统配置管理页面
 * 
 * 
 */

Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif'; // 本地图形化

var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'; // 需要补充的空格
var GETALLUSERTYPE_URL = "GetAllServManAction.action"
var pageSize = 15;
var maxId = 0;
var addFlag = false;
var pageTotal = 15;
var servManIpConfRecord;
var grid, servManIP;
var queueConfObj = {
	queueId : '',
	connectionFactory : '',
	queueName : '',
	initialContextFactory : '',
	url : '',
	userName : '',
	password : ''
};
var servManObj = {
	servManCode : '',
	servManName : '',
	companyName : '',
	contactName : '',
	contactPhone : '',
	email : '',
	imNo : '',
	servManDec : '',
	authCode : ''
}
var wsdlConfObj = {
	busiWsdlText : '',
	servManId : '',
	wsdlId : ''
};
var protocolInfoObj = {
	filePath : '',
	servManId : '',
	protocolId : ''
}

function changeStyle(style) {
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + style + ".css");
}
Ext
		.onReady(function() {
			Ext.QuickTips.init();

			Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.styleCssValue);
			Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.parent.styleCssValue);
			// Ext.Ajax.on('requestcomplete',checkUserSessionStatus, this);
			function checkUserSessionStatus(conn, response, options) {
				var sessionStatus = response.getResponseHeader["sessionstatus"];

				if (typeof (sessionStatus) != "undefined") {
					Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
						if (btn == 'ok') {
							var redirect = URL_START + document.location.host
									+ LOG_IN_URL + '?flag=true';
							window.location = redirect;
						}
					});
				}
			}
			var redStar = '<font color=red>' + '*' + '</font>';

			// 弄个缩写的别名
			var fm = Ext.form;

			// 定义复选框选择模式变量
			// var sm = new
			// Ext.grid.CheckboxSelectionModel({singleSelect:true});
			// var sm = new
			// Ext.grid.CheckboxSelectionModel({header:'',handleMouseDown:Ext.emptyFn,singleSelect:true});
			var sm = new Ext.grid.CheckboxSelectionModel({
				header : '',
				singleSelect : true
			});
			// var sm = new Ext.grid.CheckboxSelectionModel();
			sm.on('rowselect', select);
			sm.on('rowdeselect', reset);
			// 列模型定义了表格所有列的信息,
			// dataIndex 将特定的列映射到数据源(Data Store)中的数据列(在后面创建)
			var cm = new Ext.grid.ColumnModel([ sm, new Ext.grid.RowNumberer(),
					{
						id : 'servManId',
						header : show_name + "ID",
						dataIndex : 'servManId',
						width : 100,
						hidden : true
					}, {
						id : 'servManCode',
						header : show_name + "编码",
						dataIndex : 'servManCode',
						width : 100
					}, {
						id : 'servManName',
						header : show_name + "名称",
						dataIndex : 'servManName',
						width : 150
					}, {
						id : 'companyName',
						header : "厂家",
						dataIndex : 'companyName',
						width : 100
					}, {
						id : 'contactName',
						header : "联系人",
						dataIndex : 'contactName',
						width : 80
					}, {
						id : 'contactPhone',
						header : "联系电话",
						dataIndex : 'contactPhone',
						width : 80
					}, {
						id : 'email',
						header : "电子邮箱",
						dataIndex : 'email',
						width : 120
					}, {
						id : 'imNo',
						header : "即时通信号",
						dataIndex : 'imNo',
						width : 100
					}, {
						id : 'servManDec',
						header : "备注",
						dataIndex : 'servManDec',
						width : 150
					}, {
						header : "系统IP配置",
						dataIndex : 'servManId',
						width : 80,
						renderer : getDetilRule
					}, {
						id : 'servManId1',
						header : "协议列表",
						dataIndex : 'servManId',
						width : 80,
						renderer : getDetilPro
					}, {
						id : 'servManId2',
						header : "业务wsdl列表",
						dataIndex : 'servManId',
						width : 80,
						renderer : getDetilWsdl
					}, {
						header : "接收队列",
						dataIndex : 'queueId',
						width : 80,
						renderer : getQueueConf
					}, {
						header : "鉴权码",
						dataIndex : 'authCode',
						width : 80,
						hidden : true,
						renderer : getAuthCode
					} ]);

			function getDetilRule(val, params, record) {
				var servManid = record.get("servManId");
				var servManName = record.get("servManName");
				servManNametemp = servManName.replace(/ /g, "~");
				return '<a href=javascript:detDetail("' + servManid + '","'
						+ servManNametemp + '")>' + '<center>配置IP</center>'
						+ '</a>';

			}
			function getDetilPro(val, params, record) {
				var servManid = record.get("servManId");
				return '<a href=javascript:detDetailPro("' + servManid + '")>'
						+ '<center>查看</center>' + '</a>';

			}
			function getDetilWsdl(val, params, record) {
				var servManid = record.get("servManId");
				return '<a href=javascript:detDetailWsdl("' + servManid + '")>'
						+ '<center>查看</center>' + '</a>';

			}
			// 默认情况下列是可排序的
			cm.defaultSortable = true;
			// 定义一个用户对象,这样便于我们动态的添加记录,虽然也可以设置成匿名内置对象
			/** ********************************************结果列表区*********************************** */
			var hp = new Ext.data.HttpProxy({
				url : 'register/getAllServMan.action'
			});
			var store = new Ext.data.Store({// 配置分组数据集
				proxy : hp,
				reader : new Ext.data.JsonReader({
					totalProperty : "page.totalCount",
					root : 'page.result',
					idProperty : 'serManId',// default id
					fields : [ {
						name : 'servManId'
					}, {
						name : 'servManName'
					}, {
						name : 'servManCode'
					}, {
						name : 'companyName'
					}, {
						name : 'contactName'
					}, {
						name : 'contactPhone'
					}, {
						name : 'email'
					}, {
						name : 'imNo'
					}, {
						name : 'servManDec'
					}, {
						name : 'queueId'
					}, {
						name : 'authCode'
					} ]
				})
			});
			servManLabel = new Ext.form.Label({
				text : show_name+"查找："
			}), servMan = createTextField(show_name+"查找：", "servManCode",
					"90%", "text", 100, true, "", "超出最大长度100");
			// 创建编辑器表格
			grid = new Ext.grid.GridPanel({
				title : show_name + '管理',
				store : store,
				loadMask : true,
				sm : sm,// 设置复选框选择模式new
				// Ext.grid.RowSelectionModel({singleSelect:true})
				cm : cm,
				renderTo : 'grid-div',
				width : Ext.getBody().getViewSize().width - 5,
				height : Ext.getBody().getViewSize().height * 0.62,
				frame : true,
				viewConfig : {
					forceFit : false
				},
				tbar : new Ext.Toolbar({
					items : [servManLabel, servMan,'-', {
						text : '查询',
						iconCls : 'find',
						handler : query,
						scope : this
					}, '-', {
						text : '重置',
						iconCls : 'resume',
						handler : resume,
						scope : ""
					}]
				}),
				bbar : new Ext.PagingToolbar({
					pageSize : 15,
					store : store,
					paramNames : {
						start : 'page.start',
						limit : 'page.pageSize'
					},
					displayInfo : true,
					emptyMsg : "未检索到任何记录",
					items : [

					/*
					 * { text: '添加', iconCls:'new',//按钮图标的CSS名称 id :'addInfo',
					 * handler : addUserType },
					 */{
						text : '删除',
						iconCls : 'delete',// modified by jch 2009/10/20
						id : 'Btn_Del',
						hidden : false,
						handler : remove

					} /*
						 * ,{ text: '保存', iconCls:'save', id : 'updateInfo',
						 * handler : saveUserType }
						 *//*
						 * ,{ text: '刷新', iconCls: 'refresh', handler :
						 * operateUserType }
						 */]
				})
			});

			store.load({
				params : {
					'page.start' : 0,
					'page.pageSize' : pageSize
				}
			});
			function createTextFiled(fieldLabel, name, id, allowBlank, anchor,
					maxLength, maxLengthText, vtype) { // 生成一个通用的TextField
				var tf = new Ext.form.TextField({
					fieldLabel : fieldLabel,
					id : id,
					name : name,
					xtype : 'textfield',
					readOnly : false,
					allowBlank : allowBlank,
					anchor : anchor,
					blankText : '该选项为必填项,请输入内容...',
					vtype : vtype,
					maxLength : maxLength,
					maxLengthText : maxLengthText
				});
				return tf;
			}
			;
			function createTextField(fieldLabel, name,
					anchor, inputType, maxLength,
					allowBlank, vtype, maxLengthText) { // 生成一个通用的TextField
				var tf = new Ext.form.TextField({
					fieldLabel : fieldLabel,
					name : name,
					xtype : 'textfield',
					readOnly : false,
					allowBlank : allowBlank,
					anchor : anchor,
					blankText : '该选项为必填项,请输入内容...',
					width : 300,
					vtype : vtype,
					inputType : inputType,
					maxLength : maxLength,
					maxLengthText : maxLengthText
				});
				return tf;
			};
			function query(){
				var servManSch = servMan.getValue();
				grid.store.baseParams = {
						'servManDto.servManCode' : servManSch
					};
					grid.store.load({
						params : {
							'page.start' : 0,
							'page.pageSize' : pageSize
						}
					});
			};
			function resume(){
				servMan.setValue("");
			};
			var servManCodeTxt = createTextFiled(redStar + show_name + "编码",
					"servManCode", "servManCode", false, '80%', 32,
					'字符最大长度为32!');
			var servManNameTxt = createTextFiled(redStar + show_name + "名称",
					"servManName", "servManName", false, '80%', 32,
					'字符最大长度为32！');
			var companyNameTxt = createTextFiled("厂家", "companyName",
					"companyName", true, '80%', 64, '字符最大长度为64！');
			var contactNameTxt = createTextFiled("联系人", "contactName",
					"contactName", true, '80%', 64, '字符最大长度为64！');
			var contactPhoneTxt = createTextFiled("联系电话", "contactPhone",
					"contactPhone", true, '80%', 16, '字符最大长度为16！', 'phone');
			var email = createTextFiled("电子邮箱", "email", "email", true, '80%',
					32, '字符最大长度为32！', 'email');
			var imNoTxt = createTextFiled("即时通信号", "imNo", "imNo", true, '80%',
					16, '字符最大长度为16！');
			var servManIdField = new Ext.form.Hidden({
				fieldLabel : "服务商Id",
				name : 'servManId'
			});
			var queueConfId = new Ext.form.Hidden({
				fieldLabel : "队列Id",
				name : 'queueId'
			});
			var authCodeField = new Ext.form.Hidden({
				fieldLabel : '鉴权码',
				name : 'authCode'
			})
			var wsdlIdField = new Ext.form.Hidden({
				fieldLabel : "wsdl配置Id",
				name : 'wsdlId'
			});
			var busiWsdl = new Ext.form.TextField({
				fieldLabel : '业务服务wsdl',
				name : 'wsdlFile',
				// fileUpload:true,
				id : 'busiWsdl1',
				disabled : true,
				inputType : 'file',
				blankText : '请上传文件',
				anchor : '90%'
			// msgTarget:validateFileType(this.value,6)
			// autoCreate : {
			// tag : "input",
			// type : "file",
			// size : "20",
			// autocomplete : "off",
			// onChange : "validateFileType(this.value,6);"
			// }
			});
			var protoDoc = new Ext.form.TextField({
				fieldLabel : '协议文档',
				id : 'protoDoc1',
				// fileUpload:true,
				disabled : true,
				name : 'protocolFile',
				inputType : 'file',
				blankText : '请上传文件',
				anchor : '90%'
			// msgTarget:validateFileType(this.value,7)
			// autoCreate : {
			// tag : "input",
			// type : "file",
			// size : "20",
			// autocomplete : "off",
			// onChange : "validateFileType(this.value,7);"
			// }
			});
			var servManDecTxt = createTextFiled("备注", "servManDec",
					"servManDec", true, '80%');
			// *************************编辑***********************************************//
			var editForm = new Ext.form.FormPanel(
					{
						title : "编辑选项",
						width : Ext.getBody().getViewSize().width - 5,
						// height:120,
						id : 'editForm',
						height : Ext.getBody().getViewSize().height * 0.35,
						applyTo : 'editDiv',
						labelWidth : 120,
						fileUpload : true,
						labelAlign : "right",
						frame : true,
						items : [ {
							layout : "column",
							items : [
									{
										columnWidth : 0.3333,
										layout : "form",
										items : servManCodeTxt
									},
									{
										columnWidth : 0.3333,
										layout : "form",
										items : servManNameTxt
									},
									{
										columnWidth : 0.3333,
										layout : "form",
										items : companyNameTxt
									},
									{
										columnWidth : 0.3333,
										layout : "form",
										items : contactNameTxt
									},
									{
										columnWidth : 0.3333,
										layout : "form",
										items : contactPhoneTxt
									},
									{
										columnWidth : 0.3333,
										layout : "form",
										items : email
									},
									{
										columnWidth : 0.3333,
										layout : "form",
										items : imNoTxt
									},
									{
										columnWidth : 0.3333,
										layout : "form",
										items : servManDecTxt
									},
									{
										columnWidth : 0.3333,
										layout : "form",
										items : busiWsdl
									},
									{
										columnWidth : 0.3333,
										layout : "form",
										items : protoDoc
									},
									{
										columnWidth : 0.3333,
										layout : 'form',
										item : servManIdField
									},
									{
										columnWidth : 0.3333,
										layout : 'form',
										item : queueConfId
									},
									{
										columnWidth : 0.3333,
										layout : 'form',
										item : authCodeField
									},
									{
										columnWidth : 0.3333,
										layout : 'form',
										item : wsdlIdField
									},
									{
										html : '<input id = "resetForm" type ="reset" style = "display:none;">',
										border : false
									} ]
						} ],
						buttons : [ {
							text : "添加",
							id : 'addInfo',
							iconCls : 'new',
							width : 20,
							hidden : false,
							handler : add
						}, {
							text : "修改",
							id : 'updateInfo',
							iconCls : 'update',
							width : 20,
							hidden : false,
							handler : update
						}, {
							text : "重置",
							iconCls : 'resume',
							width : 20,
							hidden : false,
							handler : restore
						} ]
					});
			document.getElementById("updateInfo").disabled = true;

			function select() {
				var record = grid.getSelectionModel().getSelected();
				editForm.getForm().loadRecord(record);
				servManIdField.setValue(sm.getSelected().get('servManId'));
				document.getElementById("addInfo").disabled = true;
				document.getElementById("updateInfo").disabled = false;
				document.getElementById('busiWsdl1').disabled = false;
				document.getElementById('protoDoc1').disabled = false;
			}

			function reset() {
				editForm.getForm().reset();
				Ext.getCmp('protoDoc1').setRawValue("");
				Ext.getCmp("protoDoc1").reset();
				document.getElementById("protoDoc1").value = "";
				document.getElementById("addInfo").disabled = false;
				document.getElementById("updateInfo").disabled = true;
				document.getElementById('busiWsdl1').disabled = true;
				document.getElementById('protoDoc1').disabled = true;
			}

			function restore() {
				editForm.getForm().reset();
				var record = grid.getSelectionModel().getSelected();
				if (record == null) {
					// editForm.getForm().loadRecord();
				} else {
					editForm.getForm().loadRecord(record);
				}
				// Ext.getCmp('protoDoc1').setValue("");
				// Ext.getCmp("busiWsdl1").setValue("")
				if ((document.getElementById("addInfo").disabled == false)
						&& (document.getElementById("updateInfo").disabled == true)) {
					document.getElementById('busiWsdl1').disabled = true;
					document.getElementById('protoDoc1').disabled = true;
				} else if ((document.getElementById("addInfo").disabled == true)
						&& (document.getElementById("updateInfo").disabled = false)) {
					document.getElementById('busiWsdl1').disabled = false;
					document.getElementById('protoDoc1').disabled = false;
				}
				// document.getElementById("addInfo").disabled=false;
				// document.getElementById("updateInfo").disabled=true;
			}
			function add() {
				TimeOutDwr.isTimeOut(function(data) {
					if (data) {
						Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
							if (btn == 'ok') {
								var redirect = URL_START
										+ document.location.host + LOG_IN_URL
										+ '?flag=true';
								window.location = redirect;
							}
						});
					} else {
						servManObj.servManId = '';
						servManObj.servManCode = servManCodeTxt.getValue();
						servManObj.servManName = servManNameTxt.getValue();
						servManObj.companyName = companyNameTxt.getValue();
						servManObj.contactName = contactNameTxt.getValue();
						servManObj.contactPhone = contactPhoneTxt.getValue();
						servManObj.email = email.getValue();
						servManObj.imNo = imNoTxt.getValue();
						servManObj.servManDec = servManDecTxt.getValue();

						// Ext.Msg.alert('调试',servManDec.getValue());
						if (!editForm.form.isValid()) {
							if (servManObj.servManCode == ''
									|| servManObj.servManName == '') {
								Ext.Msg.alert('系统提示：', '请输入必填信息');
							} else {
								Ext.MessageBox.alert("系统提示", "输入值非法，请检查!");
							}
							return false;
						}

						Ext.Msg.confirm('提示', '确认要添加该记录么？', function(btn) {
							if (btn == 'yes') {
								ServAffordManDwr.save(servManObj, function(
										saveFlag) {

									if (saveFlag.title == '保存失败:') {
										Ext.Msg.alert(saveFlag.title, blankStr
												+ saveFlag.msg + blankStr);
										return;
									}
									if (saveFlag) {
										reset();
										store.load({
											params : {
												'page.start' : 0,
												'page.pageSize' : pageSize
											}
										});
										Ext.MessageBox.alert("系统提示:", blankStr
												+ saveFlag.msg + blankStr);
										// userTypeStore.load({params:{start:0,
										// limit:pageSize}});
									} else {
										Ext.MessageBox
												.alert("系统提示：", blankStr
														+ "操作可能出现了某些错误,请重试！"
														+ blankStr);
									}
								});
							}
						});

					}
				});

			}
			function update() {
				TimeOutDwr.isTimeOut(function(data) {
					if (data) {
						Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
							if (btn == 'ok') {
								var redirect = URL_START
										+ document.location.host + LOG_IN_URL
										+ '?flag=true';
								window.location = redirect;
							}
						});
					} else {
						if (sm.getSelected() == null) {
							Ext.Msg.alert('系统提示', '请在列表中选中一行，编辑后再进行修改操作！');
							return;
						}
						// alert(sm.getSelected().get('servManId'));
						servManObj.servManId = sm.getSelected()
								.get('servManId')
						servManObj.servManCode = servManCodeTxt.getValue();
						servManObj.servManName = servManNameTxt.getValue();
						servManObj.companyName = companyNameTxt.getValue();
						servManObj.contactName = contactNameTxt.getValue();
						servManObj.contactPhone = contactPhoneTxt.getValue();
						servManObj.email = email.getValue();
						servManObj.imNo = imNoTxt.getValue();
						servManObj.servManDec = servManDecTxt.getValue();
						wsdlConfObj.servManId = sm.getSelected().get(
								'servManId');
						queueConfObj.queueId = sm.getSelected().get('queueId');
						servManObj.authCode = sm.getSelected().get('authCode');
						wsdlConfObj.busiWsdlText = Ext.getCmp('busiWsdl1')
								.getValue();
						wsdlConfObj.wsdlId = '';
						wsdlIdField.setValue(0);
						record = grid.getSelectionModel().getSelected();
						servManName = record.get('servManName');
						servManCode = record.get('servManCode');
						if (!editForm.form.isValid()) {
							if (servManCode.getValue() == ''
									|| servManName.getValue() == '') {
								Ext.Msg.alert('系统提示：', '请输入必填信息');
							} else {
								Ext.MessageBox.alert("系统提示", "输入值非法，请检查!");
							}
							return false;
						}

						ServAffordManDwr.modify(servManObj, servManName,
								servManCode, queueConfObj,
								function(updateFlag) {
									if (updateFlag) {
										// reset();
										store.load({
											params : {
												'page.start' : 0,
												'page.pageSize' : pageSize
											}
										});
										Ext.MessageBox.alert(updateFlag.title,
												blankStr + updateFlag.msg
														+ blankStr);

									} else {
										Ext.MessageBox.alert("系统提示：",
												+"修改操作可能出现了某些错误,请刷新页面后重试！");
									}
								});
						if (editForm.form.isValid()) {
							editForm.form.submit({
								url : 'saveWsdlConf.action',
								params : {
									'servManId' : servManIdField.getValue(),
									'fileName' : protoDoc.getValue(),
									'wsdlName' : busiWsdl.getValue()
								},
								// waitMsg:'Please wait...',
								success : function() {
									// Ext.MessageBox.alert("系统提示:", blankStr +
									// "文件添加成功" + blankStr);
									reset();
									store.load({
										params : {
											'page.start' : 0,
											'page.pageSize' : pageSize
										}
									});
									// document.getElementById("bbar_newServDefine").disabled=true;
									document.getElementById("resetForm")
											.click();
								},
								failure : function() {
									Ext.MessageBox
											.alert("系统提示:", blankStr
													+ "文件添加操作可能出现了某些错误,请重试！"
													+ blankStr);
								}
							})
						}
					}
				});
			}

			function deleteServMan() {

				TimeOutDwr
						.isTimeOut(function(data) {
							if (data) {
								Ext.Msg.alert('提示', '会话超时，请重新登录!', function(
										btn, text) {
									if (btn == 'ok') {
										var redirect = URL_START
												+ document.location.host
												+ LOG_IN_URL + '?flag=true';
										window.location = redirect;
									}
								});
							} else {
								var data = [];
								data = userTypeGrid.getSelectionModel()
										.getSelections();
								if (data.length == 0) {
									Ext.Msg.alert('系统提示', blankStr
											+ '请先选择一条记录！' + blankStr);
									return;
								}
								Ext.Msg
										.confirm(
												'系统提示',
												'是否删除该条记录？',
												function(id) {
													if (id == 'yes') {
														var r = userTypeGrid
																.getSelectionModel()
																.getSelected();
														Ext.MessageBox
																.alert(
																		"系统提示:",
																		blankStr
																				+ "删除成功"
																				+ r);
														return;
														UserTypeConfigDwr
																.remove(
																		r.data,
																		function(
																				data) {
																			if (data) {
																				Ext.MessageBox
																						.alert(
																								"系统提示:",
																								blankStr
																										+ "删除成功"
																										+ blankStr);
																				userTypeStore
																						.load({
																							params : {
																								start : 0,
																								limit : pageSize
																							}
																						});
																			}
																		});
													} else
														return false;
												});
							}
						});
			}

			function remove() {
				TimeOutDwr
						.isTimeOut(function(data) {
							if (data) {
								Ext.Msg.alert('提示', '会话超时，请重新登录!', function(
										btn, text) {
									if (btn == 'ok') {
										var redirect = URL_START
												+ document.location.host
												+ LOG_IN_URL + '?flag=true';
										window.location = redirect;
									}
								});
							} else {
								var servCtrlIdStr = '';
								var servCtrlNameStr = '';
								var count = 0;
								var cell = grid.getSelectionModel().each(
										function(rec) {
											if (rec.get('servManId') > 0) {
												servCtrlIdStr += rec
														.get('servManId')
														+ ',';
												servCtrlNameStr += rec
														.get('servManName')
														+ ',';
												count++;
											}
										});
								// alert(servCtrlIdStr);
								if (count > 0) {
									Ext.Msg
											.confirm(
													"提醒信息",
													"确定要删除这 " + count + " 条信息吗",
													function(btn) {
														if (btn == 'yes') {
															ServAffordManDwr
																	.remove(
																			servCtrlIdStr,
																			servCtrlNameStr,
																			function(
																					data) {
																				Ext.Msg
																						.alert(
																								data.title,
																								data.msg);
																				if (data.optFlag) {
																					store
																							.load({
																								params : {
																									'page.start' : 0,
																									'page.pageSize' : pageSize
																								}
																							});
																					store
																							.reload(); // modified
																					reset();
																				}
																			});
														}
													})
								} else {
									Ext.Msg.alert("提醒信息", "请选中指定记录进行删除操作");
								}
							}
						});
			}

			/**
			 * arrId按钮的功能ID,来源于表menu_func_info arrButton按钮ID，就是界面js设置的按钮IDs
			 */
			var arrId = [ 120801, 120802, 120803 ];
			var arrButton = [ 'addInfo', 'updateInfo', 'Btn_Del' ];
			// checkButton(arrId,arrButton);

		});
function detDetail(servManIdtemp, servManNametemp) {
	var servManId = parseInt(servManIdtemp);
	var servManName = servManNametemp.replace(/~/g, " ");
	var record = [ {
		name : 'servManIpId'
	}, {
		name : 'servManId'
	}, {
		name : 'servManIp'
	}, {
		name : 'delFlag'
	} ];
	servManIpConfRecord = new Ext.data.Record.create({
		name : 'servManIpId',
		mapping : 0
	}, {
		name : 'servManId',
		mapping : 1
	}, {
		name : 'servManIp',
		mapping : 2
	}, {
		name : 'delFlag',
		mapping : 3
	})
	var hp = new Ext.data.HttpProxy({
		url : 'register/servManIpConfAction_list.action'
	});
	var storeAbMsg = new Ext.data.Store({// 配置分组数据集
		proxy : hp,
		pruneModifiedRecords : true,
		reader : new Ext.data.JsonReader({
			totalProperty : "page.totalCount",
			root : 'page.result',
			fields : record
		})
	});
	var gridWidth = Ext.getBody().getViewSize().width * 0.2;
	if (screen.width == 1024 && screen.height == 768) {
		gridWidth = Ext.getBody().getViewSize().width - 22;
	}
	var gridHeight = Ext.getBody().getViewSize().height * 0.5;
	var columnWidth = gridWidth - 8;
	var bbar1 = new Ext.PagingToolbar({// 分页工具栏
		store : storeAbMsg,
		paramNames : {
			start : 'page.start',
			limit : 'page.pageSize'
		},
		pageSize : pageTotal,
		displayInfo : true,
		displayMsg : '第 {0} 条到 {1} 条，一共 {2} 条',
		emptyMsg : "没有记录"
	});
	var IPEditor = new Ext.form.TextField({
		allowBlank : false,
		hideLabel : true,
		validateOnBlur : false,
		validator : this.ip,
		vtype : 'ip',
		vtypeText : this.ipText,
		width : 200,
		id : "ipEditorPanel"
	})
	var deleteStore = new Ext.data.SimpleStore({
		fields : [ 'delFlag', 'delText' ],
		data : [ [ '2', '是' ], [ '1', '否' ] ]
	});
	var comboxDelete = new Ext.form.ComboBox({
		allowBlank : false,
		store : deleteStore,
		hiddenName : 'delFlag',
		valueField : 'delFlag',
		displayField : 'delText',
		editable : true,
		typeAhead : true,
		mode : 'local',
		value : 1,
		triggerAction : 'all',
		selectOnFocus : true
	})
	var columModel = new Ext.grid.ColumnModel([ new Ext.grid.RowNumberer(), {
		header : show_name + 'IP的id',
		dataIndex : 'servManIpId',
		width : 50,
		hidden : true
	}, {
		header : show_name + 'id',
		dataIndex : 'servManId',
		hidden : true,
		width : 150
	}, {
		header : show_name + 'IP',
		dataIndex : 'servManIp',
		editor : new Ext.grid.GridEditor(IPEditor),
		width : 300
	}, {
		header : '删除标志',
		dataIndex : 'delFlag',
		editor : comboxDelete,
		hidden : true,
		width : 100
	} ])
	columModel.defaultSortable = false;
	var gridAbMsg = new Ext.grid.EditorGridPanel({
		store : storeAbMsg,
		cm : columModel,
		width : Ext.getBody().getViewSize().width * 0.3,
		height : Ext.getBody().getViewSize().height * 0.5,
		title : servManName,
		frame : false,
		trackMousOver : true,
		clicksToEdit : 1,
		layout : "fit",
		stripeRows : true,
		loadMask : true,
		viewConfig : {
			forceFit : true
		},
		sm : new Ext.grid.RowSelectionModel({
			singleSelect : true
		}),
		listeners : {
			'afteredit' : aterCellEdit,
			'beforeedit' : beforeCellEdit
		}
	});

	storeAbMsg.baseParams = {
		'servManIpconfDto.servManId' : servManId
	};
	storeAbMsg.load({
		params : {
			'page.start' : 0,
			'page.pageSize' : 10000
		}
	});
	var wdWidth = Ext.getBody().getViewSize().width * 0.35;
	if (screen.width == 1024 && screen.height == 768)
		wdWidth = Ext.getBody().getViewSize().width * 0.35;
	dslMapWin = new Ext.Window({ // 新建一个窗口
		title : "系统IP配置",
		layout : 'fit',
		modal : true,
		width : wdWidth,
		height : Ext.getBody().getViewSize().height * 0.6,
		resizable : false,
		listeners : {
			"minimize" : function() {
				this.hide();
			},
			"close" : function() {
				this.close();
			},
			"beforeclose" : function() {
				var m = storeAbMsg.modified.slice(0);
				if (m.length > 0) {
					Ext.Msg.confirm("提示", "有记录增加或修改，是否保存?" + blankStr,
							function(btn) {
								if (btn == "yes") {
									saveIPConfig();
									dslMapWin.hide();
								} else {
									dslMapWin.hide();
								}
							})
					return false;
				}
			}
		},
		items : [ {
			layout : "column",
			items : [ {
				columnWidth : 1.0,
				layout : "fit",
				items : gridAbMsg
			} ]
		} ],
		buttonAlign : 'center',
		buttons : [ {
			text : "新增",
			id : 'addNewInfo',
			iconCls : 'new',
			width : 20,
			hidden : false,
			handler : addNewIp
		}, {
			text : "保存",
			id : 'saveInfo',
			iconCls : 'save',
			width : 20,
			hidden : false,
			handler : saveIPConfig
		}, {
			text : "删除",
			iconCls : 'delete',
			width : 20,
			hidden : false,
			handler : deleteIPconfig
		} ]
	});
	function close() {
		dslMapWin.close();
	}
	function aterCellEdit(e) {
		if (e.column == 3) {
			var count = gridAbMsg.getStore().getCount();
			for (i = 0; i < count; i++) {
				if (e.row == i)
					continue;
				var record = gridAbMsg.getStore().getAt(i);
				if (record.get('servManIp') == e.record.get('servManIp')) {
					Ext.MessageBox.alert('系统提示', blankStr + 'IP配置重复!'
							+ blankStr, function() {
						e.record.set('servManIp', servManIP);
						e.record.dirty = false;
						e.record.commit();
						gridAbMsg.getSelectionModel().selectRow(e.row, true);
					});
					return;
				}
			}
		}
	}
	function beforeCellEdit(e) {
		var record = e.record;
		servManIP = record.get('servManIp');
	}
	function addNewIp() {
		var n = storeAbMsg.getCount();
		var initValue = {
			servManIpId : '',
			servManId : servManId,
			servManIp : '',
			delFlag : '1'
		};
		var r = new servManIpConfRecord(initValue);
		gridAbMsg.stopEditing();
		storeAbMsg.insert(n, r);
		gridAbMsg.startEditing(n, 3);
		r.dirty = false;
		r.modified = initValue;
		if (storeAbMsg.modified.indexOf(r) == -1)
			storeAbMsg.modified.push(r);
	}
	function saveIPConfig() {
		var m = storeAbMsg.modified.slice(0);
		if (m.length == 0) {
			Ext.Msg.alert("提示", blankStr + "没有记录被修改或增加!" + blankStr)
			return;
		}
		var servManIPConfigArray = [];
		Ext.each(m, function(item) {
			var servManIPconfig = {
				servManIpId : '',
				servManId : '',
				servManIp : '',
				delFlag : ''
			};
			servManIPconfig.servManIpId = item.get("servManIpId");
			servManIPconfig.servManId = item.get("servManId");
			servManIPconfig.servManIp = item.get("servManIp");
			servManIPconfig.delFlag = item.get("delFlag");
			if (servManIPconfig.servManIp == ""
					|| servManIPconfig.servManIp == null) {
				Ext.Msg.alert('信息提示', '有IP配置为空，请重新配置！', function(button) {
					if (button == 'ok') {
						return;
					}
				});
				return;
			}
			servManIPConfigArray.push(servManIPconfig);
		});
		if (servManIPConfigArray.length == 0) {
			Ext.Msg.alert("信息提示", blankStr + "IP为空或格式不正确，请重新配置!" + blankStr)
			return;
		}
		Ext.Ajax.request({
			url : 'register/servManIpConfAction_saveOrupdate.action',
			params : {
				saveServManIPConfigtypeJson : encodeURIComponent(Ext
						.encode(servManIPConfigArray))
			},
			success : function(response, options) {
				Ext.Msg.alert('消息', blankStr + '数据已经成功地保存了！' + blankStr,
						function() {
							storeAbMsg.baseParams = {
								'servManIpconfDto.servManId' : servManId
							}
							storeAbMsg.load({
								params : {
									'page.start' : 0,
									'page.pageSize' : 10000
								}
							});
						});
			},
			failure : function(response) {
				Ext.Msg.alert('错误', '数据保存失败！');
			}
		});

	}
	function deleteIPconfig() {
		var smTemp = gridAbMsg.getSelectionModel();
		var recordTemp = smTemp.getSelected();
		if (recordTemp == null) {
			Ext.Msg.alert("提示", blankStr + "请选择一行进行删除!" + blankStr);
			return;
		}
		Ext.Msg
				.confirm(
						"提示",
						"确认要删除该条记录吗?" + blankStr,
						function(btn) {
							if (btn == "yes") {
								var servManIPConfigArray = [];
								var servManIPconfig = {
									servManIpId : '',
									servManId : '',
									servManIp : '',
									delFlag : ''
								};
								servManIPconfig.servManIpId = recordTemp
										.get("servManIpId");
								servManIPconfig.servManId = recordTemp
										.get("servManId");
								servManIPconfig.servManIp = recordTemp
										.get("servManIp");
								servManIPconfig.delFlag = 2;
								servManIPConfigArray.push(servManIPconfig);
								Ext.Ajax
										.request({
											url : 'register/servManIpConfAction_saveOrupdate.action',
											params : {
												saveServManIPConfigtypeJson : encodeURIComponent(Ext
														.encode(servManIPConfigArray))
											},
											success : function(response,
													options) {
												Ext.Msg
														.alert(
																'消息',
																blankStr
																		+ '数据已经成功地删除了！'
																		+ blankStr,
																function() {
																	storeAbMsg.baseParams = {
																		'servManIpconfDto.servManId' : servManId
																	}
																	storeAbMsg
																			.load({
																				params : {
																					'page.start' : 0,
																					'page.pageSize' : 10000
																				}
																			});
																});
											},
											failure : function(response) {
												Ext.Msg.alert('错误', blankStr
														+ '数据删除失败！' + blankStr);
											}
										});
							}
						})
	}
	dslMapWin.show();
}
var gridWsdlConf;
function detDetailWsdl(servManId) {
	var servManIdValue = servManId;
	var hp = new Ext.data.HttpProxy({
		url : 'register/wsdlConfAction_findWsdlConf.action'
	});
	var storeConf = new Ext.data.Store({// 配置分组数据集
		proxy : hp,
		reader : new Ext.data.JsonReader({
			totalProperty : "page.totalCount",
			root : 'page.result',
			fields : [ 'wsdlId', 'wsdlName', 'proxyServAddr', 'busiWsdlText' ]
		})
	});
	var gridWidth = Ext.getBody().getViewSize().width - 400;
	if (screen.width == 1024 && screen.height == 768) {
		gridWidth = Ext.getBody().getViewSize().width - 22;
	}
	var gridHeight = Ext.getBody().getViewSize().height - 200;
	var columnWidth = gridWidth - 8;
	var sm1 = new Ext.grid.CheckboxSelectionModel();
	var bbar2 = new Ext.PagingToolbar({
		store : storeConf,
		paramNames : {
			start : 'page.start',
			limit : 'page.pageSize'
		},
		pageSize : pageTotal,
		displayInfo : true,
		displayMsg : '第 {0} 条到 {1} 条，一共 {2} 条',
		emptyMsg : "没有记录"
	});

	gridWsdlConf = new Ext.grid.GridPanel({
		title : '业务wsdl列表',
		width : gridWidth,// Ext.getBody().getViewSize().width
		height : gridHeight,// Ext.getBody().getViewSize().height
		frame : true,
		stripeRows : true,
		bbar : bbar2,
		sm : sm1,// 设置复选框选择模式
		store : storeConf,
		viewConfig : {
			forceFit : true
		},
		loadMask : true,
		columns : [// 配置表格列
		sm1, // 复选框选择模式中的checkbox组件将会显示在该列
		new Ext.grid.RowNumberer(), {
			header : "wsdl名称",
			width : columnWidth / 4,
			sortable : true,
			dataIndex : 'wsdlName',
			name : 'wsdlName'
		}, {
			header : "业务服务地址",
			width : columnWidth / 9,
			sortable : true,
			hidden : false,
			renderer : updateBusiWsdl
		}, {
			header : "业务服务内容",
			width : columnWidth / 9,
			sortable : true,
			hidden : true,
			dataIndex : 'busiWsdlText',
			name : 'busiWsdlText'
		}, {
			header : "业务服务wsdl",
			width : columnWidth / 9,
			sortable : true,
			dataIndex : 'wsdlId',
			renderer : getDetailBusiWsdl
		} ]
	});
	storeConf.baseParams = {
		'wsdlConfDto.servManId' : servManIdValue
	};
	storeConf.load({
		params : {
			'page.start' : 0,
			'page.pageSize' : pageTotal
		}
	});
	var width = Ext.getBody().getViewSize().width - 700;
	var height = Ext.getBody().getViewSize().height - 150;
	if (screen.width == 1024 && screen.height == 768) {
		width = Ext.getBody().getViewSize().width - 500;
		height = Ext.getBody().getViewSize().height - 150;
	}
	dslMapWin1 = new Ext.Window({ // 新建一个窗口
		title : "业务wsdl列表",
		layout : 'fit',
		modal : true, // 模式窗口
		width : width,
		height : Ext.getBody().getViewSize().height - 160,// height ,
		// minimizable : false,
		// maximizable : false,
		resizable : false,
		// maximizable : true,
		// maximized :true,
		// height : height ,
		// resizable:false,
		// minimizable : true,
		// maximizable : true,
		plain : true,
		listeners : {
			"minimize" : function() {
				this.hide();
			},
			"close" : function() {
				this.close();
			}
		},
		items : [ {
			layout : "column",
			items : [ {
				columnWidth : 1.0,
				layout : "fit",
				items : gridWsdlConf
			} ]
		} ]
	});
	dslMapWin1.show();
}
function detDetailPro(servManId) {
	var servManIdValue = servManId;
	var hp = new Ext.data.HttpProxy({
		url : 'register/protocolInfoAction_findProtocolInfo.action'
	});
	var storePro = new Ext.data.Store({// 配置分组数据集
		proxy : hp,
		reader : new Ext.data.JsonReader({
			totalProperty : "page.totalCount",
			root : 'page.result',
			fields : [ 'protocolId', 'protocolName', 'filePath', 'servManId' ]
		})
	});
	var gridWidth = Ext.getBody().getViewSize().width - 200;
	if (screen.width == 1024 && screen.height == 768) {
		gridWidth = Ext.getBody().getViewSize().width - 22;
	}
	var gridHeight = Ext.getBody().getViewSize().height - 150;
	var columnWidth = gridWidth - 8;
	var sm1 = new Ext.grid.CheckboxSelectionModel();
	var bbar1 = new Ext.PagingToolbar({
		store : storePro,
		paramNames : {
			start : 'page.start',
			limit : 'page.pageSize'
		},
		pageSize : pageTotal,
		displayInfo : true,
		displayMsg : '第 {0} 条到 {1} 条，一共 {2} 条',
		emptyMsg : "没有记录"
	});
	var gridPro = new Ext.grid.GridPanel({
		title : '协议信息列表',
		width : gridWidth,// Ext.getBody().getViewSize().width
		height : gridHeight,// Ext.getBody().getViewSize().height
		frame : true,
		stripeRows : true,
		bbar : bbar1,
		sm : sm1,// 设置复选框选择模式
		store : storePro,
		loadMask : true,
		viewConfig : {
			forceFit : true
		},
		columns : [// 配置表格列
		sm1, // 复选框选择模式中的checkbox组件将会显示在该列
		new Ext.grid.RowNumberer(), {
			header : "协议名称",
			width : columnWidth / 9,
			sortable : true,
			dataIndex : 'protocolName',
			name : 'protocolName'
		}, {
			header : "文件路径",
			width : columnWidth / 4,
			sortable : true,
			dataIndex : 'filePath',
			name : 'filePath'
		}, {
			header : "文件查看",
			width : columnWidth / 9,
			sortable : true,
			dataIndex : 'filePath',
			name : 'servName',
			renderer : getDetilProtocol
		} ]
	});
	storePro.baseParams = {
		'protocolInfoDto.servManId' : servManIdValue
	};
	storePro.load({
		params : {
			'page.start' : 0,
			'page.pageSize' : pageTotal
		}
	});
	var width = Ext.getBody().getViewSize().width - 600;
	// var height = Ext.getBody().getViewSize().height - 100;
	var height = Ext.getBody().getViewSize().height - 115;
	if (screen.width == 1024 && screen.height == 768) {
		width = Ext.getBody().getViewSize().width - 400;
	}
	dslMapWin = new Ext.Window({ // 新建一个窗口
		title : "协议信息查看",
		layout : 'fit',
		modal : true, // 模式窗口
		width : width,
		height : height,
		// minimizable : false,
		// maximizable : false,
		resizable : false,
		// minimizable : true,
		// maximizable : true,
		plain : true,
		listeners : {
			"minimize" : function() {
				this.hide();
			},
			"close" : function() {
				this.close();
			}
		},
		items : [ {
			layout : "column",
			items : [ {
				columnWidth : 1.0,
				layout : "fit",
				items : gridPro
			} ]
		} ]
	});
	dslMapWin.show();
}
function getDetailBusiWsdl(val, params, record) {
	return '<a href=javascript:getBusiWsdlText()>' + '<center>查看</center>'
			+ '</a>';
}
function getBusiWsdlText() {
	var record = gridWsdlConf.getSelectionModel().getSelected();
	var BusiWsdlText = new Ext.form.TextArea({
		hideLabel : true,
		name : "busiWsdlText",
		labelSeparator : '',
		id : "busiWsdlText",
		width : Ext.getBody().getViewSize().width * 0.69,
		readOnly : true,
		height : Ext.getBody().getViewSize().height * 0.82
	});

	var viewWin = new Ext.Window({ // 新建一个窗口
		title : "业务wsdl查看",
		layout : 'fit',
		modal : true, // 模式窗口
		width : Ext.getBody().getViewSize().width * 0.705,
		height : Ext.getBody().getViewSize().height * 0.9,
		// minimizable : false,
		// maximizable : false,
		resizable : false,
		plain : true,
		items : [ {// layout:"form",
			items : BusiWsdlText
		} ]
	});
	BusiWsdlText.setValue(record.get('busiWsdlText'));
	viewWin.show();
}
/**
 * 验证文件类型是否匹配
 * 
 * @param {}
 *            fileName
 * @param {}
 *            index
 * @return {Boolean}
 */
function validateFileType(fileName, index) {
	var form = Ext.getCmp("editForm").getForm();
	var pos = fileName.lastIndexOf(".");
	var fileType = fileName.substring(pos, fileName.length) // 此处文件后缀名也可用数组方式获得str.split(".")
	if (index == 8 && fileType.toLowerCase() != ".txt") {
		Ext.MessageBox.alert("提示", "您上传的文件类型不符合要求，必须为.txt类型");
		var file = document.getElementById(form.getComponent(index).id); // 获取组件id，清空选择的文件，仅ie适用
		file.outerHTML = file.outerHTML
		return false;
	} else if (index == 6 && fileType.toLowerCase() != ".wsdl") {
		Ext.MessageBox.alert("提示", "您上传的文件类型不符合要求，必须为.wsdl", function(btn) {
			if (btn == 'ok') {
				var file = document.getElementById('busiWsdl1');
				file.outerHTML = file.outerHTML
				return false;
			}
		});
	} else if (index == 7 && fileType.toLowerCase() != ".wsdl"
			&& fileType.toLowerCase() != ".doc"
			&& fileType.toLowerCase() != ".txt") {
		Ext.MessageBox.alert("提示", "您上传的文件类型不符合要求，必须为.wsdl或.doc或.txt",
				function(btn) {
					if (btn == 'ok') {
						var file = document.getElementById('protoDoc1');
						file.outerHTML = file.outerHTML
					}
				});
		return false;
	} else {
		return true;
	}
}
function getDetilProtocol(val) {
	var filePath = val.replace(/ /g, "~");
	return '<a href=javascript:detDetailProDownload("' + filePath + '")>'
			+ '<center>下载</center>' + '</a>';
}
function detDetailProDownload(val) {
	var filePath = val.replace(/~/g, " ");
	// window.location.href="serviceSearch/download.action?name=协议文档.doc&path="+encodeURIComponent(filePath)
	downLoadFile(filePath);
}
function updateBusiWsdl(val, params, record) {
	return '<a href=javascript:getupdateBusiWsdl()>' + '<center>修改</center>'
			+ '</a>';
}
var storeConfModify, servPrivateUrl;
function getupdateBusiWsdl() {
	var record = gridWsdlConf.getSelectionModel().getSelected();
	var hp = new Ext.data.HttpProxy({
		url : 'register/wsdlConfAction_findWsdlConf.action'
	});
	storeConfModify = new Ext.data.Store({// 配置分组数据集
		proxy : hp,
		reader : new Ext.data.JsonReader({
			totalProperty : "page.totalCount",
			root : 'page.result',
			fields : [ 'wsdlId', 'wsdlName', 'proxyServAddr', 'busiWsdlText',
					'servManId', 'servPrivateUrl', 'proxyWsdlText' ]
		}),
		autoLoad : {
			params : {
				'wsdlConfDto.wsdlId' : record.get("wsdlId"),
				'page.start' : 0,
				'page.pageSize' : pageTotal
			}
		},
		listeners : {
			load : function(store) {
				servPrivateUrl = store.getAt(0).get("servPrivateUrl"); /* 获得代理地址 */
			}
		}
	});
	var gridWidth = Ext.getBody().getViewSize().width - 400;
	if (screen.width == 1024 && screen.height == 768) {
		gridWidth = Ext.getBody().getViewSize().width - 22;
	}
	var gridHeight = Ext.getBody().getViewSize().height * 0.62;
	var columnWidth = gridWidth - 8;
	var sm1 = new Ext.grid.CheckboxSelectionModel();
	var bbar2 = new Ext.PagingToolbar({// 分页工具栏
		store : storeConfModify,
		paramNames : {
			start : 'page.start',
			limit : 'page.pageSize'
		},
		pageSize : pageTotal,
		displayInfo : true,
		displayMsg : '第 {0} 条到 {1} 条，一共 {2} 条',
		emptyMsg : "没有记录"
	});
	colum = new Ext.grid.ColumnModel([ sm1, new Ext.grid.RowNumberer(), {
		header : "wsdl名称",
		width : columnWidth / 7,
		sortable : true,
		dataIndex : 'wsdlName',
		name : 'wsdlName'
	}, {
		header : "业务服务地址",
		width : columnWidth / 4,
		sortable : true,
		hidden : false,
		editor : new Ext.grid.GridEditor(new Ext.form.TextField({
			allowBlank : false
		})),
		dataIndex : 'servPrivateUrl',
		name : 'servPrivateUrl'
	} ]);
	gridWfModify = new Ext.grid.EditorGridPanel({
		title : 'wsdl地址',
		width : gridWidth,
		height : gridHeight,
		frame : true,
		stripeRows : true,
		trackMousOver : true,
		bbar : bbar2,
		clicksToEdit : 1,
		loadMask : true,
		cm : colum,
		sm : sm1,
		store : storeConfModify,
		viewConfig : {
			forceFit : true
		}
	});

	var width = Ext.getBody().getViewSize().width * 0.5;
	var height = Ext.getBody().getViewSize().height * 0.75;
	if (screen.width == 1024 && screen.height == 768) {
		width = Ext.getBody().getViewSize().width * 0.5;
		height = Ext.getBody().getViewSize().height * 0.75;
	}
	dslMapWin2 = new Ext.Window({
		title : "wsdl地址修改",
		layout : 'fit',
		modal : true,
		width : width,
		height : Ext.getBody().getViewSize().height * 0.75,
		resizable : false,
		plain : true,
		buttonAlign : "center",
		listeners : {
			"minimize" : function() {
				this.hide();
			},
			"close" : function() {
				this.close();
			}
		},
		items : [ {
			layout : "column",
			items : [ {
				columnWidth : 1.0,
				layout : "fit",
				items : gridWfModify
			} ]
		} ],
		buttons : [ {
			text : "保存",
			id : 'saveInfo',
			iconCls : 'save',
			width : 20,
			hidden : false,
			handler : saveWsdlConfig
		}, {
			text : "返回",
			iconCls : 'close',
			width : 20,
			hidden : false,
			handler : close
		} ]
	});
	dslMapWin2.show();
}
function close() {
	this.ownerCt.hide();
}
function saveWsdlConfig() {
	var m = storeConfModify.modified.slice(0), wsdlId;
	if (m.length == 0) {
		Ext.Msg.alert("提示", blankStr + "没有记录被修改!" + blankStr);
		return;
	}
	var wsdlConfigArray = [];
	Ext.each(m, function(item) {
		var wsdlconfig = {
			wsdlId : '',
			busiServAddr : '',
			servManId : '',
			proxyServAddr : '',
			busiWsdlText : '',
			proxyWsdlText : '',
			wsdlName : ''
		};
		wsdlconfig.wsdlId = item.get("wsdlId");
		wsdlId = item.get("wsdlId");
		wsdlconfig.wsdlName = item.get("wsdlName");
		wsdlconfig.servManId = item.get("servManId");
		wsdlconfig.busiServAddr = item.get("servPrivateUrl");
		wsdlconfig.proxyServAddr = item.get("proxyServAddr");
		wsdlconfig.busiWsdlText = item.get("busiWsdlText");
		wsdlconfig.proxyWsdlText = item.get("proxyWsdlText");
		if (wsdlconfig.busiServAddr == "" || wsdlconfig.busiServAddr == null) {
			Ext.Msg.alert('信息提示', '有wsdl配置为空，请重新配置！', function(button) {
				if (button == 'ok') {
					return;
				}
			});
			return;
		}
		wsdlConfigArray.push(wsdlconfig);
	}, this);
	if (wsdlConfigArray.length == 0) {
		Ext.Msg.alert("信息提示", "wsdl为空或格式不正确，请重新配置!")
		return;
	}
	Ext.Ajax.request({
		url : 'register/wsdlConfAction_modify.action',
		params : {
			saveWsdlConfigtypeJson : encodeURIComponent(Ext
					.encode(wsdlConfigArray)),
			servPrivateUrl : servPrivateUrl
		},
		success : function(response, options) {
			Ext.Msg.alert('消息', '数据已经成功地保存了！', function() {
				storeConfModify.rejectChanges();
				storeConfModify.baseParams = {
					'wsdlConfDto.wsdlId' : wsdlId
				};
				storeConfModify.load({
					params : {
						"page.start" : 0,
						"page.pageSize" : pageSize
					},
					callback : function() {
						servPrivateUrl = storeConfModify.getAt(0).get(
								"servPrivateUrl");
						wsdlConfigArray.pop();
						wsdlConfigArray = null;
					}
				});
			});
		},
		failure : function(response) {
			Ext.Msg.alert('错误', '数据保存失败！');
		}
	});

}