/**
* 服务编排----业务类型树
* @author lisen
*/

Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif';  //本地图形化
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';     //需要补充的空格
var selNode;
var menuTree;
var form1 ;
var win=null;
 var wfProcessDefineGrid ;
 var tabPanel ;
/***********************OrderMenuTree定制菜单树*****************************************/
MenuTree = Ext.extend(Ext.tree.TreePanel, {
    
    rightMenu: null,
    constructor: function() {
        menuTree = this ;
        this.rightMenu = new Ext.menu.Menu({
            items: [
                { text: '增加类型', handler: this.addSubMenuClick, scope:this},
                { text: '修改类型', handler: this.modSubMenuClick, scope:this},
                { text: '删除类型', handler: this.deleteMenuClick, scope:this},
                '-',
                { text: '增加服务编排', handler: this.addProcess, scope:this},
                { text: '修改服务编排', handler: this.modProcess, scope:this},
                { text: '删除服务编排', handler: this.deleteProcess, scope:this},
                '-',
                { text: '刷新', handler: this.refreshClick, scope: this}
            ]
        });
        
        MenuTree.superclass.constructor.call(this, {
            renderTo: 'busiType_tree',
            title: '业务类型',
            autoScroll:true, 
            enableDD:false,//是否支持拖拽效果
            containerScroll: true,//是否支持滚动条
            width: 250,
            border: true,
            frame: false,
            height:Ext.getBody().getViewSize().height-25,
            rootVisible:true,//是否显示跟节点
            baseCls: 'x-panel',
            margins:'0 0 0 0',
            loader:new Ext.tree.TreeLoader({  
                dataUrl: "wfBusiProcess_getTree.action"
            }),
            root: new Ext.tree.AsyncTreeNode({
                id: 'TYPE_0',
                text: '业务类型',
                draggable:false
            }),
            listeners: {
            	'click': {fn: this.onLeftClick, scope: this},
                'contextmenu': {fn: this.onRightMenuClick, scope: this}
            }
        });
    },
    onLeftClick: function(node, e) {       //点击
    	selNode = node;
    	if(selNode.id.indexOf("PROC_")>-1)
    	{
    		//列表显示服务编排下面的版本信息
    		tabPanel.setActiveTab(0);
			var nodeId = selNode.id.substring(5); 
			wfProcessDefineGrid.store.load({params: {processId:nodeId}});
    	}
    },
    onRightMenuClick: function(node, e) {//右键点击
    	this.fireEvent('click', node, e);      
    	
    	//如果是页面节点时
    	var addBusitypeFuncItem = this.rightMenu.items.itemAt(0);
    	var modBusitypeFuncItem = this.rightMenu.items.itemAt(1);
    	var delBusitypeFuncItem = this.rightMenu.items.itemAt(2);
    	var sepLine = this.rightMenu.items.itemAt(3) ;
    	var addProcessFuncItem = this.rightMenu.items.itemAt(4);
    	var modProcessFuncItem = this.rightMenu.items.itemAt(5);
    	var delProcessFuncItem = this.rightMenu.items.itemAt(6);
    	
    	var isLeaf = selNode.attributes.leaf ;
    	var idStr = selNode.id ;
    	var firstChildNode = selNode.firstChild ;
    	
    	if(node.id=='TYPE_0'){
    		addBusitypeFuncItem.show();
    		sepLine.hide() ;
    		modBusitypeFuncItem.hide();
    		delBusitypeFuncItem.hide();
    		addProcessFuncItem.hide();
    		modProcessFuncItem.hide();
    		delProcessFuncItem.hide();
    	}else if(isLeaf===undefined){ //根节点
    		addBusitypeFuncItem.show();
    		modBusitypeFuncItem.show();
    		delBusitypeFuncItem.show();
    		sepLine.hide() ;
    		addProcessFuncItem.hide();
    		modProcessFuncItem.hide();
    		delProcessFuncItem.hide();
    	}else if(isLeaf==false && firstChildNode!=null && firstChildNode.id.indexOf("PROC_")!=-1){//本身是叶子节点，但是底下包含服务编排子节点
    		addBusitypeFuncItem.hide();
    		modBusitypeFuncItem.show();
    		delBusitypeFuncItem.hide();
    		addProcessFuncItem.show();
    		modProcessFuncItem.hide();
    		delProcessFuncItem.hide();
    	}else if(isLeaf==false && idStr.indexOf("TYPE_")!=-1){ //大类型节点，非叶子节点
    		addBusitypeFuncItem.show();
    		modBusitypeFuncItem.show();
    		delBusitypeFuncItem.show();
    		sepLine.hide() ;
    		addProcessFuncItem.hide();
    		modProcessFuncItem.hide();
    		delProcessFuncItem.hide();
    	}else if(isLeaf==true && idStr.indexOf("TYPE_")!=-1){//叶子节点
    		//如果是孩子节点，右边显示服务编排列表
    		addBusitypeFuncItem.hide();
    		modBusitypeFuncItem.show();
    		delBusitypeFuncItem.show();
    		sepLine.hide() ;
    		addProcessFuncItem.show();
    		modProcessFuncItem.hide();
    		delProcessFuncItem.hide();
    	}else if(idStr.indexOf("PROC_")!=-1){
    		addBusitypeFuncItem.hide();
    		modBusitypeFuncItem.hide();
    		delBusitypeFuncItem.hide();
    		sepLine.hide() ;
    		addProcessFuncItem.hide();
    		modProcessFuncItem.show();
    		delProcessFuncItem.show();
    	}
    	
    	e.preventDefault();
        this.rightMenu.showAt(e.getXY());//取得鼠标点击坐标，展示菜单
    },
    modSubMenuClick: function() {      
    	//添加
        win=new InsertMenuWindow();
        WfBusiProcessDwr.getBusitype(selNode.id.substring(5), function(data){
   		    if(data) {
   		    	var obj = Ext.decode(data) ;
   		    	var busitypeid =obj[0].busitypeid;
				var isleaf=obj[0].isleaf;
				var name=obj[0].name;
				var parentid=obj[0].parentid;
				var thesort=obj[0].thesort;
				var code=obj[0].code;
				
				if(isleaf==0){
        			win.menuForm.yesIsLeaf.setValue(false) ;
        			win.menuForm.noIsLeaf.setValue(true) ;
        		}else{
        			win.menuForm.yesIsLeaf.setValue(true) ;
        			win.menuForm.noIsLeaf.setValue(false) ;
        		}
   		    	win.menuForm.parentId.setValue(parentid) ;
        		win.menuForm.busitypeid.setValue(busitypeid) ;
        		win.menuForm.code.setValue(code) ;
        		win.menuForm.thesort.setValue(thesort) ;
        		win.menuForm.nameTf.setValue(name) ;
        		win.menuForm.parentTf.setValue(selNode.parentNode.text) ;
   		    } else {
   		    	Ext.MessageBox.alert("系统提示：", "根据菜单id 获取业务类型信息时出错,请重试！");
   		    }
   		});
        win.show() ;
    }, 
    addSubMenuClick: function() {      
    	//添加
        win=new InsertMenuWindow();
        win.menuForm.parentId.setValue(selNode.id.substring(5)) ;
        win.menuForm.busitypeid.setValue(0) ;
        win.menuForm.parentTf.setValue(selNode.text) ;
        win.show() ;
    },   
    deleteMenuClick: function() {           //删除
        var tree = this;        
    	if(selNode.childNodes && selNode.childNodes.length > 0) {
    		Ext.MessageBox.alert("系统提示：", "有子节点的节点不能删除!");
    	} else {
    		 Ext.MessageBox.confirm('系统提示:',"你确定要删除所选的菜单功能吗？",function(btn){
                if(btn == 'yes') {
                	WfBusiProcessDwr.delById(selNode.id.substring(5), function(data){
                        if(data) {
                            Ext.MessageBox.alert("系统提示：", blankStr + "删除成功！" + blankStr);
                            menuTree.root.reload();
                        } else {
                            Ext.MessageBox.alert("系统提示：", blankStr + "删除出现错误！" + blankStr);
                        }
                    });
                }
    		 });
    	}
    },
    modProcess: function() {      
    	 //添加  窗口、表单等代码在busiProcess.js文件中定义
       	processWin=new ProcessWindow();
        WfBusiProcessDwr.getBusiprocess(selNode.id.substring(5), function(data){
   		    if(data) {
   		    	var obj = Ext.decode(data) ;
   		    	var busiprocessid =obj[0].busiprocessid;
				var flowname=obj[0].flowname;
				var descn=obj[0].descn;
				var busitypeid=obj[0].busitypeid ;
   		    	processWin.processForm.busiprocessid.setValue(busiprocessid) ;
        		processWin.processForm.flowname.setValue(flowname) ;
        		processWin.processForm.descn.setValue(descn) ;
        		processWin.processForm.busitypeid.setValue(busitypeid) ;
   		    } else {
   		    	Ext.MessageBox.alert("系统提示：", "根据菜单id 获取信息时出错,请重试！");
   		    }
   		});
        processWin.show() ;
    }, 
    addProcess: function() {  
        //添加  窗口、表单等代码在busiProcess.js文件中定义
        processWin=new ProcessWindow();
        processWin.processForm.busiprocessid.setValue(0) ;
        processWin.processForm.busitypeid.setValue(selNode.id.substring(5)) ;
        processWin.show() ;
    },   
    deleteProcess: function() {           //删除
        var tree = this;        
        var pNode = selNode.parentNode ;
    	if(selNode.childNodes && selNode.childNodes.length > 0) {
    		Ext.MessageBox.alert("系统提示：", "有子节点的节点不能删除!");
    	} else {
    		 Ext.MessageBox.confirm('系统提示:',"你确定要删除所选的菜单功能吗？",function(btn){
                if(btn == 'yes') {
                	WfBusiProcessDwr.delProcessById(selNode.id.substring(5), function(data){
                        if(data) {
                            Ext.MessageBox.alert("系统提示：", blankStr + "删除成功！" + blankStr);
                            menuTree.refreshNode(pNode);
                           // menuTree.root.reload();
                        } else {
                            Ext.MessageBox.alert("系统提示：", blankStr + "删除出现错误！" + blankStr);
                        }
                    });
                }
    		 });
    	}
    },
    refreshClick: function() {
    	this.getLoader().load(selNode, function() {
            selNode.expand();
        });
    },
    getMenuIdByNodeId: function(nodeId) {   //根据节点id获得menuId
    	return nodeId;
    },
    getSelectedNode : function() {          //获得树上被选择的节点
    	if(selNode) {
    		return selNode;
    	} else {
    	    Ext.MessageBox.alert("系统提示：", blankStr + "请选择菜单树上节点" + blankStr);
    	    return;
    	}
    },
    refreshNode: function(node) {
        this.getLoader().load(node, function() {
            node.expand();
        });
    }
});

/**************************************菜单添加修改form**************************************/
MenuForm = Ext.extend(Ext.ux.Form, {
    
    parentTf:null,
    busitypeid:null,
    parentId:null,
    nameTf: null,             //"类型名称" 文本框
    code:  null,              //"类型编码" 文本框
    thesort: null,                //"url" 文本框
    leafPanel : null, // 服务探针面板
    yesIsLeaf: null,       //"是" 单选按钮
    noIsLeaf: null,       //"否" 单选按钮
    
    constructor: function() {
        this.parentTf = this.createTextFiled("父类型",'pname','80%','该选项为必填项,请输入内容...');
        this.parentTf.disable();
        this.parentId = this.createHidden("父类型ID","stFlowBusitype.parentid") ;
        this.busitypeid = this.createHidden("ID","stFlowBusitype.busitypeid") ;
        this.nameTf = this.createTextFiled("类型名称", 'stFlowBusitype.name', '80%',"类型名称不能为空！",null,15,"类型名称最大长度为15");
        this.code = this.createTextFiled("类型编码", 'stFlowBusitype.code', '80%',"类型编码不能为空！",null,15,"类型编码最大长度为15");
        this.thesort = this.createNumberField("排序",'stFlowBusitype.thesort','80%',"排序不能为空！",null,15,"");
        this.yesIsLeaf = this.createRadio("是",'stFlowBusitype.isleaf',true,1);
        this.noIsLeaf = this.createRadio("否",'stFlowBusitype.isleaf',false,0);
        this.leafPanel = new Ext.Panel({
					fieldLabel : "叶子节点",
					xtype : "panel",
					labelWidth : 1,
					layout : "column",
					isFormField : true,
					labelAlign : "left",
					items : [{
								columnWidth : .3,
								layout : "form",
								labelAlign : "right",
								items : this.yesIsLeaf
							}, {
								columnWidth : .3,
								layout : "form",
								labelAlign : "right",
								items : this.noIsLeaf
							}]
				});
				
        MenuForm.superclass.constructor.call(this, {
        	title: '类型配置',
            width: 330,
            height: 230,
            labelWidth: 70,
            frame: true,
            autoDestroy: false ,
            waitMsgTarget : true,
            bodyStyle:"padding: 5px 5px 0",
            items:[this.leafPanel,this.parentTf,this.parentId,this.busitypeid,this.nameTf,this.code,this.thesort],
            buttons: [
               {text: '保存', id: 'addBtn', iconCls: 'new',width: 20, hidden: false, handler: this.addFormClick, scope: this},
               {text: '重置', id: 'resetBtn',width: 20, iconCls:'refresh',  handler: this.resetFormClick, scope: this}
            ]
        })
     },
     addFormClick: function() {     //添加
    	if(this.getForm().isValid()) {
        	this.getForm().submit( {
                url : 'wfBusiProcess_saveOrUpdate.action',
                success : function(from, action) {
                    Ext.Msg.alert('保存成功', blankStr + '保存成功！'+blankStr );
                   // menuTree.refreshNode(selNode) ;
                    menuTree.root.reload() ;
                },
                failure : function(form, action) {
                    Ext.Msg.alert('保存失败', blankStr + '保存失败！'+blankStr );
                    menuTree.root.reload() ;
                    menuTree.refreshNode(selNode) ;
                },
                waitMsg : '正在保存数据，稍后...'
                });
            	win.hide();
    	}else{
    		Ext.Msg.alert('信息', blankStr + '请填写完成再提交!'+blankStr );
    	}
     },
     resetFormClick: function() {
     	this.getForm().reset();
     }
});
  // form_win定义一个Window对象，用于新建和修改时的弹出窗口。
 InsertMenuWindow = Ext.extend(Ext.Window,{
    menuForm : null,
    constructor: function() {
        this.menuForm = new MenuForm();
        InsertMenuWindow.superclass.constructor.call(this, {
            title: "添加类型窗口",
            width: 350,
            height: 270,
            resizable : false,
            plain: true,
            modal: true,
            autoScroll: true,
            closeAction: 'hide',
            items: [this.menuForm]
        });
    }
});

function changeStyle(style) {
    Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + style + ".css");
}

/*********************onReady 组件渲染及处理*************************************************/
Ext.onReady(function() {
    
    Ext.QuickTips.init();
    Ext.form.Field.prototype.msgTarget = 'side';
    
    Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + window.parent.styleCssValue);
    
    Ext.Ajax.on('requestcomplete',checkUserSessionStatus, this); 
	function checkUserSessionStatus(conn,response,options) {     
        var sessionStatus = response.getResponseHeader["sessionstatus"];        
        if(typeof(sessionStatus) != "undefined"){   
            Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
			    if (btn == 'ok'){   
			        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
			        window.location = redirect;   
			    }   
            });   
         }     
    }   
    menuTree  = new MenuTree(); //实例化
    menuTree.getRootNode().expand();    //展开根节点
    
   wfProcessDefineGrid = new WfProcessGrid(Ext.getBody().getViewSize().height-90,Ext.getBody().getViewSize().width-260) ;
	var wfProcessGridPanel = {
		title: '服务编排',
		id: 'wfProcessGridPanel',
		frame: true,
		bodyStyle: 'padding: 5px',
		items: [wfProcessDefineGrid]
	} 
	tabPanel = new Ext.TabPanel({
		renderTo:'wfProcessTabPanel',
		region:'center',
		id: 'tabPanel',
		height: Ext.getBody().getViewSize().height-25,
		width: Ext.getBody().getViewSize().width-260,
		enableTabScroll: true,
		fitToFrame: true,
		activeTab: 0,
		layoutOnTabChange: true,
		items: [wfProcessGridPanel]
	})
});
