/**
* 服务编排----流程定义
* @author lisen
*/

Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif';  //本地图形化
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';     //需要补充的空格
var processWin = null ;
var PAGESIZE = 15 ;
/*******************************
*******菜单添加修改form**************************************/
ProcessForm = Ext.extend(Ext.ux.Form, {
    
    busiprocessid:null,
    flowname: null,             //"类型名称" 文本框
    descn:  null,              //"类型编码" 文本框
    busitypeid:null,
    
    constructor: function() {
        this.busiprocessid = this.createHidden("ID","stFlowBusiprocess.busiprocessid") ;
        this.busitypeid = this.createHidden("ID","busitypeid") ;
        this.flowname = this.createTextFiled("组合服务名称", 'stFlowBusiprocess.flowname', '80%',"类型名称不能为空！",null,15,"类型名称最大长度为15");
        this.descn = this.createTextArea("组合服务描述", 'stFlowBusiprocess.descn', 50,'80%');
        
        ProcessForm.superclass.constructor.call(this, {
        	title: '类型配置',
            width: 300,
            height: 230,
            labelWidth: 70,
            frame: true,
            waitMsgTarget : true,
            bodyStyle:"padding: 5px 5px 0",
            
            items:[this.busiprocessid,this.busitypeid,this.flowname,this.descn],
            buttons: [
               {text: '保存', id: 'addBtn', iconCls: 'new',width: 20, hidden: false, handler: this.addFormClick, scope: this},
               {text: '重置', id: 'resetBtn',width: 20, iconCls:'refresh',  handler: this.resetFormClick, scope: this}
            ]
        })
     },
     addFormClick: function() {     //添加
    	if(this.getForm().isValid()) {
        	this.getForm().submit( {
                url : 'wfBusiProcess_saveOrUpdateProcess.action',
                success : function(from, action) {
                    Ext.Msg.alert('数据保存成功', blankStr + '操作成功！' +blankStr);
                    menuTree.root.reload() ;
                    menuTree.refreshNode(selNode) ;
                },
                failure : function(form, action) {
                    Ext.Msg.alert('数据保存失败', blankStr + '操作失败！' +blankStr);
                    menuTree.root.reload() ;
                    menuTree.refreshNode(selNode) ;
                },
                waitMsg : '正在保存数据，稍后...'
                });
            	processWin.hide();
    	}else{
    		Ext.Msg.alert('信息',  blankStr+'请填写完成再提交!' +blankStr);
    	}
     },
     resetFormClick: function() {
     	this.getForm().reset();
     }
});
  // form_win定义一个Window对象，用于新建和修改时的弹出窗口。
 ProcessWindow = Ext.extend(Ext.Window,{
    processForm : null,
    constructor: function() {
        this.processForm = new ProcessForm();
        ProcessWindow.superclass.constructor.call(this, {
            title: "添加类型窗口",
            width: 320,
            height: 270,
            resizable : false,
            plain: true,
            modal: true,
            autoScroll: true,
            closeAction: 'hide',
            items: [this.processForm]
        });
    }
});
/**************************************服务编排流程版本列表**************************************/
WfProcessGrid = Ext.extend(UxGrid, {
    rightMenu : null,
    constructor: function(height, width) {
    	this.wfProcessStore = new Ext.data.Store({          //Grid Store
            proxy: new Ext.data.HttpProxy({url: "wfProcessDefine_getProcessDefine.action", method: 'POST'}),
            reader: new Ext.data.JsonReader({totalProperty: 'totalProperty', root:'list'},
            [{name:'processdefid'},{name:'processdefname'},{name:'processchname'},{name:'versionsign'},{name:'currentstate'}])
        }),
        this.rightMenu = new Ext.menu.Menu({
            items: [
                {text: '修改版本',handler: this.onModifyClick,scope: this},
                {text: '删除版本',handler: this.onDeleteClick,scope: this}              
            ]
        });
        
        WfProcessGrid.superclass.constructor.call(this, {
            frame: true,
            width: width,
            height: height,
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            sm: new Ext.grid.RowSelectionModel({singleSelect:true}),
            cm: new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
                {header:'版本id',dataIndex:'processdefid',hidden:true},
                {header:'服务定义名称',dataIndex:'processdefname',hidden:true},
                {header:'版本名称',dataIndex:'processchname',width:100},
                {header:'版本标识',dataIndex:'versionsign',width:100},
                {header:'当前状态',dataIndex:'currentstate',width:100,renderer:function(val){return val==1?"未发布":"发布";}},
                {header:'流程XML',dataIndex:'processdefid',width:100,renderer:function(val){return "<a href='javascript:showXml("+val+")'>查看</a>";}}
            ]),
            tbar:new Ext.Toolbar({
            	items:['-',
                    {text:'添加',id: 'bbar_newServDefine', iconCls: 'new', handler:this.onAddClick,scope:this},'-',
                    {text:'修改',id: 'bbar_updateServDefine',iconCls: 'update',handler:this.onModifyClick,scope:this},'-',
                    {text:'删除',id: 'bbar_deleteServDefine',iconCls: 'delete',handler:this.onDeleteClick,scope:this}, '-',
                    {text:'发布',id: 'bbar_releaseServDefine',iconCls: 'more',handler:this.onReleaseClick,scope:this}, '-',
                    {text:'取消发布',id: 'bbar_releaseServDefine',iconCls: 'refresh',handler:this.ondoReleaseClick,scope:this}, '-'
                ]
            }),
            ds: this.wfProcessStore,
            listeners: {
                "dblclick": { fn: this.onModifyClick, scope: this},
                "rowcontextmenu": {fn: this.onRightMenuClick, scope: this}
            }
        });
    },
    onRightMenuClick: function(grid, rowIndex, e) {
        this.getSelectionModel().selectRow(rowIndex);
        this.fireEvent("cellclick", grid, rowIndex);
        e.preventDefault();
        this.rightMenu.showAt(e.getXY());
    },
    onAddClick: function() {
    	if(selNode!=null)
    	parNode = selNode.parentNode;
        if(!selNode||selNode.id.indexOf('TYPE_')!=-1) {
            Ext.MessageBox.alert('系统提示:', '请选择服务编排类别');
            return;
        }
        var nodeId;
        if(parNode!=null){
           nodeId = parNode.id.substring(5);
        }
        //打开设计界面
    	var action = "../orchestration/flowDesigner.jsp?status=new&busiId="+parNode.id.substring(5)+"&processDefId=&processCHName="+encodeURI(selNode.attributes.text)+"&processDefName=flow."+selNode.id.substring(5)+"."+this.getMaxVersion(selNode.childNodes)+'&version='+this.getMaxVersion(selNode.childNodes);
    	addFlowDesignerTab("流程设计-"+selNode.text, action);
    },
    onModifyClick: function() {
        var record = this.selectedRecord();   
        //打开设计界面
         if(record) {
        	processdefid = record.get('processdefid');
        	var action = "../orchestration/flowDesigner.jsp?status=update&busiId="+processdefid+"&processDefId="+processdefid+"&processCHName="+encodeURI(record.get('processchname'))+"&processDefName="+record.get('processdefname')+'&version='+record.get('versionsign');
    		addFlowDesignerTab("流程设计-"+record.get('processchname'), action);
         }else {
             Ext.Msg.alert('系统提示', blankStr + '请选择一条编排记录' + blankStr);
         }
    },
    onDeleteClick: function() {
        var record = this.selectedRecord();
        var that = this ;
        if(record) {
        	processdefid = record.get('processdefid');
            Ext.MessageBox.confirm('系统提示:','您确定要删除所选版本吗？',function(btn){           	
                if(btn == 'yes') {  
                    WfProcessDefineDwr.delProcessDefine(processdefid, function(data){
                       if(data) {
                           Ext.MessageBox.alert("系统提示:", blankStr + '删除成功' + blankStr);                           
                           that.remove(record); 
                           if(that.getStore().getCount()==0)      //服务定义列表中无记录添加按钮可用                       
                             document.getElementById("bbar_newServDefine").disabled=false;
                       }else{
                       	 Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);  
                       }
                    });
                }
            });
        } else {
             Ext.Msg.alert('系统提示', blankStr + '请选择一条编排记录' + blankStr);
        }
    	
    },
    onReleaseClick:function(){
    	var record = this.selectedRecord();   
    	var that = this ;
        if(record) {
        	processdefid = record.get('processdefid');
        	processdefname = record.get('processdefname') ;
            Ext.MessageBox.confirm('系统提示:','您确定要发布所选版本吗？',function(btn){           	
                if(btn == 'yes') {  
                    WfProcessDefineDwr.release(processdefid,processdefname,3, function(data){
                       if(data) {
                           Ext.MessageBox.alert("系统提示:", blankStr + '发布成功' + blankStr);                           
                           that.getStore().reload() ;
                       }else{
                       	 Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);  
                       }
                    });
                }
            });
        } else {
             Ext.Msg.alert('系统提示', blankStr + '请选择一条编排记录' + blankStr);
        }
    },
    ondoReleaseClick:function(){
    	var record = this.selectedRecord();   
    	var that = this ;
        if(record) {
        	processdefid = record.get('processdefid');
        	processdefname = record.get('processdefname') ;
            Ext.MessageBox.confirm('系统提示:','您确定要取消发布所选版本吗？',function(btn){           	
                if(btn == 'yes') {  
                    WfProcessDefineDwr.release(processdefid,processdefname,1, function(data){
                       if(data) {
                           Ext.MessageBox.alert("系统提示:", blankStr + '取消发布成功' + blankStr);                           
                           that.getStore().reload() ;
                       }else{
                       	 Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);  
                       }
                    });
                }
            });
        } else {
             Ext.Msg.alert('系统提示', blankStr + '请选择一条编排记录' + blankStr);
        }
    },
    selectedRecord: function() {
        var record = this.getSelectionModel().getSelected();
        return record;
    },
    refresh: function(){
        this.getView().refresh();
    },
    remove:function(record){
        this.getStore().remove(record);
    },
    getMaxVersion: function(childs) {
		var len = this.getStore().getTotalCount();
		var totNum = len ;
		var sufixVersion = 0 ;
		for(var i=0; i<len; i++) {
			sufixVersion = this.getMaxSufixVersion(this.getStore().getAt(i).get("versionsign")) ;
			if(sufixVersion>=totNum)
				totNum = parseInt(sufixVersion);
		}
		var maxVersion = '1.1.'+totNum ;
		return maxVersion;
	},
	getMaxSufixVersion:function(versionsign){
		return versionsign.substr(versionsign.lastIndexOf(".")+1) ;
	}
});

function refreshProcessList(){
	wfProcessDefineGrid.getStore().reload() ;
}

addFlowDesignerTab = function(name, action) {
	var panelId = "HomePanel_flowDesigner";
	var d = tabPanel.getItem(panelId);
	if (d == null) {
		var designerPanel = {    
        id :panelId,    
        defaultType: 'iframepanel',
        closable:true,
        frame: true,
        title:'编排设计',
        defaults:{
                closable:true,
                autoShow:true
              },
        items:[{    
	        	 height: Ext.getBody().getViewSize().height,
		 		 width: Ext.getBody().getViewSize().width-250,
	        	 frameConfig : {autoCreate:{id:'fluxMonitorFrame'}},
	        	 defaultSrc :  action       
	    	}]
	    };   
		d = tabPanel.add(designerPanel);
		tabPanel.activate(d);
	} else {
		d.defaultSrc=action;
		tabPanel.activate(d);
	}
};

showXml=function(processDefineId){
	var xmlText = "" ;
	 WfProcessDefineDwr.getProcessDefineXML(processDefineId, function(data){
          xmlText = data ;
         responseWsdlText.setValue(xmlText);
	 	 viewWin.show();
	 })     
	var responseWsdlText = new Ext.form.TextArea({  
		//fieldLabel : "服务编排定义XML",
		//name : "defXML",
		//id : "defXML",
		//width: Ext.getBody().getViewSize().width - 530,
		  width : Ext.getBody().getViewSize().width - 415 ,
		readOnly: true,
		height : Ext.getBody().getViewSize().height - 210
	});

   var viewWin = new Ext.Window({ // 新建一个窗口
        title : "查看",
        //layout : 'fit',
        modal : true, // 模式窗口
        width : Ext.getBody().getViewSize().width - 400 ,
        height : Ext.getBody().getViewSize().height - 170 ,
        minimizable : true,
        maximizable : true,
        plain : true,
        items:[{//layout:"form",
        items:responseWsdlText}]
      });
};