/**
 * 互联服务注册主页面
 * @class QueryForm
 * @extends Ext.ux.Form
 */
var areaUrl = "register/servAffordManRegAction_queryAllServInfo.action";
var servUrl = "servAffordManRegAction_queryAllServInfo.action";
var connServ;
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';     //需要补充的空格
var ConnServRegObj = {connServId:'',connServCode:'',connServName:'',connServType:'',areaCode:'',connRoutePlatCode:'',provideCode:'',connServInvokeMode:'',connServStatus:'',connServProcStatus:'',wsdlId:'',protocolId:'',delFlag:'',description:'',servDefineId:''};
var url_Invoke_Mode = "servAffordManRegAction_queryInvokeMode.action";
var providerUrl = "connLimitScAction_queryConnMan.action";
var SERVTYPE_STORE_URL = 'register/servDefineAction_queryServType.action';
var SERVMANURL = 'register/getAllServMan_queryAllServMan.action'
Ext.onReady(function() {
	Ext.override(Ext.menu.DateMenu, {
				render : function() {
					Ext.menu.DateMenu.superclass.render.call(this);
					if (Ext.isGecko) {
						this.picker.el.dom.childNodes[0].style.width = '178px';
						this.picker.el.dom.style.width = '178px';
					}
				}
			});

	Ext.QuickTips.init();

	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.styleCssValue);
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.parent.styleCssValue);
	var redStar = '<font color=red>' + '*' + '</font>';// 红色星号

	Ext.Ajax.on('requestcomplete', checkUserSessionStatus, this);
	// 检查用户状态 是否session 超时
	function checkUserSessionStatus(conn, response, options) {
		var sessionStatus = response.getResponseHeader["sessionstatus"];

		if (typeof(sessionStatus) != "undefined") {
			Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
						if (btn == 'ok') {
							var redirect = URL_START + document.location.host
									+ LOG_IN_URL + '?flag=true';
							window.location = redirect;
						}
					});
		}
	}

 QueryForm = Ext.extend(Ext.ux.Form,{
		 servCombo:null,
		 beginTime:null,
		 endTime:null,
    constructor:function(){
	 	this.servCombo = this.createCombo2("服务名称","","servId","servName","70%",areaUrl,"servDtoList","",false);
	 	this.servCombo.initComponent = this.addBlankSelectForCombox(this.servCombo);
	 	this.servCombo.store.load();
        this.beginTime = this.createDateField('开始时间','begin','Y-m-d H:i:s','70%','','');
        this.endTime = this.createDateField('结束时间','end','Y-m-d H:i:s','70%','','');
	 	QueryForm.superclass.constructor.call(this,{
		 	title:"工单查询",
		 	width:Ext.getBody().getViewSize().width -5,
		 	height:Ext.getBody().getViewSize().height * 0.25,
		 	region:"center",
		 	applyTo:"queryform",
//		 	bodyStyle : "padding: 5px 5px 0",
		 	frame :true,
			items : [{layout:"column",items:[{layout:"form",items:this.servCombo,columnWidth:.3333},{layout:"form",items:this.beginTime,columnWidth:.3333},{layout:"form",items:this.endTime,columnWidth:.3333}]}],
		 	buttons : [{text : '查询',id : 'query_connserv_btn',iconCls : 'find',width : 20,hidden : false,handler :this.queryFormClick,scope : this},
					   {text : '重置',id : 'resume_connserv_btn',width : 20,iconCls : 'resume',hidden : false,handler : this.onResumeClick,scope : this}]
	 	
 	})
 },
queryFormClick:function(){
	servId = this.servCombo.getValue();
	beginValue  = this.beginTime.getRawValue();
	endValue = this.endTime.getRawValue();
	connServ.store.baseParams = {'aipMessageDto.servId':servId,'aipMessageDto.beginTime':beginValue,'aipMessageDto.endTime':endValue};
	connServ.store.load({params:{'page1.start':0,'page1.pageSize':10}});
},
onResumeClick:function(){
     this.getForm().reset();
},
addBlankSelectForCombox:function(combo){
	combo.on("select", function() {
					if (combo.getValue() == -1) { // 当选择-1时，把值设置为空
						combo.setValue("");
					}
				});
		combo.store.on("datachanged", function(a) {
					var r = new Ext.data.Record({});
					r.set(combo.valueField, ''); // 添加一格值为-1的选项
					r.set(combo.displayField, combo.emptyText);
					a.insert(0, r);
				});
}
});
var queryForm = new QueryForm();
 
ConnServGrid =  Ext.extend(UxGrid, {
      store:null,
	constructor : function() {

		this.store = new Ext.data.Store({ // Grid Store
			proxy : new Ext.data.HttpProxy({
						url : "servMonAction_queryWorkOrder.action",
						method : 'POST'
					}),
			reader : new Ext.data.JsonReader({
						totalProperty : 'page1.totalCount',
						root : 'page1.result'
					}, [{name:'servId'},{name:'servName'},{name:'sendSystem'},{name:'receiveSystem'},{name:'receiveTimes'},{name:'requestTimes'},{name:'responseTimes'}, {name:'sendTimes'}])}),

		ConnServGrid.superclass.constructor.call(this, {
					title:'工单信息列表',
					frame : true,
					width : Ext.getBody().getViewSize().width -5,
					renderTo:"grid-div",
					region:"center",
					height : Ext.getBody().getViewSize().height * 0.73,
					viewConfig : {
						forceFit : true
					},
					loadMask : {
						msg : '正在载入数据,请稍候...'
					},
					sm : new Ext.grid.RowSelectionModel({singleSelect : true}),
					cm : new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
							{header : '服务id',dataIndex : 'servId',hidden : true},
							{header : '服务名称',dataIndex : 'servName',sortable : true,width : 100}, 
							{header : '源系统',dataIndex : 'sendSystem',sortable : true,hidden : false,width : 140}, 
							{header : '目标系统',dataIndex : 'receiveSystem',sortable : true,hidden : false}, 
							{header : 'oip接收次数',dataIndex : 'receiveTimes',sortable : true,width : 130}, 
							{header : 'oip发送次数',dataIndex : 'requestTimes',sortable : true,width : 100}, 
							{header : 'oip接收响应次数',dataIndex : 'responseTimes',sortable : true,width : 100}, 
							{header : 'oip返回次数',dataIndex : 'sendTimes',hidden : false,sortable : true,width : 100}
					]),
					bbar : new Ext.PagingToolbar({
								firstText : '第一页',
								nextText : '下一页',
								prevText : '上一页',
								refreshText : '刷新',
								lastText : '最后一页',
								beforePageText : '当前',
								afterPageText : '页/共{0}页',
								pageSize : 10,
								paramNames:{
									start:'page1.start',
									limit:'page1.pageSize'
								},
								store : this.store,
								displayInfo : true,
								displayMsg : '本页显示 {0} - {1},共{2}条记录',
								emptyMsg : "没有可显示的记录"
							}),
					ds : this.store,
					listeners : {
						"rowcontextmenu" : {fn : this.onRightMenuClick,scope : this},
						 "dblclick":{fn:this.onDblClick,scope:this}
					}
				})
	},
	format:function(val){
		value = ""
	    if(val == 1){
	    	value = "已注册";
	    }else if(val == 2){
	        value = "已发布";
	    }else if(val == 3){
	        value = "已注销";
	    }else{
	    	value = "其他";
	    }
	    return value;
	},
	format1:function(val){
		value = "";
		if(val == 1){
			value = "初始状态";
		}else if(val == 2){
			value = "已下发";
		}else if(val == 3){
			value = "未审核";
		}else if(val == 4){
			value = "已审核";
		}else if(val == 5){
			value = "已上报";
		}else{
			value = "其他";
		}
		return value;
	}
});
     connServ = new ConnServGrid();
     connServ.store.load({params:{'page1.start':0,'page1.pageSize':10}});
});