/**
 * 互联消息对账主页面
 * 
 * @class QueryForm
 * @extends Ext.ux.Form
 */
var areaUrl = "msgChosenAction_findCode.action";
var servUrl = "servAffordManRegAction_queryAllServInfo.action";
var servSetUrl = "servInstanceAction_findAllServInfo.action";
var queryDicUrl = "getDicAction_queryDictionary.action";
var connServ;
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'; // 需要补充的空格
Ext.onReady(function() {
	Ext.override(Ext.menu.DateMenu, {
		render : function() {
			Ext.menu.DateMenu.superclass.render.call(this);
			if (Ext.isGecko) {
				this.picker.el.dom.childNodes[0].style.width = '178px';
				this.picker.el.dom.style.width = '178px';
			}
		}
	});

	Ext.QuickTips.init();

	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
			+ window.parent.styleCssValue);
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
			+ window.parent.parent.styleCssValue);
	Ext.Ajax.on('requestcomplete', checkUserSessionStatus, this);
	// 检查用户状态 是否session 超时
	function checkUserSessionStatus(conn, response, options) {
		var sessionStatus = response.getResponseHeader["sessionstatus"];

		if (typeof (sessionStatus) != "undefined") {
			Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
				if (btn == 'ok') {
					var redirect = URL_START + document.location.host
							+ LOG_IN_URL + '?flag=true';
					window.location = redirect;
				}
			});
		}
	}

	// 格式化时间
	Date.prototype.format = function(format) {
		var o = {
			"M+" : this.getMonth() + 1, // month<
			"d+" : this.getDate(),// day
			"h+" : this.getHours(), // hour
			"m+" : this.getMinutes(), // minute
			"s+" : this.getSeconds(), // second
			"q+" : Math.floor((this.getMonth() + 3) / 3),// quarter
			"S" : this.getMilliseconds()
		// millisecond
		};
		if (/(y+)/.test(format))
			format = format.replace(RegExp.$1, (this.getFullYear() + "")
					.substr(4 - RegExp.$1.length));
		for ( var k in o) {
			if (new RegExp("(" + k + ")").test(format))
				format = format.replace(RegExp.$1, RegExp.$1.length == 1 ? o[k]
						: ("00" + o[k]).substr(("" + o[k]).length));
		}
		return format;
	};
	var beginTimeFieldValue;
	var endTimeFieldValue;
	function check() {
		var msgText = '时间为必选项，格式应为：yyyy-mm-dd hh:mm:ss！';
		if (!Ext.getCmp('beginTime').isValid()) {
			Ext.MessageBox.alert("信息提示", msgText, function(btn) {
				Ext.getCmp('beginTime').focus();
			});
			return false;
		}
		if (!Ext.getCmp('endTime').isValid()) {
			Ext.MessageBox.alert("信息提示", msgText, function(btn) {
				Ext.getCmp('endTime').focus();
			});
			return false;
		}
		beginTimeFieldValue = Ext.get("beginTime").getValue();
		endTimeFieldValue = Ext.get("endTime").getValue();
		beginTimeValueTemp = new Date(Date.parse(beginTimeFieldValue.replace(
				/-/g, "/")));
		endTimeValueTemp = new Date(Date.parse(endTimeFieldValue.replace(/-/g,
				"/")));

		var daydiff = (endTimeValueTemp.getTime() - beginTimeValueTemp
				.getTime())
				/ (1000 * 60 * 60 * 24);
		if (daydiff < 0) {
			Ext.Msg.alert("信息提示", "结束时间不能小于开始时间！");
			return false;
			;
		}
		return true;
	}
	ConnServGrid = Ext.extend(UxGrid, {
		store : null,
		constructor : function() {

			this.store = new Ext.data.Store({ // Grid Store
				proxy : new Ext.data.HttpProxy({
					url : "servInstanceAction_queryServInstance.action",
					method : 'POST'
				}),
				reader : new Ext.data.JsonReader({
					totalProperty : 'page.totalCount',
					root : 'page.result'
				}, [ {
					name : 'fromOipCode'
				}, {
					name : 'toOipCode'
				},  {
					name : 'servOipCode'
				}, {
					name : 'fromOipName'
				}, {
					name : 'toOipName'
				}, {
					name : 'servCode'
				}, {
					name : 'servName'
				}, {
					name : 'consumer'
				}, {
					name : 'receiveSystem'
				}, {
					name : 'receiveTimes'
				}, {
					name : 'requestTimes'
				}, {
					name : 'responseTimes'
				}, {
					name : 'sendTimes'
				} ])
			}), this.servPlatLabel = new Ext.form.Label({
				text : '服务所在平台：'
			}), this.servPlatCombo = this.createCombo2("服务平台名称", "servOipCode",
					"connRoutePlatCode", "connRoutePlatName", "70%", areaUrl,
					"areaList", "areaCount", true);
			this.servPlatCombo.initComponent = this
					.addBlankSelectForCombox(this.servPlatCombo);
			this.servPlatCombo.store.load();
			this.servSetLabel = new Ext.form.Label({
				text : '服务名称：'
			}), this.servSetCombo = this.createCombo2("服务名称", "servCode",
					"connServCode", "connServName", "70%", servSetUrl,
					"areaList", "areaCount", true);
			this.servSetCombo.initComponent = this
					.addBlankSelectForCombox(this.servSetCombo);
			this.servSetCombo.store.load();
			var serv = this.servSetCombo;
			var area = this.servPlatCombo;
			// 二级联动，服务的选择依赖于服务所属平台
			this.servPlatCombo.on("select", function(comb) {
				serv.setValue('');
				// 当服务所属平台框未选择时，二级框置不可用
				if (area.getValue() == '' || area.getValue() == null) {
					serv.setDisabled(true);
				} else {
					serv.setDisabled(false);
				}
				serv.store.load({
					params : {
						connRoutePlatCode : comb.value
					}
				});
			});

			// 接口类型
			var nowDate = new Date();
			var startDate = new Date(nowDate.getTime() - 24 * 60 * 60 * 1000);
			nowDate = nowDate.format("yyyy-MM-dd hh:mm:ss");
			startDate = startDate.format("yyyy-MM-dd hh:mm:ss");
			// 开始时间
			this.receiveTimeLabel = new Ext.form.Label({
				text : '接收时间：'
			}), this.beginTime = new Ext.form.DateField({
				fieldLabel : '开始时间',
				xtype : 'xdatetime',
				name : 'beginTime',
				id : 'beginTime',
				width : 200,
				anchor : '99%',
				allowBlank : false,
				altFormats : 'Y-m-d H:i:s',
				format : 'Y-m-d H:i:s',
				value : startDate,
				emptyText : '请选择一个日期'
			});

			// 结束时间
			this.endTime = new Ext.form.DateField({
				fieldLabel : '结束时间',
				xtype : 'xdatetime',
				name : 'endTime',
				id : 'endTime',
				width : 200,
				anchor : '99%',
				allowBlank : false,
				altFormats : 'Y-m-d H:i:s',
				format : 'Y-m-d H:i:s',
				value : nowDate,
				emptyText : '请选择一个日期'
			});
			ConnServGrid.superclass.constructor.call(this, {
				title : '服务信息列表',
				frame : true,
				width : Ext.getBody().getViewSize().width - 5,
				renderTo : "grid-div",
				region : "center",
				height : Ext.getBody().getViewSize().height - 10,
				viewConfig : {
					forceFit : true
				},
				loadMask : {
					msg : '正在载入数据,请稍候...'
				},
				sm : new Ext.grid.RowSelectionModel({
					singleSelect : true
				}),
				cm : new Ext.grid.ColumnModel([ new Ext.grid.RowNumberer(), {
					header : '源平台编码',
					dataIndex : 'fromOipCode',
					hidden : true
				}, {
					header : '目标平台编码',
					dataIndex : 'toOipCode',
					hidden : true
				}, {
					header : '源OIP平台名称',
					dataIndex : 'fromOipName',
					sortable : true,
					width : 100
				}, {
					header : '目标OIP平台名称',
					dataIndex : 'toOipName',
					sortable : true,
					width : 100
				}, {
					header : '服务名称',
					dataIndex : 'servName',
					sortable : true,
					width : 100
				}, {
					header : '源系统',
					dataIndex : 'consumer',
					sortable : true,
					hidden : false,
					width : 80
				}, {
					header : '目标系统',
					dataIndex : 'receiveSystem',
					sortable : true,
					hidden : false
				}, {
					header : '源oip发送次数',
					dataIndex : 'requestTimes',
					sortable : true,
					width : 100
				}, {
					header : '源oip接收响应次数',
					dataIndex : 'responseTimes',
					sortable : true,
					width : 130
				}, {
					header : '目标oip接收次数',
					dataIndex : 'receiveTimes',
					sortable : true,
					width : 100
				}, {
					header : '目标oip返回次数',
					dataIndex : 'sendTimes',
					hidden : false,
					sortable : true,
					width : 100
				}, {
					header : '详情查询',
					dataIndex : 'servCode',
					sortable : true,
					width : 100,
					renderer : this.getDetail
				} ]),
				bbar : new Ext.PagingToolbar({
					firstText : '第一页',
					nextText : '下一页',
					prevText : '上一页',
					refreshText : '刷新',
					lastText : '最后一页',
					beforePageText : '当前',
					afterPageText : '页/共{0}页',
					pageSize : 20,
					paramNames : {
						start : 'page.start',
						limit : 'page.pageSize'
					},
					store : this.store,
					displayInfo : true,
					displayMsg : '本页显示 {0} - {1},共{2}条记录',
					emptyMsg : "没有可显示的记录"
				}),
				tbar : new Ext.Toolbar({
					items : [ this.servPlatLabel, this.servPlatCombo,
							this.servSetLabel, this.servSetCombo,
							this.receiveTimeLabel, this.beginTime, "至",
							this.endTime, '-', {
								text : '查询',
								iconCls : 'find',
								handler : this.query,
								scope : this
							}, '-', {
								text : '重置',
								iconCls : 'resume',
								handler : this.resume,
								scope : this
							} ]
				}),
				ds : this.store,
				listeners : {
					"rowcontextmenu" : {
						fn : this.onRightMenuClick,
						scope : this
					},
					"dblclick" : {
						fn : this.onDblClick,
						scope : this
					}
				}
			});
		},
		query : function() {
			var servOipCode = this.servPlatCombo.getValue();
			var servCode = this.servSetCombo.getValue();
			connServ.store.baseParams = {
				'servInstanceDto.servOipCode' : servOipCode,
				'servInstanceDto.servCode' : servCode,
				'beginTime' : Ext.get("beginTime").getValue(),
				'endTime' : Ext.get("endTime").getValue()
			};
			connServ.store.load({
				params : {
					'page.start' : 0,
					'page.pageSize' : 20
				}
			});
		},
		resume : function() {
			var nowDate = new Date();
			var startDate = new Date(nowDate.getTime() - 24 * 60 * 60 * 1000);
			nowDate = nowDate.format("yyyy-MM-dd hh:mm:ss");
			startDate = startDate.format("yyyy-MM-dd hh:mm:ss");
			this.servPlatCombo.setValue("");
			this.servSetCombo.setValue("");
			this.beginTime.setValue(startDate);
			this.endTime.setValue(nowDate);
		},
		addBlankSelectForCombox : function(combo) {
			combo.on("select", function() {
				if (combo.getValue() == -1) { // 当选择-1时，把值设置为空
					combo.setValue("");
				}
			});
			combo.store.on("datachanged", function(a) {
				var r = new Ext.data.Record({});
				r.set(combo.valueField, ''); // 添加一格值为-1的选项
				r.set(combo.displayField, combo.emptyText);
				a.insert(0, r);
			});
		},
		getDetail : function(val, params, record) {
			var servCode = record.get("servCode");
			var fromOipCode = record.get("fromOipCode");
			var toOipCode = record.get("toOipCode");
			var consumer = record.get("consumer");
			var beginTime = null, endTime = null;
			if (Ext.get("beginTime") != null) {
				beginTime = Ext.get("beginTime").getValue();
				beginTime = beginTime.replace(/ /g, "@");
			}
			if (Ext.get("endTime") != null) {
				endTime = Ext.get("endTime").getValue();
				endTime = endTime.replace(/ /g, "@");
			}
			return '<a href=javascript:detDetailPro("' + servCode + '","'
					+ fromOipCode + '","' + toOipCode + '","' + consumer
					+ '","' + beginTime + '","' + endTime + '")>'
					+ '<center>查看</center>' + '</a>';

		}
	});
	connServ = new ConnServGrid();
	connServ.store.load({
		params : {
			'page.start' : 0,
			'page.pageSize' : 20
		}
	});

});
function detDetailPro(servCode, fromOipCode, toOipCode, consumer, beginTime,
		endTime) {

	var servCodeValue = servCode;
	var fromOipCodeValue = fromOipCode;
	var toOipCodeValue = toOipCode;
	var consumerValue = consumer;
	var beginTimeValue = beginTime.replace(/@/g, " ");
	var endTimeValue = endTime.replace(/@/g, " ");
	var hp = new Ext.data.HttpProxy({
		url : 'servInstanceAction_queryServInstanceDetail.action'
	});
	var storePro = new Ext.data.Store({// 配置分组数据集
		proxy : hp,
		reader : new Ext.data.JsonReader({
			totalProperty : "page1.totalCount",
			root : 'page1.result',
			fields : [ 'msgId', 'fromOipName', 'toOipName', 'servName',
					'consumer', 'receiveSystem', 'receiveStatus',
					'requestStatus', 'responseStatus', 'sendStatus', 'oipCode',
					'msgChosenTime' ]
		})
	});
	var gridWidth = Ext.getBody().getViewSize().width - 200;
	if (screen.width == 1024 && screen.height == 768) {
		gridWidth = Ext.getBody().getViewSize().width - 22;
	}
	var gridHeight = Ext.getBody().getViewSize().height * 0.55;
	var bbar1 = new Ext.PagingToolbar({
		store : storePro,
		paramNames : {
			start : 'page1.start',
			limit : 'page1.pageSize'
		},
		pageSize : 20,
		firstText : '第一页',
		nextText : '下一页',
		prevText : '上一页',
		refreshText : '刷新',
		lastText : '最后一页',
		beforePageText : '当前',
		afterPageText : '页/共{0}页',
		displayInfo : true,
		displayMsg : '第 {0} 条到 {1} 条，一共 {2} 条',
		emptyMsg : "没有记录"
	});
	var gridPro = new Ext.grid.GridPanel({
		title : '服务实例展现列表',
		width : gridWidth,// Ext.getBody().getViewSize().width
		height : gridHeight,// Ext.getBody().getViewSize().height
		frame : true,
		stripeRows : true,
		bbar : bbar1,
		store : storePro,
		loadMask : true,
		viewConfig : {
			forceFit : true
		},
		columns : [// 配置表格列
		new Ext.grid.RowNumberer(), {
			header : '消息id',
			dataIndex : 'msgId',
			sortable : true,
			width : 100
		}, {
			header : '服务名称',
			dataIndex : 'servName',
			sortable : true,
			width : 100
		}, {
			header : '源系统',
			dataIndex : 'consumer',
			sortable : true,
			hidden : false,
			width : 80
		}, {
			header : '目标系统',
			dataIndex : 'receiveSystem',
			sortable : true,
			hidden : false
		}, {
			header : '目标oip接受状态',
			dataIndex : 'receiveStatus',
			sortable : true,
			width : 100,
			renderer : this.dealIdToName
		}, {
			header : '目标oip发送响应状态',
			dataIndex : 'sendStatus',
			hidden : false,
			sortable : true,
			width : 100,
			renderer : this.dealIdToName
		}, {
			header : '源oip发送状态',
			dataIndex : 'requestStatus',
			sortable : true,
			width : 100,
			renderer : this.dealIdToName
		}, {
			header : '源oip接受响应状态',
			dataIndex : 'responseStatus',
			sortable : true,
			width : 130,
			renderer : this.dealIdToName
		}, {
			header : '源OIP平台',
			dataIndex : 'fromOipName',
			sortable : true,
			width : 100
		}, {
			header : '目标OIP平台',
			dataIndex : 'toOipName',
			sortable : true,
			width : 100
		}, {
			header : '数据抽取时间',
			dataIndex : 'msgChosenTime',
			hidden : false,
			sortable : true,
			width : 100
		} ]
	});
	storePro.baseParams = {
		'servInstanceDto1.servCode' : servCodeValue,
		'servInstanceDto1.fromOipCode' : fromOipCodeValue != 'null' ? fromOipCodeValue
				: null,
		'servInstanceDto1.toOipCode' : toOipCodeValue != 'null' ? toOipCodeValue
				: null,
		'servInstanceDto1.consumer' : consumerValue,
		'beginTime' : beginTimeValue != 'null' ? beginTimeValue : null,
		'endTime' : endTimeValue != 'null' ? endTimeValue : null
	};
	storePro.load({
		params : {
			'page1.start' : 0,
			'page1.pageSize' : 20
		}
	});
	var width = Ext.getBody().getViewSize().width - 190;
	var height = Ext.getBody().getViewSize().height * 0.60;
	if (screen.width == 1024 && screen.height == 768) {
		width = Ext.getBody().getViewSize().width - 100;
	}
	dslMapWin = new Ext.Window({ // 新建一个窗口
		title : "服务实例展现查看",
		modal : true, // 模式窗口
		width : width,
		height : height,
		resizable : false,
		plain : true,
		listeners : {
			"minimize" : function() {
				this.hide();
			},
			"close" : function() {
				this.close();
			}
		},
		items : [ gridPro ]
	});
	dslMapWin.show();
};
function dealIdToName(value) {
	if (value == '1')
		return '<font color=blue>' + '成功' + '</font>';
	else
		return '<font color=red>' + '失败' + '</font>';
};